/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.breadcrumb;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.breadcrumb.BreadcrumbItem;
import org.springframework.beans.factory.annotation.Required;

public class BreadcrumbBuilder {
    public static final String BREADCRUMB_CONST_KEY_ELEM = "breadcrumb";
    public static final String HOME_BREADCRUMB_NAME = "Home";
    protected CacheTemplate cacheTemplate;
    protected ContentStoreService storeService;
    protected String homePath;
    protected String breadcrumbNameXPathQuery;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    @Required
    public void setBreadcrumbNameXPathQuery(String breadcrumbNameXPathQuery) {
        this.breadcrumbNameXPathQuery = breadcrumbNameXPathQuery;
    }

    public List<BreadcrumbItem> buildBreadcrumb(final String url) {
        final Context context = SiteContext.getCurrent().getContext();
        return (List)this.cacheTemplate.getObject(context, (Callback)new Callback<List<BreadcrumbItem>>(){

            public List<BreadcrumbItem> execute() {
                CachingAwareList breadcrumb = new CachingAwareList();
                String breadcrumbUrl = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)url, (String)BreadcrumbBuilder.this.homePath), (String)"/index.xml");
                String[] breadcrumbUrlComponents = breadcrumbUrl.split("/");
                String currentUrl = BreadcrumbBuilder.this.homePath;
                for (String breadcrumbUrlComponent : breadcrumbUrlComponents) {
                    Item item;
                    String breadcrumbName;
                    if (StringUtils.isNotEmpty((String)breadcrumbUrlComponent)) {
                        currentUrl = currentUrl + "/" + breadcrumbUrlComponent;
                    }
                    if (StringUtils.isEmpty((String)(breadcrumbName = (item = BreadcrumbBuilder.this.storeService.getItem(context, currentUrl + "/index.xml")).queryDescriptorValue(BreadcrumbBuilder.this.breadcrumbNameXPathQuery)))) {
                        breadcrumbName = StringUtils.isNotEmpty((String)breadcrumbUrlComponent) ? StringUtils.capitalize((String)breadcrumbUrlComponent.replace("-", " ").replace(".xml", "")) : BreadcrumbBuilder.HOME_BREADCRUMB_NAME;
                    }
                    breadcrumb.add((Object)new BreadcrumbItem(currentUrl, breadcrumbName));
                    breadcrumb.addDependencyKey(item.getKey());
                }
                return breadcrumb;
            }
        }, new Object[]{url, BREADCRUMB_CONST_KEY_ELEM});
    }
}

