/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.config;

import org.apache.commons.configuration.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;

public class TargetingProperties {
    public static final String TARGETING_ENABLED_CONFIG_KEY = "targeting.enabled";
    public static final String AVAILABLE_TARGET_IDS_CONFIG_KEY = "targeting.availableTargetIds";
    public static final String FALLBACK_ID_CONFIG_KEY = "targeting.fallbackTargetId";
    public static final String ROOT_FOLDERS_CONFIG_KEY = "targeting.rootFolders";
    public static final String MERGE_FOLDERS_CONFIG_KEY = "targeting.mergeFolders";

    public static boolean isTargetingEnabled() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(TARGETING_ENABLED_CONFIG_KEY, false);
        }
        return false;
    }

    public static String[] getAvailableTargetIds() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getStringArray(AVAILABLE_TARGET_IDS_CONFIG_KEY);
        }
        return null;
    }

    public static String getFallbackTargetId() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getString(FALLBACK_ID_CONFIG_KEY);
        }
        return null;
    }

    public static String[] getRootFolders() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getStringArray(ROOT_FOLDERS_CONFIG_KEY);
        }
        return null;
    }

    public static boolean isMergeFolders() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(MERGE_FOLDERS_CONFIG_KEY, false);
        }
        return false;
    }
}

