/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.config.impl;

import java.util.ArrayList;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationBuilder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class MultiConfigurationBuilder
implements ConfigurationBuilder {
    protected String[] configPaths;
    protected ResourceLoader resourceLoader;

    public MultiConfigurationBuilder(String[] configPaths, ResourceLoader resourceLoader) {
        this.configPaths = configPaths;
        this.resourceLoader = resourceLoader;
    }

    public Configuration getConfiguration() throws ConfigurationException {
        ArrayList<XMLConfiguration> configs = new ArrayList<XMLConfiguration>();
        for (int i = this.configPaths.length - 1; i >= 0; --i) {
            try {
                Resource resource = this.resourceLoader.getResource(this.configPaths[i]);
                if (!resource.exists()) continue;
                XMLConfiguration config = new XMLConfiguration();
                config.load(resource.getInputStream());
                configs.add(config);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load configuration at " + this.configPaths[i], (Throwable)e);
            }
        }
        if (configs.size() > 1) {
            CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
            for (XMLConfiguration config : configs) {
                combinedConfig.addConfiguration((AbstractConfiguration)config);
            }
            return combinedConfig;
        }
        if (configs.size() == 1) {
            return (Configuration)configs.get(0);
        }
        return null;
    }
}

