/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;

public class BeanDefinitionUtils {
    private BeanDefinitionUtils() {
    }

    public static BeanDefinition createBeanDefinitionFromOriginal(ApplicationContext applicationContext, String beanName) {
        ApplicationContext parentContext = applicationContext.getParent();
        BeanDefinition parentDefinition = null;
        if (parentContext != null && parentContext.getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory parentBeanFactory = (ConfigurableListableBeanFactory)parentContext.getAutowireCapableBeanFactory();
            try {
                parentDefinition = parentBeanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (parentDefinition != null) {
            return new GenericBeanDefinition(parentDefinition);
        }
        return new GenericBeanDefinition();
    }

    public static void addPropertyIfNotNull(BeanDefinition definition, String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            definition.getPropertyValues().add(propertyName, propertyValue);
        }
    }
}

