/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.mvc;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class AnnotationDrivenConfigCustomizer
implements BeanPostProcessor {
    private ContentNegotiationManager contentNegotiationManager;
    private List<HttpMessageConverter<?>> messageConverters;
    private boolean replaceMessageConverters;

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setReplaceMessageConverters(boolean replaceMessageConverters) {
        this.replaceMessageConverters = replaceMessageConverters;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RequestMappingHandlerAdapter) {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean;
            if (this.contentNegotiationManager != null) {
                adapter.setContentNegotiationManager(this.contentNegotiationManager);
            }
            if (CollectionUtils.isNotEmpty(this.messageConverters)) {
                adapter.setMessageConverters(this.getMessageConverters(adapter.getMessageConverters()));
            }
        } else if (bean instanceof ExceptionHandlerExceptionResolver) {
            ExceptionHandlerExceptionResolver exceptionResolver = (ExceptionHandlerExceptionResolver)bean;
            if (this.contentNegotiationManager != null) {
                exceptionResolver.setContentNegotiationManager(this.contentNegotiationManager);
            }
            if (CollectionUtils.isNotEmpty(this.messageConverters)) {
                exceptionResolver.setMessageConverters(this.getMessageConverters(exceptionResolver.getMessageConverters()));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private List<HttpMessageConverter<?>> getMessageConverters(List<HttpMessageConverter<?>> originalMessageConverters) {
        if (this.replaceMessageConverters) {
            return this.messageConverters;
        }
        ArrayList mergedConverters = new ArrayList(this.messageConverters);
        mergedConverters.addAll(originalMessageConverters);
        return mergedConverters;
    }
}

