/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.mobile.UserAgentTemplateDetector;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptResolver;
import org.craftercms.engine.security.CrafterPageAccessManager;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.UrlTransformationService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.view.CrafterPageView;
import org.craftercms.engine.view.UserAgentAwareCrafterPageView;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.Ordered;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.RedirectView;

public class CrafterPageViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private static final String PAGE_CONST_KEY_ELEM = "page";
    private static final Log logger = LogFactory.getLog(CrafterPageViewResolver.class);
    protected int order = 10;
    protected boolean cacheUrlTransformations = true;
    protected String urlTransformerName;
    protected String fullHttpsUrlTransformerName;
    protected UrlTransformationService urlTransformationService;
    protected CacheTemplate cacheTemplate;
    protected CachingOptions cachingOptions = CachingOptions.DEFAULT_CACHING_OPTIONS;
    protected SiteItemService siteItemService;
    protected String pageViewNameXPathQuery;
    protected String redirectUrlXPathQuery;
    protected String contentTypeXPathQuery;
    protected String redirectContentType;
    protected String disabledXPathQuery;
    protected String mimeTypeXPathQuery;
    protected String forceHttpsXPathQuery;
    protected ScriptResolver scriptResolver;
    protected ViewResolver delegatedViewResolver;
    protected UserAgentTemplateDetector userAgentTemplateDetector;
    protected boolean modePreview;
    protected CrafterPageAccessManager accessManager;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Required
    public void setModePreview(boolean modePreview) {
        this.modePreview = modePreview;
    }

    public void setCacheUrlTransformations(boolean cacheUrlTransformations) {
        this.cacheUrlTransformations = cacheUrlTransformations;
    }

    @Required
    public void setUrlTransformerName(String urlTransformerName) {
        this.urlTransformerName = urlTransformerName;
    }

    @Required
    public void setFullHttpsUrlTransformerName(String fullHttpsUrlTransformerName) {
        this.fullHttpsUrlTransformerName = fullHttpsUrlTransformerName;
    }

    @Required
    public void setUrlTransformationService(UrlTransformationService urlTransformationService) {
        this.urlTransformationService = urlTransformationService;
    }

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setCachingOptions(CachingOptions cachingOptions) {
        this.cachingOptions = cachingOptions;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setPageViewNameXPathQuery(String pageViewNameXPathQuery) {
        this.pageViewNameXPathQuery = pageViewNameXPathQuery;
    }

    @Required
    public void setRedirectUrlXPathQuery(String redirectUrlXPathQuery) {
        this.redirectUrlXPathQuery = redirectUrlXPathQuery;
    }

    @Required
    public void setContentTypeXPathQuery(String contentTypeXPathQuery) {
        this.contentTypeXPathQuery = contentTypeXPathQuery;
    }

    @Required
    public void setRedirectContentType(String redirectContentType) {
        this.redirectContentType = redirectContentType;
    }

    @Required
    public void setDisabledXPathQuery(String disabledXPathQuery) {
        this.disabledXPathQuery = disabledXPathQuery;
    }

    @Required
    public void setMimeTypeXPathQuery(String mimeTypeXPathQuery) {
        this.mimeTypeXPathQuery = mimeTypeXPathQuery;
    }

    @Required
    public void setScriptResolver(ScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    @Required
    public void setForceHttpsXPathQuery(String forceHttpsXPathQuery) {
        this.forceHttpsXPathQuery = forceHttpsXPathQuery;
    }

    @Required
    public void setDelegatedViewResolver(ViewResolver delegatedViewResolver) {
        this.delegatedViewResolver = delegatedViewResolver;
    }

    @Required
    public void setUserAgentTemplateDetector(UserAgentTemplateDetector userAgentTemplateDetector) {
        this.userAgentTemplateDetector = userAgentTemplateDetector;
    }

    @Required
    public void setAccessManager(CrafterPageAccessManager accessManager) {
        this.accessManager = accessManager;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        String url = this.urlTransformationService.transform(this.urlTransformerName, viewName, this.cacheUrlTransformations);
        View view = this.getCachedLocalizedView(url, locale);
        if (view instanceof CrafterPageView) {
            this.accessManager.checkAccess(((CrafterPageView)view).getPage());
        }
        return view;
    }

    protected SiteItem getPage(String url) {
        SiteItem page = this.siteItemService.getSiteItem(url);
        if (page == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Crafter page descriptor not found at " + url));
        }
        return page;
    }

    protected View getRedirectView(String redirectUrl, boolean relative) {
        RedirectView view = new RedirectView(redirectUrl, relative, true);
        return this.applyLifecycleMethods("redirect:" + redirectUrl, (View)view);
    }

    protected View getCurrentPageHttpsRedirectView() {
        String currentUrl = RequestContext.getCurrent().getRequest().getRequestURI();
        String fullHttpsUrl = this.urlTransformationService.transform(this.fullHttpsUrlTransformerName, currentUrl);
        return this.getRedirectView(fullHttpsUrl, false);
    }

    protected View getCachedLocalizedView(final String url, final Locale locale) {
        final SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return (View)this.cacheTemplate.getObject(siteContext.getContext(), this.cachingOptions, (Callback)new Callback<View>(){

                public View execute() {
                    SiteItem page = CrafterPageViewResolver.this.getPage(url);
                    if (page != null) {
                        String disabled = page.getItem().queryDescriptorValue(CrafterPageViewResolver.this.disabledXPathQuery);
                        if (!CrafterPageViewResolver.this.modePreview && StringUtils.isNotEmpty((String)disabled) && Boolean.parseBoolean(disabled)) {
                            return null;
                        }
                        String redirectUrl = page.getItem().queryDescriptorValue(CrafterPageViewResolver.this.redirectUrlXPathQuery);
                        String contentType = page.getItem().queryDescriptorValue(CrafterPageViewResolver.this.contentTypeXPathQuery);
                        String forceHttps = page.getItem().queryDescriptorValue(CrafterPageViewResolver.this.forceHttpsXPathQuery);
                        if (StringUtils.isNotEmpty((String)contentType) && StringUtils.equalsIgnoreCase((String)CrafterPageViewResolver.this.redirectContentType, (String)contentType) && StringUtils.isNotEmpty((String)redirectUrl)) {
                            return CrafterPageViewResolver.this.getRedirectView(redirectUrl, true);
                        }
                        if (StringUtils.isNotEmpty((String)forceHttps) && Boolean.parseBoolean(forceHttps)) {
                            return CrafterPageViewResolver.this.getCurrentPageHttpsRedirectView();
                        }
                        UserAgentAwareCrafterPageView view = new UserAgentAwareCrafterPageView();
                        view.setServletContext(CrafterPageViewResolver.this.getServletContext());
                        view.setPage(page);
                        view.setModePreview(CrafterPageViewResolver.this.modePreview);
                        view.setLocale(locale);
                        view.setSiteItemService(CrafterPageViewResolver.this.siteItemService);
                        view.setPageViewNameXPathQuery(CrafterPageViewResolver.this.pageViewNameXPathQuery);
                        view.setMimeTypeXPathQuery(CrafterPageViewResolver.this.mimeTypeXPathQuery);
                        view.setDelegatedViewResolver(CrafterPageViewResolver.this.delegatedViewResolver);
                        view.setUserAgentTemplateDetector(CrafterPageViewResolver.this.userAgentTemplateDetector);
                        CrafterPageViewResolver.this.loadScripts(siteContext.getScriptFactory(), page, view);
                        view.addDependencyKey(page.getItem().getKey());
                        return CrafterPageViewResolver.this.applyLifecycleMethods(page.getStoreUrl(), (View)view);
                    }
                    return null;
                }
            }, new Object[]{url, locale, PAGE_CONST_KEY_ELEM});
        }
        return null;
    }

    protected void loadScripts(ScriptFactory scriptFactory, SiteItem page, CrafterPageView view) {
        List<String> scriptUrls;
        if (scriptFactory != null && CollectionUtils.isNotEmpty(scriptUrls = this.scriptResolver.getScriptUrls(page))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Scripts associated to page " + page.getStoreUrl() + ": " + scriptUrls));
            }
            ArrayList<Script> scripts = new ArrayList<Script>(scriptUrls.size());
            for (String scriptUrl : scriptUrls) {
                Script script = scriptFactory.getScript(scriptUrl);
                scripts.add(script);
                view.addDependencyKey(script.getKey());
            }
            view.setScripts(scripts);
        }
    }

    protected View applyLifecycleMethods(String viewName, View view) {
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
    }
}

