/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service;

import java.util.Date;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableServiceBase
extends AbstractRegistrableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableServiceBase.class);
    protected String configPath;
    protected String configFileName;
    protected ContentRepository contentRepository;

    protected void checkForUpdate(String key) {
        if (this.isConfigUpdated(key)) {
            this.loadConfiguration(key);
        }
    }

    protected boolean isConfigUpdated(String key) {
        TimeStamped config = this.getConfigurationById(key);
        if (config == null) {
            return true;
        }
        String siteConfigFullPath = this.getConfigFullPath(key);
        if (this.contentRepository.contentExists(siteConfigFullPath)) {
            Date modifiedDate = this.contentRepository.getModifiedDate(siteConfigFullPath);
            if (modifiedDate == null) {
                return false;
            }
            return modifiedDate.after(config.getLastUpdated());
        }
        this.removeConfiguration(key);
        return true;
    }

    protected abstract String getConfigFullPath(String var1);

    protected abstract void loadConfiguration(String var1);

    protected abstract TimeStamped getConfigurationById(String var1);

    protected abstract void removeConfiguration(String var1);

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

