/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.to;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastTable;
import org.craftercms.studio.api.v1.to.DmOrderTO;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;

public class DmContentItemTO
implements Serializable {
    private static final long serialVersionUID = 4692872202161051204L;
    protected String _name;
    protected String _internalName;
    protected String _contentType;
    protected String _metaDescription;
    protected String _form;
    protected String _formPagePath;
    protected String _user;
    protected String _userFirstName;
    protected String _userLastName;
    protected Date _eventDate = null;
    protected int _numOfChildren = 0;
    protected String _path;
    protected String _mandatoryParent;
    protected String _defaultWebApp;
    protected Date _scheduledDate = null;
    protected String _submittedByFirstName;
    protected String _submittedByLastName;
    protected String _submissionComment;
    protected String _lockOwner;
    protected int _width;
    protected int _height;
    protected boolean _isNow = false;
    protected boolean _isNewFile = false;
    protected boolean _isPreviewable = false;
    protected boolean _isInProgress = false;
    protected boolean _isSubmitted = false;
    protected boolean _isScheduled = false;
    protected boolean _isNavigation = false;
    protected boolean _isFloating = false;
    protected boolean _isComponent = false;
    protected boolean _isAsset = false;
    protected boolean _isContainer = false;
    protected boolean _isDocument = false;
    protected boolean _isNew = false;
    protected boolean _isDisabled = false;
    protected boolean _isLevelDescriptor = false;
    protected boolean _isInFlight;
    protected boolean _renderingTemplate = false;
    protected boolean _isDeleted = false;
    protected boolean _isDirectory = false;
    protected boolean _submittedForDeletion = false;
    protected List<DmContentItemTO> _children;
    protected List<DmContentItemTO> _components;
    protected List<DmContentItemTO> _documents;
    protected List<DmContentItemTO> _assets;
    protected List<DmContentItemTO> _renderingTemplates;
    protected List<DmContentItemTO> _pages;
    protected List<DmContentItemTO> _deletedItems;
    protected List<DmContentItemTO> _levelDescriptors;
    protected List<DmOrderTO> _orders;
    protected String _uri = null;
    protected String _browserUri = null;
    protected String _categoryRoot = null;
    protected String _nodeRef = null;
    protected String _workflowId = null;
    protected String _timezone = null;
    protected String _title = null;
    protected boolean _hideInAuthoring = false;
    protected String _parentPath = null;
    protected boolean _isReference = false;
    protected Date _lastEditDate;
    protected boolean _skipDependencies = false;
    protected Map<String, String> _properties = new FastMap();
    protected String endpoint;

    public DmContentItemTO() {
    }

    public DmContentItemTO(DmContentItemTO item) {
        this(item, true);
    }

    public DmContentItemTO(DmContentItemTO item, boolean cloneChildren) {
        this._name = item._name;
        this._internalName = item._internalName;
        this._contentType = item._contentType;
        this._metaDescription = item._metaDescription;
        this._form = item._form;
        this._formPagePath = item._formPagePath;
        this._user = item._user;
        this._userFirstName = item._userFirstName;
        this._userLastName = item._userLastName;
        this._eventDate = item._eventDate;
        this._numOfChildren = item._numOfChildren;
        this._path = item._path;
        this._mandatoryParent = item._mandatoryParent;
        this._defaultWebApp = item._defaultWebApp;
        this._isDirectory = item._isDirectory;
        this._submittedByFirstName = item._submittedByFirstName;
        this._submittedByLastName = item._submittedByLastName;
        this._submissionComment = item._submissionComment;
        this._lockOwner = item._lockOwner;
        this._isNow = item._isNow;
        this._isNewFile = item._isNewFile;
        this._isPreviewable = item._isPreviewable;
        this._isInProgress = item._isInProgress;
        this._isSubmitted = item._isSubmitted;
        this._isScheduled = item._isScheduled;
        this._isNavigation = item._isNavigation;
        this._isFloating = item._isFloating;
        this._isComponent = item._isComponent;
        this._isAsset = item._isAsset;
        this._isContainer = item._isContainer;
        this._isDocument = item._isDocument;
        this._isNew = item._isNew;
        this._isDisabled = item._isDisabled;
        this._isLevelDescriptor = item._isLevelDescriptor;
        this._isDeleted = item._isDeleted;
        this._submittedForDeletion = item._submittedForDeletion;
        this._uri = item._uri;
        this._browserUri = item._browserUri;
        this._categoryRoot = item._categoryRoot;
        this._nodeRef = item._nodeRef;
        this._title = item._title;
        this._hideInAuthoring = item._hideInAuthoring;
        this._timezone = item._timezone;
        this._parentPath = item._parentPath;
        if (item._scheduledDate != null) {
            this._scheduledDate = new Date(item._scheduledDate.getTime());
        }
        if (item._eventDate != null) {
            this._eventDate = new Date(item._eventDate.getTime());
        }
        if (item._lastEditDate != null) {
            this._lastEditDate = new Date(item._lastEditDate.getTime());
        }
        if (cloneChildren && item._children != null) {
            this._children = new FastTable(item._children.size());
            for (DmContentItemTO child : item._children) {
                this._children.add(new DmContentItemTO(child));
            }
        }
        if (item._components != null) {
            this._components = new FastTable(item._components.size());
            for (DmContentItemTO component : item._components) {
                this._components.add(new DmContentItemTO(component));
            }
        }
        if (item._assets != null) {
            this._assets = new FastTable(item._assets.size());
            for (DmContentItemTO asset : item._assets) {
                this._assets.add(new DmContentItemTO(asset));
            }
        }
        if (item._documents != null) {
            this._documents = new FastTable(item._documents.size());
            for (DmContentItemTO document : item._documents) {
                this._documents.add(new DmContentItemTO(document));
            }
        }
        if (item._deletedItems != null) {
            this._deletedItems = new FastTable(item._deletedItems.size());
            for (DmContentItemTO deletedItem : item._deletedItems) {
                this._deletedItems.add(new DmContentItemTO(deletedItem));
            }
        }
        if (item._pages != null) {
            this._pages = new FastTable(item._pages.size());
            for (DmContentItemTO page : item._pages) {
                this._pages.add(new DmContentItemTO(page));
            }
        }
        if (item._renderingTemplates != null) {
            this._renderingTemplates = new FastTable(item._renderingTemplates.size());
            for (DmContentItemTO template : item._renderingTemplates) {
                this._renderingTemplates.add(new DmContentItemTO(template));
            }
        }
        if (item._levelDescriptors != null) {
            this._levelDescriptors = new FastTable(item._levelDescriptors.size());
            for (DmContentItemTO levelDescriptor : item._levelDescriptors) {
                this._levelDescriptors.add(new DmContentItemTO(levelDescriptor));
            }
        }
        if (item._orders != null) {
            this._orders = new FastList(item._orders.size());
            for (DmOrderTO order : item._orders) {
                this._orders.add(new DmOrderTO(order));
            }
        }
        if (item._properties != null) {
            this._properties = new FastMap();
            for (String key : item._properties.keySet()) {
                this._properties.put(key, item._properties.get(key));
            }
        }
        this._width = item._width;
        this._height = item._height;
        this._skipDependencies = item._skipDependencies;
    }

    public boolean isReference() {
        return this._isReference;
    }

    public void setReference(boolean isReference) {
        this._isReference = isReference;
    }

    public String getParentPath() {
        return this._parentPath;
    }

    public void setParentPath(String parentPath) {
        this._parentPath = parentPath;
    }

    public boolean isHideInAuthoring() {
        return this._hideInAuthoring;
    }

    public void setHideInAuthoring(boolean hideInAuthoring) {
        this._hideInAuthoring = hideInAuthoring;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getInternalName() {
        return this._internalName;
    }

    public void setInternalName(String internalName) {
        this._internalName = internalName;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getUserFirstName() {
        return this._userFirstName;
    }

    public void setUserFirstName(String userFirstName) {
        this._userFirstName = userFirstName;
    }

    public String getUserLastName() {
        return this._userLastName;
    }

    public void setUserLastName(String userLastName) {
        this._userLastName = userLastName;
    }

    public String getEventDate() {
        if (this._eventDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String dateStr = ContentFormatUtils.formatDate(format, this._eventDate, this._timezone);
            return dateStr;
        }
        return null;
    }

    public String getLastEditDateAsString() {
        if (this._lastEditDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String dateStr = ContentFormatUtils.formatDate(format, this._lastEditDate, this._timezone);
            return dateStr;
        }
        return null;
    }

    public String getScheduledDate() {
        if (this._scheduledDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String dateStr = ContentFormatUtils.formatDate(format, this._scheduledDate, this._timezone);
            return dateStr;
        }
        return null;
    }

    public void setScheduledDate(Date scheduledDate) {
        this._scheduledDate = scheduledDate;
    }

    public Date getEventDateAsDate() {
        return this._eventDate;
    }

    public Date getScheduledDateAsDate() {
        return this._scheduledDate;
    }

    public void setEventDate(Date eventDate) {
        this._eventDate = eventDate;
    }

    public boolean isInProgress() {
        return this._isInProgress;
    }

    public void setInProgress(boolean isInProgress) {
        this._isInProgress = isInProgress;
    }

    public boolean isSubmitted() {
        return this._isSubmitted;
    }

    public void setSubmitted(boolean isSubmitted) {
        this._isSubmitted = isSubmitted;
    }

    public boolean isLive() {
        return !this.isInProgress() && !this.isSubmitted() && !this.isScheduled() && !this.isSubmittedForDeletion() && !this.isNew();
    }

    public boolean isScheduled() {
        if (this._isScheduled && this._scheduledDate == null) {
            return false;
        }
        return this._isScheduled;
    }

    public void setScheduled(boolean isScheduled) {
        this._isScheduled = isScheduled;
    }

    public boolean isNavigation() {
        return this._isNavigation;
    }

    public void setNavigation(boolean isNavigation) {
        this._isNavigation = isNavigation;
    }

    public boolean isFloating() {
        return this._isFloating;
    }

    public void setFloating(boolean isFloating) {
        this._isFloating = isFloating;
    }

    public boolean isComponent() {
        return this._isComponent;
    }

    public void setComponent(boolean isComponent) {
        this._isComponent = isComponent;
    }

    public boolean isDocument() {
        return this._isDocument;
    }

    public void setDocument(boolean isDocument) {
        this._isDocument = isDocument;
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public void setContainer(boolean isContainer) {
        this._isContainer = isContainer;
    }

    public boolean isNew() {
        return this._isNew;
    }

    public void setNew(boolean isNew) {
        this._isNewFile = isNew;
        this._isNew = isNew;
    }

    public boolean isDisabled() {
        return this._isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this._isDisabled = isDisabled;
    }

    public boolean isSkipDependencies() {
        return this._skipDependencies;
    }

    public void setSkipDependencies(boolean skipDependencies) {
        this._skipDependencies = skipDependencies;
    }

    public List<DmContentItemTO> getChildren() {
        return this._children;
    }

    public void setChildren(List<DmContentItemTO> children) {
        this._children = children;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getDefaultWebApp() {
        return this._defaultWebApp;
    }

    public void setDefaultWebApp(String defaultWebApp) {
        this._defaultWebApp = defaultWebApp;
    }

    public void addChild(DmContentItemTO itemToAdd, boolean recursive, boolean renamed) {
        if (this._uri != null && this._uri.equals(itemToAdd.getUri())) {
            return;
        }
        if (recursive && (this._isNewFile || this._isDeleted || renamed) && !this._submittedForDeletion) {
            itemToAdd.setMandatoryParent(this._uri);
        }
        if (this._children == null) {
            this._children = new FastTable();
        }
        this._children.add(itemToAdd);
        ++this._numOfChildren;
    }

    public List<DmContentItemTO> getComponents() {
        return this._components;
    }

    public void setComponents(List<DmContentItemTO> components) {
        this._components = components;
    }

    public List<DmContentItemTO> getAssets() {
        return this._assets;
    }

    public void setAssets(List<DmContentItemTO> assets) {
        this._assets = assets;
    }

    public List<DmContentItemTO> getPages() {
        return this._pages;
    }

    public void setPages(List<DmContentItemTO> pages) {
        this._pages = pages;
    }

    public List<DmContentItemTO> getDeletedItems() {
        return this._deletedItems;
    }

    public void setDeletedItems(List<DmContentItemTO> deletedItems) {
        this._deletedItems = deletedItems;
    }

    public List<DmContentItemTO> getLevelDescriptors() {
        return this._levelDescriptors;
    }

    public void setLevelDescriptors(List<DmContentItemTO> levelDescriptors) {
        this._levelDescriptors = levelDescriptors;
    }

    public Double getOrder(String orderName) {
        if (orderName != null && this._orders != null) {
            for (DmOrderTO order : this._orders) {
                if (!orderName.equalsIgnoreCase(order.getId())) continue;
                return order.getOrder();
            }
        }
        return -1.0;
    }

    public String getBrowserUri() {
        List<DmContentItemTO> contentItemTOList;
        if (this.isDocument() && (contentItemTOList = this.getAssets()) != null && contentItemTOList.size() > 0) {
            return contentItemTOList.get(0).getBrowserUri();
        }
        return this._browserUri;
    }

    public void setBrowserUri(String browserUri) {
        this._browserUri = browserUri;
    }

    public String getCategoryRoot() {
        return this._categoryRoot;
    }

    public void setCategoryRoot(String categoryRoot) {
        this._categoryRoot = categoryRoot;
    }

    public String getMandatoryParent() {
        return this._mandatoryParent;
    }

    public void setMandatoryParent(String mandatoryParent) {
        this._mandatoryParent = mandatoryParent;
    }

    public boolean isNewFile() {
        return this._isNewFile;
    }

    public void setNewFile(boolean isNewFile) {
        this._isNewFile = isNewFile;
        this._isNew = isNewFile;
    }

    public boolean isNow() {
        return this._isNow;
    }

    public void setNow(boolean isNow) {
        this._isNow = isNow;
    }

    public boolean isAsset() {
        return this._isAsset;
    }

    public void setAsset(boolean isAsset) {
        this._isAsset = isAsset;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public String getMetaDescription() {
        return this._metaDescription;
    }

    public void setMetaDescription(String metaDescription) {
        this._metaDescription = metaDescription;
    }

    public int getNumOfChildren() {
        return this._numOfChildren;
    }

    public void setNumOfChildren(int numOfChildren) {
        this._numOfChildren = numOfChildren;
    }

    public boolean isLevelDescriptor() {
        return this._isLevelDescriptor;
    }

    public void setLevelDescriptor(boolean isLevelDescriptor) {
        this._isLevelDescriptor = isLevelDescriptor;
    }

    public String getFormPagePath() {
        return this._formPagePath;
    }

    public void setFormPagePath(String formPagePath) {
        this._formPagePath = formPagePath;
    }

    public String getSubmittedByFirstName() {
        return this._submittedByFirstName;
    }

    public void setSubmittedByFirstName(String submittedByFirstName) {
        this._submittedByFirstName = submittedByFirstName;
    }

    public String getSubmittedByLastName() {
        return this._submittedByLastName;
    }

    public void setSubmittedByLastName(String submittedByLastName) {
        this._submittedByLastName = submittedByLastName;
    }

    public String getSubmissionComment() {
        return this._submissionComment;
    }

    public void setSubmissionComment(String submissionComment) {
        this._submissionComment = submissionComment;
    }

    public String getNodeRef() {
        return this._nodeRef;
    }

    public void setNodeRef(String nodeRef) {
        this._nodeRef = nodeRef;
    }

    public String getLockOwner() {
        return this._lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this._lockOwner = lockOwner;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DmContentItemTO)) {
            return false;
        }
        DmContentItemTO item = (DmContentItemTO)object;
        return item.getUri().equals(this._uri) && item.getDefaultWebApp().equals(this._defaultWebApp);
    }

    public int hashCode() {
        int result = 17;
        return 31 * result + this.toString().hashCode();
    }

    public String toString() {
        return null;
    }

    public String getForm() {
        return this._form;
    }

    public void setForm(String form) {
        this._form = form;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this._isDeleted = isDeleted;
    }

    public boolean isSubmittedForDeletion() {
        return this._submittedForDeletion;
    }

    public void setSubmittedForDeletion(boolean submittedForDeletion) {
        this._submittedForDeletion = submittedForDeletion;
    }

    public List<DmContentItemTO> getDocuments() {
        return this._documents;
    }

    public void setDocuments(List<DmContentItemTO> documents) {
        this._documents = documents;
    }

    public boolean isPreviewable() {
        return this._isPreviewable;
    }

    public void setPreviewable(boolean isPreviewable) {
        this._isPreviewable = isPreviewable;
    }

    public String getWorkflowId() {
        return this._workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this._workflowId = workflowId;
    }

    public String getTimezone() {
        return this._timezone;
    }

    public void setTimezone(String timezone) {
        this._timezone = timezone;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public void setDirectory(boolean directory) {
        this._isDirectory = directory;
    }

    public Date getLastEditDate() {
        return this._lastEditDate;
    }

    public void setLastEditDate(Date lastEditDate) {
        this._lastEditDate = lastEditDate;
    }

    public boolean isInFlight() {
        return this._isInFlight;
    }

    public void setInFlight(boolean inFlight) {
        this._isInFlight = inFlight;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public DmContentItemTO filterOutFiles() {
        if (this._children != null) {
            FastTable newchildren = new FastTable(this._children.size());
            for (DmContentItemTO item : this._children) {
                if (!item.isContainer()) continue;
                item = item.filterOutFiles();
                newchildren.add(item);
            }
            this._children = newchildren;
            this._numOfChildren = newchildren.size();
        }
        return this;
    }

    public DmContentItemTO filterOutHidden() {
        if (this._hideInAuthoring) {
            if (this._isComponent || this._isAsset || this._isDocument || this._isLevelDescriptor) {
                if (this._children != null) {
                    this._children = null;
                }
                if (this._documents != null) {
                    this._documents = null;
                }
                if (this._assets != null) {
                    this._assets = null;
                }
                if (this._pages != null) {
                    this._pages = null;
                }
                if (this._deletedItems != null) {
                    this._deletedItems = null;
                }
                if (this._levelDescriptors != null) {
                    this._levelDescriptors = null;
                }
                return null;
            }
            return null;
        }
        if (this._children != null) {
            FastTable newchildren = new FastTable(this._children.size());
            for (DmContentItemTO item : this._children) {
                if ((item = item.filterOutHidden()) == null) continue;
                newchildren.add(item);
            }
            this._children = newchildren;
            this._numOfChildren = newchildren.size();
        }
        if (this._documents != null) {
            FastTable newdocuments = new FastTable(this._documents.size());
            for (DmContentItemTO item : this._documents) {
                if ((item = item.filterOutHidden()) == null) continue;
                newdocuments.add(item);
            }
            this._documents = newdocuments;
        }
        if (this._assets != null) {
            FastTable newassets = new FastTable(this._assets.size());
            for (DmContentItemTO item : this._assets) {
                if ((item = item.filterOutHidden()) == null) continue;
                newassets.add(item);
            }
            this._assets = newassets;
        }
        if (this._pages != null) {
            FastTable newpages = new FastTable(this._pages.size());
            for (DmContentItemTO item : this._pages) {
                if ((item = item.filterOutHidden()) == null) continue;
                newpages.add(item);
            }
            this._pages = newpages;
        }
        if (this._deletedItems != null) {
            FastTable newdeleteditems = new FastTable(this._deletedItems.size());
            for (DmContentItemTO item : this._deletedItems) {
                if ((item = item.filterOutHidden()) == null) continue;
                this._deletedItems.add(item);
            }
            this._deletedItems = newdeleteditems;
        }
        if (this._levelDescriptors != null) {
            FastTable newleveldescriptors = new FastTable(this._levelDescriptors.size());
            for (DmContentItemTO item : this._levelDescriptors) {
                if ((item = item.filterOutHidden()) == null) continue;
                newleveldescriptors.add(item);
            }
            this._levelDescriptors = newleveldescriptors;
        }
        return this;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public void setProperties(Map<String, String> properties) {
        this._properties = properties;
    }

    public void setOrders(List<DmOrderTO> orders) {
        this._orders = orders;
    }

    public List<DmOrderTO> getOrders() {
        return this._orders;
    }

    public List<DmContentItemTO> getRenderingTemplates() {
        return this._renderingTemplates;
    }

    public void setRenderingTemplates(List<DmContentItemTO> templates) {
        this._renderingTemplates = templates;
    }

    public boolean isRenderingTemplate() {
        return this._renderingTemplate;
    }

    public void setRenderingTemplate(boolean isTemplate) {
        this._renderingTemplate = isTemplate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public class AcceptAllChildFilter
    implements ChildFilter {
        @Override
        public boolean accept(DmContentItemTO to) {
            return true;
        }
    }

    public static interface ChildFilter {
        public boolean accept(DmContentItemTO var1);
    }
}

