/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.to;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.craftercms.studio.api.v1.constant.DmConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmPathTO
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DmPathTO.class);
    private static final long serialVersionUID = 1678837872209101222L;
    protected String _storeName = "workspace";
    protected String _wemProjectsRoot;
    protected String _wemProjectName;
    protected String _siteName;
    protected String _areaName;
    protected String _relativePath;
    protected String _name;

    public String getAreaName() {
        return this._areaName;
    }

    public void setAreaName(String _areaName) {
        this._areaName = _areaName;
    }

    public DmPathTO() {
    }

    public DmPathTO(String dmPath) {
        Matcher m = DmConstants.DM_MULTI_REPO_PATH_PATTERN.matcher(dmPath);
        if (m.matches()) {
            this._wemProjectsRoot = m.group(1).length() != 0 ? m.group(1) : "wem-projects";
            this._wemProjectName = m.group(2).length() != 0 ? m.group(2) : "";
            this._siteName = m.group(3).length() != 0 ? m.group(3) : "";
            this._areaName = m.group(4).length() != 0 ? m.group(4) : "work-area";
            this._relativePath = m.group(5).length() != 0 ? m.group(5) : "/";
            int index = this._relativePath.lastIndexOf("/");
            if (index > 0 && index < this._relativePath.length() + 1) {
                this._name = this._relativePath.substring(index + 1);
            }
        }
    }

    public DmPathTO(String storeName, String wemProjectsRoot, String wemProjectName, String siteName, String areaName, String relativePath) {
        int index;
        this._storeName = storeName;
        this._wemProjectsRoot = wemProjectsRoot;
        this._wemProjectName = wemProjectName;
        this._siteName = siteName;
        this._areaName = areaName;
        this._relativePath = relativePath;
        if (this._relativePath != null && (index = this._relativePath.lastIndexOf("/")) > 0 && index < this._relativePath.length() + 1) {
            this._name = this._relativePath.substring(index + 1);
        }
    }

    public String getStoreName() {
        return this._storeName;
    }

    public void setStoreName(String storeName) {
        this._storeName = storeName;
    }

    public String getDmSitePath() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this._wemProjectsRoot).append("/");
        sb.append(this._wemProjectName).append("/");
        sb.append(this._siteName).append("/");
        sb.append(this._areaName);
        return sb.toString();
    }

    public String getRelativePath() {
        return this._relativePath;
    }

    public void setRelativePath(String relativePath) {
        this._relativePath = relativePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this._wemProjectsRoot).append("/");
        sb.append(this._wemProjectName).append("/");
        sb.append(this._siteName).append("/");
        sb.append(this._areaName);
        sb.append(this._relativePath);
        return sb.toString();
    }

    public String getAssetPath() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this._wemProjectsRoot).append("/");
        sb.append(this._wemProjectName).append("/");
        sb.append(this._siteName).append("/");
        sb.append(this._areaName);
        sb.append(this._relativePath);
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getSiteName() {
        return this._siteName;
    }
}

