/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.util;

import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.impl.v1.util.ContentComparatorBase;

public class DmContentItemComparator
extends ContentComparatorBase<ContentItemTO> {
    public static final String SORT_EVENT_DATE = "eventDate";
    public static final String SORT_INTERNAL_NAME = "internalName";
    public static final String SORT_BROWSER_URI = "browserUri";
    public static final String SORT_PATH = "path";
    public static final String SORT_USER_LAST_NAME = "userLastName";
    protected boolean _listFloatingPagesLast;
    protected boolean _listLevelDescriptorsFirst;
    protected String _secondLevelSortBy;
    protected boolean _isSecondLevelCompareRequired;
    protected boolean _secondLevelAscending;

    public DmContentItemComparator(String sort, boolean ascending, boolean listFloatingPagesLast, boolean listLevelDescriptorsFirst) {
        super(sort, ascending);
        this._listFloatingPagesLast = listFloatingPagesLast;
        this._listLevelDescriptorsFirst = listLevelDescriptorsFirst;
    }

    public DmContentItemComparator(String sort, boolean ascending, boolean listFloatingPagesLast, boolean listLevelDescriptorsFirst, String secondLevelSortBy, boolean secLevelCompareReq, boolean secLevAscending) {
        this(sort, ascending, listFloatingPagesLast, listLevelDescriptorsFirst);
        this._secondLevelSortBy = secondLevelSortBy;
        this._isSecondLevelCompareRequired = secLevelCompareReq;
        this._secondLevelAscending = secLevAscending;
    }

    public boolean areEqual(ContentItemTO item1, ContentItemTO item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.equals(item2);
    }

    public int hashCodeOf(ContentItemTO item) {
        if (item != null) {
            return item.hashCode();
        }
        return 0;
    }

    public int compare(ContentItemTO item1, ContentItemTO item2) {
        if (this._listLevelDescriptorsFirst) {
            if (item1.isLevelDescriptor && !item2.isLevelDescriptor) {
                return this._ascending ? -1 : 1;
            }
            if (!item1.isLevelDescriptor && item2.isLevelDescriptor) {
                return this._ascending ? 1 : -1;
            }
        }
        if (this._listFloatingPagesLast) {
            if (item1.isFloating && !item2.isFloating) {
                return this._ascending ? 1 : -1;
            }
            if (!item1.isFloating && item2.isFloating) {
                return this._ascending ? -1 : 1;
            }
        }
        if (SORT_EVENT_DATE.equals(this._sort)) {
            int rt = this.compareDates(item1.eventDate, item2.eventDate, this._ascending);
            if (rt == 0 && this._isSecondLevelCompareRequired) {
                return this.secondLevelCompare(item1, item2);
            }
            return rt;
        }
        if (SORT_INTERNAL_NAME.equals(this._sort)) {
            String item2InternalName;
            String item1InternalName = item1.internalName != null ? item1.internalName.toLowerCase() : null;
            int rt = this.compareStrings(item1InternalName, item2InternalName = item2.internalName != null ? item2.internalName.toLowerCase() : null, this._ascending);
            if (rt == 0 && this._isSecondLevelCompareRequired) {
                return this.secondLevelCompare(item1, item2);
            }
            return rt;
        }
        if (SORT_BROWSER_URI.equals(this._sort)) {
            String item2Uri;
            String item1Uri = item1.uri != null ? item1.uri.toLowerCase() : null;
            int rt = this.compareStrings(item1Uri, item2Uri = item2.uri != null ? item2.uri.toLowerCase() : null, this._ascending);
            if (rt == 0 && this._isSecondLevelCompareRequired) {
                return this.secondLevelCompare(item1, item2);
            }
            return rt;
        }
        if (SORT_PATH.equals(this._sort)) {
            String item2Path;
            String item1Path = item1.path != null ? item1.path.toLowerCase() : null;
            int rt = this.compareStrings(item1Path, item2Path = item2.path != null ? item2.path.toLowerCase() : null, this._ascending);
            if (rt == 0 && this._isSecondLevelCompareRequired) {
                return this.secondLevelCompare(item1, item2);
            }
            return rt;
        }
        if (SORT_USER_LAST_NAME.equals(this._sort)) {
            String item2LastName;
            String item1LastName = item1.userLastName != null ? item1.userLastName.toLowerCase() : null;
            int result = this.compareStrings(item1LastName, item2LastName = item2.userLastName != null ? item2.userLastName.toLowerCase() : null, this._ascending);
            if (result == 0) {
                String item1FirstName = item1.userFirstName != null ? item1.userFirstName.toLowerCase() : null;
                String item2FirstName = item2.userFirstName != null ? item2.userFirstName.toLowerCase() : null;
                return this.compareStrings(item1FirstName, item2FirstName, this._ascending);
            }
            return result;
        }
        return 0;
    }

    public int secondLevelCompare(ContentItemTO item1, ContentItemTO item2) {
        if (SORT_EVENT_DATE.equals(this._secondLevelSortBy)) {
            return this.compareDates(item1.eventDate, item2.eventDate, this._secondLevelAscending);
        }
        if (SORT_INTERNAL_NAME.equals(this._secondLevelSortBy)) {
            String item1InternalName = item1.internalName != null ? item1.internalName.toLowerCase() : null;
            String item2InternalName = item2.internalName != null ? item2.internalName.toLowerCase() : null;
            return this.compareStrings(item1InternalName, item2InternalName, this._secondLevelAscending);
        }
        if (SORT_BROWSER_URI.equals(this._secondLevelSortBy)) {
            String item1Uri = item1.uri != null ? item1.uri.toLowerCase() : null;
            String item2Uri = item2.uri != null ? item2.uri.toLowerCase() : null;
            return this.compareStrings(item1Uri, item2Uri, this._secondLevelAscending);
        }
        if (SORT_PATH.equals(this._secondLevelSortBy)) {
            String item1Path = item1.path != null ? item1.path.toLowerCase() : null;
            String item2Path = item2.path != null ? item2.path.toLowerCase() : null;
            return this.compareStrings(item1Path, item2Path, this._secondLevelAscending);
        }
        if (SORT_USER_LAST_NAME.equals(this._secondLevelSortBy)) {
            String item2LastName;
            String item1LastName = item1.userLastName != null ? item1.userLastName.toLowerCase() : null;
            int result = this.compareStrings(item1LastName, item2LastName = item2.userLastName != null ? item2.userLastName.toLowerCase() : null, this._secondLevelAscending);
            if (result == 0) {
                String item1FirstName = item1.userFirstName != null ? item1.userFirstName.toLowerCase() : null;
                String item2FirstName = item2.userFirstName != null ? item2.userFirstName.toLowerCase() : null;
                return this.compareStrings(item1FirstName, item2FirstName, this._secondLevelAscending);
            }
            return result;
        }
        return 0;
    }

    public void setListFloatingPagesLast(boolean listFloatingPagesLast) {
        this._listFloatingPagesLast = listFloatingPagesLast;
    }

    public boolean isListFloatingPagesLast() {
        return this._listFloatingPagesLast;
    }

    public void setListLevelDescriptorsFirst(boolean listLevelDescriptorsFirst) {
        this._listLevelDescriptorsFirst = listLevelDescriptorsFirst;
    }

    public boolean isListLevelDescriptorsFirst() {
        return this._listLevelDescriptorsFirst;
    }

    public String getSecondLevelSortBy() {
        return this._secondLevelSortBy;
    }

    public void setSecondLevelSortBy(String secondLevelSort) {
        this._secondLevelSortBy = secondLevelSort;
    }

    public boolean isSecondLevelCompareRequired() {
        return this._isSecondLevelCompareRequired;
    }

    public void setSecondLevelCompareRequired(boolean secondLevelCompareReq) {
        this._isSecondLevelCompareRequired = secondLevelCompareReq;
    }

    public boolean isSecondLevelAscending() {
        return this._secondLevelAscending;
    }

    public void setSecondLevelAscending(boolean secondLevelAscending) {
        this._secondLevelAscending = secondLevelAscending;
    }
}

