/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1;

import com.google.gdata.client.Query;
import com.google.gdata.client.analytics.DataQuery;
import com.google.gdata.data.analytics.DataEntry;
import com.google.gdata.data.analytics.DataFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.craftercms.studio.api.v1.service.AnalyticsQuery;
import org.craftercms.studio.api.v1.service.AnalyticsService;
import org.craftercms.studio.api.v1.to.AnalyticsReportTO;
import org.craftercms.studio.impl.v1.GoogleAnalyticsQueryImpl;

public class GoogleAnalyticsServiceImpl
implements AnalyticsService {
    public static final String ACCOUNTS_URL = "https://www.google.com/analytics/feeds/accounts/default";
    public static final String DATA_URL = "https://www.google.com/analytics/feeds/data";
    public static final String DIMENSION_VISITOR_TYPE = "ga:visitorType";
    public static final String DIMENSION_VISITOR_COUNT = "ga:visitorCount";
    public static final String DIMENSION_DAYS_SINCE_LAST_VISIT = "ga:daysSinceLastVisit";
    public static final String DIMENSION_USER_DEFINED_VALUE = "ga:userDefinedValue";
    public static final String DIMENSION_VISIT_LENGTH = "ga:visitLength";
    public static final String DIMENSION_REFERRAL_PATH = "ga:referralPath";
    public static final String DIMENSION_CAMPAIGN = "ga:campaign";
    public static final String DIMENSION_SOURCE = "ga:source";
    public static final String DIMENSION_MEDIUM = "ga:medium";
    public static final String DIMENSION_KEYWORD = "ga:keyword";
    public static final String DIMENSION_AD_CONTENT = "ga:adContent";
    public static final String DIMENSION_AD_GROUP = "ga:adGroup";
    public static final String DIMENSION_AD_SLOT = "ga:adSlot";
    public static final String DIMENSION_AD_SLOT_POSITION = "ga:adSlotPosition";
    public static final String DIMENSION_AD_DISTRIBUTION_NETWORK = "ga:adDistributionNetwork";
    public static final String DIMENSION_AD_MATCH_TYPE = "ga:adMatchType";
    public static final String DIMENSION_AD_MATCHED_QUERY = "ga:adMatchedQuery";
    public static final String DIMENSION_AD_PLACEMENT_DOMAIN = "ga:adPlacementDomain";
    public static final String DIMENSION_AD_PLACEMENT_URL = "ga:adPlacementUrl";
    public static final String DIMENSION_AD_FORMAT = "ga:adFormat";
    public static final String DIMENSION_AD_TARGETING_TYPE = "ga:adTargetingType";
    public static final String DIMENSION_AD_TARGETING_OPTION = "ga:adTargetingOption";
    public static final String DIMENSION_AD_DISPLAY_URL = "ga:adDisplayUrl";
    public static final String DIMENSION_AD_DESTINATION_URL = "ga:adDestinationUrl";
    public static final String DIMENSION_ADWORDS_CUSTOMER_ID = "ga:adwordsCustomerId";
    public static final String DIMENSION_ADWORDS_CAMPAIGN_ID = "ga:adwordsCampaignId";
    public static final String DIMENSION_ADWORDS_AD_GROUP_ID = "ga:adwordsAdGroupId";
    public static final String DIMENSION_ADWORDS_CREATIVE_ID = "ga:adwordsCreativeId";
    public static final String DIMENSION_ADWORDS_CRITERIA_ID = "ga:adwordsCriteriaId";
    public static final String DIMENSION_BROWSER = "ga:browser";
    public static final String DIMENSION_BROWSER_VERSION = "ga:browserVersion";
    public static final String DIMENSION_OPERATING_SYSTEM = "ga:operatingSystem";
    public static final String DIMENSION_OPERATING_SYSTEM_VERSION = "ga:operatingSystemVersion";
    public static final String DIMENSION_FLASH_VERSION = "ga:flashVersion";
    public static final String DIMENSION_JAVA_ENABLED = "ga:javaEnabled";
    public static final String DIMENSION_IS_MOBILE = "ga:isMobile";
    public static final String DIMENSION_LANGUAGE = "ga:language";
    public static final String DIMENSION_SCREEN_COLORS = "ga:screenColors";
    public static final String DIMENSION_SCREEN_RESOLUTION = "ga:screenResolution";
    public static final String DIMENSION_CONTINENT = "ga:continent";
    public static final String DIMENSION_SUB_CONTINENT = "ga:subContinent";
    public static final String DIMENSION_COUNTRY = "ga:country";
    public static final String DIMENSION_REGION = "ga:region";
    public static final String DIMENSION_CITY = "ga:city";
    public static final String DIMENSION_LATITUDE = "ga:latitude";
    public static final String DIMENSION_LONGITUDE = "ga:longitude";
    public static final String DIMENSION_NETWORK_DOMAIN = "ga:networkDomain";
    public static final String DIMENSION_NETWORK_LOCATION = "ga:networkLocation";
    public static final String DIMENSION_HOSTNAME = "ga:hostname";
    public static final String DIMENSION_PAGE_PATH = "ga:pagePath";
    public static final String DIMENSION_PAGE_TITLE = "ga:pageTitle";
    public static final String DIMENSION_LANDING_PAGE_PATH = "ga:landingPagePath";
    public static final String DIMENSION_SECOND_PAGE_PATH = "ga:secondPagePath";
    public static final String DIMENSION_EXIT_PAGE_PATH = "ga:exitPagePath";
    public static final String DIMENSION_PREVIOUS_PAGE_PATH = "ga:previousPagePath";
    public static final String DIMENSION_NEXT_PAGE_PATH = "ga:nextPagePath";
    public static final String DIMENSION_PAGE_DEPTH = "ga:pageDepth";
    public static final String DIMENSION_SEARCH_USED = "ga:searchUsed";
    public static final String DIMENSION_SEARCH_KEYWORD = "ga:searchKeyword";
    public static final String DIMENSION_SEARCH_KEYWORD_REFINEMENT = "ga:searchKeywordRefinement";
    public static final String DIMENSION_CATEGORY = "ga:searchCategory";
    public static final String DIMENSION_START_PAGE = "ga:searchStartPage";
    public static final String DIMENSION_DESTINATION_PAGE = "ga:searchDestinationPage";
    public static final String DIMENSION_EVENT_CATEGORY = "ga:eventCategory";
    public static final String DIMENSION_EVENT_ACTION = "ga:eventAction";
    public static final String DIMENSION_EVENT_LABEL = "ga:eventLabel";
    public static final String DIMENSION_TRANSACTION_ID = "ga:transactionId";
    public static final String DIMENSION_AFFILIATION = "ga:affiliation";
    public static final String DIMENSION_VISITS_TO_TRANSACTION = "ga:visitsToTransaction";
    public static final String DIMENSION_DAYS_TO_TRANSACTION = "ga:daysToTransaction";
    public static final String DIMENSION_PRODUCT_CATEGORY = "ga:productCategory";
    public static final String DIMENSION_PRODUCT_NAME = "ga:productName";
    public static final String DIMENSION_PRODUCT_SKU = "ga:productSku";
    public static final String DIMENSION_CUSTOM_VAR_NAME_N = "ga:customVarName(%d)";
    public static final String DIMENSION_CUSTOM_VAR_VALUE_N = "ga:customVarValue(%d)";
    public static final String DIMENSION_DATE = "ga:date";
    public static final String DIMENSION_YEAR = "ga:year";
    public static final String DIMENSION_MONTH = "ga:month";
    public static final String DIMENSION_WEEK = "ga:week";
    public static final String DIMENSION_DAY = "ga:day";
    public static final String DIMENSION_HOUR = "ga:hour";
    public static final String DIMENSION_NTH_MONTH = "ga:nthMonth";
    public static final String DIMENSION_NTH_WEEK = "ga:nthWeek";
    public static final String DIMENSION_NTH_DAY = "ga:nthDay";
    public static final String DIMENSION_DAY_OF_WEEK = "ga:dayOfWeek";
    public static final String METRIC_VISITORS = "ga:visitors";
    public static final String METRIC_NEW_VISITS = "ga:newVisits";
    public static final String METRIC_PERCENT_NEW_VISITS = "ga:percentNewVisits";
    public static final String METRIC_VISITS = "ga:visits";
    public static final String METRIC_TIME_ON_SITE = "ga:timeOnSite";
    public static final String METRIC_AVG_TIME_ON_SITE = "ga:avgTimeOnSite";
    public static final String METRIC_ORGANIG_SEARCHES = "ga:organincSearches";
    public static final String METRIC_IMPRESSIONS = "ga:impressions";
    public static final String METRIC_AD_CLICKS = "ga:adClicks";
    public static final String METRIC_AD_COST = "ga:adCost";
    public static final String METRIC_CPM = "ga:CPM";
    public static final String METRIC_CPC = "ga:CPC";
    public static final String METRIC_CTR = "ga:CTR";
    public static final String METRIC_COST_PER_TRANSACTION = "ga:costPerTransaction";
    public static final String METRIC_COST_PER_GOAL_CONVERSION = "ga:costPerGoalConversion";
    public static final String METRIC_COST_PER_CONVERSION = "ga:costPerConversion";
    public static final String METRIC_RPC = "ga:RPC";
    public static final String METRIC_ROI = "ga:ROI";
    public static final String METRIC_MARGIN = "ga:margin";
    public static final String METRIC_GOAL_N_STARTS = "ga:goal(%d)Starts";
    public static final String METRIC_GOAL_STARTS_ALL = "ga:goalStartsAll";
    public static final String METRIC_GOAL_N_COMPLETIONS = "ga:goal(%d)Completions";
    public static final String METRIC_GOAL_COMPLETIONS_ALL = "ga:goalCompletionsAll";
    public static final String METRIC_GOAL_N_VALUE = "ga:goal(%d)Value";
    public static final String METRIC_GOAL_VALUE_ALL = "ga:goalValueAll";
    public static final String METRIC_GOAL_VALUE_PER_VISIT = "ga:goalValuePerVisit";
    public static final String METRIC_GOAL_N_CONVERSION_RATE = "ga:goal(%d)ConversionRate";
    public static final String METRIC_GOAL_CONVERSION_RATE_ALL = "ga:goalConversionRateAll";
    public static final String METRIC_GOAL_N_ABANDONS = "ga:goal(%d)Abandons";
    public static final String METRIC_GOAL_ABANDONS_ALL = "ga:goalAbandonsAll";
    public static final String METRIC_GOAL_N_ABANDON_RATE = "ga:goal(%d)AbandonRate";
    public static final String METRIC_GOAL_ABANDON_RATE_ALL = "ga:goalAbandonRateAll";
    public static final String METRIC_ENTRANCES = "ga:entrances";
    public static final String METRIC_ENTRANCE_RATE = "ga:entranceRate";
    public static final String METRIC_BOUNCES = "ga:bounces";
    public static final String METRIC_ENTRANCE_BOUNCE_RATE = "ga:entranceBounceRate";
    public static final String METRIC_VISIT_BOUNCE_RATE = "ga:visitBounceRate";
    public static final String METRIC_PAGEVIEWS = "ga:pageviews";
    public static final String METRIC_PAGEVIEWS_PER_VISIT = "ga:pageviewsPerVisit";
    public static final String METRIC_UNIQUE_PAGEVIEWS = "ga:uniquePageviews";
    public static final String METRIC_TIME_ON_PAGE = "ga:timeOnPage";
    public static final String METRIC_AVG_TIME_ON_PAGE = "ga:avgTimeOnPage";
    public static final String METRIC_EXITS = "ga:exits";
    public static final String METRIC_EXIT_RATE = "ga:exitRate";
    public static final String METRIC_PAGE_LOAD_SAMPLE = "ga:pageLoadSample";
    public static final String METRIC_PAGE_LOAD_TIME = "ga:pageLoadTime";
    public static final String METRIC_AVG_PAGE_LOAD_TIME = "ga:avgPageLoadTime";
    public static final String METRIC_SEARCH_RESULT_VIEWS = "ga:searchResultViews";
    public static final String METRIC_SEARCH_UNIQUES = "ga:searchUniques";
    public static final String METRIC_AVG_SEARCH_RESULT_VIEWS = "ga:avgSearchResultViews";
    public static final String METRIC_SEARCH_VISITS = "ga:searchVisits";
    public static final String METRIC_PERCENT_VISITS_WITH_SEARCH = "ga:percentVisitsWithSearch";
    public static final String METRIC_SEARCH_DEPTH = "ga:searchDepth";
    public static final String METRIC_AVG_SEARCH_DEPTH = "ga:avgSearchDepth";
    public static final String METRIC_SEARCH_REFINEMENTS = "ga:searchRefinements";
    public static final String METRIC_SEARCH_DURATION = "ga:searchDuration";
    public static final String METRIC_AVG_SEARCH_DURATION = "ga:avgSearchDuration";
    public static final String METRIC_SEARCH_EXITS = "ga:searchExits";
    public static final String METRIC_SEARCH_EXIT_RATE = "ga:searchExitRate";
    public static final String METRIC_SEARCH_GOAL_N_CONVERSION_RATE = "ga:searchGoal(%d)ConversionRate";
    public static final String METRIC_SEARCH_GOAL_CONVERSION_RATE_ALL = "ga:searchGoalConversionRateAll";
    public static final String METRIC_GOAL_VALUE_ALL_PER_SEARCH = "ga:goalValueAllPerSearch";
    public static final String METRIC_TOTAL_EVENTS = "ga:totalEvents";
    public static final String METRIC_UNIQUE_EVENTS = "ga:uniqueEvents";
    public static final String METRIC_EVENT_VALUE = "ga:eventValue";
    public static final String METRIC_AVG_EVENT_VALUE = "ga:avgEventValue";
    public static final String METRIC_VISITS_WITH_EVENT = "ga:visitsWithEvent";
    public static final String METRIC_EVENTS_PER_VISIT_WITH_EVENT = "ga:eventsPerVisitWithEvent";
    public static final String METRIC_TRANSACTIONS = "ga:transactions";
    public static final String METRIC_TRANSACTIONS_PER_VISIT = "ga:transactionsPerVisit";
    public static final String METRIC_TRANSACTION_REVENUE = "ga:transactionRevenue";
    public static final String METRIC_REVENUE_PER_TRANSACTION = "ga:revenuePerTransaction";
    public static final String METRIC_TRANSACTION_REVENUE_PER_VISIT = "ga:transactionRevenuePerVisit";
    public static final String METRIC_TRANSACTION_SHIPPING = "ga:transactionShipping";
    public static final String METRIC_TRANSACTION_TAX = "ga:transactionTax";
    public static final String METRIC_TOTAL_VALUE = "ga:totalValue";
    public static final String METRIC_ITEM_QUANTITY = "ga:itemQuantity";
    public static final String METRIC_UNIQUE_PURCHASES = "ga:uniquePurchases";
    public static final String METRIC_REVENUE_PER_ITEM = "ga:revenuePerItem";
    public static final String METRIC_ITEM_REVENUE = "ga:itemRevenue";
    public static final String METRIC_ITEMS_PER_PURCHASE = "ga:itemsPerPurchase";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static Calendar calendar = Calendar.getInstance();

    @Override
    public AnalyticsQuery createQuery() {
        return new GoogleAnalyticsQueryImpl();
    }

    private static String parseDate(String date) {
        if ((date = date.trim()).equalsIgnoreCase("today")) {
            return dateFormat.format(new Date());
        }
        if (date.startsWith("today-")) {
            calendar.setTime(new Date());
            calendar.add(6, Integer.parseInt(date.substring(date.indexOf("-")).trim()));
            return dateFormat.format(calendar.getTime());
        }
        return date;
    }

    @Override
    public AnalyticsReportTO query(AnalyticsQuery query) {
        try {
            GoogleAnalyticsQueryImpl gaQuery = (GoogleAnalyticsQueryImpl)query;
            com.google.gdata.client.analytics.AnalyticsService service = new com.google.gdata.client.analytics.AnalyticsService("csga-service-v1.0");
            service.setUserCredentials(gaQuery.getUsername(), gaQuery.getPassword());
            DataQuery dq = new DataQuery(new URL(DATA_URL));
            dq.setIds(gaQuery.getViewId());
            dq.setStartDate(GoogleAnalyticsServiceImpl.parseDate(gaQuery.getStartDate()));
            dq.setEndDate(GoogleAnalyticsServiceImpl.parseDate(gaQuery.getEndDate()));
            dq.setDimensions(gaQuery.getDimensionsAsString());
            dq.setMetrics(gaQuery.getMetricsAsString());
            dq.setFilters(gaQuery.getFilters());
            dq.setSort(gaQuery.getSort());
            DataFeed df = (DataFeed)service.getFeed((Query)dq, DataFeed.class);
            AnalyticsReportTO gar = new AnalyticsReportTO();
            for (DataEntry de : df.getEntries()) {
                AnalyticsReportTO.Entry gare = new AnalyticsReportTO.Entry();
                for (String dimension : gaQuery.getDimensions()) {
                    gare.put(dimension, de.stringValueOf(dimension));
                }
                for (String metric : gaQuery.getMetrics()) {
                    gare.put(metric, de.stringValueOf(metric));
                }
                gar.addEntry(gare);
            }
            return gar;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }
}

