/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.cache;

import java.io.Serializable;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;

public class EhCacheAdapter<K extends Serializable, V> {
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean contains(K key) {
        try {
            return this.cache.getQuiet(key) != null;
        }
        catch (CacheException e) {
            throw new RuntimeException("contains failed", e);
        }
    }

    public Collection<K> getKeys() {
        return this.cache.getKeys();
    }

    public V get(K key) {
        try {
            Element element = this.cache.get(key);
            if (element != null) {
                return (V)element.getObjectValue();
            }
            return null;
        }
        catch (IllegalStateException ie) {
            throw new RuntimeException("Failed to get from EhCache as state invalid: \n  state: " + this.cache.getStatus() + "\n" + "   key: " + key, ie);
        }
        catch (CacheException e) {
            throw new RuntimeException("Failed to get from EhCache: \n   key: " + key, e);
        }
    }

    public void put(K key, V value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }
}

