/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.cache;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.craftercms.studio.api.v1.cache.Scope;
import org.craftercms.studio.api.v1.cache.ThreadSafeCacheManager;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.GoLiveQueue;
import org.craftercms.studio.impl.v1.cache.EhCacheAdapter;

public class EhCacheManagerImpl
implements ThreadSafeCacheManager {
    protected EhCacheAdapter<CacheKey, Serializable> cacheAdapter;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Scope scope, String key, Serializable item) {
        this.lock.writeLock().lock();
        try {
            CacheKey cacheKey = new CacheKey(scope, key);
            this.cacheAdapter.put(cacheKey, item);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void put(Scope scope, String key, String site, Serializable item) {
        if (site != null) {
            key = site + ":" + key;
        }
        this.put(scope, key, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable get(Scope scope, String key) {
        this.lock.readLock().lock();
        try {
            CacheKey cacheKey = new CacheKey(scope, key);
            Serializable serializable = this.cacheAdapter.get(cacheKey);
            return serializable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Serializable get(Scope scope, String key, String site) {
        if (site != null) {
            key = site + ":" + key;
        }
        return this.get(scope, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Scope scope, String key) {
        this.lock.writeLock().lock();
        try {
            CacheKey cacheKey = new CacheKey(scope, key);
            this.cacheAdapter.remove(cacheKey);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void invalidate(Scope scope) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        this.lock.writeLock().lock();
        try {
            this.cacheAdapter.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public String generateKey(Object ... params) {
        String key = "";
        if (params != null) {
            int max = params.length;
            for (int index = 0; index < max; ++index) {
                key = key + (params[index] == null ? "" : params[index].toString());
                if (index + 1 != max) continue;
                key = key + ",";
            }
        }
        return key;
    }

    @Override
    public void invalidateAndRemoveFromQueue(String fullpath, String site) {
        DmPathTO pathTO = new DmPathTO(fullpath);
        String path = pathTO.getRelativePath();
        GoLiveQueue queue = (GoLiveQueue)this.get(Scope.DM_SUBMITTED_ITEMS, "goliveItems", site);
        if (null != queue) {
            queue.remove(path);
        }
    }

    public EhCacheAdapter<CacheKey, Serializable> getEhCacheAdapter() {
        return this.cacheAdapter;
    }

    public void setEhCacheAdapter(EhCacheAdapter<CacheKey, Serializable> ehCacheAdapter) {
        this.cacheAdapter = ehCacheAdapter;
    }

    protected class CacheKey
    implements Serializable {
        protected Scope scope;
        protected String key;

        protected CacheKey(Scope scope, String key) {
            this.scope = scope;
            this.key = key;
        }

        public Scope getScope() {
            return this.scope;
        }

        public void setScope(Scope scope) {
            this.scope = scope;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null) {
                return false;
            }
            return this.scope == cacheKey.scope;
        }

        public int hashCode() {
            int result = this.scope != null ? this.scope.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

