/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.FormDmContentProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class AssetDmContentProcessor
extends FormDmContentProcessor {
    public static final int READ_BUFFER_LENGTH = 32768;
    public static final String FILE_SIZE_MB = "MB";
    public static final String FILE_SIZE_KB = "KB";
    private static final Logger logger = LoggerFactory.getLogger(AssetDmContentProcessor.class);
    public static final String NAME = "WriteAssetToDmProcessor";
    protected String _assetsSystemPath;
    protected ObjectStateService objectStateService;

    public String getAssetsSystemPath() {
        return this._assetsSystemPath;
    }

    public void setAssetsSystemPath(String assetsSystemPath) {
        this._assetsSystemPath = assetsSystemPath;
    }

    public AssetDmContentProcessor() {
        super(NAME);
    }

    public AssetDmContentProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String site = content.getProperty("site");
        String user = content.getProperty("user");
        String path = content.getProperty("path");
        String fileName = content.getProperty("fileName");
        String widthStr = content.getProperty("width");
        String heightStr = content.getProperty("height");
        int width = widthStr != null ? Integer.parseInt(widthStr) : -1;
        int height = heightStr != null ? Integer.parseInt(heightStr) : -1;
        String unlockValue = content.getProperty("unlock");
        boolean unlock = StringUtils.isEmpty((String)unlockValue) || !unlockValue.equalsIgnoreCase("false");
        boolean isPreview = ContentFormatUtils.getBooleanValue(content.getProperty("isPreview"));
        boolean isSystemAsset = ContentFormatUtils.getBooleanValue(content.getProperty("systemAsset"));
        boolean createFolders = ContentFormatUtils.getBooleanValue(content.getProperty("createFolders"));
        try {
            ContentAssetInfoTO oldAssetInfo = (ContentAssetInfoTO)result.getItem();
            ContentAssetInfoTO assetInfo = this.writeContentAsset(site, user, path, fileName, content.getContentStream(), width, height, createFolders, isPreview, unlock, isSystemAsset);
            if (oldAssetInfo != null) {
                oldAssetInfo.setFileExtension(assetInfo.getFileExtension());
                oldAssetInfo.setFileName(assetInfo.getFileName());
                oldAssetInfo.setSize(assetInfo.getSize());
                oldAssetInfo.setSizeUnit(assetInfo.getSizeUnit());
                result.setItem(oldAssetInfo);
            } else {
                result.setItem(assetInfo);
            }
        }
        catch (ServiceException e) {
            throw new ContentProcessException("Failed to write " + content.getId() + ", " + e, e);
        }
        finally {
            content.closeContentStream();
        }
    }

    protected ContentAssetInfoTO writeContentAsset(String site, String user, String path, String assetName, InputStream in, int width, int height, boolean createFolders, boolean isPreview, boolean unlock, boolean isSystemAsset) throws ServiceException {
        logger.debug("Writing content asset: [site: " + site + ", path: " + path + ", assetName: " + assetName + ", createFolders: " + createFolders, new Object[0]);
        String ext = null;
        int index = assetName.lastIndexOf(".");
        if (index > 0 && index + 1 < assetName.length()) {
            ext = assetName.substring(index + 1).toUpperCase();
        }
        String folderPath = this.contentService.expandRelativeSitePath(site, path);
        if (isSystemAsset) {
            assetName = ContentUtils.getMd5ForFile(in) + "." + ext;
        }
        String contentPath = folderPath + "/" + assetName;
        try {
            ContentItemTO parentContentItem = this.contentService.getContentItem(site, path, 0);
            if (parentContentItem == null && createFolders) {
                parentContentItem = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentContentItem != null) {
                ContentItemTO contentItem = this.contentService.getContentItem(site, path + "/" + assetName, 0);
                if (contentItem != null) {
                    this.updateFile(site, contentItem, contentPath, in, user, isPreview, unlock);
                } else {
                    contentItem = this.createNewFile(site, parentContentItem, assetName, null, in, user, unlock);
                    this.objectStateService.insertNewEntry(site, contentItem);
                }
                ContentAssetInfoTO assetInfo = new ContentAssetInfoTO();
                assetInfo.setFileName(assetName);
                assetInfo.setFileExtension(ext);
                ContentAssetInfoTO contentAssetInfoTO = assetInfo;
                return contentAssetInfoTO;
            }
            throw new ServiceException(path + " does not exist or not a directory.");
        }
        finally {
            ContentUtils.release(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateFile(String site, ContentItemTO contentItem, String fullPath, InputStream input, String user, boolean isPreview, boolean unlock) throws ServiceException {
        String contentRelativePath = this.contentService.getRelativeSitePath(site, fullPath);
        try {
            this.contentService.writeContent(site, contentRelativePath, input);
        }
        finally {
            ContentUtils.release(input);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("modifier", user);
        properties.put("modified", new Date());
        if (unlock) {
            properties.put("lockOwner", "");
        } else {
            properties.put("lockOwner", user);
        }
        String relativePath = this.contentService.getRelativeSitePath(site, fullPath);
        if (!this.objectMetadataManager.metadataExist(site, relativePath)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, relativePath);
        }
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
        if (unlock) {
            this.contentService.unLockContent(site, contentRelativePath);
            logger.debug("Unlocked the content " + fullPath, new Object[0]);
        } else {
            this.contentService.lockContent(site, contentRelativePath);
        }
        if (!isPreview) {
            DmPathTO path = new DmPathTO(fullPath);
            if (this.cancelWorkflow(site, path.getRelativePath())) {
                this.workflowService.removeFromWorkflow(site, path.getRelativePath(), true);
            } else if (this.updateWorkFlow(site, path.getRelativePath())) {
                this.workflowService.updateWorkflowSandboxes(site, path.getRelativePath());
            }
        }
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }
}

