/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;

public class ExtractAssetDependencyProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExtractAssetDependencyProcessor.class);
    public static final String NAME = "ExtractAssetDependencyProcessor";
    protected ServicesConfig servicesConfig;
    protected DmDependencyService dmDependencyService;

    public ExtractAssetDependencyProcessor() {
        super(NAME);
    }

    public ExtractAssetDependencyProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String site = content.getProperty("site");
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        String path = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
        StringWriter sw = new StringWriter();
        boolean isCss = path.endsWith(".css");
        boolean isJs = path.endsWith(".js");
        List<String> templatePatterns = this.servicesConfig.getRenderingTemplatePatterns(site);
        boolean isTemplate = false;
        for (String templatePattern : templatePatterns) {
            Pattern pattern = Pattern.compile(templatePattern);
            Matcher matcher = pattern.matcher(path);
            if (!matcher.matches()) continue;
            isTemplate = true;
            break;
        }
        try {
            if (isCss || isJs || isTemplate) {
                InputStream is = content.getContentStream();
                is.reset();
                int size = is.available();
                char[] theChars = new char[size];
                byte[] bytes = new byte[size];
                is.read(bytes, 0, size);
                int i = 0;
                while (i < size) {
                    theChars[i] = (char)(bytes[i++] & 0xFF);
                }
                StringBuffer assetContent = new StringBuffer(new String(theChars));
                HashMap<String, Set<String>> globalDeps = new HashMap<String, Set<String>>();
                if (isCss) {
                    this.dmDependencyService.extractDependenciesStyle(site, path, assetContent, globalDeps);
                } else if (isJs) {
                    this.dmDependencyService.extractDependenciesJavascript(site, path, assetContent, globalDeps);
                } else if (isTemplate) {
                    this.dmDependencyService.extractDependenciesTemplate(site, path, assetContent, globalDeps);
                }
                content.getContentStream().reset();
            }
        }
        catch (ServiceException e) {
            throw new ContentProcessException(e);
        }
        catch (IOException e) {
            throw new ContentProcessException(e);
        }
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }
}

