/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.HashMap;
import java.util.Set;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;
import org.dom4j.Document;

public class ExtractDependencyProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExtractDependencyProcessor.class);
    public static final String NAME = "ExtractDependencyProcessor";
    protected DmDependencyService dmDependencyService;

    public ExtractDependencyProcessor() {
        super(NAME);
    }

    public ExtractDependencyProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String site = content.getProperty("site");
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        String path = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
        Document document = content.getDocument();
        try {
            HashMap<String, Set<String>> globalDeps = new HashMap<String, Set<String>>();
            this.dmDependencyService.extractDependencies(site, path, document, globalDeps);
        }
        catch (ServiceException e) {
            throw new ContentProcessException(e);
        }
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }
}

