/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.DmMetadataService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;

public class ExtractMetadataProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExtractMetadataProcessor.class);
    public static final String NAME = "ExtractMetadataProcessor";
    public static final int VERSION_TO_LOOK_UP = -1;
    protected DmMetadataService dmMetadataService;

    public ExtractMetadataProcessor() {
        super(NAME);
    }

    public ExtractMetadataProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String contentType = content.getProperty("contentType");
        String site = content.getProperty("site");
        String user = content.getProperty("user");
        String sub = content.getProperty("sub");
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        String nodeRef = content.getProperty("nodeRef");
        String path = folderPath + "/" + "" + fileName;
        try {
            this.dmMetadataService.extractMetadata(site, user, path, contentType, content.getDocument());
        }
        catch (ServiceException e) {
            throw new ContentProcessException(e);
        }
    }

    public DmMetadataService getDmMetadataService() {
        return this.dmMetadataService;
    }

    public void setDmMetadataService(DmMetadataService dmMetadataService) {
        this.dmMetadataService = dmMetadataService;
    }
}

