/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.DmContentProcessor;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class FormDmContentProcessor
extends PathMatchProcessor
implements DmContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FormDmContentProcessor.class);
    public static final String NAME = "WriteContentToDmProcessor";
    protected ContentService contentService;
    protected WorkflowService workflowService;
    protected DmDependencyService dmDependencyService;
    protected ServicesConfig servicesConfig;
    protected ObjectMetadataManager objectMetadataManager;
    protected ContentRepository contentRepository;

    public FormDmContentProcessor() {
        super(NAME);
    }

    public FormDmContentProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        try {
            this.writeContent(content);
        }
        catch (ServiceException e) {
            logger.error("Failed to write " + content.getId(), e, new Object[0]);
            throw new ContentProcessException("Failed to write " + content.getId(), e);
        }
        finally {
            content.closeContentStream();
        }
    }

    protected ActivityService.ActivityType writeContent(String site, String user, String path, String fileName, String contentType, InputStream input, boolean createFolders, boolean overwrite, boolean isPreview, boolean unlock) throws ServiceException {
        String parentContentPath = this.contentService.expandRelativeSitePath(site, path);
        try {
            boolean parentExists = this.contentService.contentExists(site, path);
            ContentItemTO parentItem = this.contentService.getContentItem(site, path, 0);
            if (parentExists && createFolders) {
                parentItem = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentItem != null) {
                if (parentItem.getName().equals(fileName)) {
                    this.updateFile(site, parentItem, parentContentPath, input, user, isPreview, unlock);
                    ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
                    return activityType;
                }
                String fileFullPath = parentContentPath + "/" + fileName;
                String relativeFilePath = this.contentService.getRelativeSitePath(site, fileFullPath);
                boolean contentExists = this.contentService.contentExists(site, fileFullPath);
                ContentItemTO fileItem = this.contentService.getContentItem(site, relativeFilePath, 0);
                if (fileItem != null && overwrite) {
                    this.updateFile(site, fileItem, fileFullPath, input, user, isPreview, unlock);
                    ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
                    return activityType;
                }
                this.createNewFile(site, parentItem, fileName, contentType, input, user, unlock);
                ActivityService.ActivityType activityType = ActivityService.ActivityType.CREATED;
                return activityType;
            }
            try {
                throw new ContentNotFoundException(path + " does not exist in site: " + site);
            }
            catch (ContentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error: ", e, new Object[0]);
                throw new ContentNotFoundException("Unexpected exception ", e);
            }
        }
        finally {
            ContentUtils.release(input);
        }
    }

    protected void writeContent(PipelineContent content) throws ServiceException {
        String user = content.getProperty("user");
        String site = content.getProperty("site");
        String path = content.getProperty("path");
        String fileName = content.getProperty("fileName");
        String contentType = content.getProperty("contentType");
        InputStream input = content.getContentStream();
        boolean isPreview = ContentFormatUtils.getBooleanValue(content.getProperty("isPreview"));
        boolean createFolders = ContentFormatUtils.getBooleanValue(content.getProperty("createFolders"));
        String unlockValue = content.getProperty("unlock");
        boolean unlock = StringUtils.isEmpty((String)unlockValue) || !unlockValue.equalsIgnoreCase("false");
        boolean overwrite = ContentFormatUtils.getBooleanValue(content.getProperty("overwrite"));
        String parentContentPath = this.contentService.expandRelativeSitePath(site, path);
        try {
            ContentItemTO parentItem = this.contentService.getContentItem(site, path, 0);
            boolean parentContentExists = this.contentService.contentExists(site, path);
            if (!parentContentExists && createFolders) {
                parentItem = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentItem != null) {
                if (parentItem.getName().equals(fileName)) {
                    String newMd5;
                    InputStream existingContent = this.contentService.getContent(site, parentItem.getUri());
                    String existingMd5 = ContentUtils.getMd5ForFile(existingContent);
                    if (!existingMd5.equals(newMd5 = ContentUtils.getMd5ForFile(input))) {
                        this.updateFile(site, parentItem, parentContentPath, input, user, isPreview, unlock);
                        content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    } else {
                        this.updateLastEditedProperties(site, parentItem.getUri(), user);
                        if (!isPreview) {
                            DmPathTO pathTO = new DmPathTO(parentContentPath);
                            if (this.cancelWorkflow(site, path)) {
                                this.workflowService.removeFromWorkflow(site, pathTO.getRelativePath(), true);
                            } else if (this.updateWorkFlow(site, pathTO.getRelativePath())) {
                                this.workflowService.updateWorkflowSandboxes(site, pathTO.getRelativePath());
                            }
                        }
                    }
                    if (unlock) {
                        this.contentService.unLockContent(site, path);
                        logger.debug("Unlocked the content " + parentContentPath, new Object[0]);
                    }
                    return;
                }
                if (parentContentPath.endsWith(".xml") && !parentContentPath.endsWith("index.xml")) {
                    parentContentPath = parentContentPath.substring(0, parentContentPath.lastIndexOf("/"));
                    String partentRelativePath = this.contentService.getRelativeSitePath(site, parentContentPath);
                    parentItem = this.contentService.getContentItem(site, partentRelativePath, 0);
                }
                String fileFullPath = parentContentPath + "/" + fileName;
                String fileRelativePath = this.contentService.getRelativeSitePath(site, fileFullPath);
                boolean fileExists = this.contentService.contentExists(site, fileRelativePath);
                ContentItemTO contentItem = this.contentService.getContentItem(site, fileRelativePath, 0);
                if (fileExists && overwrite) {
                    String newMd5;
                    InputStream existingContent = this.contentService.getContent(site, fileRelativePath);
                    String existingMd5 = ContentUtils.getMd5ForFile(existingContent);
                    if (!existingMd5.equals(newMd5 = ContentUtils.getMd5ForFile(input))) {
                        this.updateFile(site, contentItem, fileFullPath, input, user, isPreview, unlock);
                        content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    } else {
                        this.updateLastEditedProperties(site, contentItem.getUri(), user);
                        if (!isPreview) {
                            DmPathTO pathTO = new DmPathTO(fileFullPath);
                            if (this.cancelWorkflow(site, pathTO.getRelativePath())) {
                                this.workflowService.removeFromWorkflow(site, pathTO.getRelativePath(), true);
                            } else if (this.updateWorkFlow(site, pathTO.getRelativePath())) {
                                this.workflowService.updateWorkflowSandboxes(site, pathTO.getRelativePath());
                            }
                        }
                    }
                    if (unlock) {
                        logger.debug("Unlocked the content " + fileFullPath, new Object[0]);
                    }
                    return;
                }
                ContentItemTO newFileItem = this.createNewFile(site, parentItem, fileName, contentType, input, user, unlock);
                content.addProperty("activityType", ActivityService.ActivityType.CREATED.toString());
                return;
            }
            try {
                throw new ContentNotFoundException(path + " does not exist in site: " + site);
            }
            catch (ContentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error: ", e, new Object[0]);
                throw new ContentNotFoundException("Unexpected exception ", e);
            }
        }
        finally {
            ContentUtils.release(input);
        }
    }

    private void updateLastEditedProperties(String site, String relativePath, String user) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("modifier", user);
        properties.put("modified", new Date());
        if (!this.objectMetadataManager.metadataExist(site, relativePath)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, relativePath);
        }
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentItemTO createNewFile(String site, ContentItemTO parentItem, String fileName, String contentType, InputStream input, String user, boolean unlock) throws ContentNotFoundException {
        ContentItemTO fileItem = null;
        if (parentItem != null) {
            String folderPath = this.fileToFolder(site, parentItem.getUri());
            try {
                this.contentService.writeContent(site, parentItem.getUri() + "/" + fileName, input);
                this.objectMetadataManager.insertNewObjectMetadata(site, parentItem.getUri() + "/" + fileName);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("name", fileName);
                properties.put("modified", new Date());
                properties.put("creator", user);
                properties.put("modifier", user);
                properties.put("owner", user);
                if (unlock) {
                    properties.put("lockOwner", "");
                } else {
                    properties.put("lockOwner", user);
                }
                this.objectMetadataManager.setObjectMetadata(site, parentItem.getUri() + "/" + fileName, properties);
            }
            catch (Exception e) {
                logger.error("Error writing new file: " + fileName, e, new Object[0]);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            if (unlock) {
                this.contentRepository.unLockItem(site, parentItem.getUri() + "/" + fileName);
            }
            fileItem = this.contentService.getContentItem(site, parentItem.getPath() + "/" + fileName, 0);
            return fileItem;
        }
        String parentPath = this.contentService.expandRelativeSitePath(site, parentItem.getPath());
        throw new ContentNotFoundException(parentPath + " does not exist in site: " + site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile(String site, ContentItemTO contentItem, String fullPath, InputStream input, String user, boolean isPreview, boolean unlock) throws ServiceException {
        try {
            this.contentService.writeContent(fullPath, input);
        }
        finally {
            ContentUtils.release(input);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("modifier", user);
        properties.put("modified", new Date());
        if (unlock) {
            properties.put("lockOwner", "");
        } else {
            properties.put("lockOwner", user);
        }
        String relativePath = this.contentService.getRelativeSitePath(site, fullPath);
        if (!this.objectMetadataManager.metadataExist(site, relativePath)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, relativePath);
        }
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
        if (unlock) {
            this.contentRepository.unLockItem(site, relativePath);
            logger.debug("Unlocked the content " + fullPath, new Object[0]);
        } else {
            this.contentRepository.lockItem(site, relativePath);
        }
        if (!isPreview) {
            DmPathTO path = new DmPathTO(fullPath);
            if (this.cancelWorkflow(site, path.getRelativePath())) {
                this.workflowService.removeFromWorkflow(site, path.getRelativePath(), true);
            } else if (this.updateWorkFlow(site, path.getRelativePath())) {
                this.workflowService.updateWorkflowSandboxes(site, path.getRelativePath());
            }
        }
    }

    protected boolean cancelWorkflow(String site, String path) {
        if (path.endsWith(this.servicesConfig.getLevelDescriptorName(site))) {
            return false;
        }
        List<String> pagePatterns = this.servicesConfig.getPagePatterns(site);
        if (ContentUtils.matchesPatterns(path, pagePatterns)) {
            return true;
        }
        List<String> componentPatterns = this.servicesConfig.getComponentPatterns(site);
        if (ContentUtils.matchesPatterns(path, componentPatterns)) {
            return true;
        }
        List<String> documentPatterns = this.servicesConfig.getDocumentPatterns(site);
        return ContentUtils.matchesPatterns(path, documentPatterns);
    }

    protected boolean updateWorkFlow(String site, String path) {
        List<String> assetPatterns = this.servicesConfig.getAssetPatterns(site);
        return ContentUtils.matchesPatterns(path, assetPatterns);
    }

    @Override
    public ContentItemTO createMissingFoldersInPath(String site, String path, boolean isPreview) {
        String[] levels = path.split("/");
        String parentPath = "";
        ContentItemTO lastItem = null;
        for (String level : levels) {
            if (StringUtils.isEmpty((String)level) || level.endsWith(".xml")) continue;
            String currentPath = parentPath + "/" + level;
            lastItem = this.contentService.getContentItem(site, currentPath, 0);
            if (lastItem == null) {
                this.contentService.createFolder(site, parentPath, level);
                lastItem = this.contentService.getContentItem(site, currentPath, 0);
            }
            parentPath = currentPath;
        }
        return lastItem;
    }

    @Override
    public String fileToFolder(String site, String path) {
        ContentItemTO itemTO = this.contentService.getContentItem(site, path, 0);
        if (itemTO.isFolder()) {
            return this.contentService.expandRelativeSitePath(site, path);
        }
        int index = path.lastIndexOf("/");
        String folderPath = path.substring(0, index);
        String parentFileName = itemTO.getName();
        String folderName = parentFileName.substring(0, parentFileName.indexOf("."));
        this.contentService.createFolder(site, folderPath, folderName);
        folderPath = folderPath + "/" + folderName;
        this.contentService.moveContent(site, path, folderPath + "/" + "index.xml");
        logger.debug("Changed file to folder from " + path + " to " + folderPath, new Object[0]);
        return folderPath;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

