/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.DmContentProcessor;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class ImportDmContentProcessor
extends PathMatchProcessor
implements DmContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ImportDmContentProcessor.class);
    public static final String NAME = "ImportDmContentProcessor";
    protected ContentService contentService;
    protected DmDependencyService dmDependencyService;
    protected WorkflowService workflowService;
    protected ServicesConfig servicesConfig;

    public ImportDmContentProcessor() {
        super(NAME);
    }

    public ImportDmContentProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        try {
            this.writeContent(content);
        }
        catch (ServiceException e) {
            logger.error("Failed to write " + content.getId(), e, new Object[0]);
            throw new ContentProcessException("Failed to write " + content.getId(), e);
        }
        finally {
            content.closeContentStream();
        }
    }

    protected ActivityService.ActivityType writeContent(String site, String user, String path, String fileName, String contentType, InputStream input, boolean createFolders, boolean overwrite, boolean isPreview, boolean unlock) throws ServiceException {
        String contentPath = this.contentService.expandRelativeSitePath(site, path);
        try {
            boolean contentExists = this.contentService.contentExists(site, path);
            ContentItemTO parentContent = this.contentService.getContentItem(site, path, 0);
            if (contentExists && createFolders) {
                parentContent = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentContent != null) {
                if (parentContent.getName().equals(fileName)) {
                    this.updateFile(site, parentContent, contentPath, input, user, unlock);
                    ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
                    return activityType;
                }
                String fileFullPath = this.contentService.expandRelativeSitePath(site, path + "/" + fileName);
                ContentItemTO contentItem = this.contentService.getContentItem(site, path + "/" + fileName, 0);
                if (contentItem != null && overwrite) {
                    this.updateFile(site, contentItem, fileFullPath, input, user, unlock);
                    ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
                    return activityType;
                }
                this.createNewFile(site, parentContent, fileName, contentType, input, user);
                ActivityService.ActivityType activityType = ActivityService.ActivityType.CREATED;
                return activityType;
            }
            try {
                throw new ContentNotFoundException(path + " does not exist in site: " + site);
            }
            catch (ContentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error: ", e, new Object[0]);
                throw new ContentNotFoundException("Unexpected exception ", e);
            }
        }
        finally {
            ContentUtils.release(input);
        }
    }

    protected void writeContent(PipelineContent content) throws ServiceException {
        String user = content.getProperty("user");
        String site = content.getProperty("site");
        String path = content.getProperty("path");
        String fileName = content.getProperty("fileName");
        String contentType = content.getProperty("contentType");
        InputStream input = content.getContentStream();
        boolean isPreview = ContentFormatUtils.getBooleanValue(content.getProperty("isPreview"));
        boolean createFolders = ContentFormatUtils.getBooleanValue(content.getProperty("createFolders"));
        String unlockValue = content.getProperty("unlock");
        boolean unlock = StringUtils.isEmpty((String)unlockValue) || !unlockValue.equalsIgnoreCase("false");
        boolean overwrite = ContentFormatUtils.getBooleanValue(content.getProperty("overwrite"));
        String contentPath = this.contentService.expandRelativeSitePath(site, path);
        try {
            ContentItemTO parentContent = this.contentService.getContentItem(site, path, 0);
            if (parentContent == null && createFolders) {
                parentContent = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentContent != null) {
                String fileFullPath;
                String relativePath;
                ContentItemTO fileItem;
                if (parentContent.getName().equals(fileName)) {
                    String newMd5;
                    InputStream existingContent = this.contentService.getContent(site, path);
                    String existingMd5 = ContentUtils.getMd5ForFile(existingContent);
                    if (!existingMd5.equals(newMd5 = ContentUtils.getMd5ForFile(input))) {
                        this.updateFile(site, parentContent, contentPath, input, user, unlock);
                        content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    } else if (!isPreview) {
                        if (this.cancelWorkflow(site, path)) {
                            this.workflowService.removeFromWorkflow(site, path, true);
                        } else if (this.updateWorkFlow(site, path)) {
                            this.workflowService.updateWorkflowSandboxes(site, path);
                        }
                    }
                    if (unlock) {
                        logger.debug("Unlocked the content " + contentPath, new Object[0]);
                    }
                    return;
                }
                String parentContentPath = this.contentService.expandRelativeSitePath(site, path);
                if (parentContentPath.endsWith(".xml") && !parentContentPath.endsWith("index.xml")) {
                    parentContentPath = parentContentPath.substring(0, parentContentPath.lastIndexOf("/"));
                    String partentRelativePath = this.contentService.getRelativeSitePath(site, parentContentPath);
                    parentContent = this.contentService.getContentItem(site, partentRelativePath, 0);
                }
                if ((fileItem = this.contentService.getContentItem(site, relativePath = this.contentService.getRelativeSitePath(site, fileFullPath = parentContentPath + "/" + fileName), 0)) != null && overwrite) {
                    String newMd5;
                    InputStream existingContent = this.contentService.getContent(site, relativePath);
                    String existingMd5 = ContentUtils.getMd5ForFile(existingContent);
                    if (!existingMd5.equals(newMd5 = ContentUtils.getMd5ForFile(input))) {
                        this.updateFile(site, fileItem, fileFullPath, input, user, unlock);
                        content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    } else if (this.cancelWorkflow(site, relativePath)) {
                        this.workflowService.removeFromWorkflow(site, relativePath, true);
                    } else if (this.updateWorkFlow(site, relativePath)) {
                        this.workflowService.updateWorkflowSandboxes(site, relativePath);
                    }
                    if (unlock) {
                        logger.debug("Unlocked the content " + fileFullPath, new Object[0]);
                    }
                    return;
                }
                content.addProperty("activityType", ActivityService.ActivityType.CREATED.toString());
                return;
            }
            try {
                throw new ContentNotFoundException(path + " does not exist in site: " + site);
            }
            catch (ContentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error: ", e, new Object[0]);
                throw new ContentNotFoundException("Unexpected exception ", e);
            }
        }
        finally {
            ContentUtils.release(input);
        }
    }

    protected ContentItemTO createNewFile(String site, ContentItemTO parentItem, String fileName, String contentType, InputStream input, String user) throws ContentNotFoundException {
        return this.createNewFile(site, parentItem, fileName, contentType, input, user, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentItemTO createNewFile(String site, ContentItemTO parentItem, String fileName, String contentType, InputStream input, String user, boolean unlock) throws ContentNotFoundException {
        if (parentItem != null) {
            String folderPath = this.fileToFolder(site, parentItem.getPath());
            try {
                this.contentService.writeContent(site, parentItem.getPath() + "/" + fileName, input);
            }
            catch (Exception e) {
                logger.error("Error writing new file: " + fileName, e, new Object[0]);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            if (unlock) {
                // empty if block
            }
            ContentItemTO fileItem = this.contentService.getContentItem(site, parentItem.getPath() + "/" + fileName, 0);
            return fileItem;
        }
        String parentPath = this.contentService.expandRelativeSitePath(site, parentItem.getPath());
        throw new ContentNotFoundException(parentPath + " does not exist in site: " + site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile(String site, ContentItemTO contentItem, String fullPath, InputStream input, String user, boolean unlock) throws ServiceException {
        String relativePath;
        try {
            this.contentService.writeContent(fullPath, input);
        }
        finally {
            ContentUtils.release(input);
        }
        if (unlock) {
            logger.debug("Unlocked the content " + fullPath, new Object[0]);
        }
        if (this.cancelWorkflow(site, relativePath = this.contentService.getRelativeSitePath(site, fullPath))) {
            this.workflowService.removeFromWorkflow(site, relativePath, true);
        } else if (this.updateWorkFlow(site, relativePath)) {
            this.workflowService.updateWorkflowSandboxes(site, relativePath);
        }
    }

    protected boolean cancelWorkflow(String site, String path) {
        if (path.endsWith(this.servicesConfig.getLevelDescriptorName(site))) {
            return true;
        }
        List<String> pagePatterns = this.servicesConfig.getPagePatterns(site);
        if (ContentUtils.matchesPatterns(path, pagePatterns)) {
            return true;
        }
        List<String> componentPatterns = this.servicesConfig.getComponentPatterns(site);
        if (ContentUtils.matchesPatterns(path, componentPatterns)) {
            return true;
        }
        List<String> documentPatterns = this.servicesConfig.getDocumentPatterns(site);
        return ContentUtils.matchesPatterns(path, documentPatterns);
    }

    protected boolean updateWorkFlow(String site, String path) {
        List<String> assetPatterns = this.servicesConfig.getAssetPatterns(site);
        return ContentUtils.matchesPatterns(path, assetPatterns);
    }

    @Override
    public ContentItemTO createMissingFoldersInPath(String site, String path, boolean isPreview) {
        String[] levels = path.split("/");
        String parentPath = "";
        ContentItemTO lastItem = null;
        for (String level : levels) {
            if (StringUtils.isEmpty((String)level) || level.endsWith(".xml")) continue;
            String currentPath = parentPath + "/" + level;
            String fullPath = this.contentService.expandRelativeSitePath(site, currentPath);
            lastItem = this.contentService.getContentItem(site, currentPath, 0);
            if (lastItem == null) {
                String parentFullPath = this.contentService.expandRelativeSitePath(site, parentPath);
                ContentItemTO parentItem = this.contentService.getContentItem(site, parentPath, 0);
                this.contentService.createFolder(site, parentPath, level);
                lastItem = this.contentService.getContentItem(site, currentPath, 0);
            }
            parentPath = currentPath;
        }
        return lastItem;
    }

    @Override
    public String fileToFolder(String site, String path) {
        ContentItemTO itemTO = this.contentService.getContentItem(site, path, 0);
        int index = path.lastIndexOf("/");
        String folderPath = path.substring(0, index);
        String parentFileName = itemTO.getName();
        String folderName = parentFileName.substring(0, parentFileName.indexOf("."));
        this.contentService.createFolder(site, folderPath, folderName);
        folderPath = folderPath + "/" + folderName;
        this.contentService.moveContent(site, path, folderPath + "/" + "index.xml");
        logger.debug("Changed file to folder from " + path + " to " + folderPath, new Object[0]);
        return folderPath;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }
}

