/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class PostActivityProcessor
extends BaseContentProcessor {
    public static final String NAME = "PostActivityProcessor";
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected ActivityService activityService;
    protected DmDependencyService dmDependencyService;

    public PostActivityProcessor() {
        super(NAME);
    }

    public PostActivityProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        List<String> displayPatterns;
        String uri;
        String type = content.getProperty("activityType");
        String user = content.getProperty("user");
        ActivityService.ActivityType activityType = ActivityService.ActivityType.CREATED.toString().equals(type) ? ActivityService.ActivityType.CREATED : ActivityService.ActivityType.UPDATED;
        String site = content.getProperty("site");
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        boolean isSystemAsset = ContentFormatUtils.getBooleanValue(content.getProperty("systemAsset"));
        if (isSystemAsset) {
            ContentAssetInfoTO assetInfoTO = (ContentAssetInfoTO)result.getItem();
            fileName = assetInfoTO.getFileName();
        }
        if (ContentUtils.matchesPatterns(uri = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName, displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site))) {
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", this.contentService.getContentTypeClass(site, uri));
            this.activityService.postActivity(site, user, uri, activityType, extraInfo);
        }
    }

    protected void updateDependenciesActivity(String site, String user, String relativePath, ActivityService.ActivityType activityType, Map<String, String> extraInfo) {
        DmDependencyTO dependencyTO = this.dmDependencyService.getDependencies(site, relativePath, false, true);
        List<Object> dependencyList = new ArrayList();
        if (dependencyTO != null) {
            dependencyList = dependencyTO.flattenChildren();
        }
        for (DmDependencyTO dep : dependencyList) {
            List<String> displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
            if (!ContentUtils.matchesPatterns(dep.getUri(), displayPatterns)) continue;
            ContentItemTO item = this.contentService.getContentItem(site, dep.getUri(), 0);
            extraInfo.put("contentType", this.contentService.getContentTypeClass(site, dep.getUri()));
            if (dep.getUri().startsWith("/site/system/page-components")) {
                this.activityService.postActivity(site, user, dep.getUri(), ActivityService.ActivityType.CREATED, extraInfo);
                continue;
            }
            this.activityService.postActivity(site, user, dep.getUri(), activityType, extraInfo);
        }
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }
}

