/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.impl.v1.deployment.EnvironmentStoreDeployer;
import org.craftercms.studio.impl.v1.deployment.PreviewDeployer;
import org.craftercms.studio.impl.v1.deployment.SyncTargetDeployer;

public class DeployerFactory {
    protected String environmentsStoreRootPath;
    protected String defaultServer;
    protected int defaultPort;
    protected String defaultPassword;
    protected String defaultTarget;
    protected SiteService siteService;
    protected ContentService contentService;
    protected ContentRepository contentRepository;

    public Deployer createPreviewDeployer() {
        PreviewDeployer previewDeployer = new PreviewDeployer();
        previewDeployer.setContentService(this.contentService);
        previewDeployer.setContentRepository(this.contentRepository);
        previewDeployer.setSiteService(this.siteService);
        previewDeployer.setDefaultServer(this.defaultServer);
        previewDeployer.setDefaultPort(this.defaultPort);
        previewDeployer.setDefaultTarget(this.defaultTarget);
        previewDeployer.setDefaultPassword(this.defaultPassword);
        return previewDeployer;
    }

    public Deployer createEnvironmentStoreDeployer(String environment) {
        EnvironmentStoreDeployer deployer = new EnvironmentStoreDeployer();
        deployer.setContentService(this.contentService);
        deployer.setEnvironmentsStoreRootPath(this.environmentsStoreRootPath);
        deployer.setEnvironment(environment);
        return deployer;
    }

    public Deployer createSyncTargetDeployer(String environment, DeploymentEndpointConfigTO endpointConfigTO) {
        SyncTargetDeployer deployer = new SyncTargetDeployer();
        deployer.setEnvironmentsStoreRootPath(this.environmentsStoreRootPath);
        deployer.setEnvironment(environment);
        deployer.setEndpointConfig(endpointConfigTO);
        return deployer;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(String defaultServer) {
        this.defaultServer = defaultServer;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

