/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.ebus.annotations.EListener;
import org.craftercms.commons.ebus.annotations.EventHandler;
import org.craftercms.commons.ebus.annotations.EventSelectorType;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.ebus.RepositoryEventMessage;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import reactor.event.Event;

@EListener
public class PreviewDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(PreviewDeployer.class);
    public static final String METADATA_EXTENSION = ".depmeta";
    public static final String DEPLOYER_SERVLET_URL = "/publish";
    public static final String DEPLOYER_PASSWORD_PARAM = "password";
    public static final String DEPLOYER_TARGET_PARAM = "target";
    public static final String DEPLOYER_SITE_PARAM = "siteId";
    public static final String DEPLOYER_DELETED_FILES_PARAM = "deletedFiles";
    public static final String DEPLOYER_CONTENT_LOCATION_PARAM = "contentLocation";
    public static final String DEPLOYER_CONTENT_FILE_PARAM = "contentFile";
    public static final String DEPLOYER_METADATA_FILE_PARAM = "metadataFile";
    public static final String FILES_SEPARATOR = ",";
    protected String defaultServer;
    protected int defaultPort;
    protected String defaultPassword;
    protected String defaultTarget;
    protected SiteService siteService;
    protected ContentService contentService;
    protected ContentRepository contentRepository;

    @Override
    public void deployFile(String site, String path) {
        DeploymentEndpointConfigTO deploymentEndpointConfigTO = this.siteService.getPreviewDeploymentEndpoint(site);
        URL requestUrl = null;
        try {
            String url = DEPLOYER_SERVLET_URL;
            ArrayList<Object> formParts = new ArrayList<Object>();
            if (deploymentEndpointConfigTO != null) {
                requestUrl = new URL(deploymentEndpointConfigTO.getServerUrl());
                formParts.add(new StringPart(DEPLOYER_PASSWORD_PARAM, deploymentEndpointConfigTO.getPassword()));
                formParts.add(new StringPart(DEPLOYER_TARGET_PARAM, deploymentEndpointConfigTO.getTarget()));
            } else {
                requestUrl = new URL("http", this.defaultServer, this.defaultPort, url);
                formParts.add(new StringPart(DEPLOYER_PASSWORD_PARAM, this.defaultPassword));
                formParts.add(new StringPart(DEPLOYER_TARGET_PARAM, this.defaultTarget));
            }
            InputStream content = this.contentService.getContent(site, path);
            if (content != null) {
                ByteArrayPartSource baps = null;
                byte[] byteArray = null;
                byteArray = IOUtils.toByteArray((InputStream)content);
                baps = new ByteArrayPartSource(path, byteArray);
                formParts.add(new FilePart(DEPLOYER_CONTENT_FILE_PARAM, (PartSource)baps));
            }
            formParts.add(new StringPart(DEPLOYER_CONTENT_LOCATION_PARAM, path));
            formParts.add(new StringPart(DEPLOYER_SITE_PARAM, site));
            PostMethod postMethod = new PostMethod(requestUrl.toString());
            postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
            Part[] parts = new Part[formParts.size()];
            for (int i = 0; i < formParts.size(); ++i) {
                parts[i] = (Part)formParts.get(i);
            }
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
            HttpClient client = new HttpClient();
            int status = client.executeMethod((HttpMethod)postMethod);
            postMethod.releaseConnection();
        }
        catch (Exception err) {
            logger.error("error while preview deploying '" + site + ":" + path + "'", err, new Object[0]);
        }
    }

    @Override
    public void deployFiles(String site, List<String> paths) {
    }

    @Override
    public void deleteFile(String site, String path) {
        DeploymentEndpointConfigTO deploymentEndpointConfigTO = this.siteService.getPreviewDeploymentEndpoint(site);
        URL requestUrl = null;
        try {
            RepositoryItem[] children;
            String url = DEPLOYER_SERVLET_URL;
            ArrayList<StringPart> formParts = new ArrayList<StringPart>();
            if (deploymentEndpointConfigTO != null) {
                requestUrl = new URL(deploymentEndpointConfigTO.getServerUrl());
                formParts.add(new StringPart(DEPLOYER_PASSWORD_PARAM, deploymentEndpointConfigTO.getPassword()));
                formParts.add(new StringPart(DEPLOYER_TARGET_PARAM, deploymentEndpointConfigTO.getTarget()));
            } else {
                requestUrl = new URL("http", this.defaultServer, this.defaultPort, url);
                formParts.add(new StringPart(DEPLOYER_PASSWORD_PARAM, this.defaultPassword));
                formParts.add(new StringPart(DEPLOYER_TARGET_PARAM, this.defaultTarget));
            }
            StringBuilder sbDeletedFiles = new StringBuilder(path);
            if (path.endsWith("/index.xml") && ((children = this.contentRepository.getContentChildren(this.contentService.expandRelativeSitePath(site, path.replace("/index.xml", "")))) == null || children.length <= 1)) {
                sbDeletedFiles.append(FILES_SEPARATOR).append(path.replace("/index.xml", ""));
            }
            formParts.add(new StringPart(DEPLOYER_DELETED_FILES_PARAM, sbDeletedFiles.toString()));
            formParts.add(new StringPart(DEPLOYER_SITE_PARAM, site));
            PostMethod postMethod = new PostMethod(requestUrl.toString());
            postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
            Part[] parts = new Part[formParts.size()];
            for (int i = 0; i < formParts.size(); ++i) {
                parts[i] = (Part)formParts.get(i);
            }
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
            HttpClient client = new HttpClient();
            int status = client.executeMethod((HttpMethod)postMethod);
            postMethod.releaseConnection();
        }
        catch (Exception err) {
            logger.error("error while preview deploying '" + site + ":" + path + "'", err, new Object[0]);
        }
    }

    @Override
    public void deleteFiles(String site, List<String> paths) {
    }

    @EventHandler(event="repository.create", ebus="@repositoryReactor", type=EventSelectorType.REGEX)
    public void onCreateContent(Event<RepositoryEventMessage> event) {
        RepositoryEventMessage message = (RepositoryEventMessage)event.getData();
        String site = message.getSite();
        String path = message.getPath();
        this.deployFile(site, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(event="repository.update", ebus="@repositoryReactor", type=EventSelectorType.REGEX)
    public void onUpdateContent(Event<RepositoryEventMessage> event) {
        RepositoryEventMessage message = (RepositoryEventMessage)event.getData();
        try {
            String site = message.getSite();
            String path = message.getPath();
            RepositoryEventContext.setCurrent(message.getRepositoryEventContext());
            this.deployFile(site, path);
        }
        catch (Exception t) {
            logger.error("Error while deploying preview content for: " + message.getSite() + " - " + message.getPath(), t, new Object[0]);
        }
        finally {
            RepositoryEventContext.setCurrent(null);
        }
    }

    @Override
    public void deployFiles(String site, List<String> paths, List<String> deletedFiles) {
    }

    @EventHandler(event="repository.previewSync", ebus="@repositoryReactor", type=EventSelectorType.REGEX)
    public void syncAllContentToPreview(Event<RepositoryEventMessage> event) throws ServiceException {
        RepositoryEventMessage message = (RepositoryEventMessage)event.getData();
        String site = message.getSite();
        logger.info("Received preview sync event for site: " + site, new Object[0]);
        RepositoryEventContext.setCurrent(message.getRepositoryEventContext());
        String siteRootPath = this.contentService.expandRelativeSitePath(site, "/");
        if (StringUtils.isNotEmpty((String)siteRootPath)) {
            try {
                this.syncFolder(site, siteRootPath);
            }
            catch (Exception e) {
                logger.error("Site '" + site + "' synchronization failed", e, new Object[0]);
                throw new ServiceException("Unable to execute sync for " + site, e);
            }
            logger.info("Synchronization of site '" + site + "' completed successfully", new Object[0]);
        } else {
            logger.error("Site '" + site + "' synchronization failed. Repository root path empty", new Object[0]);
        }
    }

    protected void syncFolder(String site, String path) {
        RepositoryItem[] children;
        for (RepositoryItem item : children = this.contentRepository.getContentChildren(path)) {
            if (item.isFolder) {
                this.syncFolder(site, item.path + "/" + item.name);
                continue;
            }
            this.deployFile(site, this.contentService.getRelativeSitePath(site, item.path + "/" + item.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(event="repository.move", ebus="@repositoryReactor", type=EventSelectorType.REGEX)
    public void onMoveContent(Event<RepositoryEventMessage> event) throws ServiceException {
        RepositoryEventMessage message = (RepositoryEventMessage)event.getData();
        try {
            String site = message.getSite();
            String path = message.getPath();
            String oldPath = message.getOldPath();
            RepositoryEventContext.setCurrent(message.getRepositoryEventContext());
            this.deleteFile(site, oldPath);
            this.syncFolder(site, this.contentService.expandRelativeSitePath(site, path));
        }
        catch (Exception t) {
            logger.error("Error while deploying moving content from: " + message.getSite() + " - " + message.getOldPath() + " to: " + message.getSite() + " - " + message.getPath(), t, new Object[0]);
        }
        finally {
            RepositoryEventContext.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(event="repository.delete", ebus="@repositoryReactor", type=EventSelectorType.REGEX)
    public void onDeleteContent(Event<RepositoryEventMessage> event) throws ServiceException {
        RepositoryEventMessage message = (RepositoryEventMessage)event.getData();
        try {
            String site = message.getSite();
            String path = message.getPath();
            RepositoryEventContext.setCurrent(message.getRepositoryEventContext());
            this.deleteFile(site, path);
        }
        catch (Exception t) {
            logger.error("Error while deleting content from: " + message.getSite() + " - " + message.getPath(), t, new Object[0]);
        }
        finally {
            RepositoryEventContext.setCurrent(null);
        }
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(String defaultServer) {
        this.defaultServer = defaultServer;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

