/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.deployment.ContentNotFoundForPublishingException;
import org.craftercms.studio.api.v1.service.deployment.UploadFailedException;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.springframework.util.StringUtils;

public class SyncTargetDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(SyncTargetDeployer.class);
    private static final String TARGET_REQUEST_PARAMETER = "target";
    private static final String VERSION_REQUEST_PARAMETER = "version";
    private static final String PASSWORD_REQUEST_PARAMETER = "password";
    private static final String SITE_REQUEST_PARAMETER = "siteId";
    private static final String DELETED_FILES_REQUEST_PARAMETER = "deletedFiles";
    private static final String CONTENT_LOCATION_REQUEST_PARAMETER = "contentLocation";
    private static final String CONTENT_FILE_REQUEST_PARAMETER = "contentFile";
    private static final String METADATA_FILE_REQUEST_PARAMETER = "metadataFile";
    private static final String FILES_SEPARATOR = ",";
    private static final String LIVE_ENVIRONMENT = "live";
    private static final String PRODUCTION_ENVIRONMENT = "Production";
    private static final String WORK_AREA_ENVIRONMENT = "work-area";
    protected String environmentsStoreRootPath;
    protected String environment;
    protected DeploymentEndpointConfigTO endpointConfig;

    @Override
    public void deployFile(String site, String path) {
    }

    @Override
    public void deployFiles(String site, List<String> paths) {
    }

    @Override
    public void deleteFile(String site, String path) {
    }

    @Override
    public void deleteFiles(String site, List<String> paths) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployFiles(String site, List<String> paths, List<String> deletedFiles) throws ContentNotFoundForPublishingException, UploadFailedException {
        block26: {
            logger.debug("Start deploying items for site \"{0}\", target \"{1}\", number of items \"{2}\"", site, this.endpointConfig.getName(), paths.size());
            URL requestUrl = null;
            try {
                requestUrl = new URL(this.endpointConfig.getServerUrl());
            }
            catch (MalformedURLException e) {
                logger.error("Invalid server URL for target {0}", this.endpointConfig.getName());
                throw new UploadFailedException(site, this.endpointConfig.getName(), this.endpointConfig.getServerUrl(), e);
            }
            ByteArrayPartSource baps = null;
            Object metadataPart = null;
            StringPart stringPart = null;
            FilePart filePart = null;
            int cntFiles = 0;
            StringBuilder sbDeletedFiles = new StringBuilder();
            ArrayList<Object> formParts = new ArrayList<Object>();
            formParts.add(new StringPart(PASSWORD_REQUEST_PARAMETER, this.endpointConfig.getPassword()));
            formParts.add(new StringPart(TARGET_REQUEST_PARAMETER, this.endpointConfig.getTarget()));
            String siteId = this.endpointConfig.getSiteId();
            if (StringUtils.isEmpty((Object)siteId)) {
                siteId = site;
            }
            formParts.add(new StringPart(SITE_REQUEST_PARAMETER, siteId));
            logger.debug("Preparing deployment items for target {0}", this.endpointConfig.getName());
            for (String path : paths) {
                logger.debug("Parsing \"{0}\" , site \"{1}\"; for publishing on target \"{2}\"", path, site, this.endpointConfig.getName());
                logger.debug("Get content for \"{0}\" , site \"{1}\", environment \"{2}\"", path, site, this.environment);
                File file = new File(this.getDestinationPath(site, path, this.environment));
                FileInputStream input = null;
                try {
                    input = FileUtils.openInputStream((File)file);
                    if (input == null || ((InputStream)input).available() < 0) {
                        if (!file.exists() || file.isDirectory()) continue;
                        baps = null;
                        stringPart = null;
                        filePart = null;
                        formParts = null;
                        throw new ContentNotFoundForPublishingException(site, this.endpointConfig.getName(), path);
                    }
                }
                catch (IOException err) {
                    logger.error("Error reading input stream from envirnoment store for content at path: " + path + " site: " + site + " environment: " + this.environment, new Object[0]);
                    if (file.exists()) continue;
                    logger.error("File expected, but does not exist at path: " + file.getAbsolutePath(), new Object[0]);
                    continue;
                }
                String fileName = file.getName();
                byte[] byteArray = null;
                try {
                    byteArray = IOUtils.toByteArray((InputStream)input);
                }
                catch (IOException e) {
                    logger.error("Error while converting input stream to byte array", e, new Object[0]);
                    baps = null;
                    stringPart = null;
                    filePart = null;
                    formParts = null;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                    input = null;
                }
                baps = new ByteArrayPartSource(fileName, byteArray);
                logger.debug("Create http request parameters for \"{0}\" , site \"{1}\"; publishing on target \"{2}\"", path, site, this.endpointConfig.getName());
                int idx = path.lastIndexOf("/");
                String relativePath = path.substring(0, idx + 1) + fileName;
                stringPart = new StringPart(CONTENT_LOCATION_REQUEST_PARAMETER + cntFiles, relativePath);
                formParts.add(stringPart);
                filePart = new FilePart(CONTENT_FILE_REQUEST_PARAMETER + cntFiles, (PartSource)baps);
                formParts.add(filePart);
                ++cntFiles;
            }
            for (int i = 0; i < deletedFiles.size(); ++i) {
                if (i > 0) {
                    sbDeletedFiles.append(FILES_SEPARATOR);
                }
                sbDeletedFiles.append(deletedFiles.get(i));
            }
            if (sbDeletedFiles.length() > 0) {
                formParts.add(new StringPart(DELETED_FILES_REQUEST_PARAMETER, sbDeletedFiles.toString()));
            }
            logger.debug("Create http request to deploy content for target {0}", this.endpointConfig.getName());
            PostMethod postMethod = null;
            HttpClient client = null;
            try {
                logger.debug("Create HTTP Post Method", new Object[0]);
                postMethod = new PostMethod(requestUrl.toString());
                postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                Part[] parts = new Part[formParts.size()];
                for (int i = 0; i < formParts.size(); ++i) {
                    parts[i] = (Part)formParts.get(i);
                }
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
                client = new HttpClient();
                logger.debug("Execute HTTP POST request \"{0}\"", postMethod.getURI());
                int status = client.executeMethod((HttpMethod)postMethod);
                if (status == 200) {
                    logger.info("Successfully deployed on target {0}", this.endpointConfig.getName());
                    break block26;
                }
                logger.error("Deployment failed for on target {1}. Deployment agent returned status {2}", this.endpointConfig.getName(), HttpStatus.getStatusText((int)status));
                throw new UploadFailedException(site, this.endpointConfig.getName(), this.endpointConfig.getServerUrl());
            }
            catch (HttpException e) {
                logger.error("Publish failed for target {0} due to http protocol exception", this.endpointConfig.getName());
                throw new UploadFailedException(site, this.endpointConfig.getName(), this.endpointConfig.getServerUrl(), e);
            }
            catch (IOException e) {
                logger.error("Publish failed for target {0} due to I/O (transport) exception", this.endpointConfig.getName());
                throw new UploadFailedException(site, this.endpointConfig.getName(), this.endpointConfig.getServerUrl(), e);
            }
            finally {
                HttpConnectionManager mgr;
                logger.debug("Release http connection and release resources", new Object[0]);
                if (client != null && (mgr = client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
                    ((SimpleHttpConnectionManager)mgr).shutdown();
                }
                if (postMethod != null) {
                    postMethod.releaseConnection();
                    postMethod = null;
                    client = null;
                }
                baps = null;
                stringPart = null;
                filePart = null;
                formParts = null;
            }
        }
        logger.info("Deployment successful on target {0}", this.endpointConfig.getName());
        logger.debug("Finished deploying items for site \"{0}\", target \"{1}\", number of items \"{2}\"", site, this.endpointConfig.getName(), paths.size());
    }

    private String getDestinationPath(String site, String path, String environment) {
        return String.format("%s/%s/%s/%s", this.environmentsStoreRootPath, site, environment, path);
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public DeploymentEndpointConfigTO getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(DeploymentEndpointConfigTO endpointConfig) {
        this.endpointConfig = endpointConfig;
    }
}

