/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.ebus;

import java.util.List;
import org.craftercms.studio.api.v1.ebus.DistributedEventMessage;
import org.craftercms.studio.api.v1.ebus.DistributedPeerEBusFacade;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.tcp.TcpClient;
import reactor.tcp.TcpConnection;
import reactor.tcp.encoding.Codec;
import reactor.tcp.encoding.json.JsonCodec;
import reactor.tcp.netty.NettyTcpClient;
import reactor.tcp.spec.TcpClientSpec;

public class DistributedPeerEBusFacedImpl
implements DistributedPeerEBusFacade {
    private static final Logger logger = LoggerFactory.getLogger(DistributedPeerEBusFacedImpl.class);
    protected Reactor distributedReactor;
    protected List<String> peerList;

    @Override
    public void notifyCluster(DistributedEventMessage message) {
        if (this.peerList != null && this.peerList.size() > 0) {
            for (String peer : this.peerList) {
                String[] t = peer.split(":");
                if (t.length != 2) {
                    logger.error("Invalid distributed event peer configuration: " + peer, new Object[0]);
                    continue;
                }
                String host = t[0];
                int port = Integer.parseInt(t[1]);
                TcpClient<String, DistributedEventMessage> client = this.getTcpClient(host, port);
                try {
                    TcpConnection conn = (TcpConnection)client.open().await();
                    conn.send((Object)message);
                    conn.close();
                }
                catch (InterruptedException e) {
                    logger.error("Error connecting to distributed peer: " + peer, e, new Object[0]);
                }
                catch (RuntimeException e) {
                    logger.error("Error connecting to distributed peer: " + peer, e, new Object[0]);
                }
            }
        }
    }

    private TcpClient<String, DistributedEventMessage> getTcpClient(String host, int port) {
        Environment env = new Environment();
        TcpClient client = (TcpClient)((TcpClientSpec)((TcpClientSpec)new TcpClientSpec(NettyTcpClient.class).env(env)).dispatcher("ringBuffer")).connect(host, port).codec((Codec)new JsonCodec(String.class)).get();
        return client;
    }

    public Reactor getDistributedReactor() {
        return this.distributedReactor;
    }

    public void setDistributedReactor(Reactor distributedReactor) {
        this.distributedReactor = distributedReactor;
    }

    public List<String> getPeerList() {
        return this.peerList;
    }

    public void setPeerList(List<String> peerList) {
        this.peerList = peerList;
    }
}

