/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.executor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.ContentProcessorPipeline;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.executor.ProcessContentExecutor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PipelineContentImpl;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class ProcessContentExecutorImpl
implements ProcessContentExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessContentExecutorImpl.class);
    protected Map<String, ContentProcessorPipeline> processorChains;
    protected SecurityService securityService;

    @Override
    public ResultTO processContent(String id, InputStream input, boolean isXml, Map<String, String> params, String chainName) throws ServiceException {
        ContentProcessorPipeline chain = this.processorChains.get(chainName);
        try {
            if (chain != null) {
                if (StringUtils.isEmpty((String)params.get("user"))) {
                    String user = this.securityService.getCurrentUser();
                    params.put("user", user);
                }
                byte[] inputBytes = null;
                try {
                    if (input != null) {
                        inputBytes = IOUtils.toByteArray((InputStream)input);
                    }
                }
                catch (IOException e) {
                    throw new ServiceException("Error while creating byte array", e);
                }
                finally {
                    ContentUtils.release(input);
                }
                ResultTO result = new ResultTO();
                byte[] inputBytesFinal = inputBytes;
                ByteArrayInputStream newByteArrayStream = null;
                try {
                    newByteArrayStream = inputBytesFinal != null ? new ByteArrayInputStream(inputBytesFinal) : null;
                    PipelineContentImpl content = new PipelineContentImpl(id, newByteArrayStream, isXml, null, "UTF-8", params);
                    chain.processContent(content, result);
                }
                catch (ContentProcessException e) {
                    logger.error("Error in chain for write content", e, new Object[0]);
                    throw e;
                }
                catch (RuntimeException e) {
                    logger.error("Error in chain for write content", e, new Object[0]);
                    throw e;
                }
                finally {
                    ContentUtils.release(newByteArrayStream);
                }
                ResultTO resultTO = result;
                return resultTO;
            }
            ContentUtils.release(input);
            throw new ServiceException(chainName + " is not defined.");
        }
        finally {
            String string = params.get("user");
        }
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public Map<String, ContentProcessorPipeline> getProcessorChains() {
        return this.processorChains;
    }

    public void setProcessorChains(Map<String, ContentProcessorPipeline> processorChains) {
        this.processorChains = processorChains;
    }
}

