/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.job;

import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.craftercms.studio.api.v1.to.EmailMessageQueueTo;
import org.craftercms.studio.api.v1.to.EmailMessageTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailMessageSender
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailMessageSender.class);
    protected JavaMailSender emailService;
    protected EmailMessageQueueTo emailMessages;
    protected String defaultFromAddress;

    public String getDefaultFromAddress() {
        return this.defaultFromAddress;
    }

    public void setDefaultFromAddress(String defaultFromAddress) {
        this.defaultFromAddress = defaultFromAddress;
    }

    public void initThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.emailMessages.size() > 0) {
                        List<EmailMessageTO> list = this.emailMessages.getAll();
                        int size = list.size();
                        for (int counter = 0; counter < size; ++counter) {
                            EmailMessageTO emailMessage = list.get(counter);
                            emailMessage.preprocessEmail();
                            String userEmailAddress = emailMessage.getTo();
                            String content = emailMessage.getContent();
                            String subject = emailMessage.getSubject();
                            String replyTo = emailMessage.getReplyTo();
                            String personalFromName = emailMessage.getPersonalFromName();
                            boolean success = this.sendEmail(subject, content, userEmailAddress, replyTo, personalFromName);
                            if (success) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Successfully sent email to:" + userEmailAddress);
                                }
                            } else {
                                LOGGER.error("Could not send email to:" + userEmailAddress);
                            }
                            emailMessage = null;
                        }
                    }
                    int secs = 30;
                    Thread.sleep(secs * 1000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected boolean sendEmail(final String subject, final String content, final String userEmailAddress, final String replyTo, final String personalFromName) {
        boolean success = true;
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(userEmailAddress));
                InternetAddress[] replyTos = new InternetAddress[1];
                if (replyTo != null && !"".equals(replyTo)) {
                    replyTos[0] = new InternetAddress(replyTo);
                    mimeMessage.setReplyTo((Address[])replyTos);
                }
                InternetAddress fromAddress = new InternetAddress(EmailMessageSender.this.defaultFromAddress);
                if (personalFromName != null) {
                    fromAddress.setPersonal(personalFromName);
                }
                mimeMessage.setFrom((Address)fromAddress);
                mimeMessage.setText(content);
                mimeMessage.setSubject(subject);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("sending email to [" + userEmailAddress + "]subject subject :[" + subject + "]");
                }
            }
        };
        try {
            this.emailService.send(preparator);
        }
        catch (MailException ex) {
            LOGGER.error("Error sending email notification to:" + userEmailAddress, (Throwable)ex);
            success = false;
        }
        return success;
    }

    public JavaMailSender getEmailService() {
        return this.emailService;
    }

    public void setEmailService(JavaMailSender emailService) {
        this.emailService = emailService;
    }

    public void setEmailMessages(EmailMessageQueueTo emailMessages) {
        this.emailMessages = emailMessages;
    }
}

