/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.job;

import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.job.Job;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryJob.class);
    private String username;
    private String password;
    private SecurityService sercurityService;

    @Override
    public void execute() {
        String ticket = this.sercurityService.authenticate(this.username, this.password);
        if (StringUtils.isNotEmpty((String)ticket)) {
            CronJobContext cronJobContext = new CronJobContext(ticket);
            CronJobContext.setCurrent(cronJobContext);
            this.executeAsSignedInUser();
            CronJobContext.clear();
        } else {
            logger.error("Not able to authenticate user for cron job.");
        }
    }

    protected abstract void executeAsSignedInUser();

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SecurityService getSecurityService() {
        return this.sercurityService;
    }

    public void setSecurityService(SecurityService sercurityService) {
        this.sercurityService = sercurityService;
    }
}

