/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.listener;

import java.util.Date;
import org.craftercms.studio.api.v1.cache.Scope;
import org.craftercms.studio.api.v1.cache.ThreadSafeCacheManager;
import org.craftercms.studio.api.v1.listener.DmWorkflowListener;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.to.GoLiveQueue;

public class DmWorkflowListenerImpl
implements DmWorkflowListener {
    private static final Logger logger = LoggerFactory.getLogger(DmWorkflowListenerImpl.class);
    protected ThreadSafeCacheManager cache;
    protected ContentService contentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postGolive(String site, DmDependencyTO submittedItem) {
        this.cache.getLock().writeLock().lock();
        try {
            if (submittedItem == null) {
                return;
            }
            logger.debug("Go live complete [" + submittedItem.getUri() + "]", new Object[0]);
            if (!submittedItem.isDeleted()) {
                this.updateReferredObjects(site, submittedItem);
            }
        }
        finally {
            this.cache.getLock().writeLock().unlock();
        }
    }

    protected void updateReferredObjects(String site, DmDependencyTO submittedItem) {
        ContentItemTO to = this.updateCache(site, submittedItem);
    }

    protected ContentItemTO updateCache(String site, DmDependencyTO to) {
        String fullPath = this.contentService.expandRelativeSitePath(site, to.getUri());
        ContentItemTO thisItem = this.updateCacheToGoliveState(fullPath, to.getScheduledDate(), site);
        logger.debug("update cache for url [" + fullPath + "]", new Object[0]);
        if (fullPath.endsWith("index.xml")) {
            String parentFolder = this.getParent(fullPath);
            this.updateCacheToGoliveState(parentFolder, to.getScheduledDate(), site);
            logger.debug("update cache for url [" + parentFolder + "]", new Object[0]);
        }
        return thisItem;
    }

    protected ContentItemTO updateCacheToGoliveState(String fullPath, Date scheduleDate, String site) {
        ContentItemTO to = (ContentItemTO)this.cache.get(Scope.DM_CONTENT_ITEM, fullPath);
        if (to != null) {
            ContentItemTO updatedTo = new ContentItemTO(to);
            updatedTo.setInProgress(false);
            updatedTo.setSubmitted(false);
            updatedTo.setScheduledDate(scheduleDate);
            if (scheduleDate != null) {
                updatedTo.setScheduled(true);
            } else {
                updatedTo.setNew(false);
                updatedTo.setScheduled(false);
            }
            this.cache.put(Scope.DM_CONTENT_ITEM, fullPath, updatedTo);
            GoLiveQueue queue = (GoLiveQueue)this.cache.get(Scope.DM_SUBMITTED_ITEMS, "goliveItems", site);
            if (null != queue) {
                queue.remove(to.getUri());
            }
        }
        return to;
    }

    protected String getParent(String fullPath) {
        String s = "/index.xml";
        int i = fullPath.length() - s.length();
        String parentFolder = fullPath.substring(0, i);
        return parentFolder;
    }

    protected void warmTheCache(String site, DmDependencyTO submitted, String fullPath, boolean add) {
        GoLiveQueue queue = (GoLiveQueue)this.cache.get(Scope.DM_SUBMITTED_ITEMS, "goliveItems", site);
        if (queue != null && null != fullPath) {
            if (!submitted.isDeleted()) {
                String relativePath = this.contentService.getRelativeSitePath(site, fullPath);
                ContentItemTO to = this.contentService.getContentItem(site, relativePath);
                if (add) {
                    queue.add(to);
                }
            }
            if (!add) {
                String uri = submitted.getUri();
                if (uri != null) {
                    String indexOrParentUri = uri.endsWith("index.xml") ? this.getParent(uri) : (uri.endsWith("/") ? uri + "index.xml" : uri + "/" + "index.xml");
                    queue.remove(indexOrParentUri);
                }
                queue.remove(uri);
            }
        }
    }

    @Override
    public void postSubmitToGolive(String site, DmDependencyTO dependencyTO) {
        logger.debug("Submit to Go live complete [" + dependencyTO + "]", new Object[0]);
    }

    @Override
    public void postReject(String site, DmDependencyTO submittedItem) {
        logger.debug("Reject complete [" + submittedItem.getUri() + "]", new Object[0]);
    }

    public ThreadSafeCacheManager getCache() {
        return this.cache;
    }

    public void setCache(ThreadSafeCacheManager cache) {
        this.cache = cache;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

