/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.alfresco;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.impl.v1.repository.AbstractContentRepository;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AlfrescoContentRepository
extends AbstractContentRepository
implements SecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(AlfrescoContentRepository.class);
    protected String alfrescoUrl;
    protected String adminUser;
    protected String adminPassword;
    protected boolean bootstrapEnabled = false;

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        return this.getContentStreamCMIS(path);
    }

    @Override
    public boolean contentExists(String path) {
        try {
            return this.getNodeRefForPathCMIS(path) != null;
        }
        catch (ContentNotFoundException e) {
            logger.info("Content not found exception for path: " + path, e);
            return false;
        }
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        logger.debug("writing content to " + path, new Object[0]);
        this.addDebugStack();
        return this.writeContentCMIS(path, content);
    }

    @Override
    public boolean createFolder(String path, String name) {
        this.addDebugStack();
        String folderRef = this.createFolderInternal(path, name);
        return folderRef != null;
    }

    @Override
    public boolean deleteContent(String path) {
        logger.debug("deleting content at " + path, new Object[0]);
        this.addDebugStack();
        return this.deleteContentCMIS(path);
    }

    @Override
    public boolean copyContent(String fromPath, String toPath) {
        this.addDebugStack();
        return this.copyContentInternal(fromPath, toPath, false);
    }

    @Override
    public boolean moveContent(String fromPath, String toPath) {
        this.addDebugStack();
        return this.copyContentInternal(fromPath, toPath, true);
    }

    @Override
    public RepositoryItem[] getContentChildren(String path) {
        this.addDebugStack();
        RepositoryItem[] items = this.getContentChildrenCMIS(path);
        return items;
    }

    @Override
    public String createVersion(String path, boolean majorVersion) {
        String versionLabel;
        long startTime;
        block6: {
            startTime = System.currentTimeMillis();
            versionLabel = null;
            if (majorVersion) {
                HashMap params = new HashMap();
                String cleanPath = path.replaceAll("//", "/");
                if (cleanPath.endsWith("/")) {
                    cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
                }
                try {
                    ObjectType type;
                    Session session = this.getCMISSession();
                    CmisObject cmisObject = session.getObjectByPath(cleanPath);
                    if (cmisObject == null || !"cmis:document".equals((type = cmisObject.getBaseType()).getId())) break block6;
                    Document document = (Document)cmisObject;
                    ObjectId objId = null;
                    try {
                        objId = document.checkOut();
                    }
                    catch (CmisVersioningException ex) {
                        String pwcId = document.getVersionSeriesCheckedOutId();
                        objId = session.getObject(pwcId);
                    }
                    Document workingCopy = (Document)session.getObject(objId);
                    ContentStream contentStream = workingCopy.getContentStream();
                    objId = workingCopy.checkIn(majorVersion, null, contentStream, null);
                    session.removeObjectFromCache(document.getId());
                    session.removeObjectFromCache(objId);
                }
                catch (CmisBaseException err) {
                    logger.error("Error while creating new " + (majorVersion ? "major" : "minor") + " version for path " + path, (Exception)((Object)err), new Object[0]);
                }
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("createVersion(String path, boolean majorVersion); {0}, {1}\n\t\tDuration: {2}", path, majorVersion, duration);
        return versionLabel;
    }

    @Override
    public VersionTO[] getContentVersionHistory(String path) {
        this.addDebugStack();
        return this.getContentVersionHistoryCMIS(path);
    }

    @Override
    public boolean revertContent(String path, String version, boolean major, String comment) {
        this.addDebugStack();
        return this.revertContentCMIS(path, version, major, comment);
    }

    protected String createFolderInternal(String path, String name) {
        logger.debug("creating a folder at " + path + " with name: " + name, new Object[0]);
        if (this.createMissingFoldersCMIS(path + "/" + name)) {
            try {
                String nodeRef = this.getNodeRefForPathCMIS(path + "/" + name);
                return nodeRef;
            }
            catch (ContentNotFoundException e) {
                logger.info("Error while creating folder {1} in path {0}", e, path, name);
            }
        }
        return "";
    }

    protected boolean copyContentInternal(String fromPath, String toPath, boolean isCut) {
        logger.debug((isCut ? "Move" : "Copy") + " content from " + fromPath + " to " + toPath, new Object[0]);
        return this.copyContentInternalCMIS(fromPath, toPath, isCut);
    }

    protected InputStream alfrescoGetRequest(String uri, Map<String, String> params) throws Exception {
        long startTime = System.currentTimeMillis();
        InputStream retResponse = null;
        URI serviceURI = new URI(this.buildAlfrescoRequestURL(uri, params));
        retResponse = serviceURI.toURL().openStream();
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("alfrescoGetRequest(String uri, Map<String, String> params); {0}, {1}\n\t\tDuration: {2}", uri, params.values(), duration);
        return retResponse;
    }

    protected String alfrescoPostRequest(String uri, Map<String, String> params, InputStream body, String bodyMimeType) throws Exception {
        long startTime = System.currentTimeMillis();
        String serviceURL = this.buildAlfrescoRequestURL(uri, params);
        PostMethod postMethod = new PostMethod(serviceURL);
        postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(body, bodyMimeType));
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        int status = httpClient.executeMethod((HttpMethod)postMethod);
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("alfrescoPostRequest(String uri, Map<String, String> params, InputStream body, String bodyMimeType; {0}, {1}, {2}, {3}\n\t\tDuration: {4}", uri, params, "stream", bodyMimeType, duration);
        return postMethod.getResponseBodyAsString();
    }

    protected String alfrescoMultipartPostRequest(String uri, Map<String, String> params, InputStream body, String bodyMimeType, String charSet) throws Exception {
        long startTime = System.currentTimeMillis();
        String serviceURL = this.buildAlfrescoRequestURL(uri, new HashMap<String, String>(0));
        PostMethod postMethod = new PostMethod(serviceURL);
        int partSize = params.size() + 1;
        Part[] parts = new Part[partSize];
        int index = 0;
        for (String key : params.keySet()) {
            parts[index] = new StringPart(key, params.get(key));
            ++index;
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)body);
        String name = params.get("filename");
        ByteArrayPartSource partSource = new ByteArrayPartSource(name, bytes);
        parts[index] = new FilePart("filedata", (PartSource)partSource, bodyMimeType, charSet);
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        logger.debug("Executing multipart post request to " + uri, new Object[0]);
        int status = httpClient.executeMethod((HttpMethod)postMethod);
        logger.debug("Response status back from the server: " + status, new Object[0]);
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("alfrescoMultipartPostRequest(String uri, Map<String, String> params, InputStream body, String bodyMimeType, String charSet); {0}, {1}, {2}, {3}, {4}\n\t\tDuration: {5}", uri, params, "body", bodyMimeType, charSet, duration);
        return postMethod.getResponseBodyAsString();
    }

    protected String buildAlfrescoRequestURL(String uri, Map<String, String> params) throws Exception {
        String url = "";
        String serviceUrlBase = this.alfrescoUrl + "/service";
        String ticket = this.getAlfTicket();
        if (params != null) {
            for (String key : params.keySet()) {
                uri = uri.replace("{" + key + "}", URLEncoder.encode(params.get(key), "utf-8"));
            }
        }
        url = serviceUrlBase + uri;
        url = url + (url.contains("?") ? "&alf_ticket=" + ticket : "?alf_ticket=" + ticket);
        return url;
    }

    public String getAlfTicket() {
        return this.getSessionTicket();
    }

    @Override
    public Map<String, String> getUserProfile(String username) {
        this.addDebugStack();
        InputStream retStream = null;
        HashMap<String, String> toRet = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)username)) {
            return toRet;
        }
        try {
            String downloadURI = "/api/people/{username}";
            HashMap<String, String> lookupContentParams = new HashMap<String, String>();
            lookupContentParams.put("username", username);
            retStream = this.alfrescoGetRequest(downloadURI, lookupContentParams);
            ObjectMapper objectMapper = new ObjectMapper();
            Map result = (Map)objectMapper.readValue(retStream, HashMap.class);
            toRet.put("userName", (String)result.get("userName"));
            toRet.put("firstName", (String)result.get("firstName"));
            toRet.put("lastName", (String)result.get("lastName"));
            toRet.put("email", (String)result.get("email"));
        }
        catch (Exception err) {
            logger.error("err getting user profile: ", err, new Object[0]);
        }
        return toRet;
    }

    @Override
    public Set<String> getUserGroups(String username) {
        this.addDebugStack();
        InputStream retStream = null;
        HashSet<String> toRet = new HashSet<String>();
        try {
            String downloadURI = "/api/people/{username}?groups=true";
            HashMap<String, String> lookupContentParams = new HashMap<String, String>();
            lookupContentParams.put("username", username);
            retStream = this.alfrescoGetRequest(downloadURI, lookupContentParams);
            ObjectMapper objectMapper = new ObjectMapper();
            Map result = (Map)objectMapper.readValue(retStream, HashMap.class);
            List groups = (List)result.get("groups");
            for (Map group : groups) {
                toRet.add((String)group.get("displayName"));
            }
        }
        catch (Exception err) {
            logger.error("err getting content: ", err, new Object[0]);
        }
        return toRet;
    }

    @Override
    public String getCurrentUser() {
        this.addDebugStack();
        String username = this.getSessionUsername();
        return username;
    }

    @Override
    public String authenticate(String username, String password) {
        InputStream retStream = null;
        String toRet = null;
        try {
            String downloadURI = "/api/login?u={u}&pw={pw}";
            HashMap<String, String> lookupContentParams = new HashMap<String, String>();
            lookupContentParams.put("u", username);
            lookupContentParams.put("pw", password);
            retStream = this.alfrescoGetRequest(downloadURI, lookupContentParams);
            SAXReader reader = new SAXReader();
            org.dom4j.Document response = reader.read(retStream);
            Node ticketNode = response.selectSingleNode("//ticket");
            toRet = ticketNode.getText();
            this.storeSessionTicket(toRet);
            this.storeSessionUsername(username);
        }
        catch (Exception err) {
            logger.error("err getting content: ", err, new Object[0]);
        }
        return toRet;
    }

    @Override
    public boolean validateTicket(String ticket) {
        long startTime = System.currentTimeMillis();
        ticket = ticket != null ? ticket : this.getSessionTicket();
        logger.debug("Validating ticket " + ticket, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ticket", ticket);
        String serviceURL = null;
        try {
            serviceURL = this.buildAlfrescoRequestURL("/api/login/ticket/{ticket}", params);
            GetMethod getMethod = new GetMethod(serviceURL);
            HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            int status = httpClient.executeMethod((HttpMethod)getMethod);
            if (status == 200) {
                long duration = System.currentTimeMillis() - startTime;
                logger.debug("validateTicket(String ticket); {0}\n\t\tDuration: {1}", ticket, duration);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while validating authentication token", e, new Object[0]);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("validateTicket(String ticket); {0}\n\t\tDuration: {1}", ticket, duration);
        return false;
    }

    private void addDebugStack() {
        if (logger.getLevel().equals("debug")) {
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            logger.debug("Thread: " + threadName, new Object[0]);
            StackTraceElement[] stackTraceElements = thread.getStackTrace();
            StringBuilder sbStack = new StringBuilder();
            int stackSize = 10 < stackTraceElements.length - 2 ? 10 : stackTraceElements.length;
            for (int i = 2; i < stackSize + 2; ++i) {
                sbStack.append("\n\t").append(stackTraceElements[i].toString());
            }
            RequestContext context = RequestContext.getCurrent();
            CronJobContext cronJobContext = CronJobContext.getCurrent();
            if (context != null) {
                HttpServletRequest request = context.getRequest();
                String url = request.getRequestURI() + "?" + request.getQueryString();
                logger.debug("Http request: " + url, new Object[0]);
            } else if (cronJobContext != null) {
                logger.debug("Cron Job", new Object[0]);
            }
            logger.debug("Stack trace (depth 10): " + sbStack.toString(), new Object[0]);
        }
    }

    protected String getNodeRefForPathCMIS(String fullPath) throws ContentNotFoundException {
        long startTime = System.currentTimeMillis();
        HashMap params = new HashMap();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        String nodeRef = null;
        try {
            Session session = this.getCMISSession();
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            if (cmisObject != null) {
                Property property = cmisObject.getProperty("alfcmis:nodeRef");
                nodeRef = property.getValueAsString();
            }
        }
        catch (CmisBaseException e) {
            logger.warn("Object not found in CMIS repository for path: {0}", fullPath);
            throw new ContentNotFoundException((Exception)((Object)e));
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("getNodeRefForPathCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return nodeRef;
    }

    protected InputStream getContentStreamCMIS(String fullPath) throws ContentNotFoundException {
        long startTime = System.currentTimeMillis();
        HashMap params = new HashMap();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        InputStream inputStream = null;
        try {
            ObjectType type;
            Session session = this.getCMISSession();
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            Object nodeRef = null;
            if (cmisObject != null && "cmis:document".equals((type = cmisObject.getType()).getId())) {
                Document document = (Document)cmisObject;
                ContentStream contentStream = document.getContentStream();
                inputStream = contentStream.getStream();
            }
        }
        catch (CmisBaseException e) {
            logger.error("Error getting content from CMIS repository for path: ", (Exception)((Object)e), fullPath);
            throw new ContentNotFoundException((Exception)((Object)e));
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("getContentStreamCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return inputStream;
    }

    protected RepositoryItem[] getContentChildrenCMIS(String fullPath) {
        ObjectType type;
        long startTime = System.currentTimeMillis();
        HashMap params = new HashMap();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        Session session = this.getCMISSession();
        CmisObject cmisObject = session.getObjectByPath(cleanPath);
        Object nodeRef = null;
        RepositoryItem[] items = null;
        if (cmisObject != null && "cmis:folder".equals((type = cmisObject.getBaseType()).getId())) {
            Folder folder = (Folder)cmisObject;
            ItemIterable children = folder.getChildren();
            ArrayList<RepositoryItem> tempList = new ArrayList<RepositoryItem>();
            for (CmisObject child : children) {
                boolean isWorkingCopy = false;
                boolean isFolder = "cmis:folder".equals(child.getBaseType().getId());
                RepositoryItem item = new RepositoryItem();
                item.name = child.getName();
                if (BaseTypeId.CMIS_DOCUMENT.equals((Object)child.getBaseTypeId())) {
                    List aspects;
                    Document document = (Document)child;
                    item.path = (String)document.getPaths().get(0);
                    Property secundaryTypes = document.getProperty("cmis:secondaryObjectTypeIds");
                    if (secundaryTypes != null && (aspects = (List)secundaryTypes.getValue()).contains("P:cm:workingcopy")) {
                        isWorkingCopy = true;
                    }
                } else {
                    item.path = fullPath;
                }
                item.path = StringUtils.removeEnd((String)item.path, (String)("/" + item.name));
                item.isFolder = isFolder;
                if (isWorkingCopy) continue;
                tempList.add(item);
            }
            items = new RepositoryItem[tempList.size()];
            items = tempList.toArray(items);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("getContentChildrenCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean writeContentCMIS(String fullPath, InputStream content) {
        long startTime = System.currentTimeMillis();
        HashMap params = new HashMap();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        int splitIndex = cleanPath.lastIndexOf("/");
        String filename = cleanPath.substring(splitIndex + 1);
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String mimeType = mimeTypesMap.getContentType(filename);
        try {
            Session session = this.getCMISSession();
            ContentStream contentStream = session.getObjectFactory().createContentStream(filename, -1L, mimeType, content);
            CmisObject cmisObject = null;
            if (this.contentExists(cleanPath)) {
                cmisObject = session.getObjectByPath(cleanPath);
            }
            if (cmisObject != null) {
                ObjectType type = cmisObject.getBaseType();
                if ("cmis:document".equals(type.getId())) {
                    Document document = (Document)cmisObject;
                    String pwcId = document.getVersionSeriesCheckedOutId();
                    if (pwcId != null) {
                        Document pwcDocument = (Document)session.getObject(pwcId);
                        pwcDocument.checkIn(false, null, contentStream, null);
                    } else {
                        document.setContentStream(contentStream, true);
                    }
                    session.removeObjectFromCache(document.getId());
                }
            } else {
                String folderPath = cleanPath.substring(0, splitIndex);
                CmisObject folderCmisObject = null;
                if (this.contentExists(folderPath)) {
                    folderCmisObject = session.getObjectByPath(folderPath);
                }
                Folder folder = null;
                if (folderCmisObject == null) {
                    boolean created = this.createMissingFoldersCMIS(folderPath);
                    if (!created) return false;
                    session.clear();
                    folderCmisObject = session.getObjectByPath(folderPath);
                    folder = (Folder)folderCmisObject;
                } else {
                    folder = (Folder)folderCmisObject;
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", "cmis:document");
                properties.put("cmis:name", filename);
                folder.createDocument(properties, contentStream, VersioningState.MINOR);
            }
            long duration = System.currentTimeMillis() - startTime;
            logger.debug("writeContentCMIS(String fullPath, InputStream content); {0}, {1}\n\t\tDuration: {2}", fullPath, "content", duration);
            return true;
        }
        catch (CmisBaseException e) {
            logger.error("Error writing content to a path {0}", (Exception)((Object)e), fullPath);
        }
        catch (NullPointerException e) {
            logger.error("Error writing content to a path {0}", e, fullPath);
        }
        catch (Throwable t) {
            logger.error("Error writing content to a path {0}", t, fullPath);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("writeContentCMIS(String fullPath, InputStream content); {0}, {1}\n\t\tDuration: {2}", fullPath, "content", duration);
        return false;
    }

    protected boolean deleteContentCMIS(String fullPath) {
        long startTime = System.currentTimeMillis();
        boolean result = false;
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        try {
            Session session = this.getCMISSession();
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            if (cmisObject == null) {
                logger.debug("No content found at " + fullPath, new Object[0]);
                result = true;
            } else {
                Document doc;
                ObjectType type = cmisObject.getBaseType();
                if (BaseTypeId.CMIS_DOCUMENT.value().equals(type.getId()) && (doc = (Document)cmisObject).isVersionSeriesCheckedOut().booleanValue()) {
                    doc.cancelCheckOut();
                }
                cmisObject.delete(true);
                session.removeObjectFromCache(cmisObject.getId());
                result = true;
            }
        }
        catch (CmisBaseException e) {
            logger.error("Could not find content for path {0}", fullPath);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("deleteContentCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return result;
    }

    protected VersionTO[] getContentVersionHistoryCMIS(String fullPath) {
        long startTime = System.currentTimeMillis();
        VersionTO[] versions = new VersionTO[]{};
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        try {
            Session session = this.getCMISSession();
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            if (cmisObject != null) {
                ObjectType type = cmisObject.getType();
                if ("cmis:document".equals(type.getId())) {
                    Document doc = (Document)cmisObject;
                    List versionsCMIS = doc.getAllVersions();
                    if (versionsCMIS != null && versionsCMIS.size() > 0) {
                        versions = new VersionTO[versionsCMIS.size()];
                    }
                    int idx = 0;
                    for (Document version : versionsCMIS) {
                        VersionTO versionTO = new VersionTO();
                        versionTO.setVersionNumber(version.getVersionLabel());
                        versionTO.setLastModifier(version.getLastModifiedBy());
                        versionTO.setLastModifiedDate(version.getLastModificationDate().getTime());
                        versionTO.setComment(version.getCheckinComment());
                        versions[idx++] = versionTO;
                    }
                }
            } else {
                logger.info("Content not found for path: [" + fullPath + "]", new Object[0]);
            }
        }
        catch (CmisBaseException err) {
            logger.error("err getting content: ", (Exception)((Object)err), new Object[0]);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("getContentVersionHistoryCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return versions;
    }

    protected boolean revertContentCMIS(String fullPath, String version, boolean major, String comment) {
        boolean success;
        long startTime;
        block4: {
            startTime = System.currentTimeMillis();
            success = false;
            String cleanPath = fullPath.replaceAll("//", "/");
            if (cleanPath.endsWith("/")) {
                cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
            }
            try {
                Document doc;
                List versionsCMIS;
                ObjectType type;
                Session session = this.getCMISSession();
                CmisObject cmisObject = session.getObjectByPath(cleanPath);
                if (cmisObject == null || !"cmis:document".equals((type = cmisObject.getType()).getId()) || (versionsCMIS = (doc = (Document)cmisObject).getAllVersions()) == null || versionsCMIS.size() <= 0) break block4;
                for (Document documentVersion : versionsCMIS) {
                    if (!version.equals(documentVersion.getVersionLabel())) continue;
                    ContentStream contentStream = documentVersion.getContentStream();
                    ObjectId checkoutId = doc.checkOut();
                    Document checkedOutDoc = (Document)session.getObject(checkoutId);
                    checkedOutDoc.checkIn(false, null, contentStream, comment);
                    success = true;
                    break;
                }
            }
            catch (CmisBaseException err) {
                logger.error("err reverting content content: ", (Exception)((Object)err), new Object[0]);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("revertContentCMIS(String fullPath, String version, boolean major, String comment); {0}, {1}, {2}, {3}\n\t\tDuration: {4}", fullPath, version, major, comment, duration);
        return success;
    }

    protected boolean createMissingFoldersCMIS(String fullPath) {
        String newFolderRef = null;
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.length() > 1 && cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        try {
            int idx = cleanPath.lastIndexOf("/");
            String parentPath = "/";
            String name = "";
            if (idx >= 0) {
                parentPath = cleanPath.substring(0, idx);
                if (StringUtils.isEmpty((String)parentPath)) {
                    parentPath = "/";
                }
                name = cleanPath.substring(idx + 1);
            }
            Session session = this.getCMISSession();
            CmisObject parentCmisOBject = null;
            try {
                parentCmisOBject = session.getObjectByPath(parentPath);
            }
            catch (CmisObjectNotFoundException ex) {
                logger.info("Parent folder [{0}] not found, creating it.", cleanPath);
                this.createMissingFoldersCMIS(parentPath);
                session.clear();
                parentCmisOBject = session.getObjectByPath(parentPath);
            }
            if (parentCmisOBject != null) {
                ObjectType type = parentCmisOBject.getType();
                if ("cmis:folder".equals(type.getId())) {
                    Folder folder = (Folder)parentCmisOBject;
                    HashMap<String, String> newFolderProps = new HashMap<String, String>();
                    newFolderProps.put("cmis:objectTypeId", "cmis:folder");
                    newFolderProps.put("cmis:name", name);
                    Folder newFolder = folder.createFolder(newFolderProps);
                    Property property = newFolder.getProperty("alfcmis:nodeRef");
                    newFolderRef = property.getValueAsString();
                }
            } else {
                logger.error("Failed to create " + name + " folder since " + fullPath + " does not exist.", new Object[0]);
            }
        }
        catch (CmisBaseException err) {
            logger.error("Failed to create  folder in {0}", (Exception)((Object)err), fullPath);
        }
        return true;
    }

    protected String createFolderInternalCMIS(String fullPath, String name) {
        long startTime = System.currentTimeMillis();
        String newFolderRef = null;
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.length() > 1 && cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        try {
            CmisObject parentCmisOBject;
            block10: {
                Session session = this.getCMISSession();
                parentCmisOBject = null;
                try {
                    parentCmisOBject = session.getObjectByPath(cleanPath);
                }
                catch (CmisObjectNotFoundException ex) {
                    String parentName;
                    String nodeRef;
                    logger.info("Parent folder [{0}] not found, creating it.", cleanPath);
                    int idx = cleanPath.lastIndexOf("/");
                    if (idx < 0) break block10;
                    String ancestorPath = cleanPath.substring(0, idx);
                    if (StringUtils.isEmpty((String)ancestorPath)) {
                        ancestorPath = "/";
                    }
                    if (StringUtils.isEmpty((String)(nodeRef = this.createFolderInternalCMIS(ancestorPath, parentName = cleanPath.substring(idx + 1))))) {
                        logger.error("Failed to create " + name + " folder since " + fullPath + " does not exist.", new Object[0]);
                        return newFolderRef;
                    }
                    parentCmisOBject = session.getObjectByPath(cleanPath);
                }
            }
            if (parentCmisOBject != null) {
                ObjectType type = parentCmisOBject.getType();
                if ("cmis:folder".equals(type.getId())) {
                    Folder folder = (Folder)parentCmisOBject;
                    HashMap<String, String> newFolderProps = new HashMap<String, String>();
                    newFolderProps.put("cmis:objectTypeId", "cmis:folder");
                    newFolderProps.put("cmis:name", name);
                    Folder newFolder = folder.createFolder(newFolderProps);
                    Property property = newFolder.getProperty("alfcmis:nodeRef");
                    newFolderRef = property.getValueAsString();
                }
            } else {
                logger.error("Failed to create " + name + " folder since " + fullPath + " does not exist.", new Object[0]);
            }
        }
        catch (CmisBaseException err) {
            logger.error("Failed to create " + name + " folder in {0}", (Exception)((Object)err), fullPath);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("createFolderInternalCMIS(String fullPath, String name); {0}, {1}\n\t\tDuration: {2}", fullPath, name, duration);
        return newFolderRef;
    }

    protected boolean copyContentInternalCMIS(String fromFullPath, String toFullPath, boolean isCut) {
        String cleanToPath;
        long startTime = System.currentTimeMillis();
        boolean result = false;
        String cleanFromPath = fromFullPath.replaceAll("//", "/");
        if (cleanFromPath.endsWith("/")) {
            cleanFromPath = cleanFromPath.substring(0, cleanFromPath.length() - 1);
        }
        if ((cleanToPath = toFullPath.replaceAll("//", "/")).endsWith("/")) {
            cleanToPath = cleanToPath.substring(0, cleanToPath.length() - 1);
        }
        try {
            Session session = this.getCMISSession();
            CmisObject sourceCmisObject = session.getObjectByPath(cleanFromPath);
            CmisObject targetCmisObject = session.getObjectByPath(cleanToPath);
            if (sourceCmisObject != null && targetCmisObject != null) {
                ObjectType sourceType = sourceCmisObject.getType();
                ObjectType targetType = targetCmisObject.getType();
                if (BaseTypeId.CMIS_FOLDER.value().equals(targetType.getId())) {
                    Folder targetFolder = (Folder)targetCmisObject;
                    if ("cmis:document".equals(sourceType.getId())) {
                        Document sourceDocument = (Document)sourceCmisObject;
                        logger.debug("Coping document {0} to {1}", sourceDocument.getPaths().get(0), targetFolder.getPath());
                        this.copyDocument(targetFolder, sourceDocument);
                    } else if ("cmis:folder".equals(sourceType.getId())) {
                        Folder sourceFolder = (Folder)sourceCmisObject;
                        logger.debug("Coping folder {0} to {1}", sourceFolder.getPath(), targetFolder.getPath());
                        this.copyChildren(targetFolder, sourceFolder);
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    logger.debug("copyContentInternalCMIS(String fromFullPath, String toFullPath, boolean isCut); {0}, {1}, {2}\n\t\tDuration: {3}", fromFullPath, toFullPath, isCut, duration);
                    return true;
                }
                logger.error((isCut ? "Move" : "Copy") + " failed since target path " + toFullPath + " is not folder.", new Object[0]);
            } else {
                if (sourceCmisObject == null) {
                    logger.error((isCut ? "Move" : "Copy") + " failed since source path " + fromFullPath + " does not exist.", new Object[0]);
                }
                if (targetCmisObject == null) {
                    logger.error((isCut ? "Move" : "Copy") + " failed since target path " + toFullPath + " does not exist.", new Object[0]);
                }
            }
        }
        catch (CmisBaseException err) {
            logger.error("Error while " + (isCut ? "moving" : "copying") + " content from " + fromFullPath + " to " + toFullPath, (Exception)((Object)err), new Object[0]);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("copyContentInternalCMIS(String fromFullPath, String toFullPath, boolean isCut); {0}, {1}, {2}\n\t\tDuration: {3}", fromFullPath, toFullPath, isCut, duration);
        return result;
    }

    private void copyFolder(Folder parentFolder, Folder toCopyFolder) {
        HashMap<String, String> folderProperties = new HashMap<String, String>(2);
        folderProperties.put("cmis:name", toCopyFolder.getName());
        folderProperties.put("cmis:objectTypeId", toCopyFolder.getBaseTypeId().value());
        Folder newFolder = parentFolder.createFolder(folderProperties);
        this.copyChildren(newFolder, toCopyFolder);
    }

    private void copyChildren(Folder parentFolder, Folder toCopyFolder) {
        ItemIterable immediateChildren = toCopyFolder.getChildren();
        for (CmisObject child : immediateChildren) {
            if (BaseTypeId.CMIS_DOCUMENT.value().equals(child.getBaseTypeId().value())) {
                this.copyDocument(parentFolder, (Document)child);
                continue;
            }
            if (!BaseTypeId.CMIS_FOLDER.value().equals(child.getBaseTypeId().value())) continue;
            this.copyFolder(parentFolder, (Folder)child);
        }
    }

    private void copyDocument(Folder parentFolder, Document sourceDocument) {
        HashMap<String, String> documentProperties = new HashMap<String, String>(2);
        documentProperties.put("cmis:name", sourceDocument.getName());
        documentProperties.put("cmis:objectTypeId", sourceDocument.getBaseTypeId().value());
        parentFolder.createDocument(documentProperties, sourceDocument.getContentStream(), VersioningState.MINOR);
    }

    protected Session getCMISSession() {
        return this.getCMISSession(true);
    }

    protected Session getCMISSession(boolean alfrescoCMIS) {
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        String ticket = this.getAlfTicket();
        parameter.put("org.apache.chemistry.opencmis.user", "ROLE_TICKET");
        parameter.put("org.apache.chemistry.opencmis.password", ticket);
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", this.alfrescoUrl + "/api/-default-/public/cmis/versions/1.1/atom/");
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        if (alfrescoCMIS) {
            // empty if block
        }
        List repositories = new ArrayList();
        repositories = sessionFactory.getRepositories(parameter);
        Repository repository = (Repository)repositories.get(0);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", repository.getId());
        Session session = sessionFactory.createSession(parameter);
        return session;
    }

    @Override
    public void lockItem(String site, String path) {
        String fullPath = this.expandRelativeSitePath(site, path);
        this.lockItemCMIS(fullPath);
    }

    protected void lockItemCMIS(String fullPath) {
        long startTime = System.currentTimeMillis();
        Session session = this.getCMISSession();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        try {
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            Document document = (Document)cmisObject;
            if (!document.isVersionSeriesCheckedOut().booleanValue()) {
                document.checkOut();
            }
        }
        catch (CmisBaseException err) {
            logger.error("Error while locking content at path " + cleanPath, (Exception)((Object)err), new Object[0]);
        }
        catch (Throwable err) {
            logger.error("Error while locking content at path " + cleanPath, err);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("lockItemCMIS(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
    }

    protected String expandRelativeSitePath(String site, String relativePath) {
        return "/wem-projects/" + site + "/" + site + "/work-area" + relativePath;
    }

    @Override
    public void unLockItem(String site, String path) {
        long startTime = System.currentTimeMillis();
        String fullPath = this.expandRelativeSitePath(site, path);
        Session session = this.getCMISSession();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        if (this.contentExists(cleanPath)) {
            try {
                Document pwcDocument;
                Document document;
                String pwcId;
                CmisObject cmisObject = session.getObjectByPath(cleanPath);
                ObjectType type = cmisObject.getBaseType();
                if ("cmis:document".equals(type.getId()) && StringUtils.isNotEmpty((String)(pwcId = (document = (Document)cmisObject).getVersionSeriesCheckedOutId())) && (pwcDocument = (Document)session.getObject(pwcId)) != null) {
                    pwcDocument.cancelCheckOut();
                }
            }
            catch (CmisBaseException err) {
                logger.error("Error while locking content at path " + cleanPath, (Exception)((Object)err), new Object[0]);
            }
            catch (Throwable err) {
                logger.error("Error while locking content at path " + cleanPath, err);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("unLockItem(String site, String path); {0}, {1}\n\t\tDuration: {2}", site, path, duration);
    }

    @Override
    public void addUserGroup(String groupName) {
        String newGroupRequestBody = "{ \"displayName\":\"" + groupName + "\"}";
        try {
            InputStream bodyStream = IOUtils.toInputStream((String)newGroupRequestBody, (String)"UTF-8");
            String string = this.alfrescoPostRequest("/api/rootgroups/" + groupName, null, bodyStream, "application/json");
        }
        catch (Exception err) {
            logger.error("err adding root group: " + groupName, err, new Object[0]);
        }
    }

    @Override
    public void addUserGroup(String parentGroup, String groupName) {
        String newGroupRequestBody = "{ \"displayName\":\"" + groupName + "\"}";
        try {
            InputStream bodyStream = IOUtils.toInputStream((String)newGroupRequestBody, (String)"UTF-8");
            String string = this.alfrescoPostRequest("/api/groups/" + parentGroup + "/children/GROUP_" + groupName, null, bodyStream, "application/json");
        }
        catch (Exception err) {
            logger.error("err adding group: " + groupName + " to parent group: " + parentGroup, err, new Object[0]);
        }
    }

    @Override
    public void addUserToGroup(String groupName, String user) {
        String addUserToGroupRequestBody = "{ \"displayName\":\"" + user + "\"}";
        try {
            InputStream bodyStream = IOUtils.toInputStream((String)addUserToGroupRequestBody, (String)"UTF-8");
            String string = this.alfrescoPostRequest("/api/groups/" + groupName + "/children/" + user, null, bodyStream, "application/json");
        }
        catch (Exception err) {
            logger.error("err adding user: " + user + " to parent group: " + groupName, err, new Object[0]);
        }
    }

    @Override
    public String getCurrentToken() {
        return this.getSessionTicket();
    }

    protected String getSessionTicket() {
        String ticket = "UNSET";
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            ticket = (String)httpSession.getAttribute("alf_ticket");
        } else {
            CronJobContext cronJobContext = CronJobContext.getCurrent();
            if (cronJobContext != null) {
                ticket = cronJobContext.getAuthenticationToken();
            } else {
                RepositoryEventContext repositoryEventContext = RepositoryEventContext.getCurrent();
                if (repositoryEventContext != null) {
                    ticket = repositoryEventContext.getAuthenticationToken();
                }
            }
        }
        if (ticket == null) {
            ticket = "NOTICKET";
        }
        return ticket;
    }

    protected void storeSessionTicket(String ticket) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("alf_ticket", (Object)ticket);
        }
    }

    protected String getSessionUsername() {
        String username = null;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            username = (String)httpSession.getAttribute("alf_user");
        }
        return username;
    }

    protected void storeSessionUsername(String username) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("alf_user", (Object)username);
        }
    }

    @Override
    public Date getModifiedDate(String fullPath) {
        long startTime = System.currentTimeMillis();
        HashMap params = new HashMap();
        String cleanPath = fullPath.replaceAll("//", "/");
        if (cleanPath.endsWith("/")) {
            cleanPath = cleanPath.substring(0, cleanPath.length() - 1);
        }
        Date modifiedDate = null;
        try {
            Session session = this.getCMISSession();
            CmisObject cmisObject = session.getObjectByPath(cleanPath);
            if (cmisObject != null) {
                modifiedDate = cmisObject.getLastModificationDate().getTime();
            }
        }
        catch (CmisBaseException e) {
            logger.error("Error getting content from CMIS repository for path: ", (Exception)((Object)e), fullPath);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("getModifiedDate(String fullPath); {0}\n\t\tDuration: {1}", fullPath, duration);
        return modifiedDate;
    }

    @Override
    public boolean logout() {
        long startTime = System.currentTimeMillis();
        String ticket = this.getSessionTicket();
        logger.debug("Invalidating ticket " + ticket, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ticket", ticket);
        String serviceURL = null;
        try {
            serviceURL = this.buildAlfrescoRequestURL("/api/login/ticket/{ticket}", params);
            DeleteMethod getMethod = new DeleteMethod(serviceURL);
            HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            int status = httpClient.executeMethod((HttpMethod)getMethod);
            if (status == 200) {
                long duration = System.currentTimeMillis() - startTime;
                logger.debug("logout()\n\t\tDuration: {0}", duration);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while invalidating authentication token", e, new Object[0]);
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("logout()\n\t\tDuration: {0}", duration);
        return false;
    }

    public void bootstrap() throws Exception {
        if (this.bootstrapEnabled) {
            String ticket = this.authenticate(this.adminUser, this.adminPassword);
            RepositoryEventContext repositoryEventContext = new RepositoryEventContext(ticket);
            RepositoryEventContext.setCurrent(repositoryEventContext);
            if (!this.bootstrapCheck()) {
                logger.debug("Bootstrapping repository for Crafter CMS", new Object[0]);
                String bootstrapFolderPath = this.getBootstrapFolderPath();
                bootstrapFolderPath = bootstrapFolderPath + File.separator + "repo-bootstrap";
                File source = new File(bootstrapFolderPath);
                this.bootstrapDir(source, bootstrapFolderPath);
                this.addUserGroup("CRAFTER_CREATE_SITES");
                this.addUserToGroup("CRAFTER_CREATE_SITES", this.adminUser);
            }
            RepositoryEventContext.setCurrent(null);
        }
    }

    private void bootstrapDir(File dir, String rootPath) {
        Collection children = FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File child : children) {
            String childPath = child.getAbsolutePath();
            logger.debug("BOOTSTRAP Processing path: {0}", childPath);
            if (rootPath.equals(childPath)) continue;
            String relativePath = childPath.replace(rootPath, "");
            relativePath = relativePath.replace(File.separator, "/");
            String parentPath = child.getParent().replace(rootPath, "");
            if (StringUtils.isEmpty((String)(parentPath = parentPath.replace(File.separator, "/")))) {
                parentPath = "/";
            }
            if (child.isDirectory()) {
                this.createFolderInternalCMIS(parentPath, child.getName());
                continue;
            }
            if (!child.isFile()) continue;
            try {
                this.writeContentCMIS(relativePath, FileUtils.openInputStream((File)child));
            }
            catch (IOException e) {
                logger.error("Error while bootstrapping file: " + relativePath, e, new Object[0]);
            }
        }
    }

    private boolean bootstrapCheck() {
        boolean contenSpace = this.contentExists("/wem-projects");
        boolean blueprintsSpace = this.contentExists("/cstudio/blueprints");
        boolean configSpace = this.contentExists("/cstudio/config");
        return contenSpace && blueprintsSpace && configSpace;
    }

    private String getBootstrapFolderPath() {
        String path = this.getClass().getClassLoader().getResource("").getPath();
        String fullPath = null;
        try {
            fullPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String[] pathArr = fullPath.split("/WEB-INF/classes/");
        fullPath = pathArr[0];
        String reponsePath = "";
        reponsePath = new File(fullPath).getPath();
        return reponsePath;
    }

    public String getAlfrescoUrl() {
        return this.alfrescoUrl;
    }

    public void setAlfrescoUrl(String url) {
        this.alfrescoUrl = url;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public boolean isBootstrapEnabled() {
        return this.bootstrapEnabled;
    }

    public void setBootstrapEnabled(boolean bootstrapEnabled) {
        this.bootstrapEnabled = bootstrapEnabled;
    }
}

