/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.cached;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.impl.v1.repository.AbstractContentRepository;

public class CachedContentRepository
extends AbstractContentRepository {
    private static final Logger logger = LoggerFactory.getLogger(CachedContentRepository.class);
    ContentRepository wrappedRepo;
    long cacheAge = System.currentTimeMillis();
    HashMap<String, Object> globalCache = new HashMap();

    public ContentRepository getWrappedRepository() {
        return this.wrappedRepo;
    }

    public void setWrappedRepository(ContentRepository repo) {
        this.wrappedRepo = repo;
    }

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        InputStream value = null;
        try {
            BytesContainer cachedBytesContainer = (BytesContainer)this.getCachedObject("getContent-" + path);
            if (path.startsWith("/cstudio")) {
                if (cachedBytesContainer == null) {
                    value = this.wrappedRepo.getContent(path);
                    if (value != null) {
                        byte[] bytes = IOUtils.toByteArray((InputStream)value);
                        value.reset();
                        BytesContainer container = new BytesContainer(bytes);
                        this.cacheObject("getContent-" + path, bytes);
                    }
                } else {
                    byte[] cachedBytes = cachedBytesContainer.getBytes();
                    value = new ByteArrayInputStream(cachedBytes);
                }
            } else {
                value = this.wrappedRepo.getContent(path);
            }
        }
        catch (Exception err) {
            value = this.wrappedRepo.getContent(path);
        }
        return value;
    }

    @Override
    public boolean contentExists(String path) {
        Boolean value = null;
        value = (Boolean)this.getCachedObject("contentExists-" + path);
        if (value == null && (value = Boolean.valueOf(this.wrappedRepo.contentExists(path))) != null) {
            this.cacheObject("contentExists-" + path, value);
        }
        return value;
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        return this.wrappedRepo.writeContent(path, content);
    }

    @Override
    public boolean createFolder(String path, String name) {
        return this.wrappedRepo.createFolder(path, name);
    }

    @Override
    public boolean deleteContent(String path) {
        return this.wrappedRepo.deleteContent(path);
    }

    @Override
    public boolean copyContent(String fromPath, String toPath) {
        return this.wrappedRepo.copyContent(fromPath, toPath);
    }

    @Override
    public boolean moveContent(String fromPath, String toPath) {
        return this.wrappedRepo.moveContent(fromPath, toPath);
    }

    @Override
    public RepositoryItem[] getContentChildren(String path) {
        RepositoryItem[] value = null;
        value = (RepositoryItem[])this.getCachedObject("getContentChildren-" + path);
        if (value == null && (value = this.wrappedRepo.getContentChildren(path)) != null) {
            this.cacheObject("getContentChildren-" + path, value);
        }
        return value;
    }

    @Override
    public VersionTO[] getContentVersionHistory(String path) {
        VersionTO[] value = null;
        value = (VersionTO[])this.getCachedObject("getContentVersionHistory-" + path);
        if (value == null && (value = this.wrappedRepo.getContentVersionHistory(path)) != null) {
            this.cacheObject("getContentVersionHistory-" + path, value);
        }
        return value;
    }

    @Override
    public String createVersion(String path, boolean majorVersion) {
        return this.wrappedRepo.createVersion(path, majorVersion);
    }

    @Override
    public boolean revertContent(String path, String label, boolean major, String comment) {
        return this.wrappedRepo.revertContent(path, label, major, comment);
    }

    @Override
    public InputStream getContentVersion(String path, String version) throws ContentNotFoundException {
        return this.wrappedRepo.getContentVersion(path, version);
    }

    @Override
    public void lockItem(String site, String path) {
        this.wrappedRepo.lockItem(site, path);
    }

    @Override
    public void unLockItem(String site, String path) {
        this.wrappedRepo.unLockItem(site, path);
    }

    protected void cacheObject(String key, Object value) {
        HashMap<String, Object> cache = this.getCache();
        cache.put(key, value);
    }

    protected Object getCachedObject(String key) {
        Object value = null;
        HashMap<String, Object> cache = this.getCache();
        value = cache.get(key);
        if (value != null) {
            logger.debug("HIT: " + key, new Object[0]);
        }
        return value;
    }

    protected HashMap<String, Object> getCache() {
        Object cache = null;
        if (System.currentTimeMillis() - this.cacheAge > 10000L) {
            this.cacheAge = System.currentTimeMillis();
            this.globalCache = new HashMap();
        }
        return this.globalCache;
    }

    @Override
    public Date getModifiedDate(String path) {
        Date value = null;
        value = (Date)this.getCachedObject("getModifiedDate-" + path);
        if (value == null && (value = this.wrappedRepo.getModifiedDate(path)) != null) {
            this.cacheObject("getModifiedDate-" + path, value);
        }
        return value;
    }

    protected class BytesContainer {
        byte[] bytes = null;

        public BytesContainer(byte[] value) {
            this.bytes = value;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

