/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.disk;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.impl.v1.repository.AbstractContentRepository;
import org.springframework.web.context.ServletContextAware;
import reactor.core.Reactor;

public class DiskContentRepository
extends AbstractContentRepository
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DiskContentRepository.class);
    private ServletContext ctx;
    String rootPath;
    protected Reactor repositoryReactor;
    protected boolean bootstrapEnabled = false;

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        BufferedInputStream retStream = null;
        try {
            File file = this.constructRepoPath(path).toFile();
            retStream = new BufferedInputStream(FileUtils.openInputStream((File)file));
        }
        catch (Exception err) {
            throw new ContentNotFoundException("error while opening file", err);
        }
        return retStream;
    }

    @Override
    public boolean contentExists(String path) {
        return Files.exists(this.constructRepoPath(path), new LinkOption[0]);
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        boolean success = true;
        try {
            File file = this.constructRepoPath(path).toFile();
            File folder = file.getParentFile();
            if (folder != null && !folder.exists()) {
                folder.mkdirs();
            }
            FileUtils.writeByteArrayToFile((File)file, (byte[])IOUtils.toByteArray((InputStream)content));
        }
        catch (Exception err) {
            logger.error("error writing file: " + path, err, new Object[0]);
            success = false;
        }
        return success;
    }

    @Override
    public boolean createFolder(String path, String name) {
        boolean success = true;
        try {
            Files.createDirectories(this.constructRepoPath(path, name), new FileAttribute[0]);
        }
        catch (Exception err) {
            success = false;
        }
        return success;
    }

    @Override
    public boolean deleteContent(String path) {
        boolean success = true;
        try {
            File file = this.constructRepoPath(path).toFile();
            FileUtils.deleteQuietly((File)file);
        }
        catch (Exception err) {
            logger.error("error while deleting content", err, new Object[0]);
            success = false;
        }
        return success;
    }

    @Override
    public boolean copyContent(String fromPath, String toPath) {
        boolean success = true;
        try {
            Path source = this.constructRepoPath(fromPath);
            Path target = this.constructRepoPath(toPath);
            File sourceFile = source.toFile();
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectory((File)sourceFile, (File)target.toFile());
            } else {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)target.toFile());
            }
        }
        catch (Exception err) {
            logger.error("Error while copping content from {0} to {1}", err, fromPath, toPath);
            success = false;
        }
        return success;
    }

    @Override
    public boolean moveContent(String fromPath, String toPath) {
        boolean success = true;
        try {
            File source = this.constructRepoPath(fromPath).toFile();
            File dest = this.constructRepoPath(toPath).toFile();
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if (source.isDirectory()) {
                File[] dirList;
                for (File file : dirList = source.listFiles()) {
                    if (file.isDirectory()) {
                        FileUtils.moveDirectoryToDirectory((File)file, (File)dest, (boolean)true);
                        continue;
                    }
                    FileUtils.moveFileToDirectory((File)file, (File)dest, (boolean)true);
                }
                source.delete();
            }
            FileUtils.moveFileToDirectory((File)source, (File)dest, (boolean)true);
        }
        catch (Exception err) {
            success = false;
        }
        return success;
    }

    @Override
    public RepositoryItem[] getContentChildren(String path) {
        final ArrayList retItems = new ArrayList();
        try {
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            String finalPath = path;
            Files.walkFileTree(this.constructRepoPath(finalPath), opts, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path visitPath, BasicFileAttributes attrs) throws IOException {
                    RepositoryItem item = new RepositoryItem();
                    item.name = visitPath.toFile().getName();
                    String visitFolderPath = visitPath.toString();
                    item.isFolder = visitPath.toFile().isDirectory();
                    int lastIdx = visitFolderPath.lastIndexOf(File.separator + item.name);
                    if (lastIdx > 0) {
                        item.path = visitFolderPath.substring(0, lastIdx);
                    }
                    item.path = item.path.replace(DiskContentRepository.this.getRootPath().replace("/", File.separator), "");
                    item.path = item.path.replace(File.separator + ".xml", "");
                    item.path = item.path.replace(File.separator, "/");
                    if (!".DS_Store".equals(item.name)) {
                        logger.debug("ITEM NAME: {0}", item.name);
                        logger.debug("ITEM PATH: {0}", item.path);
                        logger.debug("ITEM FOLDER: ({0}): {1}", visitFolderPath, item.isFolder);
                        retItems.add(item);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception opts) {
            // empty catch block
        }
        RepositoryItem[] items = new RepositoryItem[retItems.size()];
        items = retItems.toArray(items);
        return items;
    }

    @Override
    public VersionTO[] getContentVersionHistory(String path) {
        final ArrayList versionList = new ArrayList();
        try {
            String pathToContent = path.substring(0, path.lastIndexOf(File.separator));
            final String filename = path.substring(path.lastIndexOf(File.separator) + 1);
            Path versionPath = this.constructVersionRepoPath(pathToContent);
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(versionPath, opts, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path visitPath, BasicFileAttributes attrs) throws IOException {
                    String versionFilename = visitPath.toString();
                    if (versionFilename.contains(filename)) {
                        VersionTO version = new VersionTO();
                        String label = versionFilename.substring(versionFilename.lastIndexOf("--") + 2);
                        BasicFileAttributes attr = Files.readAttributes(visitPath, BasicFileAttributes.class, new LinkOption[0]);
                        version.setVersionNumber(label);
                        version.setLastModifier("ADMIN");
                        version.setLastModifiedDate(new Date(attr.lastModifiedTime().toMillis()));
                        version.setComment("");
                        versionList.add(version);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception err) {
            logger.error("error while getting history for content item " + path, new Object[0]);
            logger.debug("error while getting history for content item " + path, err);
        }
        Collections.sort(versionList);
        VersionTO[] versions = new VersionTO[versionList.size()];
        versions = versionList.toArray(versions);
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createVersion(String path, boolean majorVersion) {
        String versionId = null;
        String string = path;
        synchronized (string) {
            versionId = this.determineNextVersionLabel(path, majorVersion);
            InputStream content = null;
            try {
                content = this.getContent(path);
                String versionPath = path + "--" + versionId;
                CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                String pathToContent = versionPath.substring(0, versionPath.lastIndexOf(File.separator));
                Files.createDirectories(this.constructVersionRepoPath(pathToContent), new FileAttribute[0]);
                Files.copy(content, this.constructVersionRepoPath(versionPath), options);
            }
            catch (Exception err) {
                logger.error("error versioning file: " + path, err, new Object[0]);
                versionId = null;
            }
            finally {
                this.closeInputStreamQuietly(content);
            }
        }
        return versionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revertContent(String path, String label, boolean major, String comment) {
        boolean success = false;
        String string = path;
        synchronized (string) {
            block8: {
                String versionId = this.determineNextVersionLabel(path, major);
                InputStream versionContent = null;
                InputStream wipContent = null;
                try {
                    versionContent = this.getVersionedContent(path, label);
                    String versionPath = path + "--" + versionId;
                    CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    String pathToContent = versionPath.substring(0, versionPath.lastIndexOf(File.separator));
                    Files.createDirectories(this.constructVersionRepoPath(pathToContent), new FileAttribute[0]);
                    Files.copy(versionContent, this.constructVersionRepoPath(versionPath), options);
                    wipContent = this.getVersionedContent(path, label);
                    Files.copy(wipContent, this.constructRepoPath(path), options);
                    this.closeInputStreamQuietly(versionContent);
                }
                catch (Exception err) {
                    logger.error("error versioning file: " + path, err, new Object[0]);
                    versionId = null;
                    break block8;
                }
                finally {
                    this.closeInputStreamQuietly(versionContent);
                    this.closeInputStreamQuietly(wipContent);
                }
                this.closeInputStreamQuietly(wipContent);
            }
        }
        return success;
    }

    @Override
    public InputStream getContentVersion(String path, String version) throws ContentNotFoundException {
        return this.getVersionedContent(path, version);
    }

    @Override
    public void lockItem(String site, String path) {
    }

    @Override
    public void unLockItem(String site, String path) {
    }

    protected InputStream getVersionedContent(String path, String label) throws ContentNotFoundException {
        InputStream retStream = null;
        try {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.READ};
            retStream = Files.newInputStream(this.constructVersionRepoPath(path + "--" + label), new OpenOption[0]);
        }
        catch (Exception err) {
            throw new ContentNotFoundException("error while opening file", err);
        }
        return retStream;
    }

    protected String determineNextVersionLabel(String path, boolean majorVersion) {
        String versionId = null;
        VersionTO[] versions = this.getContentVersionHistory(path);
        if (versions.length != 0) {
            VersionTO latestVersion = versions[versions.length - 1];
            String label = latestVersion.getVersionNumber();
            String[] labelParts = label.split("\\.");
            int major = Integer.parseInt(labelParts[0]);
            int minor = Integer.parseInt(labelParts[1]);
            versionId = majorVersion ? major + 1 + ".0" : major + "." + (minor + 1);
        } else {
            versionId = majorVersion ? "1.0" : "0.1";
        }
        return versionId;
    }

    public void bootstrap() throws Exception {
        Path cstudioFolder = this.constructRepoPath("cstudio");
        boolean bootstrapCheck = Files.exists(cstudioFolder, new LinkOption[0]);
        if (this.bootstrapEnabled && !bootstrapCheck) {
            try {
                logger.error("Bootstrapping repository for Crafter CMS", new Object[0]);
                Files.createDirectories(this.constructRepoPath(new String[0]), new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RequestContext context = RequestContext.getCurrent();
            String bootstrapFolderPath = this.ctx.getRealPath(File.separator + "repo-bootstrap");
            Path source = FileSystems.getDefault().getPath(bootstrapFolderPath, new String[0]);
            logger.info("Bootstrapping with baseline @ " + source.toFile().toString(), new Object[0]);
            Path target = this.constructRepoPath(new String[0]);
            TreeCopier tc = new TreeCopier(source, target, false, false);
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
        }
    }

    public void setServletContext(ServletContext ctx) {
        logger.debug("ServletContext: {0} ", ctx);
        this.ctx = ctx;
    }

    protected Path constructRepoPath(String ... args) {
        return FileSystems.getDefault().getPath(this.rootPath, args);
    }

    protected Path constructVersionRepoPath(String ... args) {
        return FileSystems.getDefault().getPath(this.rootPath + File.separator + "versions", args);
    }

    protected boolean closeInputStreamQuietly(InputStream is) {
        boolean success;
        block3: {
            success = true;
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ioErr) {
                    success = false;
                    if (!"debug".equals(logger.getLevel())) break block3;
                    logger.error("Error while closing InputStream quietly", ioErr, new Object[0]);
                }
            }
        }
        return success;
    }

    @Override
    public Date getModifiedDate(String path) {
        Date modifiedDate = null;
        try {
            File file = this.constructRepoPath(path).toFile();
            modifiedDate = new Date(file.lastModified());
        }
        catch (Exception err) {
            logger.error("error while getting last modified date for file", err, new Object[0]);
        }
        return modifiedDate;
    }

    public Reactor getRepositoryReactor() {
        return this.repositoryReactor;
    }

    public void setRepositoryReactor(Reactor repositoryReactor) {
        this.repositoryReactor = repositoryReactor;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public boolean isBootstrapEnabled() {
        return this.bootstrapEnabled;
    }

    public void setBootstrapEnabled(boolean bootstrapEnabled) {
        this.bootstrapEnabled = bootstrapEnabled;
    }

    static class TreeCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean prompt;
        private final boolean preserve;

        static void copyFile(Path source, Path target, boolean prompt, boolean preserve) {
            CopyOption[] copyOptionArray;
            if (preserve) {
                CopyOption[] copyOptionArray2 = new CopyOption[2];
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                CopyOption[] copyOptionArray3 = new CopyOption[1];
                copyOptionArray = copyOptionArray3;
                copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
            }
            CopyOption[] options = copyOptionArray;
            try {
                Files.copy(source, target, options);
            }
            catch (IOException x) {
                logger.error("Unable to copy: %s: %s%n", source, x);
            }
        }

        TreeCopier(Path source, Path target, boolean prompt, boolean preserve) {
            this.source = source;
            this.target = target;
            this.prompt = prompt;
            this.preserve = preserve;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            CopyOption[] copyOptionArray;
            if (this.preserve) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, options);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException x) {
                logger.error("Unable to create: %s: %s%n", newdir, x);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            TreeCopier.copyFile(file, this.target.resolve(this.source.relativize(file)), this.prompt, this.preserve);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (exc == null && this.preserve) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(newdir, time);
                }
                catch (IOException x) {
                    logger.error("Unable to copy all attributes to: %s: %s%n", newdir, x);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (exc instanceof FileSystemLoopException) {
                logger.error("cycle detected: " + file, new Object[0]);
            } else {
                logger.error("Unable to copy: %s: %s%n", file, exc);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

