/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.mapped;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.impl.v1.repository.AbstractContentRepository;

public class MappedContentRepository
extends AbstractContentRepository {
    private static final Logger logger = LoggerFactory.getLogger(MappedContentRepository.class);
    private Map<String, ContentRepository> repositoryMap = new HashMap<String, ContentRepository>();
    private String repositoryType = "default";

    public Map<String, ContentRepository> getRepositoryMap() {
        return this.repositoryMap;
    }

    public void setRepositoryMap(Map<String, ContentRepository> map) {
        this.repositoryMap = map;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String type) {
        this.repositoryType = type;
    }

    public void registerRepository(String type, ContentRepository repo) {
        this.repositoryMap.put(type, repo);
    }

    protected ContentRepository lookupRepo(String key) {
        ContentRepository repo = this.repositoryMap.get(key);
        if (repo == null) {
            throw new RuntimeException("respository type '" + key + "' not found.  Check server config.");
        }
        return repo;
    }

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.getContent(path);
    }

    @Override
    public boolean contentExists(String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.contentExists(path);
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.writeContent(path, content);
    }

    @Override
    public boolean createFolder(String path, String name) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.createFolder(path, name);
    }

    @Override
    public boolean deleteContent(String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.deleteContent(path);
    }

    @Override
    public boolean copyContent(String fromPath, String toPath) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.copyContent(fromPath, toPath);
    }

    @Override
    public boolean moveContent(String fromPath, String toPath) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.moveContent(fromPath, toPath);
    }

    @Override
    public RepositoryItem[] getContentChildren(String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.getContentChildren(path);
    }

    @Override
    public VersionTO[] getContentVersionHistory(String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.getContentVersionHistory(path);
    }

    @Override
    public String createVersion(String path, boolean majorVersion) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.createVersion(path, majorVersion);
    }

    @Override
    public boolean revertContent(String path, String label, boolean major, String comment) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.revertContent(path, label, major, comment);
    }

    @Override
    public InputStream getContentVersion(String path, String version) throws ContentNotFoundException {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.getContentVersion(path, version);
    }

    @Override
    public void lockItem(String site, String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        repo.lockItem(site, path);
    }

    @Override
    public void unLockItem(String site, String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        repo.unLockItem(site, path);
    }

    @Override
    public Date getModifiedDate(String path) {
        ContentRepository repo = this.lookupRepo(this.repositoryType);
        return repo.getModifiedDate(path);
    }
}

