/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.path;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.impl.v1.repository.AbstractContentRepository;

public class PathMappedContentRepository
extends AbstractContentRepository {
    private static final Logger logger = LoggerFactory.getLogger(PathMappedContentRepository.class);
    private ContentRepository defaultRepo;
    private Map<String, ContentRepository> pathRepoMap;

    public ContentRepository getDefaultRepository() {
        return this.defaultRepo;
    }

    public void setDefaultRepository(ContentRepository repo) {
        this.defaultRepo = repo;
    }

    public Map<String, ContentRepository> getPathRepositoryMap() {
        return this.pathRepoMap;
    }

    public void setPathRepositoryMap(Map<String, ContentRepository> repoMap) {
        this.pathRepoMap = repoMap;
    }

    public PathMappedContentRepository() {
        this.setPathRepositoryMap(new HashMap<String, ContentRepository>());
    }

    protected ContentRepository lookupRepo(String path) {
        ContentRepository retRepo = this.defaultRepo;
        Set<String> pathRegexs = this.pathRepoMap.keySet();
        for (String pathRegex : pathRegexs) {
            try {
                Matcher m = Pattern.compile(pathRegex).matcher(path);
                if (!m.find()) continue;
                retRepo = this.pathRepoMap.get(pathRegex);
                break;
            }
            catch (Exception regexErr) {
                logger.error("error looking up repo with regex '{0}' and path '{1}'", regexErr, pathRegex, path);
            }
        }
        if (retRepo == null) {
            logger.error("Repo is null, cannot complete operation.  No default set and '{0}' does not match any mapped repository,", path);
            throw new RuntimeException("Repo is null, cannot complete operation.");
        }
        return retRepo;
    }

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        ContentRepository repo = this.lookupRepo(path);
        return repo.getContent(path);
    }

    @Override
    public boolean contentExists(String path) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.contentExists(path);
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.writeContent(path, content);
    }

    @Override
    public boolean createFolder(String path, String name) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.createFolder(path, name);
    }

    @Override
    public boolean deleteContent(String path) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.deleteContent(path);
    }

    @Override
    public boolean copyContent(String fromPath, String toPath) {
        ContentRepository toRepo;
        ContentRepository fromRepo = this.lookupRepo(fromPath);
        if (fromRepo != (toRepo = this.lookupRepo(toPath))) {
            logger.error("From repository for path '{0}' and To repository for path '{1}' do not match", fromPath, toPath);
            throw new RuntimeException("cross repo copy operation not supported");
        }
        return fromRepo.copyContent(fromPath, toPath);
    }

    @Override
    public boolean moveContent(String fromPath, String toPath) {
        ContentRepository toRepo;
        ContentRepository fromRepo = this.lookupRepo(fromPath);
        if (fromRepo != (toRepo = this.lookupRepo(toPath))) {
            logger.error("From repository for path '{0}' and To repository for path '{1}' do not match", fromPath, toPath);
            throw new RuntimeException("cross repo move operation not supported");
        }
        return fromRepo.moveContent(fromPath, toPath);
    }

    @Override
    public RepositoryItem[] getContentChildren(String path) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.getContentChildren(path);
    }

    @Override
    public VersionTO[] getContentVersionHistory(String path) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.getContentVersionHistory(path);
    }

    @Override
    public String createVersion(String path, boolean majorVersion) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.createVersion(path, majorVersion);
    }

    @Override
    public boolean revertContent(String path, String label, boolean major, String comment) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.revertContent(path, label, major, comment);
    }

    @Override
    public void lockItem(String site, String path) {
        ContentRepository repo = this.lookupRepo(path);
        repo.lockItem(site, path);
    }

    @Override
    public void unLockItem(String site, String path) {
        ContentRepository repo = this.lookupRepo(path);
        repo.unLockItem(site, path);
    }

    @Override
    public Date getModifiedDate(String path) {
        ContentRepository repo = this.lookupRepo(path);
        return repo.getModifiedDate(path);
    }
}

