/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.ActivityFeed;
import org.craftercms.studio.api.v1.dal.ActivityFeedMapper;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.util.DebugUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityServiceImpl
extends AbstractRegistrableService
implements ActivityService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityServiceImpl.class);
    protected static final int MAX_LEN_USER_ID = 255;
    protected static final int MAX_LEN_SITE_ID = 255;
    protected static final int MAX_LEN_ACTIVITY_TYPE = 255;
    protected static final int MAX_LEN_ACTIVITY_DATA = 4000;
    protected static final int MAX_LEN_APP_TOOL_ID = 36;
    protected static final String ACTIVITY_PROP_ACTIVITY_SUMMARY = "activitySummary";
    protected static final String ACTIVITY_PROP_ID = "id";
    protected static final String ACTIVITY_PROP_POST_DATE = "postDate";
    protected static final String ACTIVITY_PROP_USER = "user";
    protected static final String ACTIVITY_PROP_FEEDUSER = "feedUserId";
    protected static final String ACTIVITY_PROP_CONTENTID = "contentId";
    protected static final String ACTIVITY_FEED_FORMAT = "json";
    @Autowired
    protected ActivityFeedMapper activityFeedMapper;
    protected boolean userNamesAreCaseSensitive = false;
    protected ContentService contentService;
    protected SecurityService securityService;

    @Override
    public void register() {
        this.getServicesManager().registerService(ActivityService.class, this);
    }

    @Override
    public void postActivity(String site, String user, String contentId, ActivityService.ActivityType activity, Map<String, String> extraInfo) {
        JSONObject activityPost = new JSONObject();
        activityPost.put((Object)ACTIVITY_PROP_USER, (Object)user);
        activityPost.put((Object)ACTIVITY_PROP_ID, (Object)contentId);
        if (extraInfo != null) {
            activityPost.putAll(extraInfo);
        }
        String contentType = null;
        if (extraInfo != null) {
            contentType = extraInfo.get("contentType");
        }
        this.postActivity(ContentUtils.generateActivityValue(activity), site, null, activityPost.toString(), contentId, contentType, user);
    }

    private void postActivity(String activityType, String siteNetwork, String appTool, String activityData, String contentId, String contentType, String approver) {
        String currentUser = StringUtils.isEmpty((String)approver) ? this.securityService.getCurrentUser() : approver;
        try {
            if (siteNetwork == null) {
                siteNetwork = "";
            } else if (siteNetwork.length() > 255) {
                throw new ServiceException("Invalid site network - exceeds 255 chars: " + siteNetwork);
            }
            if (appTool == null) {
                appTool = "";
            } else if (appTool.length() > 36) {
                throw new ServiceException("Invalid app tool - exceeds 36 chars: " + appTool);
            }
            if (StringUtils.isEmpty((String)activityType)) {
                throw new ServiceException("Invalid activity type - activity type is empty");
            }
            if (activityType.length() > 255) {
                throw new ServiceException("Invalid activity type - exceeds 255 chars: " + activityType);
            }
            if (activityData == null) {
                activityData = "";
            } else if (activityType.length() > 4000) {
                throw new ServiceException("Invalid activity data - exceeds 4000 chars: " + activityData);
            }
            if (StringUtils.isEmpty((String)currentUser)) {
                throw new ServiceException("Invalid user - user is empty");
            }
            if (currentUser.length() > 255) {
                throw new ServiceException("Invalid user - exceeds 255 chars: " + currentUser);
            }
            currentUser = currentUser.toLowerCase();
            if (contentType == null) {
                contentType = "pages";
            }
        }
        catch (ServiceException e) {
            logger.error("Error in getting feeds", e, new Object[0]);
        }
        try {
            Date postDate = new Date();
            ActivityFeed activityPost = new ActivityFeed();
            activityPost.setUserId(currentUser);
            activityPost.setSiteNetwork(siteNetwork);
            activityPost.setSummary(activityData);
            activityPost.setType(activityType);
            activityPost.setCreationDate(postDate);
            activityPost.setModifiedDate(postDate);
            activityPost.setSummaryFormat(ACTIVITY_FEED_FORMAT);
            activityPost.setContentId(contentId);
            activityPost.setContentType(contentType);
            try {
                long postId = this.postFeedEntry(activityPost);
                activityPost.setId(postId);
                logger.debug("Posted: " + activityPost, new Object[0]);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to post activity: " + e, e);
            }
        }
        catch (ServiceException e) {
            logger.error("Error in posting feed", e, new Object[0]);
        }
    }

    private long postFeedEntry(ActivityFeed activityFeed) {
        int count = this.getCountUserContentFeedEntries(activityFeed.getUserId(), activityFeed.getSiteNetwork(), activityFeed.getContentId());
        if (count == 0) {
            activityFeed.setCreationDate(new Date());
            return this.insertFeedEntry(activityFeed);
        }
        this.updateFeedEntry(activityFeed);
        return -1L;
    }

    private int getCountUserContentFeedEntries(String feedUserId, String siteId, String contentId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", feedUserId);
        params.put(ACTIVITY_PROP_CONTENTID, contentId);
        params.put("siteNetwork", siteId);
        return this.activityFeedMapper.getCountUserContentFeedEntries(params);
    }

    private long insertFeedEntry(ActivityFeed activityFeed) {
        DebugUtils.addDebugStack(logger);
        logger.info("Insert activity " + activityFeed.getContentId(), new Object[0]);
        Long id = this.activityFeedMapper.insertActivityFeed(activityFeed);
        return id != null ? id : -1L;
    }

    private void updateFeedEntry(ActivityFeed activityFeed) {
        DebugUtils.addDebugStack(logger);
        logger.info("Update activity " + activityFeed.getContentId(), new Object[0]);
        this.activityFeedMapper.updateActivityFeed(activityFeed);
    }

    @Override
    public void renameContentId(String site, String oldUrl, String newUrl) {
        DebugUtils.addDebugStack(logger);
        logger.info("Rename " + oldUrl + " to " + newUrl, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newPath", newUrl);
        params.put("site", site);
        params.put("oldPath", oldUrl);
        this.activityFeedMapper.renameContent(params);
    }

    @Override
    public List<ContentItemTO> getActivities(String site, String user, int num, String sort, boolean ascending, boolean excludeLive, String filterType) throws ServiceException {
        int startPos = 0;
        FastList contentItems = new FastList();
        boolean hasMoreItems = true;
        while (contentItems.size() < num && hasMoreItems) {
            int remainingItems = num - contentItems.size();
            hasMoreItems = this.getActivityFeeds(user, site, startPos, num, filterType, excludeLive, (List<ContentItemTO>)contentItems, remainingItems);
            startPos += num;
        }
        if (contentItems.size() > num) {
            return contentItems.subList(0, num);
        }
        return contentItems;
    }

    protected boolean getActivityFeeds(String user, String site, int startPos, int size, String filterType, boolean hideLiveItems, List<ContentItemTO> contentItems, int remainingItem) {
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        if (!this.userNamesAreCaseSensitive) {
            user = user.toLowerCase();
        }
        List<ActivityFeed> activityFeeds = null;
        activityFeeds = this.selectUserFeedEntries(user, ACTIVITY_FEED_FORMAT, site, startPos, size, filterType, hideLiveItems);
        for (ActivityFeed activityFeed : activityFeeds) {
            activityFeedEntries.add(activityFeed.getJSONString());
        }
        boolean hasMoreItems = true;
        if (activityFeedEntries.size() < size) {
            hasMoreItems = false;
        }
        if (activityFeedEntries != null && activityFeedEntries.size() > 0) {
            for (int index = 0; index < activityFeedEntries.size() && remainingItem != 0; --remainingItem, ++index) {
                JSONObject feedObject = JSONObject.fromObject(activityFeedEntries.get(index));
                String id = feedObject.containsKey((Object)ACTIVITY_PROP_CONTENTID) ? feedObject.getString(ACTIVITY_PROP_CONTENTID) : "";
                ContentItemTO item = this.createActivityItem(site, feedObject, id);
                contentItems.add(item);
            }
        }
        logger.debug("Total Item post live filter : " + contentItems.size() + " hasMoreItems : " + hasMoreItems, new Object[0]);
        return hasMoreItems;
    }

    protected ContentItemTO createActivityItem(String site, JSONObject feedObject, String id) {
        try {
            Date editedDate;
            ContentItemTO item = null;
            if (!this.contentService.contentExists(site, id)) {
                String activitySummary;
                JSONObject summaryObject;
                String modifier;
                item = this.contentService.createDummyDmContentItemForDeletedNode(site, id);
                String string = modifier = feedObject.containsKey((Object)ACTIVITY_PROP_FEEDUSER) ? feedObject.getString(ACTIVITY_PROP_FEEDUSER) : "";
                if (modifier != null && !modifier.isEmpty()) {
                    item.user = modifier;
                }
                if ((summaryObject = JSONObject.fromObject((Object)(activitySummary = feedObject.containsKey((Object)ACTIVITY_PROP_ACTIVITY_SUMMARY) ? feedObject.getString(ACTIVITY_PROP_ACTIVITY_SUMMARY) : ""))).containsKey((Object)"content-type")) {
                    String contentType;
                    item.contentType = contentType = (String)summaryObject.get("content-type");
                }
                if (summaryObject.containsKey((Object)"internalName")) {
                    String internalName;
                    item.internalName = internalName = (String)summaryObject.get("internalName");
                }
                if (summaryObject.containsKey((Object)"browserUri")) {
                    String browserUri;
                    item.browserUri = browserUri = (String)summaryObject.get("browserUri");
                }
                item.setLockOwner("");
            } else {
                item = this.contentService.getContentItem(site, id, 0);
            }
            String postDate = feedObject.containsKey((Object)ACTIVITY_PROP_POST_DATE) ? feedObject.getString(ACTIVITY_PROP_POST_DATE) : "";
            item.eventDate = editedDate = ContentUtils.getEditedDate(postDate);
            return item;
        }
        catch (Exception e) {
            logger.error("Error fetching content item for [" + id + "]", e.getMessage());
            return null;
        }
    }

    private List<ActivityFeed> selectUserFeedEntries(String feedUserId, String format, String siteId, int startPos, int feedSize, String contentType, boolean hideLiveItems) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", feedUserId);
        params.put("summaryFormat", format);
        params.put("siteNetwork", siteId);
        params.put("startPos", startPos);
        params.put("feedSize", feedSize);
        if (StringUtils.isNotEmpty((String)contentType) && !contentType.toLowerCase().equals("all")) {
            params.put("contentType", contentType.toLowerCase());
        }
        if (hideLiveItems) {
            ArrayList<String> statesValues = new ArrayList<String>();
            for (State state : State.LIVE_STATES) {
                statesValues.add(state.name());
            }
            params.put("states", statesValues);
            return this.activityFeedMapper.selectUserFeedEntriesHideLive(params);
        }
        return this.activityFeedMapper.selectUserFeedEntries(params);
    }

    @Override
    public ActivityFeed getDeletedActivity(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ACTIVITY_PROP_CONTENTID, path);
        params.put("siteNetwork", site);
        String activityType = ContentUtils.generateActivityValue(ActivityService.ActivityType.DELETED);
        params.put("activityType", activityType);
        return this.activityFeedMapper.getDeletedActivity(params);
    }

    @Override
    public void deleteActivitiesForSite(String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.activityFeedMapper.deleteActivitiesForSite(params);
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

