/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.clipboard;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.DmContentProcessor;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.clipboard.ClipboardService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentItemIdGenerator;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.DmRenameService;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.DmPasteItemTO;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.PathMacrosTransaltor;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ClipboardServiceImpl
extends AbstractRegistrableService
implements ClipboardService {
    protected static final Logger logger = LoggerFactory.getLogger(ClipboardServiceImpl.class);
    public static final Pattern FILE_PATTERN = Pattern.compile("(.+)-([0-9]+)\\.(.+)");
    public static final Pattern FOLDER_PATTERN = Pattern.compile("(.+)-([0-9]+)");
    protected DmContentProcessor writeProcessor;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected ObjectStateService objectStateService;
    protected DmRenameService dmRenameService;
    protected SecurityService securityService;
    protected ContentTypeService contentTypeService;
    protected ContentItemIdGenerator contentItemIdGenerator;
    protected DmDependencyService dmDependencyService;

    @Override
    public void register() {
        this.getServicesManager().registerService(ClipboardService.class, this);
    }

    @Override
    public List<String> paste(String site, List<Map<String, String>> pasteItems, String destination, boolean cut) throws ServiceException {
        if (cut) {
            return this.cutPaste(site, pasteItems, destination);
        }
        return this.copyPaste(site, pasteItems, destination);
    }

    @Override
    public String duplicate(String site, String path, String source) throws ServiceException {
        return this._duplicate(site, path, false, source);
    }

    protected String _duplicate(String site, String path, boolean toDraft, String source) throws ServiceException {
        block5: {
            boolean contentAsFolder;
            String user = this.securityService.getCurrentUser();
            String fullPath = this.contentService.expandRelativeSitePath(site, path);
            ContentItemTO item = this.contentService.getContentItem(site, path);
            if (item == null) break block5;
            ContentTypeConfigTO config = this.getContentTypeConfig(site, path);
            boolean bl = contentAsFolder = config != null ? config.isContentAsFolder() : false;
            if (!contentAsFolder && path.endsWith("index.xml")) {
                contentAsFolder = true;
            }
            String namePath = path;
            if (contentAsFolder && path.endsWith("index.xml")) {
                namePath = namePath.replace("/index.xml", "");
            }
            String name = this.contentService.getNextAvailableName(site, namePath);
            InputStream content = this.getDuplicatedContent(site, user, source, name, contentAsFolder);
            String fileName = contentAsFolder ? "index.xml" : name;
            String newPath = namePath.substring(0, namePath.lastIndexOf("/"));
            newPath = contentAsFolder ? newPath + "/" + name : newPath;
            String destPath = this.contentService.expandRelativeSitePath(site, newPath);
            String copiedPath = this.copy(site, user, null, path, newPath, fileName, content, toDraft, DmContentLifeCycleService.ContentLifeCycleOperation.DUPLICATE);
            ContentItemTO itemTo = this.contentService.getContentItem(site, newPath + "/" + fileName);
            this.objectStateService.insertNewEntry(site, newPath + "/" + fileName);
            String string = newPath + "/" + fileName;
            return string;
        }
        throw new ContentNotFoundException(path + " does not exist.");
    }

    protected String copy(String site, String user, SourcePageInfo sourcePageInfo, String path, String destination, String destinationFileName, InputStream content, boolean isDraft, DmContentLifeCycleService.ContentLifeCycleOperation writeOperation) throws ServiceException {
        if (sourcePageInfo == null) {
            sourcePageInfo = new SourcePageInfo(path);
        }
        String relativePath = this.contentService.getRelativeSitePath(site, path);
        ContentTypeConfigTO config = this.getContentTypeConfig(site, relativePath);
        if (content == null) {
            content = this.contentService.getContent(site, relativePath);
        }
        if (relativePath.endsWith(".xml")) {
            if (sourcePageInfo.getParams() == null) {
                Map<String, String> params = this.contentItemIdGenerator.getIds();
                sourcePageInfo.setParams(params);
            }
            Map<String, String> dependencies = this.copyDependencies(site, user, sourcePageInfo, path, isDraft);
            content = this.updateContent(site, relativePath, content, sourcePageInfo.getParams(), dependencies);
        }
        String contentType = config == null ? null : config.getName();
        String fileName = StringUtils.isEmpty((String)destinationFileName) ? ContentUtils.getPageName(path) : destinationFileName;
        this.writeContent(site, destination, fileName, user, content, contentType, false, writeOperation);
        return destination + "/" + fileName;
    }

    protected void writeContent(String site, String path, String fileName, String user, InputStream content, String contentType, boolean edit, DmContentLifeCycleService.ContentLifeCycleOperation writeOperation) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("fileName", fileName);
        params.put("user", user);
        params.put("contentType", contentType);
        params.put("createFolders", "true");
        params.put("edit", Boolean.valueOf(edit).toString());
        params.put("activityType", "false");
        params.put("skipCleanPreview", "true");
        params.put("copiedContent", "true");
        params.put("contentLifecycleOperation", writeOperation.toString());
        String id = site + ":" + path + ":" + fileName + ":" + contentType;
        if (!StringUtils.isEmpty((String)contentType)) {
            this.contentService.processContent(id, content, true, params, "formContent");
        } else if (fileName.endsWith(".xml")) {
            this.contentService.processContent(id, content, true, params, "formContent");
        } else {
            this.contentService.processContent(id, content, false, params, "assetContent");
        }
    }

    protected Map<String, String> copyDependencies(String site, String user, SourcePageInfo sourcePageInfo, String dependencyPath, boolean isPreview) throws ServiceException {
        Map<String, String> copyDependencies = this.dmDependencyService.getCopyDependencies(site, sourcePageInfo.getPath(), dependencyPath);
        HashMap<String, String> copiedDependenices = new HashMap<String, String>();
        for (String path : copyDependencies.keySet()) {
            String target = copyDependencies.get(path);
            String destinationPath = PathMacrosTransaltor.resolvePath(target, sourcePageInfo.getParams());
            String destinationFullPath = this.contentService.expandRelativeSitePath(site, destinationPath);
            String srcFullPath = this.contentService.expandRelativeSitePath(site, path);
            String copiedPath = this.copy(site, user, sourcePageInfo, path, destinationPath, null, null, isPreview, DmContentLifeCycleService.ContentLifeCycleOperation.COPY);
            copiedDependenices.put(path, copiedPath);
        }
        return copiedDependenices;
    }

    protected InputStream updateContent(String site, String path, InputStream is, Map<String, String> params, Map<String, String> dependencies) throws ServiceException {
        if (path.endsWith(".xml")) {
            Document document;
            try {
                document = ContentUtils.convertStreamToXml(is);
            }
            catch (DocumentException e) {
                throw new ServiceException("Error while updating content", (Exception)((Object)e));
            }
            if (document != null) {
                Element root = document.getRootElement();
                Node pageIdNode = root.selectSingleNode("//objectId");
                if (pageIdNode != null) {
                    ((Element)pageIdNode).setText(params.get("pageId"));
                }
                Node groupIdNode = root.selectSingleNode("//objectGroupId");
                if (pageIdNode != null) {
                    ((Element)groupIdNode).setText(params.get("pageGroupId"));
                }
                is = this.dmDependencyService.replaceDependencies(site, document, dependencies);
            }
        }
        return is;
    }

    protected InputStream getDuplicatedContent(String site, String user, String path, String name, boolean contentAsFolder) throws ContentNotFoundException {
        if (path.endsWith(".xml")) {
            Document document = null;
            try {
                document = this.contentService.getContentAsDocument(this.contentService.expandRelativeSitePath(site, path));
            }
            catch (DocumentException e) {
                logger.error("Error getting xml document for following path: " + this.contentService.expandRelativeSitePath(site, path), new Object[0]);
            }
            if (document != null) {
                Pattern pattern = contentAsFolder ? FOLDER_PATTERN : FILE_PATTERN;
                Matcher m = pattern.matcher(name);
                if (m.matches()) {
                    Node modifiedDateNode;
                    Node modifierNode;
                    Node fileNameNode;
                    String number = m.group(2);
                    Element root = document.getRootElement();
                    Node nameNode = root.selectSingleNode("//internal-name");
                    if (nameNode != null) {
                        String nameValue = nameNode.getText();
                        ((Element)nameNode).setText(nameValue + " " + number);
                    }
                    if ((fileNameNode = root.selectSingleNode("//file-name")) != null) {
                        String fileName = contentAsFolder ? "index.xml" : name;
                        ((Element)fileNameNode).setText(fileName);
                    }
                    if ((modifierNode = root.selectSingleNode("//lastModifiedBy")) != null) {
                        ((Element)modifierNode).setText(user);
                    }
                    if ((modifiedDateNode = root.selectSingleNode("//lastModifiedDate")) != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                        String date = ContentFormatUtils.formatDate(format, new Date());
                        String formDate = ContentFormatUtils.convertToFormDate(date);
                        ((Element)modifiedDateNode).setText(formDate);
                    }
                }
                return ContentUtils.convertDocumentToStream(document, "UTF-8");
            }
            return null;
        }
        return this.contentService.getContent(site, path);
    }

    protected ContentTypeConfigTO getContentTypeConfig(String site, String path) {
        try {
            return this.contentTypeService.getContentTypeByRelativePath(site, path);
        }
        catch (ServiceException e) {
            logger.warn("No content type found for " + path, new Object[0]);
            return null;
        }
    }

    protected List<String> cutPaste(String site, List<Map<String, String>> pasteItems, String destination) throws ServiceException {
        for (Map<String, String> pasteItem : pasteItems) {
            String path = pasteItem.get("uri");
            path = FilenameUtils.normalize((String)path);
            String fullPath = this.contentService.expandRelativeSitePath(site, path);
            this.objectStateService.setSystemProcessing(site, path, true);
            String destinationUri = destination;
            if (destination.endsWith("index.xml")) {
                destinationUri = ContentUtils.getParentUrl(destinationUri);
            }
            if (this.contentService.contentExists(site, destinationUri = destinationUri + "/" + ContentUtils.getPageName(path.replace("/index.xml", "")))) {
                throw new ServiceException("Content already exists [" + site + ":" + destinationUri + "]");
            }
            this.dmRenameService.rename(site, path, destinationUri, false);
            this.updateFileWithNewNavOrder(site, destinationUri);
            ContentItemTO itemTO = this.contentService.getContentItem(destinationUri);
            this.objectStateService.transition(site, itemTO, TransitionEvent.SAVE);
            this.objectStateService.setSystemProcessing(site, destinationUri, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileWithNewNavOrder(String site, String path) {
        if (!path.endsWith(".xml")) {
            path = path + "/" + "index.xml";
        }
        String user = this.securityService.getCurrentUser();
        try {
            ContentItemTO item = this.contentService.getContentItem(site, path);
            if (item != null) {
                Document document = this.contentService.getContentAsDocument(this.contentService.expandRelativeSitePath(site, path));
                DmPageNavigationOrderService dmPageNavigationOrderService = this.getService(DmPageNavigationOrderService.class);
                dmPageNavigationOrderService.addNavOrder(site, path, document);
                InputStream content = ContentUtils.convertDocumentToStream(document, "UTF-8");
                this.updateFileDirect(site, path, content);
            }
        }
        catch (Exception e) {
            logger.warn("Error while update file with new Nav order " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileDirect(String site, String relativePath, InputStream input) {
        try {
            this.contentService.writeContent(site, relativePath, input);
        }
        finally {
            ContentUtils.release(input);
        }
    }

    protected List<String> copyPaste(String site, List<Map<String, String>> pasteItems, String destination) throws ServiceException {
        String user = this.securityService.getCurrentUser();
        ArrayList<String> copiedItems = new ArrayList<String>();
        if (pasteItems != null && pasteItems.size() > 0) {
            String destFullpath = this.contentService.expandRelativeSitePath(site, destination);
            ContentItemTO destItem = this.contentService.getContentItem(site, destination);
            if (destItem == null) {
                throw new ServiceException("Error while pasting content. " + destination + " does not exist.");
            }
            String destNodePath = destFullpath;
            if (!destItem.isFolder()) {
                if (destItem.getName().equals("index.xml")) {
                    destNodePath = destItem.getPath();
                } else {
                    String folderPath = this.writeProcessor.fileToFolder(site, destNodePath);
                    destItem = this.contentService.getContentItem(site, folderPath);
                    destNodePath = folderPath;
                }
            } else if (destItem.isPage() && destItem.getName().equals("index.xml")) {
                destNodePath = destItem.getPath();
            }
            for (Map<String, String> pasteItem : pasteItems) {
                DmPasteItemTO dmPasteItem = new DmPasteItemTO();
                String pasteItemUri = pasteItem.get("uri");
                dmPasteItem.setUri(pasteItemUri);
                dmPasteItem.setDeep(Boolean.parseBoolean(pasteItem.get("deep")));
                if (this.hasSameChild(pasteItemUri, destItem, site)) {
                    this.duplicateContent(site, destination, user, destItem, pasteItemUri);
                    continue;
                }
                this.copyContent(site, user, dmPasteItem, destNodePath, copiedItems);
            }
        }
        return copiedItems;
    }

    protected void copyContent(String site, String user, DmPasteItemTO pasteItem, String destination, List<String> copiedItems) throws ServiceException {
        String path = pasteItem.getUri();
        boolean deep = true;
        String fullPath = this.contentService.expandRelativeSitePath(site, path);
        try {
            ContentItemTO contentItem = this.contentService.getContentItemTree(site, path, 1);
            if (contentItem == null) {
                throw new ServiceException("Error while pasting content. " + path + " does not exist.");
            }
            String nodePath = fullPath;
            if (contentItem.isFolder()) {
                this.copyChildren(site, user, path, contentItem, destination + contentItem.getName(), pasteItem, deep, true, copiedItems);
                if (contentItem.getChildren() == null || contentItem.getChildren().size() == 0) {
                    ContentItemTO destinationParentItem = this.contentService.getContentItem(site, destination);
                    this.contentService.copyContent(site, path, destination);
                }
            } else if (contentItem.getName().equals("index.xml")) {
                String folderPath = contentItem.getPath();
                if (folderPath.endsWith("/")) {
                    folderPath = folderPath.substring(0, folderPath.length() - 1);
                }
                String folderName = folderPath.substring(folderPath.lastIndexOf("/") + 1);
                path = path.replace("/index.xml", "");
                this.copyChildren(site, user, path, contentItem, destination + "/" + folderName, pasteItem, deep, false, copiedItems);
                String copiedPath = this.copy(site, user, null, contentItem.getUri(), destination + "/" + folderName, null, null, false, DmContentLifeCycleService.ContentLifeCycleOperation.COPY);
                this.objectStateService.insertNewEntry(site, copiedPath);
                copiedItems.add(copiedPath);
            } else {
                String copiedPath = this.copy(site, user, null, nodePath, destination, null, null, false, DmContentLifeCycleService.ContentLifeCycleOperation.COPY);
                this.objectStateService.insertNewEntry(site, copiedPath);
                copiedItems.add(copiedPath);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Error while pasting " + path, e);
        }
    }

    protected void copyChildren(String site, String user, String parentPath, ContentItemTO parentContentItem, String destination, DmPasteItemTO parentItem, boolean deep, boolean copyIndex, List<String> copiedItems) throws ServiceException {
        if (deep) {
            ContentItemTO parentItemTree = this.contentService.getContentItemTree(site, parentContentItem.getUri(), 1);
            ContentItemTO indexDescp = null;
            for (ContentItemTO child : parentItemTree.getChildren()) {
                if (child.getName().equals("index.xml")) {
                    indexDescp = child;
                    continue;
                }
                if (!copyIndex && child.getName().equals("index.xml")) continue;
                this.copyItem(site, user, parentPath, destination, deep, copiedItems, child);
            }
            if (copyIndex && indexDescp != null) {
                this.copyItem(site, user, parentPath, destination, deep, copiedItems, indexDescp);
            }
        } else if (parentContentItem.getChildren() != null && parentContentItem.getChildren().size() > 0) {
            for (DmPasteItemTO childPasteItem : parentItem.getChildren()) {
                this.copyContent(site, user, childPasteItem, destination, copiedItems);
            }
        }
    }

    protected void copyItem(String site, String user, String parentPath, String destination, boolean deep, List<String> copiedItems, ContentItemTO childItem) throws ServiceException {
        DmPasteItemTO childPasteItem = new DmPasteItemTO();
        String childUri = parentPath + "/" + childItem.getName();
        childPasteItem.setUri(childUri);
        childPasteItem.setDeep(deep);
        this.copyContent(site, user, childPasteItem, destination, copiedItems);
    }

    protected boolean hasSameChild(String srcPath, ContentItemTO destination, String site) {
        String originalDirectory = ContentUtils.getParentUrl(srcPath);
        ContentItemTO itemTree = this.contentService.getContentItemTree(site, destination.getUri(), 1);
        String originalDirectoryFullPath = this.contentService.expandRelativeSitePath(site, originalDirectory);
        String srcFullPath = this.contentService.expandRelativeSitePath(site, srcPath);
        if (!srcPath.endsWith("index.xml")) {
            originalDirectoryFullPath = srcFullPath;
        }
        for (ContentItemTO child : itemTree.getChildren()) {
            if (!originalDirectoryFullPath.endsWith("/" + child.getName())) continue;
            return true;
        }
        return false;
    }

    protected void duplicateContent(String site, String destination, String user, ContentItemTO destItem, String pasteItem) throws ServiceException {
        String srcFullPath = this.contentService.expandRelativeSitePath(site, pasteItem);
        ContentItemTO srcItem = this.contentService.getContentItem(site, pasteItem);
        String destNodePath = this.contentService.expandRelativeSitePath(site, destItem.getUri());
        String destRelLoc = this.getDestPath(site, destItem.getUri(), pasteItem, srcItem);
        String newPath = this.duplicate(site, destRelLoc, pasteItem);
    }

    protected String getDestPath(String site, String destination, String pasteItem, ContentItemTO srcItem) {
        String srcNodePath = this.contentService.expandRelativeSitePath(site, pasteItem);
        String destRelLoc = destination + '/' + srcItem.getName();
        if (srcItem.getName().equals("index.xml")) {
            srcItem = this.contentService.getContentItem(srcNodePath.replace("/" + srcItem.getName(), ""));
            destRelLoc = destination + "/" + srcItem.getName() + "/" + "index.xml";
        }
        return destRelLoc;
    }

    public DmContentProcessor getWriteProcessor() {
        return this.writeProcessor;
    }

    public void setWriteProcessor(DmContentProcessor writeProcessor) {
        this.writeProcessor = writeProcessor;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmRenameService getDmRenameService() {
        return this.dmRenameService;
    }

    public void setDmRenameService(DmRenameService dmRenameService) {
        this.dmRenameService = dmRenameService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public ContentItemIdGenerator getContentItemIdGenerator() {
        return this.contentItemIdGenerator;
    }

    public void setContentItemIdGenerator(ContentItemIdGenerator contentItemIdGenerator) {
        this.contentItemIdGenerator = contentItemIdGenerator;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public class SourcePageInfo {
        protected String path;
        protected Map<String, String> params;

        public SourcePageInfo(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }
    }
}

