/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.ContentTypePathTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.to.SiteContentTypePathsTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ContentTypesConfigImpl
extends ConfigurableServiceBase
implements ContentTypesConfig {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypesConfigImpl.class);
    protected Map<String, ContentTypeConfigTO> contentTypeMap = new HashMap<String, ContentTypeConfigTO>();
    protected Map<String, SiteContentTypePathsTO> pathMapping = new HashMap<String, SiteContentTypePathsTO>();
    protected Map<String, String> contentTypeNodeMap = new HashMap<String, String>();
    protected ContentService contentService;

    @Override
    public ContentTypeConfigTO getContentTypeConfig(String site, String contentType) {
        String key = this.createKey(site, contentType);
        return this.contentTypeMap.get(key);
    }

    protected String createKey(String site, String contentType) {
        return site + "," + contentType;
    }

    @Override
    protected void loadConfiguration(String key) {
        String configFileFullPath = null;
        if (!StringUtils.isEmpty((String)key)) {
            String[] keys = key.split(",");
            if (keys.length == 2) {
                String site = keys[0];
                String contentType = keys[1];
                String siteConfigPath = this.configPath.replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
                configFileFullPath = siteConfigPath + "/" + this.configFileName;
            } else {
                logger.error("Invalid content type config key provided: " + key + " site, content type is expected.", new Object[0]);
            }
        } else {
            logger.error("Key cannot be empty. site, content type is expected.", new Object[0]);
        }
        if (configFileFullPath != null) {
            ContentTypeConfigTO contentTypeConfig = this.loadConfigurationFile(configFileFullPath);
            this.addContentType(key, contentTypeConfig);
        }
    }

    protected ContentTypeConfigTO loadConfigurationFile(String configFileFullPath) {
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(configFileFullPath);
        }
        catch (DocumentException e) {
            logger.error("No content type configuration document found at " + configFileFullPath, (Exception)((Object)e), new Object[0]);
        }
        if (document != null) {
            Element root = document.getRootElement();
            String name = root.valueOf("@name");
            ContentTypeConfigTO contentTypeConfig = new ContentTypeConfigTO();
            contentTypeConfig.setName(name);
            contentTypeConfig.setLabel(root.valueOf("label"));
            String imageThumbnail = root.valueOf("image-thumbnail");
            if (imageThumbnail != null) {
                contentTypeConfig.setImageThumbnail(imageThumbnail);
            }
            contentTypeConfig.setForm(root.valueOf("form"));
            boolean previewable = ContentFormatUtils.getBooleanValue(root.valueOf("previewable"));
            contentTypeConfig.setFormPath(root.valueOf("form-path"));
            contentTypeConfig.setPreviewable(previewable);
            contentTypeConfig.setModelInstancePath(root.valueOf("model-instance-path"));
            boolean contentAsFolder = ContentFormatUtils.getBooleanValue(root.valueOf("content-as-folder"));
            contentTypeConfig.setContentAsFolder(contentAsFolder);
            boolean useRoundedFolder = ContentFormatUtils.getBooleanValue(root.valueOf("use-rounded-folder"));
            contentTypeConfig.setUseRoundedFolder(useRoundedFolder);
            List<String> pathIncludes = this.getPaths(root, "paths/includes/pattern");
            if (pathIncludes.size() == 0) {
                pathIncludes.add(".*");
            }
            contentTypeConfig.setPathIncludes(pathIncludes);
            List<String> pathExcludes = this.getPaths(root, "paths/excludes/pattern");
            contentTypeConfig.setPathExcludes(pathExcludes);
            this.loadRoles(contentTypeConfig, root.selectNodes("allowed-roles/role"));
            this.loadDeleteDependencies(contentTypeConfig, root.selectNodes("delete-dependencies/delete-dependency"));
            this.loadCopyDependencyPatterns(contentTypeConfig, root.selectNodes("copy-dependencies/copy-dependency"));
            contentTypeConfig.setLastUpdated(new Date());
            contentTypeConfig.setType(this.getContentTypeTypeByName(name));
            return contentTypeConfig;
        }
        logger.error("No content type configuration document found at " + configFileFullPath, new Object[0]);
        return null;
    }

    protected void loadDeleteDependencies(ContentTypeConfigTO contentTypeConfig, List<Node> nodes) {
        ArrayList<DeleteDependencyConfigTO> deleteConfigs = new ArrayList<DeleteDependencyConfigTO>();
        if (nodes != null) {
            for (Node node : nodes) {
                Node patternNode = node.selectSingleNode("pattern");
                Node removeFolderNode = node.selectSingleNode("remove-empty-folder");
                if (patternNode == null) continue;
                String pattern = patternNode.getText();
                String removeEmptyFolder = removeFolderNode.getText();
                boolean isRemoveEmptyFolder = false;
                if (removeEmptyFolder != null) {
                    isRemoveEmptyFolder = Boolean.valueOf(removeEmptyFolder);
                }
                if (!StringUtils.isNotEmpty((String)pattern)) continue;
                DeleteDependencyConfigTO deleteConfigTO = new DeleteDependencyConfigTO(pattern, isRemoveEmptyFolder);
                deleteConfigs.add(deleteConfigTO);
            }
            contentTypeConfig.setDeleteDependencies(deleteConfigs);
        }
    }

    private String getContentTypeTypeByName(String name) {
        if (Pattern.matches("/component/.*?", name)) {
            return "component";
        }
        if (Pattern.matches("/page/.*?", name)) {
            return "page";
        }
        return "unknown";
    }

    private List<String> getPaths(Element root, String path) {
        ArrayList<String> paths = null;
        List nodes = root.selectNodes(path);
        if (nodes != null && nodes.size() > 0) {
            paths = new ArrayList(nodes.size());
            for (Node node : nodes) {
                String role = node.getText();
                if (StringUtils.isEmpty((String)role)) continue;
                paths.add(role);
            }
        } else {
            paths = new ArrayList<String>();
        }
        return paths;
    }

    protected void loadRoles(ContentTypeConfigTO config, List<Node> nodes) {
        HashSet<String> roles = null;
        if (nodes != null && nodes.size() > 0) {
            roles = new HashSet(nodes.size());
            for (Node node : nodes) {
                String role = node.getText();
                if (StringUtils.isEmpty((String)role)) continue;
                roles.add(role);
            }
        } else {
            roles = new HashSet<String>();
        }
        config.setAllowedRoles(roles);
    }

    protected void addContentType(String key, ContentTypeConfigTO contentTypeConfig) {
        if (!StringUtils.isEmpty((String)key) && contentTypeConfig != null) {
            if (this.contentTypeMap.get(key) != null) {
                this.removeConfiguration(key);
            }
            this.contentTypeMap.put(key, contentTypeConfig);
            this.addToPathMapping(key, contentTypeConfig);
        }
    }

    protected void addToPathMapping(String key, ContentTypeConfigTO configToAdd) {
        logger.debug("Adding a path configuration to mapping with key: " + key, new Object[0]);
        String[] values = key.split(",");
        String site = values[0];
        SiteContentTypePathsTO paths = this.pathMapping.get(site);
        if (paths != null) {
            boolean added = false;
            for (String pathInclude : configToAdd.getPathIncludes()) {
                for (ContentTypePathTO pathTO : paths.getConfigs()) {
                    if (!pathTO.getPathInclude().equalsIgnoreCase(pathInclude)) continue;
                    logger.debug("Adding " + key + " to " + pathInclude, new Object[0]);
                    pathTO.addToAllowedContentTypes(key);
                    added = true;
                }
                if (added) continue;
                logger.debug("Creating a new include for " + key + " with " + pathInclude, new Object[0]);
                ContentTypePathTO pathTO = this.createNewPathConfig(pathInclude, key, configToAdd);
                paths.getConfigs().add(pathTO);
            }
            paths.setLastUpdated(new Date());
        } else {
            logger.debug("No configuration exists. adding a new record.", new Object[0]);
            SiteContentTypePathsTO newPaths = new SiteContentTypePathsTO();
            List<String> pathIncludes = configToAdd.getPathIncludes();
            ArrayList<ContentTypePathTO> configs = new ArrayList<ContentTypePathTO>();
            for (String pathInclude : pathIncludes) {
                ContentTypePathTO pathTO = this.createNewPathConfig(pathInclude, key, configToAdd);
                configs.add(pathTO);
            }
            newPaths.setConfigs(configs);
            newPaths.setLastUpdated(new Date());
            this.pathMapping.put(site, newPaths);
        }
    }

    private ContentTypePathTO createNewPathConfig(String pathInclude, String key, ContentTypeConfigTO config) {
        ContentTypePathTO pathTO = new ContentTypePathTO();
        pathTO.setPathInclude(pathInclude);
        pathTO.addToAllowedContentTypes(key);
        return pathTO;
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.contentTypeMap.get(key);
    }

    @Override
    protected void removeConfiguration(String key) {
        ContentTypeConfigTO contentTypeConfig;
        if (!StringUtils.isEmpty((String)key) && (contentTypeConfig = this.contentTypeMap.get(key)) != null) {
            this.contentTypeMap.remove(key);
            this.removeFromPathMapping(key, contentTypeConfig);
        }
    }

    protected void removeFromPathMapping(String key, ContentTypeConfigTO configToRemove) {
        String[] values = key.split(",");
        String site = values[0];
        SiteContentTypePathsTO paths = this.pathMapping.get(site);
        if (paths != null) {
            for (String pathInclude : configToRemove.getPathIncludes()) {
                for (ContentTypePathTO pathTO : paths.getConfigs()) {
                    if (!pathTO.getPathInclude().equalsIgnoreCase(pathInclude)) continue;
                    pathTO.removeAllowedContentTypes(key);
                }
            }
            paths.setLastUpdated(new Date());
        }
    }

    protected void loadCopyDependencyPatterns(ContentTypeConfigTO config, List<Node> copyDependencyNodes) {
        ArrayList<CopyDependencyConfigTO> copyConfig = new ArrayList<CopyDependencyConfigTO>();
        if (copyDependencyNodes != null) {
            for (Node copyDependency : copyDependencyNodes) {
                Node patternNode = copyDependency.selectSingleNode("pattern");
                Node targetNode = copyDependency.selectSingleNode("target");
                if (patternNode == null || targetNode == null) continue;
                String pattern = patternNode.getText();
                String target = targetNode.getText();
                if (!StringUtils.isNotEmpty((String)pattern) || !StringUtils.isNotEmpty((String)target)) continue;
                CopyDependencyConfigTO copyDependencyConfigTO = new CopyDependencyConfigTO(pattern, target);
                copyConfig.add(copyDependencyConfigTO);
            }
        }
        config.setCopyDepedencyPattern(copyConfig);
    }

    @Override
    public ContentTypeConfigTO loadConfiguration(String site, String configPath) {
        Date modifiedDate;
        ContentTypeConfigTO contentTypeConfig;
        String key = this.contentTypeNodeMap.get(site + "," + ContentUtils.getParentUrl(configPath));
        if (!StringUtils.isEmpty((String)key) && (contentTypeConfig = this.contentTypeMap.get(key)) != null && !(modifiedDate = this.contentRepository.getModifiedDate(this.contentService.expandRelativeSitePath(site, configPath))).after(contentTypeConfig.getLastUpdated())) {
            logger.debug("Skipping loading " + key + " since it is previsouly loaded and no change was made.", new Object[0]);
            return contentTypeConfig;
        }
        logger.debug("Loading configuration from " + key + " since it is not loaded or configuration file is updated.", new Object[0]);
        return this.reloadConfiguration(site, configPath);
    }

    @Override
    public ContentTypeConfigTO reloadConfiguration(String site, String configPath) {
        String key = this.contentTypeNodeMap.get(site + "," + ContentUtils.getParentUrl(configPath));
        logger.debug("Loading configuration from " + key + " since it is not loaded or configuration file is updated.", new Object[0]);
        ContentTypeConfigTO contentTypeConfig = this.loadConfigurationFile(configPath);
        key = this.createKey(site, contentTypeConfig.getName());
        this.addContentType(key, contentTypeConfig);
        return contentTypeConfig;
    }

    @Override
    public SiteContentTypePathsTO getPathMapping(String site) {
        return this.pathMapping.get(site);
    }

    @Override
    public ContentTypeConfigTO getContentTypeConfig(String key) {
        return this.contentTypeMap.get(key);
    }

    @Override
    protected String getConfigFullPath(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            String[] keys = key.split(",");
            if (keys.length == 2) {
                String site = keys[0];
                String contentType = keys[1];
                String siteConfigPath = this.configPath.replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
                String siteConfigFullPath = siteConfigPath + "/" + this.configFileName;
                return siteConfigFullPath;
            }
            logger.error("Invalid content type config key provided: " + key + " site, content type is expected.", new Object[0]);
        } else {
            logger.error("Key cannot be empty. site, content type is expected.", new Object[0]);
        }
        return null;
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(ContentTypesConfig.class, this);
    }

    public Map<String, SiteContentTypePathsTO> getPathMapping() {
        return this.pathMapping;
    }

    public void setPathMapping(Map<String, SiteContentTypePathsTO> pathMapping) {
        this.pathMapping = pathMapping;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

