/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.configuration.DeploymentEndpointConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.DeploymentConfigTO;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DeploymentEndpointConfigImpl
extends ConfigurableServiceBase
implements DeploymentEndpointConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentEndpointConfigImpl.class);
    protected Map<String, DeploymentConfigTO> siteMapping = new HashMap<String, DeploymentConfigTO>();
    protected ContentService contentService;

    @Override
    protected void loadConfiguration(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", key);
        siteConfigPath = siteConfigPath + "/" + this.configFileName;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(siteConfigPath);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document != null) {
            Element root = document.getRootElement();
            DeploymentConfigTO config = new DeploymentConfigTO();
            List endpoints = root.selectNodes("endpoint");
            for (Element endpointElm : endpoints) {
                DeploymentEndpointConfigTO endpointConfig = new DeploymentEndpointConfigTO();
                String name = endpointElm.valueOf("name");
                endpointConfig.setName(name);
                String type = endpointElm.valueOf("type");
                endpointConfig.setType(type);
                String serverUrl = endpointElm.valueOf("server-url");
                endpointConfig.setServerUrl(serverUrl);
                String versionUrl = endpointElm.valueOf("version-url");
                endpointConfig.setVersionUrl(versionUrl);
                String password = endpointElm.valueOf("password");
                endpointConfig.setPassword(password);
                String target = endpointElm.valueOf("target");
                endpointConfig.setTarget(target);
                String siteId = endpointElm.valueOf("site-id");
                endpointConfig.setSiteId(siteId);
                String sendMetadataStr = endpointElm.valueOf("send-metadata");
                boolean sendMetadataVal = StringUtils.isNotEmpty((String)sendMetadataStr) && Boolean.parseBoolean(sendMetadataStr);
                endpointConfig.setSendMetadata(sendMetadataVal);
                List excludePatternElms = endpointElm.selectNodes("exclude/pattern");
                ArrayList<String> excludePatternStrs = new ArrayList<String>();
                for (Element patternElem : excludePatternElms) {
                    excludePatternStrs.add(patternElem.getText());
                }
                endpointConfig.setExcludePattern(excludePatternStrs);
                List includePatternElms = endpointElm.selectNodes("include/pattern");
                ArrayList<String> includePatternStrs = new ArrayList<String>();
                for (Element patternElem : includePatternElms) {
                    includePatternStrs.add(patternElem.getText());
                }
                endpointConfig.setIncludePattern(includePatternStrs);
                String bucketSizeStr = endpointElm.valueOf("bucket-size");
                if (StringUtils.isNotEmpty((String)bucketSizeStr)) {
                    try {
                        int bucketSizeVal = Integer.parseInt(bucketSizeStr);
                        endpointConfig.setBucketSize(bucketSizeVal);
                    }
                    catch (NumberFormatException exc) {
                        LOGGER.info(String.format("Illegal number format for buckets size in deployment endpoint %s config [path: %s]", name, siteConfigPath), new Object[0]);
                        LOGGER.info(String.format("Default bucket size %d will be used for endpoint [%s]", endpointConfig.getBucketSize(), name), new Object[0]);
                    }
                } else {
                    LOGGER.info(String.format("Buckets size not defined in deployment endpoint (%s) config [path: %s]", name, siteConfigPath), new Object[0]);
                    LOGGER.info(String.format("Default bucket size (%d) will be used for endpoint [%s]", endpointConfig.getBucketSize(), name), new Object[0]);
                }
                String statusUrl = endpointElm.valueOf("status-url");
                endpointConfig.setStatusUrl(statusUrl);
                config.addEndpoint(endpointConfig);
            }
            config.setLastUpdated(new Date());
            this.siteMapping.put(key, config);
        }
    }

    @Override
    protected String getConfigFullPath(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", key);
        return siteConfigPath + "/" + this.configFileName;
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.siteMapping.get(key);
    }

    @Override
    protected void removeConfiguration(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            this.siteMapping.remove(key);
        }
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(DeploymentEndpointConfig.class, this);
    }

    @Override
    public DeploymentEndpointConfigTO getDeploymentConfig(String site, String endpoint) {
        DeploymentConfigTO config;
        if (this.siteMapping.containsKey(site) && (config = this.siteMapping.get(site)) != null) {
            return config.getEndpoint(endpoint);
        }
        return null;
    }

    @Override
    public boolean isUpdated(String site) {
        return super.isConfigUpdated(site);
    }

    @Override
    public boolean exists(String site) {
        if (this.siteMapping == null) {
            return false;
        }
        return this.siteMapping.get(site) != null;
    }

    @Override
    public DeploymentConfigTO getSiteDeploymentConfig(String site) {
        return this.siteMapping.get(site);
    }

    @Override
    public void reloadConfiguration(String site) {
        this.loadConfiguration(site);
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

