/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.util.FastList;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DmFolderConfigTO;
import org.craftercms.studio.api.v1.to.RepositoryConfigTO;
import org.craftercms.studio.api.v1.to.SiteConfigTO;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesConfigImpl
extends AbstractRegistrableService
implements ServicesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesConfigImpl.class);
    protected static final String WEM_PROJECTS_PATH = "/wem-projects";
    protected static final String WORK_AREA_PATH = "/work-area";
    protected static final String LIVE_PATH = "/live";
    protected static final String PATH_CONTENT = "content";
    protected static final String PATH_WCM_CONTENT = "wcm-content";
    protected static final String PATH_PROTOTYPE = "prototype";
    protected static final String PATH_TEMPLATE = "template";
    protected static final String PATTERN_PAGE = "page";
    protected static final String PATTERN_COMPONENT = "component";
    protected static final String PATTERN_ASSET = "asset";
    protected static final String PATTERN_DOCUMENT = "document";
    protected static final String PATTERN_RENDERING_TEMPLATE = "rendering-template";
    protected static final String PATTERN_LEVEL_DESCRIPTOR = "level-descriptor";
    protected static final String PATTERN_PREVIEWABLE_MIMETYPES = "previewable-mimetypes";
    protected static final String ELM_PATTERN = "pattern";
    protected static final String ATTR_DEPTH = "@depth";
    protected static final String ATTR_DISPLAY_NAME = "@displayName";
    protected static final String ATTR_NAMESPACE = "@namespace";
    protected static final String ATTR_NAME = "@name";
    protected static final String ATTR_SITE = "@site";
    protected static final String ATTR_PATH = "@path";
    protected static final String ATTR_READ_DIRECT_CHILDREN = "@read-direct-children";
    protected static final String ATTR_ATTACH_ROOT_PREFIX = "@attach-root-prefix";
    protected static final String LIVE_REPOSITORY_PATH_SUFFIX = "-live";
    protected String configPath;
    protected String configFileName;
    protected Map<String, SiteConfigTO> siteMapping = new HashMap<String, SiteConfigTO>();
    protected ContentTypesConfig contentTypesConfig;
    protected ContentService contentService;
    protected ContentRepository contentRepository;

    @Override
    public void register() {
        this._servicesManager.registerService(ServicesConfig.class, this);
    }

    @Override
    public String getWemProject(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getWemProject() != null) {
            return config.getWemProject();
        }
        return null;
    }

    @Override
    public List<DmFolderConfigTO> getFolders(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getFolders();
        }
        return null;
    }

    @Override
    public String getRootPrefix(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getRootPrefix();
        }
        return null;
    }

    @Override
    public ContentTypeConfigTO getContentTypeConfig(String site, String name) {
        return this.contentTypesConfig.getContentTypeConfig(site, name);
    }

    @Override
    public List<String> getAssetPatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getAssetPatterns();
        }
        return null;
    }

    @Override
    public List<DeleteDependencyConfigTO> getDeleteDependencyPatterns(String site, String contentType) {
        if (contentType == null) {
            return Collections.emptyList();
        }
        ContentTypeConfigTO contentTypeConfig = this.contentTypesConfig.getContentTypeConfig(site, contentType);
        if (contentTypeConfig != null) {
            return contentTypeConfig.getDeleteDependencyPattern();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CopyDependencyConfigTO> getCopyDependencyPatterns(String site, String contentType) {
        if (contentType == null) {
            return Collections.emptyList();
        }
        ContentTypeConfigTO contentTypeConfig = this.contentTypesConfig.getContentTypeConfig(site, contentType);
        if (contentTypeConfig != null) {
            return contentTypeConfig.getCopyDepedencyPattern();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getComponentPatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getComponentPatterns();
        }
        return null;
    }

    @Override
    public List<String> getPagePatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getPagePatterns();
        }
        return null;
    }

    @Override
    public List<String> getRenderingTemplatePatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getRenderingTemplatePatterns();
        }
        return null;
    }

    @Override
    public List<String> getLevelDescriptorPatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getLevelDescriptorPatterns();
        }
        return null;
    }

    @Override
    public List<String> getDocumentPatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getDocumentPatterns();
        }
        return null;
    }

    @Override
    public String getLevelDescriptorName(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getLevelDescriptorName();
        }
        return null;
    }

    @Override
    public List<String> getDisplayInWidgetPathPatterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getDisplayPatterns();
        }
        return null;
    }

    @Override
    public String getDefaultTimezone(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null) {
            return config.getTimezone();
        }
        return null;
    }

    @Override
    public boolean isUpdated(String site) {
        return this.isConfigUpdated(site);
    }

    protected boolean isConfigUpdated(String site) {
        SiteConfigTO config = this.siteMapping.get(site);
        if (config == null) {
            return true;
        }
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", site);
        String siteConfigFullPath = siteConfigPath + "/" + this.configFileName;
        if (this.contentRepository.contentExists(siteConfigFullPath)) {
            Date modifiedDate = this.contentRepository.getModifiedDate(siteConfigFullPath);
            if (modifiedDate == null) {
                return false;
            }
            return modifiedDate.after(config.getLastUpdated());
        }
        if (!this.contentRepository.contentExists(siteConfigPath)) {
            this.siteMapping.remove(site);
        }
        return true;
    }

    protected void loadConfiguration(String site) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", site);
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(siteConfigPath + "/" + this.configFileName);
        }
        catch (DocumentException e) {
            LOGGER.error("Error while loading configuration for " + site + " at " + siteConfigPath, (Throwable)e);
        }
        if (document != null) {
            Element root = document.getRootElement();
            Node configNode = root.selectSingleNode("/site-config");
            String name = configNode.valueOf("display-name");
            SiteConfigTO siteConfig = new SiteConfigTO();
            siteConfig.setName(name);
            siteConfig.setWemProject(configNode.valueOf("wem-project"));
            siteConfig.setTimezone(configNode.valueOf("default-timezone"));
            this.loadSiteRepositoryConfiguration(siteConfig, configNode.selectSingleNode("repository"));
            siteConfig.setLastUpdated(new Date());
            this.siteMapping.put(site, siteConfig);
        } else {
            LOGGER.error("No site configuration found for " + site + " at " + siteConfigPath);
        }
    }

    protected void loadSiteRepositoryConfiguration(SiteConfigTO siteConfig, Node node) {
        RepositoryConfigTO repoConfigTO = new RepositoryConfigTO();
        repoConfigTO.setRootPrefix(node.valueOf("@rootPrefix"));
        repoConfigTO.setLevelDescriptorName(node.valueOf(PATTERN_LEVEL_DESCRIPTOR));
        this.loadFolderConfiguration(siteConfig, repoConfigTO, node.selectNodes("folders/folder"));
        this.loadPatterns(siteConfig, repoConfigTO, node.selectNodes("patterns/pattern-group"));
        List<String> displayPatterns = this.getStringList(node.selectNodes("display-in-widget-patterns/display-in-widget-pattern"));
        repoConfigTO.setDisplayPatterns(displayPatterns);
        siteConfig.setRepositoryConfig(repoConfigTO);
    }

    protected List<String> getStringList(List<Node> nodes) {
        FastList items = null;
        if (nodes != null && nodes.size() > 0) {
            items = new FastList(nodes.size());
            for (Node node : nodes) {
                items.add(node.getText());
            }
        } else {
            items = new FastList(0);
        }
        return items;
    }

    protected void loadPatterns(SiteConfigTO site, RepositoryConfigTO repo, List<Node> nodes) {
        if (nodes != null) {
            for (Node node : nodes) {
                String patternKey = node.valueOf(ATTR_NAME);
                if (!StringUtils.isEmpty((String)patternKey)) {
                    List patternNodes = node.selectNodes(ELM_PATTERN);
                    if (patternNodes == null) continue;
                    FastList patterns = new FastList(patternNodes.size());
                    for (Node patternNode : patternNodes) {
                        String pattern = patternNode.getText();
                        if (StringUtils.isEmpty((String)pattern)) continue;
                        patterns.add(pattern);
                    }
                    if (patternKey.equals(PATTERN_PAGE)) {
                        repo.setPagePatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_COMPONENT)) {
                        repo.setComponentPatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_ASSET)) {
                        repo.setAssetPatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_DOCUMENT)) {
                        repo.setDocumentPatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_RENDERING_TEMPLATE)) {
                        repo.setRenderingTemplatePatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_LEVEL_DESCRIPTOR)) {
                        repo.setLevelDescriptorPatterns((List<String>)patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_PREVIEWABLE_MIMETYPES)) {
                        repo.setPreviewableMimetypesPaterns((List<String>)patterns);
                        continue;
                    }
                    LOGGER.error("Unknown pattern key: " + patternKey + " is provided in " + site.getName());
                    continue;
                }
                LOGGER.error("no pattern key provided in " + site.getName() + " configuration. Skipping the pattern.");
            }
        } else {
            LOGGER.warn(site.getName() + " does not have any pattern configuration.");
        }
    }

    protected void loadFolderConfiguration(SiteConfigTO site, RepositoryConfigTO repo, List<Node> folderNodes) {
        if (folderNodes != null) {
            FastList folders = new FastList(folderNodes.size());
            for (Node folderNode : folderNodes) {
                DmFolderConfigTO folderConfig = new DmFolderConfigTO();
                folderConfig.setName(folderNode.valueOf(ATTR_NAME));
                folderConfig.setPath(folderNode.valueOf(ATTR_PATH));
                folderConfig.setReadDirectChildren(ContentFormatUtils.getBooleanValue(folderNode.valueOf(ATTR_READ_DIRECT_CHILDREN)));
                folderConfig.setAttachRootPrefix(ContentFormatUtils.getBooleanValue(folderNode.valueOf(ATTR_ATTACH_ROOT_PREFIX)));
                folders.add(folderConfig);
            }
            repo.setFolders((List<DmFolderConfigTO>)folders);
        } else {
            LOGGER.warn(site.getName() + " does not have any folder configuration.");
        }
    }

    @Override
    public Set<String> getAllAvailableSites() {
        Set<String> siteNames = this.siteMapping.keySet();
        return siteNames;
    }

    @Override
    public List<String> getPreviewableMimetypesPaterns(String site) {
        SiteConfigTO config;
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
        if ((config = this.siteMapping.get(site)) != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getPreviewableMimetypesPaterns();
        }
        return null;
    }

    @Override
    public boolean siteExists(String site) {
        if (this.siteMapping == null) {
            return false;
        }
        return this.siteMapping.get(site) != null;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public ContentTypesConfig getContentTypesConfig() {
        return this.contentTypesConfig;
    }

    public void setContentTypesConfig(ContentTypesConfig contentTypesConfig) {
        this.contentTypesConfig = contentTypesConfig;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

