/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.configuration.SiteEnvironmentConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.EnvironmentConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class SiteEnvironmentConfigImpl
extends ConfigurableServiceBase
implements SiteEnvironmentConfig {
    private static final Logger logger = LoggerFactory.getLogger(SiteEnvironmentConfigImpl.class);
    protected Map<String, EnvironmentConfigTO> siteMapping = new HashMap<String, EnvironmentConfigTO>();
    protected String environment;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void register() {
        this._servicesManager.registerService(SiteEnvironmentConfig.class, this);
    }

    @Override
    public EnvironmentConfigTO getEnvironmentConfig(String site) {
        return this.siteMapping.get(site);
    }

    @Override
    public String getPreviewServerUrl(String site) {
        String previewServerUrl;
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null && !StringUtils.isEmpty((String)(previewServerUrl = config.getPreviewServerUrl()))) {
            String sandbox = null;
            String webProject = this.servicesConfig.getWemProject(site);
            return previewServerUrl.replaceAll("\\$\\{webproject\\}", webProject).replaceAll("\\$\\{sandbox\\}", sandbox);
        }
        return "";
    }

    @Override
    public String getLiveServerUrl(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getLiveServerUrl();
        }
        return "";
    }

    @Override
    public String getAdminEmailAddress(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getAdminEmailAddress();
        }
        return "";
    }

    @Override
    public String getAuthoringServerUrl(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getAuthoringServerUrl();
        }
        return "";
    }

    @Override
    public String getFormServerUrl(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getFormServerUrlPattern();
        }
        return "";
    }

    @Override
    public String getCookieDomain(String site) {
        return null;
    }

    @Override
    public boolean isUpdated(String site) {
        return super.isConfigUpdated(site);
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.siteMapping.get(key);
    }

    @Override
    protected void removeConfiguration(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            this.siteMapping.remove(key);
        }
    }

    @Override
    protected void loadConfiguration(String key) {
        String configLocation = this.configPath.replaceFirst("\\{site\\}", key).replaceFirst("\\{environment\\}", this.environment);
        configLocation = configLocation + "/" + this.configFileName;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(configLocation);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document != null) {
            Element root = document.getRootElement();
            EnvironmentConfigTO config = new EnvironmentConfigTO();
            String previewServerUrl = root.valueOf("preview-server-url");
            config.setPreviewServerUrl(previewServerUrl);
            String openDropdown = root.valueOf("open-site-dropdown");
            config.setOpenDropdown(openDropdown != null ? Boolean.valueOf(openDropdown) : false);
            String previewServerUrlPattern = root.valueOf("preview-server-url-pattern");
            config.setPreviewServerUrlPattern(previewServerUrlPattern);
            String orbeonServerUrlPattern = root.valueOf("form-server-url");
            config.setFormServerUrlPattern(orbeonServerUrlPattern);
            String authoringServerUrl = root.valueOf("authoring-server-url");
            config.setAuthoringServerUrl(authoringServerUrl);
            String authoringServerUrlPattern = root.valueOf("authoring-server-url-pattern");
            config.setAuthoringServerUrlPattern(authoringServerUrlPattern);
            String liveServerUrl = root.valueOf("live-server-url");
            config.setLiveServerUrl(liveServerUrl);
            String adminEmailAddress = root.valueOf("admin-email-address");
            config.setAdminEmailAddress(adminEmailAddress);
            String cookieDomain = root.valueOf("cookie-domain");
            config.setCookieDomain(cookieDomain);
            List channelGroupList = root.selectNodes("publishing-channels/channel-group");
            for (Element element : channelGroupList) {
                PublishingChannelGroupConfigTO pcgConfigTo = new PublishingChannelGroupConfigTO();
                Node node = element.selectSingleNode("label");
                if (node != null) {
                    pcgConfigTo.setName(node.getText());
                }
                List channels = element.selectNodes("channels/channel");
                for (Element channel : channels) {
                    PublishingChannelConfigTO pcConfigTO = new PublishingChannelConfigTO();
                    pcConfigTO.setName(channel.getText());
                    pcgConfigTo.getChannels().add(pcConfigTO);
                }
                node = element.selectSingleNode("live-environment");
                if (node != null) {
                    String isLiveEnvStr = node.getText();
                    boolean isLiveEnvVal = StringUtils.isNotEmpty((String)isLiveEnvStr) && Boolean.valueOf(isLiveEnvStr) != false;
                    pcgConfigTo.setLiveEnvironment(isLiveEnvVal);
                    if (isLiveEnvVal) {
                        if (config.getLiveEnvironmentPublishingGroup() == null) {
                            config.setLiveEnvironmentPublishingGroup(pcgConfigTo);
                        } else {
                            pcgConfigTo.setLiveEnvironment(false);
                            logger.warn("Multiple publishing groups assigned as live environment. Only one publishing group can be live environment. " + config.getLiveEnvironmentPublishingGroup().getName() + " is already set as live environment.", new Object[0]);
                        }
                    }
                }
                config.getPublishingChannelGroupConfigs().put(pcgConfigTo.getName(), pcgConfigTo);
            }
            String previewDeploymentEndpoint = root.valueOf("preview-deployment-endpoint");
            config.setPreviewDeploymentEndpoint(previewDeploymentEndpoint);
            config.setLastUpdated(new Date());
            this.siteMapping.put(key, config);
        }
    }

    @Override
    public void reloadConfiguration(String site) {
        this.loadConfiguration(site);
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public Map<String, PublishingChannelGroupConfigTO> getPublishingChannelGroupConfigs(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getPublishingChannelGroupConfigs();
        }
        return Collections.emptyMap();
    }

    @Override
    public PublishingChannelGroupConfigTO getLiveEnvironmentPublishingGroup(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getLiveEnvironmentPublishingGroup();
        }
        return null;
    }

    @Override
    public boolean exists(String site) {
        if (this.siteMapping == null) {
            return false;
        }
        return this.siteMapping.get(site) != null;
    }

    @Override
    public String getPreviewDeploymentEndpoint(String site) {
        EnvironmentConfigTO config = this.siteMapping.get(site);
        if (config != null) {
            return config.getPreviewDeploymentEndpoint();
        }
        return null;
    }

    @Override
    protected String getConfigFullPath(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", key).replaceFirst("\\{environment\\}", this.environment);
        return siteConfigPath + "/" + this.configFileName;
    }
}

