/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.ObjectMetadata;
import org.craftercms.studio.api.v1.dal.ObjectState;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.ebus.RepositoryEventMessage;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.executor.ProcessContentExecutor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.DmRenameService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.DmOrderTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.GoLiveDeleteCandidates;
import org.craftercms.studio.api.v1.to.RenderingTemplateTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v1.util.DebugUtils;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentItemOrderComparator;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import reactor.core.Reactor;
import reactor.event.Event;

public class ContentServiceImpl
implements ContentService {
    protected static final String MSG_ERROR_IO_CLOSE_FAILED = "err_io_closed_failed";
    private static final Logger logger = LoggerFactory.getLogger(ContentServiceImpl.class);
    public static final Pattern COPY_FILE_PATTERN = Pattern.compile("(.+)-([0-9]+)\\.(.+)");
    public static final Pattern COPY_FOLDER_PATTERN = Pattern.compile("(.+)-([0-9]+)");
    private ContentRepository _contentRepository;
    protected ServicesConfig servicesConfig;
    protected GeneralLockService generalLockService;
    protected ObjectStateService objectStateService;
    protected DmDependencyService dependencyService;
    protected ProcessContentExecutor contentProcessor;
    protected DmRenameService dmRenameService;
    protected ObjectMetadataManager objectMetadataManager;
    protected SecurityService securityService;
    protected Reactor repositoryReactor;
    protected DmPageNavigationOrderService dmPageNavigationOrderService;
    protected SecurityProvider securityProvider;
    protected ActivityService activityService;
    protected DmContentLifeCycleService dmContentLifeCycleService;

    @Override
    public boolean contentExists(String site, String path) {
        return this._contentRepository.contentExists(this.expandRelativeSitePath(site, path));
    }

    @Override
    public boolean contentExists(String fullPath) {
        return this._contentRepository.contentExists(fullPath);
    }

    @Override
    public InputStream getContent(String path) throws ContentNotFoundException {
        return this._contentRepository.getContent(path);
    }

    @Override
    public InputStream getContent(String site, String path) throws ContentNotFoundException {
        return this._contentRepository.getContent(this.expandRelativeSitePath(site, path));
    }

    @Override
    public String getContentAsString(String path) {
        String content = null;
        try {
            content = IOUtils.toString((InputStream)this._contentRepository.getContent(path));
        }
        catch (Exception err) {
            logger.error("Failed to get content as string for path {0}", path);
            logger.debug("Failed to get content as string for path {0}", err, path);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getContentAsDocument(String path) throws DocumentException {
        Document retDocument = null;
        InputStream is = null;
        try {
            is = this.getContent(path);
        }
        catch (ContentNotFoundException e) {
            logger.error("Content not found for path {0}", e, path);
        }
        if (is != null) {
            try {
                SAXReader saxReader = new SAXReader();
                retDocument = saxReader.read(is);
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException err) {
                    logger.error(MSG_ERROR_IO_CLOSE_FAILED, err, path);
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException err) {
                logger.error(MSG_ERROR_IO_CLOSE_FAILED, err, path);
            }
        }
        return retDocument;
    }

    @Override
    public boolean writeContent(String path, InputStream content) {
        boolean writeSuccess = false;
        writeSuccess = this._contentRepository.writeContent(path, content);
        try {
            this._contentRepository.createVersion(path, false);
        }
        catch (Exception err) {
            logger.error("Failed to create version for object at path: " + path, err, new Object[0]);
        }
        return writeSuccess;
    }

    @Override
    public void writeContent(String site, String path, String fileName, String contentType, InputStream input, String createFolders, String edit, String unlock) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("fileName", fileName);
        params.put("contentType", contentType);
        params.put("createFolders", createFolders);
        params.put("edit", edit);
        params.put("unlock", unlock);
        String id = site + ":" + path + ":" + fileName + ":" + contentType;
        String fullPath = this.expandRelativeSitePath(site, path);
        String relativePath = path;
        boolean contentExists = this.contentExists(site, path);
        String lockKey = id;
        if (contentExists) {
            lockKey = site + ":" + path;
        }
        this.generalLockService.lock(lockKey);
        try {
            ContentItemTO itemTo;
            boolean savaAndClose;
            boolean bl = savaAndClose = StringUtils.isEmpty((String)unlock) || !unlock.equalsIgnoreCase("false");
            if (contentExists) {
                ObjectState objectState = this.objectStateService.getObjectState(site, path);
                if (objectState == null) {
                    ContentItemTO item = this.getContentItem(site, path, 0);
                    this.objectStateService.insertNewEntry(site, item);
                    objectState = this.objectStateService.getObjectState(site, path);
                }
                if (objectState != null) {
                    if (objectState.getSystemProcessing() != 0) {
                        logger.error(String.format("Error Content %s is being processed (Object State is system processing);", fileName), new Object[0]);
                        throw new RuntimeException(String.format("Content \"%s\" is being processed", fileName));
                    }
                    this.objectStateService.setSystemProcessing(site, path, true);
                } else {
                    logger.error("the object state is still null.", new Object[0]);
                }
            }
            String chainID = "assetContent";
            if (path.startsWith("/site")) {
                chainID = "formContent";
            }
            this.processContent(id, input, true, params, chainID);
            if (contentExists) {
                this.objectStateService.setSystemProcessing(site, path, false);
            } else {
                this.objectStateService.setSystemProcessing(site, path, false);
            }
            String savedFileName = (String)params.get("fileName");
            String savedPath = (String)params.get("path");
            fullPath = this.expandRelativeSitePath(site, savedPath);
            if (!savedPath.endsWith(savedFileName)) {
                fullPath = fullPath + "/" + savedFileName;
            }
            if ((itemTo = this.getContentItem(site, relativePath = this.getRelativeSitePath(site, fullPath = fullPath.replace("//", "/")), 0)) != null) {
                if (savaAndClose) {
                    this.objectStateService.transition(site, itemTo, TransitionEvent.SAVE);
                } else {
                    this.objectStateService.transition(site, itemTo, TransitionEvent.SAVE_FOR_PREVIEW);
                }
                this.objectStateService.setSystemProcessing(site, itemTo.getUri(), false);
            } else {
                this.objectStateService.insertNewEntry(site, itemTo);
            }
            RepositoryEventMessage message = new RepositoryEventMessage();
            message.setSite(site);
            message.setPath(relativePath);
            String sessionTicket = this.securityProvider.getCurrentToken();
            RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
            message.setRepositoryEventContext(repositoryEventContext);
            this.repositoryReactor.notify((Object)"repository.update", Event.wrap((Object)message));
        }
        catch (RuntimeException e) {
            logger.error("error writing content", e, new Object[0]);
            this.objectStateService.setSystemProcessing(site, relativePath, false);
            this.objectStateService.setSystemProcessing(site, path, false);
            throw e;
        }
        finally {
            this.generalLockService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContentAndRename(String site, String path, String targetPath, String fileName, String contentType, InputStream input, String createFolders, String edit, String unlock, boolean createFolder) throws ServiceException {
        String id = site + ":" + path + ":" + fileName + ":" + contentType;
        if (!this.generalLockService.tryLock(id)) {
            this.generalLockService.lock(id);
            this.generalLockService.unlock(id);
            return;
        }
        try {
            this.writeContent(site, path, fileName, contentType, input, createFolders, edit, unlock);
            this.rename(site, path, targetPath, createFolder);
        }
        catch (Throwable t) {
            logger.error("Error while executing write and rename: ", t);
        }
        finally {
            this.generalLockService.unlock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> writeContentAsset(String site, String path, String assetName, InputStream in, String isImage, String allowedWidth, String allowedHeight, String allowLessSize, String draft, String unlock, String systemAsset) throws ServiceException {
        if (assetName != null) {
            assetName = assetName.replace(" ", "_");
        }
        boolean isSystemAsset = Boolean.valueOf(systemAsset);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("fileName", assetName);
        params.put("isImage", isImage);
        params.put("allowLessSize", allowLessSize);
        params.put("allowedWidth", allowedWidth);
        params.put("allowedHeight", allowedHeight);
        params.put("contentType", "");
        params.put("createFolders", "true");
        params.put("unlock", unlock);
        params.put("systemAsset", String.valueOf(isSystemAsset));
        String id = site + ":" + path + ":" + assetName + ":" + "";
        String fullPath = null;
        ContentItemTO item = null;
        try {
            ObjectState itemState;
            fullPath = this.expandRelativeSitePath(site, path + "/" + assetName);
            item = this.getContentItem(site, path + "/" + assetName);
            if (item != null && (itemState = this.objectStateService.getObjectState(site, path + "/" + assetName)) != null) {
                if (itemState.getSystemProcessing() != 0) {
                    logger.error(String.format("Error Content %s is being processed (Object State is SYSTEM_PROCESSING);", assetName), new Object[0]);
                    throw new RuntimeException(String.format("Content \"%s\" is being processed", assetName));
                }
                this.objectStateService.setSystemProcessing(site, path + "/" + assetName, true);
            }
            ResultTO result = this.processContent(id, in, false, params, "assetContent");
            if (isSystemAsset) {
                ContentAssetInfoTO assetInfoTO = (ContentAssetInfoTO)result.getItem();
                fullPath = fullPath.replace(assetName, assetInfoTO.getFileName());
            }
            if ((item = this.getContentItem(site, this.getRelativeSitePath(site, fullPath))) != null) {
                this.objectStateService.transition(site, item, TransitionEvent.SAVE);
            }
            RepositoryEventMessage message = new RepositoryEventMessage();
            message.setSite(site);
            message.setPath(this.getRelativeSitePath(site, fullPath));
            String sessionTicket = this.securityProvider.getCurrentToken();
            RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
            message.setRepositoryEventContext(repositoryEventContext);
            this.repositoryReactor.notify((Object)"repository.update", Event.wrap((Object)message));
            HashMap<String, Object> toRet = new HashMap<String, Object>();
            toRet.put("success", true);
            toRet.put("message", item);
            HashMap<String, Object> hashMap = toRet;
            if (item != null) {
                this.objectStateService.setSystemProcessing(site, this.getRelativeSitePath(site, fullPath), false);
            }
            return hashMap;
        }
        catch (Exception e) {
            try {
                logger.error("Error processing content", e, new Object[0]);
                HashMap<String, Object> toRet = new HashMap<String, Object>();
                toRet.put("success", true);
                toRet.put("message", e.getMessage());
                toRet.put("error", e);
                HashMap<String, Object> hashMap = toRet;
                if (item != null) {
                    this.objectStateService.setSystemProcessing(site, this.getRelativeSitePath(site, fullPath), false);
                }
                return hashMap;
            }
            catch (Throwable throwable) {
                if (item != null) {
                    this.objectStateService.setSystemProcessing(site, this.getRelativeSitePath(site, fullPath), false);
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean writeContent(String site, String path, InputStream content) {
        return this.writeContent(this.expandRelativeSitePath(site, path), content);
    }

    @Override
    public boolean createFolder(String site, String path, String name) {
        return this._contentRepository.createFolder(this.expandRelativeSitePath(site, path), name);
    }

    @Override
    public boolean deleteContent(String site, String path, String approver) {
        return this.deleteContent(site, path, true, approver);
    }

    @Override
    public boolean deleteContent(String site, String path, boolean generateActivity, String approver) {
        if (generateActivity) {
            this.generateDeleteActivity(site, path, approver);
        }
        boolean toRet = this._contentRepository.deleteContent(this.expandRelativeSitePath(site, path));
        this.objectStateService.deleteObjectStateForPath(site, path);
        this.objectMetadataManager.deleteObjectMetadata(site, path);
        this.dependencyService.deleteDependenciesForSiteAndPath(site, path);
        RepositoryEventMessage message = new RepositoryEventMessage();
        message.setSite(site);
        message.setPath(path);
        String sessionTicket = this.securityProvider.getCurrentToken();
        RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
        message.setRepositoryEventContext(repositoryEventContext);
        this.repositoryReactor.notify((Object)"repository.delete", Event.wrap((Object)message));
        return toRet;
    }

    protected void generateDeleteActivity(String site, String path, String approver) {
        boolean exists;
        if (StringUtils.isEmpty((String)approver)) {
            approver = this.securityService.getCurrentUser();
        }
        if (exists = this.contentExists(site, path)) {
            ObjectMetadata properties = this.objectMetadataManager.getProperties(site, path);
            String user = properties != null && !StringUtils.isEmpty((String)properties.getSubmittedBy()) ? properties.getSubmittedBy() : approver;
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            if (path.endsWith(".xml")) {
                extraInfo.put("contentType", this.getContentTypeClass(site, path));
            }
            logger.debug("[DELETE] posting delete activity on " + path + " by " + user + " in " + site, new Object[0]);
            this.activityService.postActivity(site, user, path, ActivityService.ActivityType.DELETED, extraInfo);
            if (path.endsWith(".xml")) {
                String contentType = this.getContentTypeClass(site, path);
                this.dmContentLifeCycleService.process(site, user, path, contentType, DmContentLifeCycleService.ContentLifeCycleOperation.DELETE, null);
            }
        }
    }

    @Override
    public boolean copyContent(String site, String fromPath, String toPath) {
        return this._contentRepository.copyContent(this.expandRelativeSitePath(site, fromPath), this.expandRelativeSitePath(site, toPath));
    }

    @Override
    public boolean moveContent(String site, String fromPath, String toPath) {
        boolean toRet = this._contentRepository.moveContent(this.expandRelativeSitePath(site, fromPath), this.expandRelativeSitePath(site, toPath));
        RepositoryEventMessage message = new RepositoryEventMessage();
        message.setSite(site);
        message.setPath(toPath);
        message.setOldPath(fromPath);
        String sessionTicket = this.securityProvider.getCurrentToken();
        RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
        message.setRepositoryEventContext(repositoryEventContext);
        this.repositoryReactor.notify((Object)"repository.move", Event.wrap((Object)message));
        return toRet;
    }

    protected ContentItemTO createNewContentItemTO(String site, String contentPath) {
        ContentItemTO item = new ContentItemTO();
        item.uri = contentPath = contentPath.replace("//", "/");
        item.path = contentPath.substring(0, contentPath.lastIndexOf("/"));
        item.name = contentPath.substring(contentPath.lastIndexOf("/") + 1);
        item.asset = true;
        item.site = site;
        item.internalName = item.name;
        item.contentType = "asset";
        item.disabled = false;
        item.floating = false;
        item.hideInAuthoring = false;
        item.page = false;
        item.previewable = false;
        item.isPreviewable = false;
        item.component = false;
        item.document = false;
        item.asset = true;
        item.browserUri = "";
        item.isNew = true;
        item.submitted = false;
        item.scheduled = false;
        item.deleted = false;
        item.submittedForDeletion = false;
        item.inProgress = true;
        item.live = false;
        item.folder = !item.name.contains(".");
        return item;
    }

    protected ContentItemTO populateContentDrivenProperties(String site, ContentItemTO item) throws Exception {
        String fullContentPath = this.expandRelativeSitePath(item.site, item.uri);
        String contentPath = item.uri;
        logger.debug("Pupulating page props {0}", contentPath);
        item.setLevelDescriptor(item.name.equals(this.servicesConfig.getLevelDescriptorName(site)));
        item.isPage = item.page = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getPagePatterns(site));
        item.isPreviewable = item.previewable = item.page;
        item.isComponent = item.component = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getComponentPatterns(site)) || item.isLevelDescriptor();
        item.isAsset = item.asset = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getAssetPatterns(site));
        item.isDocument = item.document = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getDocumentPatterns(site));
        item.uri = contentPath;
        item.path = contentPath.substring(0, contentPath.lastIndexOf("/"));
        item.name = contentPath.substring(contentPath.lastIndexOf("/") + 1);
        item.browserUri = item.page ? contentPath.replace("/site/website", "").replace("/index.xml", "") : null;
        Document contentDoc = this.getContentAsDocument(fullContentPath);
        if (contentDoc != null) {
            Element rootElement = contentDoc.getRootElement();
            item.internalName = rootElement.valueOf("internal-name");
            item.contentType = rootElement.valueOf("content-type");
            item.disabled = rootElement.valueOf("disabled") != null && rootElement.valueOf("disabled").equals("true");
            item.floating = rootElement.valueOf("placeInNav") != null && !rootElement.valueOf("placeInNav").equals("true");
            item.navigation = rootElement.valueOf("placeInNav") != null && rootElement.valueOf("placeInNav").equals("true");
            item.hideInAuthoring = rootElement.valueOf("hideInAuthoring") != null && rootElement.valueOf("hideInAuthoring").equals("true");
            item.hideInAuthoring = rootElement.valueOf("hideInAuthoring") != null && rootElement.valueOf("hideInAuthoring").equals("true");
            item.setOrders(this.getItemOrders(rootElement.selectNodes("//orderDefault_f")));
            String displayTemplate = rootElement.valueOf("display-template");
            if (displayTemplate != null) {
                RenderingTemplateTO template = new RenderingTemplateTO();
                template.uri = displayTemplate;
                template.name = "DEFAULT";
                item.renderingTemplates.add(template);
            }
        } else {
            logger.error("no xml document could be loaded for path {0}", fullContentPath);
        }
        return item;
    }

    protected void addOrderValue(List<DmOrderTO> orders, String orderName, String orderStr) {
        Double orderValue = null;
        try {
            orderValue = Double.parseDouble(orderStr);
        }
        catch (NumberFormatException e) {
            logger.debug(orderName + ", " + orderStr + " is not a valid order value pair.", new Object[0]);
        }
        if (!StringUtils.isEmpty((String)orderName) && orderValue != null) {
            DmOrderTO order = new DmOrderTO();
            order.setId(orderName);
            order.setOrder(orderValue);
            orders.add(order);
        }
    }

    protected List<DmOrderTO> getItemOrders(List<Node> nodes) {
        if (nodes != null) {
            ArrayList<DmOrderTO> orders = new ArrayList<DmOrderTO>(nodes.size());
            for (Node node : nodes) {
                String orderName = "default";
                String orderStr = node.getText();
                this.addOrderValue(orders, orderName, orderStr);
            }
            return orders;
        }
        return null;
    }

    protected ContentItemTO populateItemChildren(ContentItemTO item, int depth) {
        String fullContentPath = this.expandRelativeSitePath(item.site, item.uri);
        String contentPath = item.uri;
        item.children = new ArrayList<ContentItemTO>();
        item.numOfChildren = 0;
        if (contentPath.indexOf("/index.xml") != -1 || contentPath.indexOf(".") == -1) {
            if (contentPath.indexOf("/index.xml") != -1) {
                fullContentPath = fullContentPath.replace("/index.xml", "");
            }
            RepositoryItem[] childRepoItems = this._contentRepository.getContentChildren(fullContentPath);
            boolean indexFound = false;
            if (childRepoItems != null) {
                item.numOfChildren = childRepoItems.length;
                if (item.numOfChildren != 0) {
                    item.isContainer = true;
                    item.container = true;
                }
                logger.debug("Checking if {0} has index", contentPath);
                for (int j = 0; j < childRepoItems.length; ++j) {
                    if ("index.xml".equals(childRepoItems[j].name)) {
                        if (item.uri.indexOf("/index.xml") == -1) {
                            item.uri = item.uri + "/index.xml";
                        }
                        --item.numOfChildren;
                        indexFound = true;
                        continue;
                    }
                    String childPath = this.getRelativeSitePath(item.site, childRepoItems[j].path + "/" + childRepoItems[j].name);
                    item.children.add(this.getContentItem(item.site, childPath, depth - 1));
                }
                if (!indexFound) {
                    item.folder = true;
                    item.isContainer = true;
                    item.container = true;
                    item.page = false;
                    item.asset = false;
                    item.component = false;
                    item.previewable = false;
                    item.isPreviewable = false;
                    item.internalName = item.name;
                    item.contentType = "folder";
                    item.path = item.uri;
                }
                ContentItemOrderComparator comparator = new ContentItemOrderComparator("default", true, true, true);
                Collections.sort(item.children, comparator);
            } else {
                item.isContainer = true;
                item.container = true;
            }
        } else {
            item.isContainer = false;
            item.container = false;
        }
        if (item.internalName == null) {
            item.internalName = item.name;
        }
        return item;
    }

    @Override
    public ContentItemTO getContentItem(String site, String path) {
        return this.getContentItem(site, path, 2);
    }

    @Override
    public ContentItemTO getContentItem(String site, String path, int depth) {
        logger.debug("Loading content item ... should be cached {0}, {1}, {2}", site, path, depth);
        ContentItemTO item = null;
        String fullContentPath = this.expandRelativeSitePath(site, path);
        String contentPath = path;
        logger.debug("Getting content item for {0}", contentPath);
        DebugUtils.addDebugStack(logger);
        long startTime = System.currentTimeMillis();
        try {
            item = this.createNewContentItemTO(site, contentPath);
            if (depth != 0) {
                item = this.populateItemChildren(item, depth);
            }
            if (item.uri.endsWith(".xml")) {
                item = this.populateContentDrivenProperties(site, item);
            } else {
                item.setLevelDescriptor(item.name.equals(this.servicesConfig.getLevelDescriptorName(site)));
                item.isPage = item.page = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getPagePatterns(site));
                item.isPreviewable = item.previewable = item.page;
                item.isAsset = item.asset = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getAssetPatterns(site));
                item.isComponent = item.component = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getComponentPatterns(site)) || item.isLevelDescriptor() || item.asset || ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getRenderingTemplatePatterns(site));
                item.isDocument = item.document = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getDocumentPatterns(site));
            }
            this.loadContentTypeProperties(site, item, item.contentType);
            this.populateMetadata(site, item);
            if (!item.isFolder() || item.isContainer()) {
                this.populateWorkflowProperties(site, item);
            }
        }
        catch (Exception err) {
            logger.error("error constructing item for object at path '{0}'", err, fullContentPath);
        }
        long executionTime = System.currentTimeMillis() - startTime;
        logger.debug("Content item [{0}] retrieved in {1} milis", fullContentPath, executionTime);
        return item;
    }

    @Override
    public ContentItemTO getContentItem(String fullPath) {
        String site = this.getSiteFromFullPath(fullPath);
        String relativePath = this.getRelativeSitePath(site, fullPath);
        return this.getContentItem(site, fullPath);
    }

    protected void loadContentTypeProperties(String site, ContentItemTO item, String contentType) {
        if (contentType != null && !contentType.equals("folder") && !contentType.equals("asset")) {
            ContentTypeConfigTO config = this.servicesConfig.getContentTypeConfig(site, contentType);
            if (config != null) {
                item.setForm(config.getForm());
                item.setFormPagePath(config.getFormPath());
                item.setPreviewable(config.isPreviewable());
                item.isPreviewable = item.previewable;
            }
        } else {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String mimeType = fileNameMap.getContentTypeFor(item.getUri());
            if (mimeType != null && !StringUtils.isEmpty((String)mimeType)) {
                item.setPreviewable(ContentUtils.matchesPatterns(mimeType, this.servicesConfig.getPreviewableMimetypesPaterns(site)));
                item.isPreviewable = item.previewable;
            }
        }
    }

    protected void populateWorkflowProperties(String site, ContentItemTO item) {
        ObjectState state = this.objectStateService.getObjectState(site, item.getUri(), false);
        if (state != null) {
            item.setLive(State.isLive(State.valueOf(state.getState())));
            item.isLive = item.isLive();
            item.setInProgress(!item.isLive());
            item.isInProgress = item.isInProgress();
            item.setScheduled(State.isScheduled(State.valueOf(state.getState())));
            item.isScheduled = item.isScheduled();
            item.setSubmitted(State.isSubmitted(State.valueOf(state.getState())));
            item.isSubmitted = item.isSubmitted();
            item.setInFlight(state.getSystemProcessing() == 1);
            item.isInFlight = item.isInFlight();
        }
    }

    protected void populateMetadata(String site, ContentItemTO item) {
        ObjectMetadata metadata = this.objectMetadataManager.getProperties(site, item.getUri());
        if (metadata != null) {
            if (StringUtils.isEmpty((String)metadata.getLockOwner())) {
                item.setLockOwner("");
            } else {
                item.setLockOwner(metadata.getLockOwner());
            }
            if (metadata.getLaunchDate() != null) {
                item.scheduledDate = metadata.getLaunchDate();
                item.setScheduledDate(metadata.getLaunchDate());
            }
            if (StringUtils.isEmpty((String)metadata.getModifier())) {
                item.setUser("");
                item.setUserLastName("");
                item.setUserFirstName("");
            } else {
                item.user = metadata.getModifier();
                item.setUser(metadata.getModifier());
                if (StringUtils.isEmpty((String)metadata.getFirstName())) {
                    item.userFirstName = metadata.getModifier();
                    item.setUserFirstName(metadata.getModifier());
                } else {
                    item.userFirstName = metadata.getFirstName();
                    item.setUserFirstName(metadata.getFirstName());
                }
                if (StringUtils.isEmpty((String)metadata.getLastName())) {
                    item.userLastName = "";
                    item.setUserLastName("");
                } else {
                    item.userLastName = metadata.getLastName();
                    item.setUserLastName(metadata.getLastName());
                }
            }
            if (metadata.getModified() != null) {
                item.lastEditDate = metadata.getModified();
                item.eventDate = metadata.getModified();
                item.setLastEditDate(metadata.getModified());
                item.setEventDate(metadata.getModified());
            }
        } else {
            item.setLockOwner("");
        }
    }

    @Override
    public ContentItemTO getContentItemTree(String site, String path, int depth) {
        logger.debug("Getting content item  tree for {0}:{1} depth {2}", site, path, depth);
        DebugUtils.addDebugStack(logger);
        long startTime = System.currentTimeMillis();
        boolean isPages = path.contains("/site/website");
        ContentItemTO root = null;
        root = isPages && path.equals("/site/website") ? this.getContentItem(site, path + "/index.xml") : this.getContentItem(site, path);
        long executionTime = System.currentTimeMillis() - startTime;
        logger.debug("Content item tree [{0}:{1} depth {2}] retrieved in {3} milis", site, path, depth, executionTime);
        return root;
    }

    @Override
    public ContentItemTO getContentItemTree(String fullPath, int depth) {
        String site = this.getSiteFromFullPath(fullPath);
        String relativePath = this.getRelativeSitePath(site, fullPath);
        return this.getContentItemTree(site, relativePath, depth);
    }

    @Override
    public VersionTO[] getContentItemVersionHistory(String site, String path) {
        return this._contentRepository.getContentVersionHistory(this.expandRelativeSitePath(site, path));
    }

    @Override
    public boolean revertContentItem(String site, String path, String version, boolean major, String comment) {
        boolean success = false;
        success = this._contentRepository.revertContent(this.expandRelativeSitePath(site, path), version, major, comment);
        RepositoryEventMessage message = new RepositoryEventMessage();
        message.setSite(site);
        message.setPath(path);
        String sessionTicket = this.securityProvider.getCurrentToken();
        RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
        message.setRepositoryEventContext(repositoryEventContext);
        this.repositoryReactor.notify((Object)"repository.update", Event.wrap((Object)message));
        if (success) {
            // empty if block
        }
        return success;
    }

    @Override
    public InputStream getContentVersion(String site, String path, String version) throws ContentNotFoundException {
        String repositoryPath = this.expandRelativeSitePath(site, path);
        return this._contentRepository.getContentVersion(repositoryPath, version);
    }

    @Override
    public String getContentVersionAsString(String site, String path, String version) throws ContentNotFoundException {
        String content = null;
        try {
            content = IOUtils.toString((InputStream)this.getContentVersion(site, path, version));
        }
        catch (Exception err) {
            logger.error("Failed to get content as string for path {0}", path);
            logger.debug("Failed to get content as string for path {0}", err, path);
        }
        return content;
    }

    @Override
    public ContentItemTO createDummyDmContentItemForDeletedNode(String site, String relativePath) {
        String contentTypeClass;
        String folderPath;
        String timeZone;
        String absolutePath = this.expandRelativeSitePath(site, relativePath);
        DmPathTO path = new DmPathTO(absolutePath);
        ContentItemTO item = new ContentItemTO();
        item.timezone = timeZone = this.servicesConfig.getDefaultTimezone(site);
        String name = path.getName();
        String fullPath = path.toString();
        item.path = folderPath = name.equals("index.xml") ? relativePath.replace("/" + name, "") : relativePath;
        String internalName = folderPath;
        int index = folderPath.lastIndexOf(47);
        if (index != -1) {
            internalName = folderPath.substring(index + 1);
        }
        item.internalName = internalName;
        item.isDisabled = false;
        item.isNavigation = false;
        item.name = name;
        item.uri = relativePath;
        item.contentType = contentTypeClass = this.getContentTypeClass(site, relativePath);
        if (contentTypeClass.equals("components")) {
            item.component = true;
        } else if (contentTypeClass.equals("documents")) {
            item.document = true;
        }
        item.isDeleted = true;
        item.deleted = true;
        item.isContainer = false;
        item.container = false;
        item.isNew = false;
        item.isInProgress = false;
        item.timezone = this.servicesConfig.getDefaultTimezone(site);
        item.isPreviewable = false;
        item.browserUri = this.getBrowserUri(item);
        return item;
    }

    @Override
    public String expandRelativeSitePath(String site, String relativePath) {
        return "/wem-projects/" + site + "/" + site + "/work-area" + relativePath;
    }

    @Override
    public String getRelativeSitePath(String site, String fullPath) {
        return fullPath.replace("/wem-projects/" + site + "/" + site + "/work-area", "");
    }

    protected String getRelativeSitePath(String fullPath) {
        String path = fullPath.replace("/wem-projects/", "");
        String site = path.substring(0, path.indexOf("/"));
        return this.getRelativeSitePath(site, fullPath);
    }

    protected String getSiteFromFullPath(String fullPath) {
        String path = fullPath.replace("/wem-projects/", "");
        String site = path.substring(0, path.indexOf("/"));
        return site;
    }

    protected String getBrowserUri(ContentItemTO item) {
        String replacePattern = "";
        replacePattern = item.isComponent ? "/site/(components|component-bindings|indexes|resources)" : (item.isAsset ? "/static-assets" : (item.isDocument ? "/site/documents" : "/site/website"));
        boolean isPage = !item.isComponent && !item.isAsset && !item.isDocument;
        return ContentServiceImpl.getBrowserUri(item.uri, replacePattern, isPage);
    }

    protected static String getBrowserUri(String uri, String replacePattern, boolean isPage) {
        String browserUri = uri.replaceFirst(replacePattern, "");
        if ((browserUri = browserUri.replaceFirst("/index.xml", "")).length() == 0) {
            browserUri = "/";
        }
        if (isPage) {
            browserUri = browserUri.replaceFirst("\\.xml", ".html");
        }
        return browserUri;
    }

    @Override
    public String getContentTypeClass(String site, String uri) {
        if (this.matchesPatterns(uri, this.servicesConfig.getComponentPatterns(site)) || uri.endsWith("/" + this.servicesConfig.getLevelDescriptorName(site))) {
            return "components";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getDocumentPatterns(site))) {
            return "documents";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getAssetPatterns(site))) {
            return "assets";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getRenderingTemplatePatterns(site))) {
            return "renderingTemplate";
        }
        return "pages";
    }

    protected boolean matchesPatterns(String uri, List<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!uri.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    protected void rename(String site, String path, String targetPath, boolean createFolder) throws ServiceException {
        this.dmRenameService.rename(site, path, targetPath, createFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultTO processContent(String id, InputStream input, boolean isXml, Map<String, String> params, String contentChainForm) throws ServiceException {
        long start = System.currentTimeMillis();
        try {
            String[] strings = id.split(":");
            String path = strings[1];
            String site = strings[0];
            long startTime = System.currentTimeMillis();
            ResultTO to = this.contentProcessor.processContent(id, input, isXml, params, contentChainForm);
            long duration = System.currentTimeMillis() - startTime;
            logger.warn("Write Duration: {0}", duration);
            ResultTO resultTO = to;
            return resultTO;
        }
        finally {
            long end = System.currentTimeMillis();
            logger.debug("Write complete for [" + id + "] in time [" + (end - start) + "]", new Object[0]);
        }
    }

    @Override
    public String getNextAvailableName(String site, String path) {
        String[] levels = path.split("/");
        int length = levels.length;
        if (length > 0) {
            ContentItemTO item = this.getContentItem(site, path, 0);
            if (item != null) {
                String name = ContentUtils.getPageName(path);
                String parentPath = ContentUtils.getParentUrl(path);
                ContentItemTO parentItem = this.getContentItemTree(site, parentPath, 1);
                if (parentItem != null) {
                    int lastIndex = name.lastIndexOf(".");
                    String ext = item.isFolder() ? "" : name.substring(lastIndex);
                    String originalName = item.isFolder() ? name : name.substring(0, lastIndex);
                    List<ContentItemTO> children = parentItem.getChildren();
                    int lastNumber = 0;
                    String namePattern = originalName + "\\-[0-9]+" + ext;
                    if (children != null && children.size() > 0) {
                        for (ContentItemTO child : children) {
                            Pattern pattern;
                            Matcher matcher;
                            String childName;
                            if (item.isFolder() != child.isFolder() || !(childName = child.getName()).matches(namePattern) || !(matcher = (pattern = item.isFolder() ? COPY_FOLDER_PATTERN : COPY_FILE_PATTERN).matcher(childName)).matches()) continue;
                            int helper = ContentFormatUtils.getIntValue(matcher.group(2));
                            lastNumber = helper > lastNumber ? helper : lastNumber;
                        }
                    }
                    String nextName = originalName + "-" + ++lastNumber + ext;
                    return nextName;
                }
            }
        } else {
            return "";
        }
        return levels[length - 1];
    }

    @Override
    public GoLiveDeleteCandidates getDeleteCandidates(String site, String relativePath) throws ServiceException {
        ArrayList items = new ArrayList();
        ContentItemTO contentItem = this.getContentItem(site, relativePath);
        GoLiveDeleteCandidates deletedItems = new GoLiveDeleteCandidates(site, this);
        if (contentItem != null) {
            this.childDeleteItems(site, contentItem, deletedItems);
        }
        return deletedItems;
    }

    protected void childDeleteItems(String site, ContentItemTO contentItem, GoLiveDeleteCandidates items) throws ServiceException {
        if (contentItem.isFolder() && (contentItem = this.getContentItemTree(site, contentItem.getUri(), 1)).getChildren() != null && contentItem.getNumOfChildren() > 0) {
            for (ContentItemTO child : contentItem.getChildren()) {
                this.childDeleteItems(site, child, items);
            }
        }
        items.getPaths().add(contentItem.getUri());
    }

    @Override
    public void lockContent(String site, String path) {
        this._contentRepository.lockItem(site, path);
        this.objectMetadataManager.lockContent(site, path, this.securityService.getCurrentUser());
    }

    @Override
    public void unLockContent(String site, String path) {
        ContentItemTO item = this.getContentItem(site, path, 0);
        this.objectStateService.transition(site, item, TransitionEvent.CANCEL_EDIT);
        this._contentRepository.unLockItem(site, path);
        this.objectMetadataManager.unLockContent(site, path);
    }

    @Override
    public List<DmOrderTO> getItemOrders(String site, String path) throws ContentNotFoundException {
        List<DmOrderTO> dmOrderTOs = this.getOrders(site, path, "default", false);
        for (DmOrderTO dmOrderTO : dmOrderTOs) {
            dmOrderTO.setName(StringUtils.escape((String)dmOrderTO.getName()));
        }
        return dmOrderTOs;
    }

    private List<DmOrderTO> getOrders(String site, String relativePath, String orderName, boolean includeFloating) {
        ContentItemTO item;
        int index;
        if (!StringUtils.isEmpty((String)relativePath) && relativePath.endsWith(".xml") && (index = relativePath.lastIndexOf("/")) > 0) {
            int secondIndex;
            String fileName = relativePath.substring(index + 1);
            String path = relativePath.substring(0, index);
            if ("index.xml".equals(fileName) && (secondIndex = path.lastIndexOf("/")) > 0) {
                path = path.substring(0, secondIndex);
            }
            relativePath = path;
        }
        if ((item = this.getContentItem(site, relativePath)).getChildren() != null) {
            ArrayList<DmOrderTO> orders = new ArrayList<DmOrderTO>(item.getChildren().size());
            String pathIndex = relativePath + "/" + "index.xml";
            for (ContentItemTO child : item.getChildren()) {
                if (pathIndex.equals(child.getUri()) || child.isLevelDescriptor() || child.isDeleted() || child.isFloating() && !includeFloating) continue;
                DmOrderTO order = new DmOrderTO();
                order.setId(child.getUri());
                Double orderNumber = child.getOrder(orderName);
                if (orderNumber == null || !(orderNumber > 0.0)) continue;
                order.setOrder(child.getOrder(orderName));
                order.setName(child.getInternalName());
                if (child.isDisabled()) {
                    order.setDisabled("true");
                } else {
                    order.setDisabled("false");
                }
                if (child.isNavigation()) {
                    order.setPlaceInNav("true");
                } else {
                    order.setPlaceInNav("false");
                }
                orders.add(order);
            }
            return orders;
        }
        return null;
    }

    @Override
    public double reorderItems(String site, String relativePath, String before, String after, String orderName) throws ServiceException {
        Double beforeOrder = null;
        Double afterOrder = null;
        DmOrderTO beforeOrderTO = null;
        DmOrderTO afterOrderTO = null;
        String fullPath = this.expandRelativeSitePath(site, relativePath);
        if (!StringUtils.isEmpty((String)before)) {
            ContentItemTO beforeItem = this.getContentItem(site, before, 0);
            beforeOrder = beforeItem.getOrder(orderName);
            beforeOrderTO = new DmOrderTO();
            beforeOrderTO.setId(before);
            if (beforeOrder != null && beforeOrder > 0.0) {
                beforeOrderTO.setOrder(beforeOrder);
            }
        }
        if (!StringUtils.isEmpty((String)after)) {
            ContentItemTO afterItem = this.getContentItem(site, after, 0);
            afterOrder = afterItem.getOrder(orderName);
            afterOrderTO = new DmOrderTO();
            afterOrderTO.setId(after);
            if (afterOrder != null && afterOrder > 0.0) {
                afterOrderTO.setOrder(afterOrder);
            }
        }
        if (afterOrder == null && beforeOrder == null) {
            return this.dmPageNavigationOrderService.getNewNavOrder(site, ContentUtils.getParentUrl(relativePath.replace("/index.xml", "")));
        }
        if (beforeOrder == null) {
            return (0.0 + afterOrder) / 2.0;
        }
        if (afterOrder == null) {
            logger.info("afterOrder == null", new Object[0]);
            return this.dmPageNavigationOrderService.getNewNavOrder(site, ContentUtils.getParentUrl(relativePath.replace("/index.xml", "")));
        }
        return this.computeReorder(site, relativePath, beforeOrderTO, afterOrderTO, orderName);
    }

    protected double computeReorder(String site, String relativePath, DmOrderTO beforeOrderTO, DmOrderTO afterOrderTO, String orderName) throws ContentNotFoundException {
        List<DmOrderTO> orderTO = this.getOrders(site, relativePath, orderName, true);
        Collections.sort(orderTO);
        int beforeIndex = orderTO.indexOf(beforeOrderTO);
        int afterIndex = orderTO.indexOf(afterOrderTO);
        if (beforeIndex + 1 != afterIndex) {
            beforeOrderTO = orderTO.get(afterIndex - 1);
        }
        return (beforeOrderTO.getOrder() + afterOrderTO.getOrder()) / 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameBulk(String site, String path, String targetPath, boolean createFolder) {
        this.generalLockService.lock(site + ":" + path);
        try {
            this.dmRenameService.rename(site, path, targetPath, createFolder);
            boolean bl = true;
            return bl;
        }
        catch (ContentNotFoundException e) {
            logger.error("Error executing bulk rename for {0}, {1} -> {2}", e, site, path, targetPath);
            boolean bl = false;
            return bl;
        }
        catch (ServiceException e) {
            logger.error("Error executing bulk rename for {0}, {1} -> {2}", e, site, path, targetPath);
            boolean bl = false;
            return bl;
        }
        finally {
            this.generalLockService.unlock(site + ":" + path);
        }
    }

    public ContentRepository getContentRepository() {
        return this._contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this._contentRepository = contentRepository;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmDependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DmDependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public ProcessContentExecutor getContentProcessor() {
        return this.contentProcessor;
    }

    public void setContentProcessor(ProcessContentExecutor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    public DmRenameService getDmRenameService() {
        return this.dmRenameService;
    }

    public void setDmRenameService(DmRenameService dmRenameService) {
        this.dmRenameService = dmRenameService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public Reactor getRepositoryReactor() {
        return this.repositoryReactor;
    }

    public void setRepositoryReactor(Reactor repositoryReactor) {
        this.repositoryReactor = repositoryReactor;
    }

    public DmPageNavigationOrderService getDmPageNavigationOrderService() {
        return this.dmPageNavigationOrderService;
    }

    public void setDmPageNavigationOrderService(DmPageNavigationOrderService dmPageNavigationOrderService) {
        this.dmPageNavigationOrderService = dmPageNavigationOrderService;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public DmContentLifeCycleService getDmContentLifeCycleService() {
        return this.dmContentLifeCycleService;
    }

    public void setDmContentLifeCycleService(DmContentLifeCycleService dmContentLifeCycleService) {
        this.dmContentLifeCycleService = dmContentLifeCycleService;
    }
}

