/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.ContentTypePathTO;
import org.craftercms.studio.api.v1.to.SiteContentTypePathsTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class ContentTypeServiceImpl
extends ConfigurableServiceBase
implements ContentTypeService {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeServiceImpl.class);
    protected ContentService contentService;
    protected ServicesConfig servicesConfig;
    protected ContentTypesConfig contentTypesConfig;
    protected SecurityService securityService;
    protected ContentRepository contentRepository;

    @Override
    public ContentTypeConfigTO getContentTypeForContent(String site, String path) throws ServiceException {
        ContentItemTO itemTO = this.contentService.getContentItem(site, path);
        if (itemTO != null) {
            String type = itemTO.getContentType();
            if (!StringUtils.isEmpty((String)type)) {
                return this.servicesConfig.getContentTypeConfig(site, type);
            }
            throw new ServiceException("No content type specified for " + path + " in site: " + site);
        }
        throw new ContentNotFoundException(path + " is not found in site: " + site);
    }

    @Override
    public boolean isUserAllowed(Set<String> userRoles, ContentTypeConfigTO item) {
        if (item != null) {
            String name = item.getName();
            Set<String> allowedRoles = item.getAllowedRoles();
            logger.debug("Checking allowed roles on " + name + ". user roles: " + userRoles + ", allowed roles: " + allowedRoles, new Object[0]);
            if (allowedRoles == null || allowedRoles.size() == 0) {
                return true;
            }
            boolean notAllowed = Collections.disjoint(userRoles, allowedRoles);
            if (notAllowed) {
                logger.debug(name + " is not allowed for the user.", new Object[0]);
                return false;
            }
            return true;
        }
        logger.debug("no content type config provided. returning true for user access to content type checking.", new Object[0]);
        return true;
    }

    @Override
    public ContentTypeConfigTO getContentTypeByRelativePath(String site, String relativePath) throws ServiceException {
        ContentItemTO item = this.contentService.getContentItem(site, relativePath);
        if (item != null) {
            String type = item.getContentType();
            if (!StringUtils.isEmpty((String)type)) {
                return this.servicesConfig.getContentTypeConfig(site, type);
            }
            throw new ServiceException("No content type specified for " + relativePath + " in site: " + site);
        }
        throw new ContentNotFoundException(relativePath + " is not found in site: " + site);
    }

    @Override
    public ContentTypeConfigTO getContentType(String site, String type) {
        return this.servicesConfig.getContentTypeConfig(site, type);
    }

    @Override
    public List<ContentTypeConfigTO> getAllContentTypes(String site, boolean searchable) {
        return this.getAllContentTypes(site);
    }

    protected List<ContentTypeConfigTO> getAllContentTypes(String site) {
        SiteContentTypePathsTO pathsConfig = this.contentTypesConfig.getPathMapping(site);
        if (pathsConfig != null && pathsConfig.getConfigs() != null) {
            ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
            for (ContentTypePathTO pathConfig : pathsConfig.getConfigs()) {
                Set<String> allowedContentTypes = pathConfig.getAllowedContentTypes();
                if (!CollectionUtils.isNotEmpty(allowedContentTypes)) continue;
                for (String key : allowedContentTypes) {
                    logger.debug("Checking an allowed content type: " + key, new Object[0]);
                    ContentTypeConfigTO typeConfig = this.contentTypesConfig.getContentTypeConfig(key);
                    if (typeConfig == null) continue;
                    logger.debug("adding " + key + " to content types.", new Object[0]);
                    contentTypes.add(typeConfig);
                }
            }
            return contentTypes;
        }
        logger.error("No content type path configuration is found for site: " + site, new Object[0]);
        return null;
    }

    protected List<ContentTypeConfigTO> getAllContentTypes_old(String site) {
        String contentTypesRootPath = this.configPath.replaceAll("\\{site\\}", site);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(contentTypesRootPath);
        ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                this.getContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
        return contentTypes;
    }

    protected void getContentTypeConfigForChildren(String site, RepositoryItem node, List<ContentTypeConfigTO> contentTypes) {
        String fullPath = node.path + "/" + node.name;
        logger.debug("Get Content Type Config fot Children path = {0}", fullPath);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(fullPath);
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                ContentTypeConfigTO config;
                if (!folders[i].isFolder) continue;
                String configPath = folders[i].path + "/" + folders[i].name + "/" + this.configFileName;
                if (this.contentService.contentExists(configPath) && (config = this.contentTypesConfig.loadConfiguration(site, configPath)) != null) {
                    contentTypes.add(config);
                }
                this.getContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
    }

    @Override
    protected String getConfigFullPath(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", key);
        return siteConfigPath + "/" + this.configFileName;
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return null;
    }

    @Override
    protected void removeConfiguration(String key) {
    }

    @Override
    protected void loadConfiguration(String key) {
    }

    @Override
    public List<ContentTypeConfigTO> getAllowedContentTypesForPath(String site, String relativePath) throws ServiceException {
        String user = this.securityService.getCurrentUser();
        Set<String> userRoles = this.securityService.getUserRoles(site, user);
        SiteContentTypePathsTO pathsConfig = this.contentTypesConfig.getPathMapping(site);
        if (pathsConfig != null && pathsConfig.getConfigs() != null) {
            ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
            HashSet<String> contentKeys = new HashSet<String>();
            for (ContentTypePathTO pathConfig : pathsConfig.getConfigs()) {
                if (!relativePath.matches(pathConfig.getPathInclude())) continue;
                logger.debug(relativePath + " matches " + pathConfig.getPathInclude(), new Object[0]);
                Set<String> allowedContentTypes = pathConfig.getAllowedContentTypes();
                if (!CollectionUtils.isNotEmpty(allowedContentTypes)) continue;
                for (String key : allowedContentTypes) {
                    if (!contentKeys.contains(key)) {
                        logger.debug("Checking an allowed content type: " + key, new Object[0]);
                        ContentTypeConfigTO typeConfig = this.contentTypesConfig.getContentTypeConfig(key);
                        if (typeConfig != null) {
                            boolean isMatch = true;
                            if (typeConfig.getPathExcludes() != null) {
                                for (String excludePath : typeConfig.getPathExcludes()) {
                                    if (!relativePath.matches(excludePath)) continue;
                                    logger.debug(relativePath + " matches an exclude path: " + excludePath, new Object[0]);
                                    isMatch = false;
                                    break;
                                }
                            }
                            if (isMatch) {
                                logger.debug("adding " + key + " to content types.", new Object[0]);
                                this.addContentTypes(site, userRoles, typeConfig, contentTypes);
                            }
                        } else {
                            logger.warn("no configuration found for " + key, new Object[0]);
                        }
                        contentKeys.add(key);
                        continue;
                    }
                    logger.debug(key + " is already added. skipping the content type.", new Object[0]);
                }
            }
            return contentTypes;
        }
        logger.error("No content type path configuration is found for site: " + site, new Object[0]);
        return null;
    }

    protected void addContentTypes(String site, Set<String> userRoles, ContentTypeConfigTO config, List<ContentTypeConfigTO> contentTypes) {
        boolean isAllowed = this.isUserAllowed(userRoles, config);
        if (isAllowed) {
            contentTypes.add(config);
        }
    }

    @Override
    public boolean changeContentType(String site, String path, String contentType) throws ServiceException {
        ContentTypeConfigTO contentTypeConfigTO = this.getContentType(site, contentType);
        if (contentTypeConfigTO.getFormPath().equalsIgnoreCase("simple")) {
            return true;
        }
        String fullPath = this.contentService.expandRelativeSitePath(site, path);
        ContentItemTO item = this.contentService.getContentItem(site, path, 0);
        if (item != null) {
            this.contentService.lockContent(site, path);
            Document original = null;
            try {
                original = this.contentService.getContentAsDocument(fullPath);
            }
            catch (DocumentException e) {
                logger.error("Error while getting document for " + fullPath, (Exception)((Object)e), new Object[0]);
                return false;
            }
            throw new RuntimeException("Is it getting here?");
        }
        throw new ContentNotFoundException(path + " is not a valid content path.");
    }

    @Override
    public void reloadConfiguration(String site) {
        String contentTypesRootPath = this.configPath.replaceAll("\\{site\\}", site);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(contentTypesRootPath);
        ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                this.reloadContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
    }

    protected void reloadContentTypeConfigForChildren(String site, RepositoryItem node, List<ContentTypeConfigTO> contentTypes) {
        String fullPath = node.path + "/" + node.name;
        logger.debug("Get Content Type Config fot Children path = {0}", fullPath);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(fullPath);
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                ContentTypeConfigTO config;
                if (!folders[i].isFolder) continue;
                String configPath = folders[i].path + "/" + folders[i].name + "/" + this.configFileName;
                if (this.contentService.contentExists(configPath) && (config = this.contentTypesConfig.loadConfiguration(site, configPath)) != null) {
                    contentTypes.add(config);
                }
                this.reloadContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(ContentTypeService.class, this);
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentTypesConfig getContentTypesConfig() {
        return this.contentTypesConfig;
    }

    public void setContentTypesConfig(ContentTypesConfig contentTypesConfig) {
        this.contentTypesConfig = contentTypesConfig;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    @Override
    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

