/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.script.ScriptExecutor;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.spring.context.ApplicationContextProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class DmContentLifeCycleServiceImpl
extends AbstractRegistrableService
implements DmContentLifeCycleService {
    private static final Logger logger = LoggerFactory.getLogger(DmContentLifeCycleServiceImpl.class);
    protected String scriptLocation;
    protected Map<String, Object> _scriptObjects;
    protected ContentService contentService;
    protected SecurityService securityService;
    protected ScriptExecutor scriptExecutor;

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public Map<String, Object> getScriptObjects() {
        return this._scriptObjects;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this._scriptObjects = scriptObjects;
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(DmContentLifeCycleService.class, this);
    }

    @Override
    public void process(String site, String user, String path, String contentType, DmContentLifeCycleService.ContentLifeCycleOperation operation, Map<String, String> params) {
        if (operation == null) {
            logger.warn("No lifecycle operation provided for " + site + ":" + path, new Object[0]);
            return;
        }
        if (StringUtils.isEmpty((String)contentType)) {
            logger.warn("Skipping content lifecycle script execution. no content type provided for " + site + ":" + path, new Object[0]);
            return;
        }
        String scriptPath = this.getScriptPath(site, contentType);
        if (!this.contentService.contentExists(scriptPath)) {
            logger.error("No script found at " + scriptPath + ", contentType: " + contentType, new Object[0]);
            return;
        }
        String script = this.contentService.getContentAsString(scriptPath);
        Map<String, Object> model = this.buildModel(site, user, path, contentType, operation.toString(), params);
        try {
            this.scriptExecutor.executeScriptString(script, model);
        }
        catch (Exception e) {
            logger.error("Error while executing content lifecycle script for " + site + ":" + path, e, new Object[0]);
        }
    }

    protected String getScriptPath(String site, String contentType) {
        String location = this.scriptLocation.replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        return location;
    }

    protected Map<String, Object> buildModel(String site, String user, String path, String contentType, String operation, Map<String, String> params) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (String scriptObjectName : this._scriptObjects.keySet()) {
            model.put(scriptObjectName, this._scriptObjects.get(scriptObjectName));
        }
        model.put("site", site);
        model.put("path", path);
        model.put("fullPath", this.contentService.expandRelativeSitePath(site, path));
        user = StringUtils.isEmpty((String)user) ? this.securityService.getCurrentUser() : user;
        model.put("user", user);
        model.put("contentType", contentType);
        model.put("contentLifecycleOperation", operation);
        model.put("contentLoader", new XmlContentLoader());
        model.put("applicationContext", ApplicationContextProvider.getApplicationContext());
        if (params != null) {
            for (String key : params.keySet()) {
                model.put(key, params.get(key));
            }
        }
        return model;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public class XmlContentLoader
    implements Serializable {
        private static final long serialVersionUID = -7848136703282922101L;

        public Document getContent(String fullPath) {
            InputStream is = null;
            try {
                is = DmContentLifeCycleServiceImpl.this.contentService.getContent(fullPath);
                SAXReader saxReader = new SAXReader();
                Document content = saxReader.read(is);
                return content;
            }
            catch (DocumentException e) {
                logger.error("Error while reading content from " + fullPath, (Exception)((Object)e), new Object[0]);
                if (is != null) {
                    ContentUtils.release(is);
                }
                return null;
            }
            catch (ContentNotFoundException e) {
                logger.error("Error while reading content from " + fullPath, e, new Object[0]);
                if (is != null) {
                    ContentUtils.release(is);
                }
                return null;
            }
        }
    }
}

