/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.script.ScriptExecutor;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmMetadataService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.impl.v1.util.ValueConverter;
import org.craftercms.studio.impl.v1.util.spring.context.ApplicationContextProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DmMetadataServiceImpl
extends AbstractRegistrableService
implements DmMetadataService {
    private static final Logger logger = LoggerFactory.getLogger(DmMetadataServiceImpl.class);
    public static final int VERSION_TO_LOOK_UP = -1;
    protected ValueConverter converter = new ValueConverter();
    protected String scriptLocation = "";
    protected Map<String, Object> scriptObjects;
    protected SecurityService securityService;
    protected ContentService contentService;
    protected ScriptExecutor scriptExecutor;

    @Override
    public void register() {
        this.getServicesManager().registerService(DmMetadataService.class, this);
    }

    @Override
    public void extractMetadata(String site, String user, String path, String contentType, Document content) throws ServiceException {
        user = StringUtils.isEmpty((String)user) ? this.securityService.getCurrentUser() : user;
        String fullPath = this.contentService.expandRelativeSitePath(site, path);
        if (content == null) {
            try {
                this.contentService.getContentAsDocument(fullPath);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        contentType = StringUtils.isEmpty((String)contentType) ? this.getContentType(content) : contentType;
        String actionedUponPath = this.contentService.expandRelativeSitePath(site, path);
        String scriptPath = this.getScriptPath(site, contentType);
        if (this.contentService.contentExists(scriptPath)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            if (this.scriptObjects != null && this.scriptObjects.size() > 0) {
                for (String scriptObjectName : this.scriptObjects.keySet()) {
                    model.put(scriptObjectName, this.scriptObjects.get(scriptObjectName));
                }
            }
            if (!StringUtils.isEmpty((String)actionedUponPath)) {
                model.put("nodeRef", actionedUponPath);
            }
            model.put("contentXml", content.getDocument());
            model.put("site", site);
            model.put("path", path);
            model.put("user", user);
            model.put("contentType", contentType);
            model.put("applicationContext", ApplicationContextProvider.getApplicationContext());
            try {
                String script = this.contentService.getContentAsString(scriptPath);
                this.scriptExecutor.executeScriptString(script, model);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        } else {
            logger.error("No script found at " + scriptPath + ", contentType: " + contentType, new Object[0]);
        }
    }

    protected String getContentType(Document content) {
        if (content != null) {
            Element root = content.getRootElement();
            return root.valueOf("//content-type");
        }
        return null;
    }

    protected String getScriptPath(String site, String contentType) {
        String location = this.scriptLocation.replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        return location;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public Map<String, Object> getScriptObjects() {
        return this.scriptObjects;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this.scriptObjects = scriptObjects;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }
}

