/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.PageNavigationOrder;
import org.craftercms.studio.api.v1.dal.PageNavigationOrderMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;

public class DmPageNavigationOrderServiceImpl
extends AbstractRegistrableService
implements DmPageNavigationOrderService {
    private static final Logger logger = LoggerFactory.getLogger(DmPageNavigationOrderServiceImpl.class);
    protected GeneralLockService generalLockService;
    protected ContentService contentService;
    protected int pageNavigationOrderIncrement = 1000;
    @Autowired
    protected PageNavigationOrderMapper pageNavigationOrderMapper;

    @Override
    public void register() {
        this._servicesManager.registerService(DmPageNavigationOrderService.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getNewNavOrder(String site, String path) {
        String lockId = site + ":" + path;
        this.generalLockService.lock(lockId);
        float lastNavOrder = 1000.0f;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", path);
            PageNavigationOrder pageNavigationOrder = this.pageNavigationOrderMapper.getPageNavigationOrderForSiteAndPath(params);
            if (pageNavigationOrder == null) {
                pageNavigationOrder = new PageNavigationOrder();
                pageNavigationOrder.setSite(site);
                pageNavigationOrder.setPath(path);
                ContentItemTO itemTreeTO = this.contentService.getContentItemTree(site, path, 1);
                if (itemTreeTO == null) {
                    pageNavigationOrder.setMaxCount(0.0f);
                } else {
                    if (StringUtils.isEmpty((String)itemTreeTO.getNodeRef())) {
                        pageNavigationOrder.setFolderId(UUID.randomUUID().toString());
                    } else {
                        pageNavigationOrder.setFolderId(itemTreeTO.getNodeRef());
                    }
                    pageNavigationOrder.setMaxCount(1000.0f * (float)itemTreeTO.getNumOfChildren());
                }
                this.pageNavigationOrderMapper.insert(pageNavigationOrder);
            } else {
                float newMaxCount = pageNavigationOrder.getMaxCount() + (float)this.pageNavigationOrderIncrement;
                pageNavigationOrder.setMaxCount(newMaxCount);
                this.pageNavigationOrderMapper.update(pageNavigationOrder);
            }
            lastNavOrder = pageNavigationOrder.getMaxCount();
        }
        catch (Exception e) {
            logger.error("Unexpected error: ", e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(lockId);
        }
        return lastNavOrder;
    }

    @Override
    public boolean addNavOrder(String site, String path, Document document) {
        boolean docUpdated = false;
        Element root = document.getRootElement();
        Node navOrderNode = root.selectSingleNode("//orderDefault_f");
        if (navOrderNode != null) {
            String newOrder = String.valueOf(this.getNewNavOrder(site, path));
            ((Element)navOrderNode).setText(newOrder);
            docUpdated = true;
        }
        return docUpdated;
    }

    @Override
    public boolean updateNavOrder(String site, String path, Document document) {
        boolean docUpdated = false;
        Element root = document.getRootElement();
        Node navOrderNode = root.selectSingleNode("//orderDefault_f");
        if (navOrderNode != null) {
            String value = ((Element)navOrderNode).getText();
            if (StringUtils.isEmpty((String)value)) {
                String newOrder = String.valueOf(this.getNewNavOrder(site, path));
                ((Element)navOrderNode).setText(newOrder);
                docUpdated = true;
            } else {
                logger.debug("Nav Order value already exist: " + value, new Object[0]);
            }
        }
        return docUpdated;
    }

    @Override
    public void deleteSequencesForSite(String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.pageNavigationOrderMapper.deleteSequencesForSite(params);
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public int getPageNavigationOrderIncrement() {
        return this.pageNavigationOrderIncrement;
    }

    public void setPageNavigationOrderIncrement(int pageNavigationOrderIncrement) {
        this.pageNavigationOrderIncrement = pageNavigationOrderIncrement;
    }
}

