/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.ObjectMetadata;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.listener.DmWorkflowListener;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.content.DmRenameService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyRules;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.service.workflow.context.GoLiveContext;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowProcessor;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreGoLiveOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreScheduleOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.SubmitLifeCycleOperation;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;

public class DmRenameServiceImpl
extends AbstractRegistrableService
implements DmRenameService {
    private static final Logger logger = LoggerFactory.getLogger(DmRenameServiceImpl.class);
    protected SecurityService securityService;
    protected ContentService contentService;
    protected ObjectStateService objectStateService;
    protected WorkflowService workflowService;
    protected ActivityService activityService;
    protected DmContentLifeCycleService dmContentLifeCycleService;
    protected DmWorkflowListener dmWorkflowListener;
    protected DmPublishService dmPublishService;
    protected WorkflowProcessor workflowProcessor;
    protected ObjectMetadataManager objectMetadataManager;
    protected DmDependencyService dmDependencyService;

    @Override
    public void register() {
        this.getServicesManager().registerService(DmRenameService.class, this);
    }

    protected String getIndexFilePath(String path) {
        if (!path.endsWith(".xml")) {
            path = path + "/" + "index.xml";
        }
        return path;
    }

    @Override
    public boolean isItemRenamed(String site, DmDependencyTO item) {
        if (item.getUri().endsWith(".xml") || !item.getUri().contains(".")) {
            return this.isItemRenamed(site, item.getUri());
        }
        return false;
    }

    @Override
    public boolean isItemRenamed(String site, String uri) {
        return this.objectMetadataManager.isRenamed(site, uri);
    }

    @Override
    public void goLive(String site, List<DmDependencyTO> submittedItems, String approver, MultiChannelPublishingContext mcpContext) throws ServiceException {
        long start = System.currentTimeMillis();
        try {
            Date now = new Date();
            Map<Date, List<DmDependencyTO>> groupedPackages = this.workflowService.groupByDate(submittedItems, now);
            for (Date scheduledDate : groupedPackages.keySet()) {
                this.submitWorkflow(site, groupedPackages.get(scheduledDate), now, scheduledDate, approver, mcpContext);
            }
        }
        catch (ContentNotFoundException e) {
            throw new ServiceException("Error during go live", e);
        }
        catch (ServiceException e) {
            throw new ServiceException("Error during go live", e);
        }
        long end = System.currentTimeMillis();
        logger.debug("Total go live time on rename item = " + (end - start), new Object[0]);
    }

    protected void submitWorkflow(String site, List<DmDependencyTO> submittedItems, Date now, Date scheduledDate, String approver, MultiChannelPublishingContext mcpContext) throws ServiceException {
        String assignee = "";
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> dependenices = new ArrayList<String>();
        Date launchDate = scheduledDate.equals(now) ? null : scheduledDate;
        boolean isScheduled = launchDate != null;
        String pathPrefix = "/wem-projects/" + site + "/" + site + "/work-area";
        StringBuilder label = new StringBuilder();
        label.append(isScheduled ? "Rename_Workflow_Scheduled" : "Rename_Workflow");
        label.append(":");
        HashSet<String> rescheduledUris = new HashSet<String>();
        for (DmDependencyTO submittedItem : submittedItems) {
            String workflowLabel = this.getWorkflowPaths(site, submittedItem, pathPrefix, paths, dependenices, isScheduled, rescheduledUris);
            label.append(workflowLabel);
            label.append(",");
        }
        HashSet<String> uris = new HashSet<String>();
        HashMap submittedBy = new HashMap();
        for (String path : paths) {
            String uri = path.substring(pathPrefix.length());
            uris.add(uri);
            this.dmPublishService.cancelScheduledItem(site, uri);
        }
        GoLiveContext context = new GoLiveContext(approver, site);
        SubmitLifeCycleOperation operation = null;
        if (launchDate == null) {
            operation = new PreGoLiveOperation(this.workflowService, uris, context, rescheduledUris);
        } else {
            for (String dependency : dependenices) {
                String uri = dependency.substring(pathPrefix.length());
                uris.add(uri);
            }
            operation = new PreScheduleOperation(this.workflowService, uris, launchDate, context, rescheduledUris);
        }
        this.workflowProcessor.addToWorkflow(site, paths, launchDate, label.toString(), operation, approver, mcpContext);
        logger.debug("Go live rename: paths posted " + paths + "for workflow scheduled at : " + launchDate, new Object[0]);
    }

    protected String getWorkflowPaths(String site, DmDependencyTO submittedItem, String pathPrefix, List<String> paths, List<String> dependenices, boolean isScheduled, Set<String> rescheduledUris) throws ContentNotFoundException, ServiceException {
        logger.debug("GoLive on renamed node " + submittedItem.getUri(), new Object[0]);
        ArrayList<String> childUris = new ArrayList<String>();
        String submittedUri = submittedItem.getUri();
        List<String> submittedChildUris = this.getSubmittedChildUri(submittedItem);
        if (submittedUri.endsWith(".xml") && !submittedUri.endsWith("index.xml")) {
            childUris.add(submittedUri);
        } else {
            this.getChildrenUri(site, ContentUtils.getParentUrl(submittedItem.getUri()), childUris);
        }
        StringBuilder label = new StringBuilder();
        label.append(ContentUtils.getParentUrl(submittedUri));
        for (String uri : childUris) {
            String oldStagingUri = this.objectMetadataManager.getOldPath(site, uri);
            if (oldStagingUri != null && this.isRenameDeleteTag(site, uri) && (!submittedUri.endsWith(".xml") || submittedUri.endsWith("index.xml"))) {
                String string = ContentUtils.getParentUrl(oldStagingUri);
            }
            if (!submittedChildUris.contains(uri) && !submittedItem.getUri().equals(uri)) continue;
            paths.add(pathPrefix + uri);
            List<String> refPaths = this.getReferencePaths(site, uri, submittedItem, pathPrefix, rescheduledUris);
            dependenices.addAll(refPaths);
            if (isScheduled || refPaths == null || refPaths.size() <= 0) continue;
            paths.addAll(refPaths);
        }
        return label.toString();
    }

    protected List<String> getSubmittedChildUri(DmDependencyTO submittedItem) {
        ArrayList<String> childUri = new ArrayList<String>();
        if (submittedItem.getChildren() != null) {
            for (DmDependencyTO child : submittedItem.getChildren()) {
                childUri.add(child.getUri());
            }
        }
        return childUri;
    }

    protected List<String> getChildrenUri(String site, String path, List<String> paths) {
        ContentItemTO itemTree = this.contentService.getContentItemTree(site, path, 1);
        if (itemTree.getNumOfChildren() > 0) {
            for (ContentItemTO child : itemTree.getChildren()) {
                this.getChildrenUri(site, child.getUri(), paths);
            }
        } else {
            paths.add(itemTree.getUri());
        }
        return paths;
    }

    protected boolean isRenameDeleteTag(String site, String uri) {
        ObjectMetadata metadata = this.objectMetadataManager.getProperties(site, uri);
        return StringUtils.isEmpty((String)metadata.getDeleteUrl());
    }

    protected List<String> getReferencePaths(String site, String uri, DmDependencyTO submittedItem, String pathPrefix, Set<String> rescheduledUris) throws ServiceException {
        DmDependencyTO to = null;
        ArrayList<String> depedencyPaths = new ArrayList<String>();
        if (uri.equals(submittedItem.getUri())) {
            to = submittedItem;
        } else {
            if (submittedItem.getChildren() == null) {
                return null;
            }
            for (DmDependencyTO depedencyTo : submittedItem.getChildren()) {
                if (!uri.equals(depedencyTo.getUri())) continue;
                to = depedencyTo;
                break;
            }
        }
        if (this.workflowService.isRescheduleRequest(to, site)) {
            rescheduledUris.add(to.getUri());
        }
        this.dmWorkflowListener.postGolive(site, to);
        DependencyRules rule = new DependencyRules(site);
        rule.setContentService(this.contentService);
        rule.setObjectStateService(this.objectStateService);
        Set<DmDependencyTO> dependencyTOSet = rule.applySubmitRule(to);
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            depedencyPaths.add(pathPrefix + dependencyTO.getUri());
            this.dmWorkflowListener.postGolive(site, dependencyTO);
        }
        return depedencyPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String site, String sourcePath, String targetPath, boolean createFolder) throws ServiceException, ContentNotFoundException {
        long start = System.currentTimeMillis();
        if (!sourcePath.endsWith(".xml")) {
            String string = sourcePath = sourcePath.endsWith("/") ? sourcePath + "index.xml" : sourcePath + "/" + "index.xml";
        }
        if (!targetPath.endsWith(".xml")) {
            targetPath = targetPath.endsWith("/") ? targetPath + "index.xml" : targetPath + "/" + "index.xml";
        }
        logger.debug("Rename - starting to move contents from source:" + sourcePath + " to destination: " + targetPath, new Object[0]);
        String user = this.securityService.getCurrentUser();
        String srcOrgFullPath = this.contentService.expandRelativeSitePath(site, sourcePath);
        String dstOrgFullPath = this.contentService.expandRelativeSitePath(site, targetPath);
        String srcFullPath = srcOrgFullPath;
        if (srcFullPath.endsWith("index.xml")) {
            srcFullPath = ContentUtils.getParentUrl(srcFullPath);
        }
        String srcNodeName = ContentUtils.getPageName(srcFullPath);
        String srcNodeParentUrl = ContentUtils.getParentUrl(srcFullPath);
        String dstFullPath = dstOrgFullPath;
        if (dstFullPath.endsWith("index.xml")) {
            dstFullPath = ContentUtils.getParentUrl(dstFullPath);
        }
        if (dstFullPath == null) {
            throw new ServiceException("Error while moving content. " + targetPath + " is not valid.");
        }
        String dstNodeName = ContentUtils.getPageName(dstFullPath);
        String dstNodeParentUrl = ContentUtils.getParentUrl(dstFullPath);
        this.preRenameCleanWorkFlow(site, sourcePath);
        String dstNodeParentPath = this.contentService.getRelativeSitePath(site, dstNodeParentUrl);
        String dstPath = this.contentService.getRelativeSitePath(site, dstFullPath);
        if (srcNodeParentUrl.equalsIgnoreCase(dstNodeParentUrl)) {
            ContentItemTO srcItem = this.contentService.getContentItem(srcFullPath);
            if (srcItem != null && srcItem.isFolder() && dstFullPath.endsWith(".xml")) {
                this.contentService.moveContent(site, this.contentService.getRelativeSitePath(site, srcFullPath), targetPath);
            } else if (srcItem != null && !srcItem.isFolder() && !dstFullPath.endsWith(".xml")) {
                this.contentService.createFolder(site, dstNodeParentPath, dstNodeName);
                this.contentService.moveContent(site, this.contentService.getRelativeSitePath(site, srcFullPath), dstPath);
            } else {
                this.contentService.moveContent(site, this.contentService.getRelativeSitePath(site, srcFullPath), dstPath);
            }
        } else {
            this.contentService.moveContent(site, this.contentService.getRelativeSitePath(site, srcFullPath), dstPath);
        }
        ContentItemTO item = this.contentService.getContentItem(site, this.contentService.getRelativeSitePath(site, dstFullPath));
        if (item == null) {
            throw new ContentNotFoundException("Error while moving content " + dstFullPath + " does not exist.");
        }
        String renamedUri = item.getUri();
        String storedStagingUri = this.objectMetadataManager.getOldPath(site, renamedUri);
        this.objectStateService.updateObjectPath(site, sourcePath, renamedUri);
        if (storedStagingUri == null) {
            this.addRenameUriDeleteProperty(site, renamedUri);
        }
        this.postRenameUpdateStatus(user, site, targetPath, sourcePath, true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourcePath", sourcePath);
        params.put("targetPath", targetPath);
        params.put("sourceFullPath", srcOrgFullPath);
        params.put("targetFullPath", dstOrgFullPath);
        String contentTypeClass = this.contentService.getContentTypeClass(site, this.contentService.getRelativeSitePath(site, dstOrgFullPath));
        this.dmContentLifeCycleService.process(site, user, targetPath, contentTypeClass, DmContentLifeCycleService.ContentLifeCycleOperation.RENAME, params);
        long end = System.currentTimeMillis();
        logger.debug("Total time to rename = " + (end - start), new Object[0]);
    }

    protected void preRenameCleanWorkFlow(String site, String path) throws ServiceException {
        if (path.endsWith("index.xml")) {
            path = ContentUtils.getParentUrl(path);
        }
        ContentItemTO item = this.contentService.getContentItem(site, path);
        ArrayList<String> childUris = new ArrayList<String>();
        if (item != null) {
            this.getChildrenUri(site, item.getUri(), childUris);
        }
        try {
            ArrayList<String> transitionNodes = new ArrayList<String>();
            for (String childUri : childUris) {
                this.workflowService.removeFromWorkflow(site, childUri, true);
                ContentItemTO childItem = this.contentService.getContentItem(site, this.getIndexFilePath(childUri));
                if (childItem == null) continue;
                transitionNodes.add(childUri);
            }
            if (!transitionNodes.isEmpty()) {
                this.objectStateService.transitionBulk(site, transitionNodes, TransitionEvent.SAVE, State.NEW_UNPUBLISHED_UNLOCKED);
            }
        }
        catch (Exception e) {
            logger.error("Error during clean workflow", e, new Object[0]);
            throw new ServiceException("Error during clean workflow", e);
        }
    }

    protected void addRenameUriDeleteProperty(String site, String relativePath) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("deleteUrl", true);
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
    }

    protected void postRenameUpdateStatus(String user, String site, String path, String oldPath, boolean addNodeProperty) throws ContentNotFoundException {
        path = this.getIndexFilePath(path);
        oldPath = this.getIndexFilePath(oldPath);
        String srcFullPath = this.contentService.expandRelativeSitePath(site, path);
        ContentItemTO itemTO = this.contentService.getContentItem(site, path);
        ArrayList<String> transitionItems = new ArrayList<String>();
        if (itemTO == null) {
            srcFullPath = srcFullPath.replace("/index.xml", "");
            oldPath = oldPath.replace("/index.xml", "");
            itemTO = this.contentService.getContentItem(srcFullPath);
        }
        if (srcFullPath.endsWith("index.xml")) {
            String parentNodePath = ContentUtils.getParentUrl(srcFullPath);
            String parentRelativePath = this.contentService.getRelativeSitePath(site, parentNodePath);
            ContentItemTO parentItem = this.contentService.getContentItem(site, parentRelativePath);
            this.updateChildItems(site, parentItem, oldPath, path, addNodeProperty, user, false);
        } else {
            ContentItemTO parentItem = this.contentService.getContentItem(srcFullPath);
            this.updateChildItems(site, parentItem, oldPath, path, addNodeProperty, user, true);
        }
        ArrayList<String> childUris = new ArrayList<String>();
        if (itemTO != null) {
            transitionItems.add(itemTO.getUri());
            this.getChildrenUri(site, itemTO.getUri(), childUris);
        }
        for (String childUri : childUris) {
            ContentItemTO childItem = this.contentService.getContentItem(site, childUri);
            if (childItem == null) continue;
            transitionItems.add(childItem.getUri());
        }
        if (!transitionItems.isEmpty()) {
            this.objectStateService.transitionBulk(site, transitionItems, TransitionEvent.SAVE, State.NEW_UNPUBLISHED_UNLOCKED);
        }
    }

    protected void updateChildItems(String site, ContentItemTO node, String parentOldPath, String parentNewPath, boolean addNodeProperty, String user, boolean fileContent) {
        ContentItemTO itemTree = this.contentService.getContentItemTree(site, node.getUri(), 1);
        if (itemTree.getNumOfChildren() > 0) {
            for (ContentItemTO child : itemTree.getChildren()) {
                this.updateChildItems(site, child, parentOldPath, parentNewPath, addNodeProperty, user, fileContent);
            }
        } else {
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            String relativePath = node.getUri();
            this.addItemPropertyToChildren(site, relativePath, parentNewPath, parentOldPath, addNodeProperty, user, fileContent);
            extraInfo.put("contentType", this.contentService.getContentTypeClass(site, this.getIndexFilePath(relativePath)));
            this.activityService.postActivity(site, user, this.getIndexFilePath(relativePath), ActivityService.ActivityType.UPDATED, extraInfo);
        }
    }

    protected void addItemPropertyToChildren(String site, String relativePath, String renamedPath, String oldPath, boolean addNodeProperty, String user, boolean fileContent) {
        String oldUri = fileContent ? oldPath : relativePath.replace(ContentUtils.getParentUrl(renamedPath), ContentUtils.getParentUrl(oldPath));
        this.objectStateService.updateObjectPath(site, oldUri, relativePath);
        this.objectMetadataManager.updateObjectPath(site, oldUri, relativePath);
        ObjectMetadata metadata = this.objectMetadataManager.getProperties(site, relativePath);
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (addNodeProperty && StringUtils.isEmpty((String)metadata.getOldUrl()) && fileContent) {
            properties.put("renamed", 1);
            if (StringUtils.isEmpty((String)metadata.getOldUrl())) {
                properties.put("oldUrl", oldUri);
            }
        } else {
            String indexRelativePath = this.getIndexFilePath(relativePath);
            metadata = this.objectMetadataManager.getProperties(site, indexRelativePath);
            if (metadata == null) {
                metadata = new ObjectMetadata();
            }
            properties.put("renamed", 1);
            if (StringUtils.isEmpty((String)metadata.getOldUrl())) {
                properties.put("oldUrl", oldUri);
            }
        }
        properties.put("modifier", user);
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
        try {
            Document document = this.contentService.getContentAsDocument(this.contentService.expandRelativeSitePath(site, relativePath));
            HashMap<String, Set<String>> globalDeps = new HashMap<String, Set<String>>();
            this.dmDependencyService.extractDependencies(site, relativePath, document, globalDeps);
        }
        catch (Exception e) {
            logger.error("Error during extracting dependency of " + relativePath, e, new Object[0]);
        }
        this.updateGoLiveQueue(site, relativePath, oldUri);
        this.updateActivity(site, oldUri, relativePath);
    }

    protected void updateGoLiveQueue(String site, String newFullPath, String oldUri) {
    }

    protected void updateActivity(String site, String oldUrl, String newUrl) {
        logger.debug("Updating activity url post rename:" + newUrl, new Object[0]);
        this.activityService.renameContentId(site, oldUrl, newUrl);
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public DmContentLifeCycleService getDmContentLifeCycleService() {
        return this.dmContentLifeCycleService;
    }

    public void setDmContentLifeCycleService(DmContentLifeCycleService dmContentLifeCycleService) {
        this.dmContentLifeCycleService = dmContentLifeCycleService;
    }

    public DmWorkflowListener getDmWorkflowListener() {
        return this.dmWorkflowListener;
    }

    public void setDmWorkflowListener(DmWorkflowListener dmWorkflowListener) {
        this.dmWorkflowListener = dmWorkflowListener;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public WorkflowProcessor getWorkflowProcessor() {
        return this.workflowProcessor;
    }

    public void setWorkflowProcessor(WorkflowProcessor workflowProcessor) {
        this.workflowProcessor = workflowProcessor;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }
}

