/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.dal.ObjectMetadata;
import org.craftercms.studio.api.v1.dal.ObjectMetadataMapper;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectMetadataManagerImpl
implements ObjectMetadataManager {
    @Autowired
    protected ObjectMetadataMapper objectMetadataMapper;

    @Override
    public void insertNewObjectMetadata(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.objectMetadataMapper.insertEntry(params);
    }

    @Override
    public void setObjectMetadata(String site, String path, Map<String, Object> properties) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.putAll(properties);
        this.objectMetadataMapper.setProperties(params);
    }

    @Override
    public ObjectMetadata getProperties(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        return this.objectMetadataMapper.getProperties(params);
    }

    @Override
    public boolean metadataExist(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        int cnt = this.objectMetadataMapper.countEntries(params);
        if (cnt < 1) {
            return false;
        }
        return cnt <= 1;
    }

    @Override
    public boolean isRenamed(String site, String path) {
        if (this.metadataExist(site, path)) {
            ObjectMetadata metadata = this.getProperties(site, path);
            return metadata.getRenamed() > 0;
        }
        return false;
    }

    @Override
    public String getOldPath(String site, String path) {
        if (this.metadataExist(site, path)) {
            ObjectMetadata metadata = this.getProperties(site, path);
            return metadata.getOldUrl();
        }
        return "";
    }

    @Override
    public void lockContent(String site, String path, String lockOwner) {
        if (!this.metadataExist(site, path)) {
            this.insertNewObjectMetadata(site, path);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", lockOwner);
        this.objectMetadataMapper.setLockOwner(params);
    }

    @Override
    public void unLockContent(String site, String path) {
        if (!this.metadataExist(site, path)) {
            this.insertNewObjectMetadata(site, path);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", "");
        this.objectMetadataMapper.setLockOwner(params);
    }

    @Override
    public void deleteObjectMetadataForSite(String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.objectMetadataMapper.deleteObjectMetadataForSite(params);
    }

    @Override
    public void deleteObjectMetadata(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", site);
        this.objectMetadataMapper.deleteEntry(params);
    }

    @Override
    public void updateObjectPath(String site, String oldPath, String newPath) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.objectMetadataMapper.updateObjectPath(params);
    }

    @Override
    public void clearRenamed(String site, String path) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("renamed", false);
        params.put("oldUrl", "");
        this.setObjectMetadata(site, path, params);
    }
}

