/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.dependency;

import java.util.Iterator;
import java.util.List;
import javolution.util.FastList;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmDependencyDiffService
extends AbstractRegistrableService {
    private static final Logger logger = LoggerFactory.getLogger(DmDependencyDiffService.class);

    @Override
    public void register() {
        this.getServicesManager().registerService(DmDependencyDiffService.class, this);
    }

    public DiffResponse diff(DiffRequest diffRequest) throws ServiceException {
        if (diffRequest == null) {
            throw new ServiceException("diffcontext cannot be null");
        }
        DiffResponse response = new DiffResponse();
        boolean recursive = diffRequest.isRecursive();
        String site = diffRequest.getSite();
        String sourcePath = diffRequest.getSourcePath();
        String destPath = diffRequest.getDestPath();
        if (StringUtils.isEmpty((String)destPath)) {
            destPath = sourcePath;
        }
        Object sourceDependencies = new FastList();
        sourceDependencies = this.findDependencies(site, diffRequest.getSourceSandbox(), sourcePath, recursive, (List<String>)sourceDependencies);
        Object destDependencies = new FastList();
        destDependencies = this.findDependencies(site, diffRequest.getDestSandbox(), destPath, recursive, (List<String>)destDependencies);
        Iterator i$ = destDependencies.iterator();
        while (i$.hasNext()) {
            String destDependency = (String)i$.next();
            if (sourceDependencies.contains(destDependency)) continue;
            response.removedDependenices.add(destDependency);
        }
        i$ = sourceDependencies.iterator();
        while (i$.hasNext()) {
            String sourceDependency = (String)i$.next();
            if (destDependencies.contains(sourceDependency)) continue;
            response.addedDependencies.add(sourceDependency);
        }
        return response;
    }

    protected List<String> findDependencies(String site, String sandbox, String relativePath, boolean isRecursive, List<String> dependencies) throws ServiceException {
        DmDependencyService dmDependencyService = this.getService(DmDependencyService.class);
        List<String> dependenciesFromDoc = dmDependencyService.getDependencyPaths(site, relativePath);
        dependencies.addAll(dependenciesFromDoc);
        if (isRecursive) {
            for (String dependency : dependenciesFromDoc) {
                if (dependencies.contains(dependency)) continue;
                dependencies.addAll(this.findDependencies(site, sandbox, dependency, isRecursive, dependencies));
            }
        }
        return dependencies;
    }

    protected List<String> convertDependencyTO(List<DmDependencyTO> dependency) {
        FastList dependencyUris = new FastList();
        for (DmDependencyTO to : dependency) {
            dependencyUris.add(to.getUri());
        }
        return dependencyUris;
    }

    public static class DiffRequest {
        protected String site;
        protected String sourcePath;
        protected String destPath;
        protected String sourceSandbox;
        protected String destSandbox;
        protected Document sourceDoc;
        protected Document destDoc;
        protected boolean recursive = true;

        public DiffRequest(String site, String sourcePath, String destPath, String sourceSandbox, String destSandbox, boolean recursive) {
            this.site = site;
            this.sourcePath = sourcePath;
            this.destPath = destPath;
            this.sourceSandbox = sourceSandbox;
            this.destSandbox = destSandbox;
            this.recursive = recursive;
        }

        public String getSite() {
            return this.site;
        }

        public void setSite(String site) {
            this.site = site;
        }

        public String getSourceSandbox() {
            return this.sourceSandbox;
        }

        public void setSourceSandbox(String sourceSandbox) {
            this.sourceSandbox = sourceSandbox;
        }

        public String getDestSandbox() {
            return this.destSandbox;
        }

        public void setDestSandbox(String destSandbox) {
            this.destSandbox = destSandbox;
        }

        public Document getSourceDoc() {
            return this.sourceDoc;
        }

        public void setSourceDoc(Document sourceDoc) {
            this.sourceDoc = sourceDoc;
        }

        public Document getDestDoc() {
            return this.destDoc;
        }

        public void setDestDoc(Document destDoc) {
            this.destDoc = destDoc;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public String getDestPath() {
            return this.destPath;
        }

        public void setDestPath(String destPath) {
            this.destPath = destPath;
        }
    }

    public static class DiffResponse {
        protected List<String> addedDependencies = new FastList();
        protected List<String> removedDependenices = new FastList();

        public List<String> getAddedDependencies() {
            return this.addedDependencies;
        }

        public void setAddedDependencies(List<String> addedDependencies) {
            this.addedDependencies = addedDependencies;
        }

        public List<String> getRemovedDependenices() {
            return this.removedDependenices;
        }

        public void setRemovedDependenices(List<String> removedDependenices) {
            this.removedDependenices = removedDependenices;
        }
    }
}

