/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.dependency;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.DependencyEntity;
import org.craftercms.studio.api.v1.dal.DependencyMapper;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class DmDependencyServiceImpl
extends AbstractRegistrableService
implements DmDependencyService {
    private static final Logger logger = LoggerFactory.getLogger(DmDependencyServiceImpl.class);
    protected static final String JSON_KEY_ITEMS = "items";
    protected static final String JSON_KEY_SUBMISSION_COMMENT = "submissionComment";
    protected ContentService contentService;
    protected ServicesConfig servicesConfig;
    protected ObjectStateService objectStateService;
    protected List<String> ignoreDependenciesRules = new ArrayList<String>();
    @Autowired
    protected DependencyMapper dependencyMapper;

    @Override
    public void register() {
        this.getServicesManager().registerService(DmDependencyService.class, this);
    }

    protected List<ContentItemTO> getDependentItems(String site, String parentUri, List<DependencyEntity> dependencies, boolean populateUpdatedDependecinesOnly) {
        ArrayList<ContentItemTO> items = null;
        if (dependencies != null) {
            items = new ArrayList(dependencies.size());
            for (DependencyEntity dependency : dependencies) {
                String path = dependency.getTargetPath();
                ContentItemTO dependencyItem = null;
                dependencyItem = this.contentService.getContentItem(site, path);
                if (dependencyItem == null) continue;
                dependencyItem.setReference(true);
                dependencyItem.setMandatoryParent(parentUri);
                items.add(dependencyItem);
            }
        } else {
            items = new ArrayList<ContentItemTO>(0);
        }
        return items;
    }

    @Override
    public Map<String, Object> getDependencies(String site, String request, Boolean deleteDependencies) throws ServiceException {
        if (deleteDependencies == null) {
            deleteDependencies = false;
        }
        try {
            List<ContentItemTO> items = null;
            JSONArray jsonArray = (JSONArray)JSONSerializer.toJSON((Object)request);
            if (jsonArray != null && jsonArray.size() > 0) {
                ArrayList<String> submittedItems = new ArrayList<String>(jsonArray.size());
                ListIterator iterator = jsonArray.listIterator();
                while (iterator.hasNext()) {
                    JSONObject jsonObject = (JSONObject)iterator.next();
                    String uri = jsonObject.getString("uri");
                    submittedItems.add(uri);
                }
                DmContentItemComparator comparator = new DmContentItemComparator("browserUri", true, true, true);
                items = this.getDependencies(site, submittedItems, comparator, false, deleteDependencies);
            }
            StringBuilder sb = new StringBuilder();
            for (ContentItemTO item : items) {
                String comment = item.getSubmissionComment();
                if (!StringUtils.isNotEmpty((String)comment)) continue;
                sb.append(comment).append("\n");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(JSON_KEY_ITEMS, items);
            result.put(JSON_KEY_SUBMISSION_COMMENT, sb.toString());
            return result;
        }
        catch (RuntimeException e) {
            logger.error("Error getting dependecies", e, new Object[0]);
            throw e;
        }
        catch (ServiceException e) {
            logger.error("Error getting dependecies", e, new Object[0]);
            throw e;
        }
    }

    @Override
    public DmDependencyTO getDependencies(String site, String path, boolean populateUpdatedDependecinesOnly, boolean recursive) {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(path);
        HashSet<String> processedDependencies = new HashSet<String>();
        List<DmDependencyTO> items = this.getDependencyItems(site, paths, processedDependencies, populateUpdatedDependecinesOnly, recursive, false);
        if (items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    protected List<DmDependencyTO> getDependencyItems(String site, List<String> paths, Set<String> processedDependencies, boolean populateUpdatedDependecinesOnly, boolean recursive, boolean isDraftContent) {
        ArrayList<DmDependencyTO> items = new ArrayList<DmDependencyTO>(paths.size());
        ServicesConfig servicesConfig = this.getService(ServicesConfig.class);
        for (String path : paths) {
            if (processedDependencies.contains(path)) continue;
            processedDependencies.add(path);
            DmDependencyTO item = new DmDependencyTO();
            item.setUri(path);
            if (recursive && (ContentUtils.matchesPatterns(path, servicesConfig.getPagePatterns(site)) || ContentUtils.matchesPatterns(path, servicesConfig.getComponentPatterns(site)))) {
                try {
                    Document document = this.loadDocument(site, path);
                    if (document == null) {
                        return items;
                    }
                    Element root = document.getRootElement();
                    boolean skipDependencies = false;
                    String isSkipDependenciesValue = root.valueOf("//skipDependencies");
                    if (isSkipDependenciesValue != null && !"".equals(isSkipDependenciesValue)) {
                        skipDependencies = ContentFormatUtils.getBooleanValue(isSkipDependenciesValue);
                    }
                    if (skipDependencies) {
                        return items;
                    }
                    StringBuffer buffer = new StringBuffer(XmlUtils.convertDocumentToString(document));
                    List<String> assets = this.getDependentFileNames(site, buffer, populateUpdatedDependecinesOnly, servicesConfig.getAssetPatterns(site));
                    List<DmDependencyTO> assetItems = this.getDependencyItems(site, assets, processedDependencies, populateUpdatedDependecinesOnly, false, false);
                    item.setAssets(assetItems);
                    List<String> components = this.getDependentFileNames(site, buffer, populateUpdatedDependecinesOnly, servicesConfig.getComponentPatterns(site));
                    List<DmDependencyTO> compItems = this.getDependencyItems(site, components, processedDependencies, populateUpdatedDependecinesOnly, recursive, true);
                    item.setComponents(compItems);
                    List<String> documents = this.getDependentFileNames(site, buffer, populateUpdatedDependecinesOnly, servicesConfig.getDocumentPatterns(site));
                    List<DmDependencyTO> docItems = this.getDependencyItems(site, documents, processedDependencies, populateUpdatedDependecinesOnly, recursive, false);
                    item.setDocuments(docItems);
                    List<String> templates = this.getDependentFileNames(site, buffer, populateUpdatedDependecinesOnly, servicesConfig.getRenderingTemplatePatterns(site));
                    List<DmDependencyTO> templateItems = this.getDependencyItems(site, templates, processedDependencies, populateUpdatedDependecinesOnly, recursive, false);
                    item.setRenderingTemplates(templateItems);
                    List<String> pages = this.getDependentFileNames(site, buffer, populateUpdatedDependecinesOnly, servicesConfig.getPagePatterns(site));
                    List<DmDependencyTO> pageItems = this.getDependencyItems(site, pages, processedDependencies, populateUpdatedDependecinesOnly, recursive, false);
                    item.setPages(pageItems);
                }
                catch (ContentNotFoundException e) {
                    logger.error("Error while getting dependent file names for " + path + " in " + site, e, new Object[0]);
                }
                catch (IOException e) {
                    logger.error("Error while getting dependent file names for " + path + " in " + site, e, new Object[0]);
                }
            }
            items.add(item);
        }
        return items;
    }

    protected Document loadDocument(String site, String path) throws ContentNotFoundException {
        Document document = null;
        document = this.getDocument(site, path);
        return document;
    }

    protected Document getDocument(String site, String path) throws ContentNotFoundException {
        Document document = null;
        try {
            InputStream content = this.contentService.getContent(site, path);
            document = ContentUtils.convertStreamToXml(content);
        }
        catch (DocumentException e) {
            logger.error("Failed to convert content to XML document.", (Exception)((Object)e), new Object[0]);
        }
        return document;
    }

    protected List<String> getDependentFileNames(String site, StringBuffer buffer, boolean populateUpdatedDependecinesOnly, List<String> patterns) {
        ArrayList<String> files = new ArrayList<String>();
        if (patterns != null) {
            for (String patternStr : patterns) {
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(buffer);
                while (matcher.find()) {
                    String match = matcher.group();
                    if (files.contains(match)) continue;
                    files.add(match);
                }
            }
        }
        return files;
    }

    protected List<ContentItemTO> getDependencies(String site, List<String> submittedItems, DmContentItemComparator comparator, boolean multiLevelChildren) throws ServiceException {
        return this.getDependencies(site, submittedItems, comparator, multiLevelChildren, false);
    }

    protected List<ContentItemTO> getDependencies(String site, List<String> submittedItems, DmContentItemComparator comparator, boolean multiLevelChildren, boolean delDep) throws ServiceException {
        if (submittedItems != null) {
            ArrayList<ContentItemTO> items = new ArrayList<ContentItemTO>(submittedItems.size());
            HashSet<String> includedItems = new HashSet<String>();
            HashSet<String> includedDependencies = new HashSet<String>();
            for (String submittedItem : submittedItems) {
                boolean deleteDependencies = delDep;
                if (StringUtils.isEmpty((String)submittedItem) || includedItems.contains(submittedItem)) continue;
                try {
                    ContentItemTO item = null;
                    String fullPath = this.contentService.expandRelativeSitePath(site, submittedItem);
                    item = this.contentService.getContentItem(site, submittedItem);
                    if (item.isSubmittedForDeletion()) {
                        deleteDependencies = true;
                    }
                    if (deleteDependencies && item.isContainer()) {
                        String string = submittedItem.replace("index.xml", "");
                    }
                    this.retrieveDependencyItems(item, includedDependencies, deleteDependencies, site);
                    this.addDependencyItem(site, items, includedItems, includedDependencies, item, comparator, deleteDependencies);
                    if (delDep) continue;
                    List<String> levelDescs = this.getDependentLevelDescriptors(site, submittedItem, false, this.servicesConfig.getLevelDescriptorName(site));
                    for (String levelDesc : levelDescs) {
                        if (!this.objectStateService.isNew(site, levelDesc) || submittedItems.contains(levelDesc) || includedItems.contains(levelDesc)) continue;
                        includedItems.add(levelDesc);
                        ContentItemTO lvlItem = this.contentService.getContentItem(site, levelDesc);
                        this.retrieveDependencyItems(lvlItem, includedDependencies, deleteDependencies, site);
                        this.addDependencyItem(site, items, includedItems, includedDependencies, lvlItem, comparator, deleteDependencies);
                    }
                }
                catch (ContentNotFoundException e) {
                    logger.error("content not found [" + submittedItem + "]", e, new Object[0]);
                }
            }
            ArrayList<ContentItemTO> displayItems = new ArrayList<ContentItemTO>();
            ArrayList<String> allReferences = new ArrayList<String>();
            if (!multiLevelChildren) {
                for (ContentItemTO item : items) {
                    if (includedDependencies.contains(item.getUri())) continue;
                    List<ContentItemTO> targetChildren = item.getChildren();
                    List<ContentItemTO> pages = item.getPages();
                    item.setChildren(new ArrayList<ContentItemTO>());
                    item.setNumOfChildren(0);
                    this.flattenDependencies(item, targetChildren, comparator, item, allReferences);
                    this.flattenDependencies(item, pages, comparator, null, allReferences);
                    displayItems.add(item);
                }
            }
            this.removeDuplicateReferences(allReferences, displayItems);
            return displayItems;
        }
        throw new ServiceException("No items provided.");
    }

    protected void retrieveDependencyItems(ContentItemTO parentItem, Set<String> includedDependencies, boolean deleteDependency, String site) {
        List<ContentItemTO> levelDescriptorItems;
        List<ContentItemTO> documentItems;
        String contentType = parentItem.getContentType();
        if (contentType == null) {
            return;
        }
        List<DeleteDependencyConfigTO> deleteDependencyPatterns = this.servicesConfig.getDeleteDependencyPatterns(site, contentType);
        ArrayList<String> deletePattern = new ArrayList<String>();
        for (DeleteDependencyConfigTO dependencyConfigTO : deleteDependencyPatterns) {
            deletePattern.add(dependencyConfigTO.getPattern());
        }
        List<ContentItemTO> componentItems = parentItem.getComponents();
        if (componentItems != null) {
            for (ContentItemTO component : componentItems) {
                if (deleteDependency && !ContentUtils.matchesPatterns(component.getUri(), deletePattern)) continue;
                includedDependencies.add(component.getUri());
            }
        }
        if ((documentItems = parentItem.getDocuments()) != null) {
            for (ContentItemTO document : documentItems) {
                if (deleteDependency && (!deleteDependency || !ContentUtils.matchesPatterns(document.getUri(), deletePattern))) continue;
                includedDependencies.add(document.getUri());
            }
        }
        if ((levelDescriptorItems = parentItem.getLevelDescriptors()) != null) {
            for (ContentItemTO levelDescriptor : levelDescriptorItems) {
                if (deleteDependency && (!deleteDependency || !ContentUtils.matchesPatterns(levelDescriptor.getUri(), deletePattern))) continue;
                includedDependencies.add(levelDescriptor.getUri());
            }
        }
    }

    protected void addDependencyItem(String site, List<ContentItemTO> items, Set<String> includedItems, Set<String> includedDependencies, ContentItemTO item, DmContentItemComparator comparator, boolean deleteDependencies) throws ServiceException {
        String itemFullPath = this.contentService.expandRelativeSitePath(site, item.getUri());
        if (!deleteDependencies && item.isNewFile()) {
            String parentUri = "";
            if (item.getName().equals("index.xml")) {
                String uri = item.getPath();
                String[] levels = uri.split("/");
                int last = levels.length - 1;
                for (int index = 0; index < last; ++index) {
                    parentUri = parentUri + levels[index] + "/";
                }
                parentUri = parentUri + "index.xml";
            } else {
                parentUri = item.getPath() + "/" + "index.xml";
            }
            if (!includedItems.contains(parentUri) && parentUri.startsWith("/site/website")) {
                try {
                    String fullPath = this.contentService.expandRelativeSitePath(site, parentUri);
                    ContentItemTO parentItem = this.contentService.getContentItem(site, parentUri);
                    if (parentItem != null) {
                        this.retrieveDependencyItems(parentItem, includedDependencies, deleteDependencies, site);
                        if (parentItem.isNewFile()) {
                            this.addDependencyItem(site, items, includedItems, includedDependencies, parentItem, comparator, deleteDependencies);
                        }
                    }
                }
                catch (ContentNotFoundException fullPath) {
                    // empty catch block
                }
            }
        }
        boolean found = false;
        int position = -1;
        for (int index = 0; index < items.size(); ++index) {
            ContentItemTO topLevelItem = items.get(index);
            String categoryUri = topLevelItem.getUri();
            categoryUri = categoryUri.replaceFirst("index.xml", "");
            String topLevelItemFullPath = this.contentService.expandRelativeSitePath(site, topLevelItem.getUri());
            if (item.getUri().startsWith(categoryUri)) {
                this.populatePageDependencies(site, item, true);
                boolean topLevelItemRenamed = false;
                topLevelItem.addChild(item, comparator, true, topLevelItemRenamed);
                position = index;
                found = true;
                continue;
            }
            String currentCategoryUri = item.getUri().replaceFirst("index.xml", "");
            if (!topLevelItem.getUri().startsWith(currentCategoryUri)) continue;
            items.remove(index);
            this.populatePageDependencies(site, item, true);
            item.addChild(topLevelItem, comparator, true);
            if (found) continue;
            this.populatePageDependencies(site, item, true);
            items.add(index, item);
            found = true;
            position = index;
        }
        if (!found) {
            if (!deleteDependencies) {
                this.populatePageDependencies(site, item, true);
            }
            items.add(item);
        }
        includedItems.add(item.getUri());
    }

    protected void flattenDependencies(ContentItemTO topLevelItem, List<ContentItemTO> children, DmContentItemComparator comparator, ContentItemTO parent, List<String> referencePages) {
        if (children != null) {
            for (ContentItemTO child : children) {
                if (!this.isChildAlreadyExists(topLevelItem, child)) {
                    topLevelItem.addChild(child, false, false);
                }
                if (parent != null) {
                    child.setParentPath(parent.getBrowserUri());
                } else {
                    referencePages.add(child.getUri());
                }
                this.flattenDependencies(topLevelItem, child.getChildren(), comparator, child, referencePages);
                this.flattenDependencies(topLevelItem, child.getPages(), comparator, null, referencePages);
                child.setChildren(null);
            }
        }
    }

    protected boolean isChildAlreadyExists(ContentItemTO topLevelItem, ContentItemTO item) {
        List<ContentItemTO> children = topLevelItem.getChildren();
        for (ContentItemTO child : children) {
            if (!child.getUri().equals(item.getUri())) continue;
            return true;
        }
        return false;
    }

    protected void removeDuplicateReferences(List<String> references, List<ContentItemTO> displayItems) {
        Iterator<ContentItemTO> itr = displayItems.iterator();
        while (itr.hasNext()) {
            ContentItemTO item = itr.next();
            String uri = item.getUri();
            if (!references.contains(uri)) continue;
            itr.remove();
        }
    }

    protected void populatePageDependencies(String site, ContentItemTO item, boolean populateUpdatedDependecinesOnly) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("sourcePath", item.getUri());
        params.put("type", "page");
        List<DependencyEntity> pages = this.dependencyMapper.getDependenciesByType(params);
        List<ContentItemTO> pageItems = this.getDependentItems(site, item.getUri(), pages, populateUpdatedDependecinesOnly);
        ArrayList<ContentItemTO> newPages = new ArrayList<ContentItemTO>();
        if (populateUpdatedDependecinesOnly) {
            for (ContentItemTO pageItem : pageItems) {
                if (!pageItem.isNew()) continue;
                newPages.add(pageItem);
            }
            item.setPages(newPages);
        } else {
            item.setPages(pageItems);
        }
    }

    @Override
    public void extractDependencies(String site, String path, Document document, Map<String, Set<String>> globalDeps) throws ServiceException {
        if (globalDeps == null) {
            globalDeps = new HashMap<String, Set<String>>();
        }
        Map<String, List<String>> dependencies = this.extractDirectDependency(site, path, document, globalDeps);
        int size = 0;
        for (List<String> vals : dependencies.values()) {
            size += vals == null ? 0 : vals.size();
        }
        this.setDependencies(site, path, dependencies);
    }

    protected Map<String, List<String>> extractDirectDependency(String site, String path, Document document, Map<String, Set<String>> globalDeps) {
        if (globalDeps == null) {
            globalDeps = new HashMap<String, Set<String>>();
        }
        Set<String> globalPages = globalDeps.get("page");
        Set<String> globalComponents = globalDeps.get("component");
        if (globalPages != null && globalPages.contains(path) || globalComponents != null && globalComponents.contains(path)) {
            return new HashMap<String, List<String>>();
        }
        try {
            StringBuffer sb;
            String content;
            String fullPath;
            Matcher matcher;
            Pattern pattern;
            Element root = document.getRootElement();
            boolean skipDependencies = false;
            String isSkipDependenciesValue = root.valueOf("//skipDependencies");
            if (isSkipDependenciesValue != null && !"".equals(isSkipDependenciesValue)) {
                skipDependencies = ContentFormatUtils.getBooleanValue(isSkipDependenciesValue);
            }
            if (skipDependencies) {
                return new HashMap<String, List<String>>();
            }
            ServicesConfig servicesConfig = this.getService(ServicesConfig.class);
            StringBuffer buffer = new StringBuffer(XmlUtils.convertDocumentToString(document));
            List<String> assets = this.getDependentFileNames(site, buffer, false, servicesConfig.getAssetPatterns(site));
            List<String> components = this.getDependentFileNames(site, buffer, false, servicesConfig.getComponentPatterns(site));
            List<String> documents = this.getDependentFileNames(site, buffer, false, servicesConfig.getDocumentPatterns(site));
            List<String> pages = this.getDependentFileNames(site, buffer, false, servicesConfig.getPagePatterns(site));
            List<String> templates = this.getDependentFileNames(site, buffer, false, servicesConfig.getRenderingTemplatePatterns(site));
            HashMap<String, List<String>> dependency = new HashMap<String, List<String>>();
            dependency.put("asset", assets);
            dependency.put("component", components);
            dependency.put("document", documents);
            dependency.put("page", pages);
            dependency.put("rendTemplate", templates);
            for (String patternStr : servicesConfig.getPagePatterns(site)) {
                pattern = Pattern.compile(patternStr);
                matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                if (globalPages == null) {
                    globalPages = new HashSet<String>();
                }
                globalPages.add(path);
                globalDeps.put("page", globalPages);
                break;
            }
            for (String patternStr : servicesConfig.getComponentPatterns(site)) {
                pattern = Pattern.compile(patternStr);
                matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                if (globalComponents == null) {
                    globalComponents = new HashSet<String>();
                }
                globalComponents.add(path);
                globalDeps.put("component", globalComponents);
                break;
            }
            for (String assetPath : assets) {
                Set<String> parsedAssets = globalDeps.get("asset");
                if (parsedAssets == null) {
                    parsedAssets = new HashSet<String>();
                }
                if (parsedAssets.contains(assetPath)) continue;
                if (assetPath.endsWith(".css")) {
                    fullPath = this.contentService.expandRelativeSitePath(site, assetPath);
                    content = this.contentService.getContentAsString(fullPath);
                    if (!StringUtils.isNotEmpty((String)content)) continue;
                    sb = new StringBuffer(content);
                    try {
                        this.extractDependenciesStyle(site, assetPath, sb, globalDeps);
                    }
                    catch (ServiceException e) {
                        logger.error("Failed to get style dependencies", e, new Object[0]);
                    }
                    continue;
                }
                if (!assetPath.endsWith(".js") || !StringUtils.isNotEmpty((String)(content = this.contentService.getContentAsString(fullPath = this.contentService.expandRelativeSitePath(site, assetPath))))) continue;
                sb = new StringBuffer(content);
                try {
                    this.extractDependenciesJavascript(site, assetPath, sb, globalDeps);
                }
                catch (ServiceException e) {
                    logger.error("Failed to get javascript dependencies", e, new Object[0]);
                }
            }
            for (String templatePath : templates) {
                Set<String> parsedTemplates = globalDeps.get("rendTemplate");
                if (parsedTemplates == null) {
                    parsedTemplates = new HashSet<String>();
                }
                if (parsedTemplates.contains(templatePath) || !StringUtils.isNotEmpty((String)(content = this.contentService.getContentAsString(fullPath = this.contentService.expandRelativeSitePath(site, templatePath))))) continue;
                sb = new StringBuffer(content);
                try {
                    this.extractDependenciesTemplate(site, templatePath, sb, globalDeps);
                }
                catch (ServiceException e) {
                    logger.error("Failed to get template dependencies", e, new Object[0]);
                }
            }
            return dependency;
        }
        catch (IOException e) {
            logger.error("Failed to get direct dependency", e, new Object[0]);
            return null;
        }
    }

    @Override
    public void extractDependenciesTemplate(String site, String path, StringBuffer templateContent, Map<String, Set<String>> globalDeps) throws ServiceException {
        if (globalDeps == null) {
            globalDeps = new HashMap<String, Set<String>>();
        }
        List<String> assets = this.getDependentFileNames(site, templateContent, false, this.servicesConfig.getAssetPatterns(site));
        List<String> templates = this.getDependentFileNames(site, templateContent, false, this.servicesConfig.getRenderingTemplatePatterns(site));
        while (templates.contains(path)) {
            templates.remove(path);
        }
        HashMap<String, List<String>> dependency = new HashMap<String, List<String>>();
        dependency.put("asset", assets);
        dependency.put("rendTemplate", templates);
        this.setDependencies(site, path, dependency);
        Set<String> parsedTemplates = globalDeps.get("rendTemplate");
        if (parsedTemplates == null) {
            parsedTemplates = new HashSet<String>();
        }
        parsedTemplates.add(path);
        globalDeps.put("rendTemplate", parsedTemplates);
        for (String assetPath : assets) {
            StringBuffer sb;
            String assetFullPath;
            Set<String> parsedAssets = globalDeps.get("asset");
            if (parsedAssets == null) {
                parsedAssets = new HashSet<String>();
            }
            if (parsedAssets.contains(assetPath)) continue;
            if (assetPath.endsWith(".css")) {
                if (!this.contentService.contentExists(site, assetPath)) continue;
                assetFullPath = this.contentService.expandRelativeSitePath(site, assetPath);
                sb = new StringBuffer(this.contentService.getContentAsString(assetFullPath));
                this.extractDependenciesStyle(site, assetPath, sb, globalDeps);
                continue;
            }
            if (!assetPath.endsWith(".js") || !this.contentService.contentExists(site, assetPath)) continue;
            assetFullPath = this.contentService.expandRelativeSitePath(site, assetPath);
            sb = new StringBuffer(this.contentService.getContentAsString(assetFullPath));
            this.extractDependenciesJavascript(site, assetPath, sb, globalDeps);
        }
        for (String templatePath : templates) {
            if (parsedTemplates.contains(templatePath) || !this.contentService.contentExists(site, templatePath)) continue;
            String templateFullPath = this.contentService.expandRelativeSitePath(site, templatePath);
            StringBuffer sb = new StringBuffer(this.contentService.getContentAsString(templateFullPath));
            this.extractDependenciesTemplate(site, templatePath, sb, globalDeps);
        }
    }

    @Override
    public void extractDependenciesStyle(String site, String path, StringBuffer styleContent, Map<String, Set<String>> globalDeps) throws ServiceException {
        if (globalDeps == null) {
            globalDeps = new HashMap<String, Set<String>>();
        }
        List<String> assets = this.getDependentFileNames(site, styleContent, false, this.servicesConfig.getAssetPatterns(site));
        while (assets.contains(path)) {
            assets.remove(path);
        }
        HashMap<String, List<String>> dependency = new HashMap<String, List<String>>();
        dependency.put("asset", assets);
        this.setDependencies(site, path, dependency);
        Set<String> parsedAssets = globalDeps.get("asset");
        if (parsedAssets == null) {
            parsedAssets = new HashSet<String>();
        }
        parsedAssets.add(path);
        globalDeps.put("asset", parsedAssets);
        for (String assetPath : assets) {
            if (parsedAssets.contains(assetPath) || !assetPath.endsWith(".css") || !this.contentService.contentExists(site, assetPath)) continue;
            String assetFullPath = this.contentService.expandRelativeSitePath(site, assetPath);
            StringBuffer sb = new StringBuffer(this.contentService.getContentAsString(assetFullPath));
            this.extractDependenciesStyle(site, assetPath, sb, globalDeps);
        }
    }

    @Override
    public void extractDependenciesJavascript(String site, String path, StringBuffer javascriptContent, Map<String, Set<String>> globalDeps) throws ServiceException {
        if (globalDeps == null) {
            globalDeps = new HashMap<String, Set<String>>();
        }
        List<String> assets = this.getDependentFileNames(site, javascriptContent, false, this.servicesConfig.getAssetPatterns(site));
        while (assets.contains(path)) {
            assets.remove(path);
        }
        HashMap<String, List<String>> dependency = new HashMap<String, List<String>>();
        dependency.put("asset", assets);
        this.setDependencies(site, path, dependency);
        Set<String> parsedAssets = globalDeps.get("asset");
        if (parsedAssets == null) {
            parsedAssets = new HashSet<String>();
        }
        parsedAssets.add(path);
        globalDeps.put("asset", parsedAssets);
        for (String assetPath : assets) {
            if (parsedAssets.contains(assetPath) || !assetPath.endsWith(".js") || !this.contentService.contentExists(site, assetPath)) continue;
            String assetFullPath = this.contentService.expandRelativeSitePath(site, assetPath);
            StringBuffer sb = new StringBuffer(this.contentService.getContentAsString(assetFullPath));
            this.extractDependenciesJavascript(site, assetPath, sb, globalDeps);
        }
    }

    protected List<String> getDependentLevelDescriptors(String site, String path, boolean b, String levelDescriptorName) {
        ArrayList<String> levelDescriptors = new ArrayList<String>();
        return levelDescriptors;
    }

    @Override
    public void setDependencies(String site, String path, Map<String, List<String>> dependencies) throws ServiceException {
        try {
            HashMap<String, List<String>> filteredDependencies = new HashMap<String, List<String>>();
            for (String type : dependencies.keySet()) {
                filteredDependencies.put(type, this.applyIgnoreDependenciesRules(site, dependencies.get(type)));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("path", path);
            this.dependencyMapper.deleteAllSourceDependencies(params);
            if (dependencies != null) {
                for (String type : dependencies.keySet()) {
                    List<String> files = dependencies.get(type);
                    if (files == null || files.size() <= 0) continue;
                    ArrayList<DependencyEntity> deps = new ArrayList<DependencyEntity>();
                    for (String file : files) {
                        DependencyEntity dependencyObj = new DependencyEntity();
                        dependencyObj.setSite(site);
                        dependencyObj.setSourcePath(path);
                        dependencyObj.setTargetPath(file);
                        dependencyObj.setType(type);
                        deps.add(dependencyObj);
                    }
                    params = new HashMap();
                    params.put("dependencies", deps);
                    this.dependencyMapper.insertList(params);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed to set dependencies for " + path + " in " + site, e);
        }
    }

    private List<String> applyIgnoreDependenciesRules(String site, List<String> dependencies) {
        ArrayList<String> filteredDependencies = new ArrayList<String>();
        for (String dependency : dependencies) {
            boolean ignore = false;
            if (!this.contentService.contentExists(site, dependency)) {
                for (String rule : this.ignoreDependenciesRules) {
                    if (!dependency.matches(rule)) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            filteredDependencies.add(dependency);
        }
        return filteredDependencies;
    }

    @Override
    public void updateDependencies(String site, String path, String state) {
        DmDependencyTO dmDependencyTo = this.getDependencies(site, path, false, true);
        if (dmDependencyTo != null) {
            List<DmDependencyTO> pages = dmDependencyTo.getPages();
            this.updateDependency(site, state, pages);
            List<DmDependencyTO> components = dmDependencyTo.getComponents();
            this.updateDependency(site, state, components);
            List<DmDependencyTO> documents = dmDependencyTo.getDocuments();
            this.updateDependency(site, state, documents);
            List<DmDependencyTO> templates = dmDependencyTo.getRenderingTemplates();
            this.updateDependency(site, state, templates);
        }
    }

    protected void updateDependency(String site, String state, List<DmDependencyTO> dependencies) {
    }

    @Override
    public InputStream replaceDependencies(String site, Document document, Map<String, String> dependencies) throws ServiceException {
        try {
            if (!dependencies.isEmpty()) {
                String xml = XmlUtils.convertDocumentToString(document);
                for (String source : dependencies.keySet()) {
                    String target = dependencies.get(source);
                    xml = xml.replace(source, target);
                }
                return new ByteArrayInputStream(xml.getBytes());
            }
        }
        catch (IOException e) {
            throw new ServiceException("Unable to replace dependencies " + e);
        }
        return ContentUtils.convertDocumentToStream(document, "UTF-8");
    }

    @Override
    public Map<String, String> getCopyDependencies(String site, String sourceContentPath, String dependencyPath) throws ServiceException {
        HashMap<String, String> copyDependency = new HashMap<String, String>();
        if (sourceContentPath.endsWith(".xml") && dependencyPath.endsWith(".xml")) {
            String fullPath = this.contentService.expandRelativeSitePath(site, sourceContentPath);
            ContentItemTO dependencyItem = this.contentService.getContentItem(site, sourceContentPath);
            if (dependencyItem != null) {
                String contentType = dependencyItem.getContentType();
                List<CopyDependencyConfigTO> copyDependencyPatterns = this.servicesConfig.getCopyDependencyPatterns(site, contentType);
                if (copyDependencyPatterns != null && copyDependencyPatterns.size() > 0) {
                    logger.debug("Copy Pattern provided for contentType" + contentType, new Object[0]);
                    DmDependencyTO dmDependencyTo = this.getDependencies(site, dependencyPath, false, true);
                    if (dmDependencyTo != null) {
                        List<DmDependencyTO> dependencyTOItems = dmDependencyTo.getDirectDependencies();
                        for (DmDependencyTO dependency : dependencyTOItems) {
                            String assocFilePath = dependency.getUri();
                            for (CopyDependencyConfigTO copyConfig : copyDependencyPatterns) {
                                ContentItemTO assocItem;
                                if (!StringUtils.isNotEmpty((String)copyConfig.getPattern()) || !StringUtils.isNotEmpty((String)copyConfig.getTarget()) || !assocFilePath.matches(copyConfig.getPattern()) || (assocItem = this.contentService.getContentItem(site, assocFilePath)) == null) continue;
                                copyDependency.put(dependency.getUri(), copyConfig.getTarget());
                            }
                        }
                    }
                } else {
                    logger.debug("Copy Pattern is not provided for contentType" + contentType, new Object[0]);
                }
            } else {
                logger.debug("Not found dependency item at {0}", fullPath);
            }
        }
        return copyDependency;
    }

    @Override
    public List<String> getDependencyPaths(String site, String path) {
        ArrayList<String> toRet = new ArrayList<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("sourcePath", path);
        List<DependencyEntity> deps = this.dependencyMapper.getDependencies(params);
        for (DependencyEntity dep : deps) {
            toRet.add(dep.getTargetPath());
        }
        return toRet;
    }

    @Override
    public void deleteDependenciesForSite(String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.dependencyMapper.deleteDependenciesForSite(params);
    }

    @Override
    public void deleteDependenciesForSiteAndPath(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.dependencyMapper.deleteDependenciesForSiteAndPath(params);
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public List<String> getIgnoreDependenciesRules() {
        return this.ignoreDependenciesRules;
    }

    public void setIgnoreDependenciesRules(List<String> ignoreDependenciesRules) {
        this.ignoreDependenciesRules = ignoreDependenciesRules;
    }
}

