/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.collections.FastArrayList;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.dal.ActivityFeed;
import org.craftercms.studio.api.v1.dal.CopyToEnvironment;
import org.craftercms.studio.api.v1.dal.CopyToEnvironmentMapper;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistoryMapper;
import org.craftercms.studio.api.v1.dal.PublishToTarget;
import org.craftercms.studio.api.v1.dal.PublishToTargetMapper;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.ebus.RepositoryEventMessage;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.CopyToEnvironmentItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.to.DmDeploymentTaskTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.impl.v1.deployment.DeployerFactory;
import org.craftercms.studio.impl.v1.service.deployment.job.DeployContentToEnvironmentStore;
import org.craftercms.studio.impl.v1.service.deployment.job.PublishContentToDeploymentTarget;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.Reactor;
import reactor.event.Event;

public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    private static final int HISTORY_ALL_LIMIT = 9999999;
    private static final String CONTENT_TYPE_ALL = "all";
    private static int CTED_AUTOINCREMENT = 0;
    private static int PSD_AUTOINCREMENT = 0;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected ActivityService activityService;
    protected DmDependencyService dmDependencyService;
    protected DmFilterWrapper dmFilterWrapper;
    protected SiteService siteService;
    protected ObjectStateService objectStateService;
    protected ObjectMetadataManager objectMetadataManager;
    protected ContentRepository contentRepository;
    protected DeployerFactory deployerFactory;
    protected Reactor repositoryReactor;
    protected DmPublishService dmPublishService;
    @Autowired
    protected DeploymentSyncHistoryMapper deploymentSyncHistoryMapper;
    @Autowired
    protected CopyToEnvironmentMapper copyToEnvironmentMapper;
    @Autowired
    protected PublishToTargetMapper publishToTargetMapper;

    @Override
    public void deploy(String site, String environment, List<String> paths, Date scheduledDate, String approver, String submissionComment) throws DeploymentException {
        if (scheduledDate != null && scheduledDate.after(new Date())) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.SUBMIT_WITHOUT_WORKFLOW_SCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED);
            this.objectStateService.setSystemProcessingBulk(site, paths, false);
        } else {
            this.objectStateService.setSystemProcessingBulk(site, paths, true);
        }
        ArrayList<String> newPaths = new ArrayList<String>();
        ArrayList<String> updatedPaths = new ArrayList<String>();
        ArrayList<String> movedPaths = new ArrayList<String>();
        HashMap<String, List<String>> groupedPaths = new HashMap<String, List<String>>();
        for (String p : paths) {
            if (this.objectStateService.isNew(site, p)) {
                newPaths.add(p);
                continue;
            }
            if (this.objectMetadataManager.isRenamed(site, p)) {
                movedPaths.add(p);
                continue;
            }
            updatedPaths.add(p);
        }
        groupedPaths.put("NEW", newPaths);
        groupedPaths.put("MOVE", movedPaths);
        groupedPaths.put("UPDATE", updatedPaths);
        List<CopyToEnvironment> items = this.createItems(site, environment, groupedPaths, scheduledDate, approver, submissionComment);
        for (CopyToEnvironment item : items) {
            this.copyToEnvironmentMapper.insertItemForDeployment(item);
        }
    }

    private List<CopyToEnvironment> createItems(String site, String environment, Map<String, List<String>> paths, Date scheduledDate, String approver, String submissionComment) {
        ArrayList<CopyToEnvironment> newItems = new ArrayList<CopyToEnvironment>(paths.size());
        for (String action : paths.keySet()) {
            for (String path : paths.get(action)) {
                CopyToEnvironment item = new CopyToEnvironment();
                item.setId(++CTED_AUTOINCREMENT);
                item.setSite(site);
                item.setEnvironment(environment);
                item.setPath(path);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setAction(action);
                if (this.objectMetadataManager.isRenamed(site, path)) {
                    String oldPath = this.objectMetadataManager.getOldPath(site, item.getPath());
                    item.setOldPath(oldPath);
                }
                String contentTypeClass = this.contentService.getContentTypeClass(site, path);
                item.setContentTypeClass(contentTypeClass);
                item.setUser(approver);
                item.setSubmissionComment(submissionComment);
                newItems.add(item);
            }
        }
        return newItems;
    }

    @Override
    public void delete(String site, List<String> paths, String approver, Date scheduledDate) throws DeploymentException {
        if (scheduledDate != null && scheduledDate.after(new Date())) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.DELETE, State.NEW_DELETED);
            this.objectStateService.setSystemProcessingBulk(site, paths, false);
        } else {
            this.objectStateService.setSystemProcessingBulk(site, paths, true);
        }
        Set<String> environments = this.getAllPublishingEnvironments(site);
        for (String environment : environments) {
            List<CopyToEnvironment> items = this.createDeleteItems(site, environment, paths, approver, scheduledDate);
            for (CopyToEnvironment item : items) {
                this.copyToEnvironmentMapper.insertItemForDeployment(item);
            }
        }
    }

    protected Set<String> getAllPublishingEnvironments(String site) {
        Map<String, PublishingChannelGroupConfigTO> groupConfigTOs = this.siteService.getPublishingChannelGroupConfigs(site);
        HashSet<String> environments = new HashSet<String>();
        if (groupConfigTOs != null && groupConfigTOs.size() > 0) {
            for (PublishingChannelGroupConfigTO groupConfigTO : groupConfigTOs.values()) {
                if (!StringUtils.isNotEmpty((String)groupConfigTO.getName())) continue;
                environments.add(groupConfigTO.getName());
            }
        }
        return environments;
    }

    private List<CopyToEnvironment> createDeleteItems(String site, String environment, List<String> paths, String approver, Date scheduledDate) {
        ArrayList<CopyToEnvironment> newItems = new ArrayList<CopyToEnvironment>(paths.size());
        for (String path : paths) {
            CopyToEnvironment item = new CopyToEnvironment();
            item.setId(++CTED_AUTOINCREMENT);
            item.setSite(site);
            item.setEnvironment(environment);
            item.setPath(path);
            item.setScheduledDate(scheduledDate);
            item.setState("READY_FOR_LIVE");
            item.setAction("DELETE");
            if (this.objectMetadataManager.isRenamed(site, path)) {
                String oldPath = this.objectMetadataManager.getOldPath(site, item.getPath());
                item.setOldPath(oldPath);
            }
            String contentTypeClass = this.contentService.getContentTypeClass(site, path);
            item.setContentTypeClass(contentTypeClass);
            item.setUser(approver);
            newItems.add(item);
        }
        return newItems;
    }

    @Override
    public void deleteDeploymentDataForSite(String site) {
        this.signalWorkersToStop();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.copyToEnvironmentMapper.deleteDeploymentDataForSite(params);
        this.publishToTargetMapper.deleteDeploymentDataForSite(params);
        this.deploymentSyncHistoryMapper.deleteDeploymentDataForSite(params);
        this.signalWorkersToContinue();
    }

    private void signalWorkersToContinue() {
        DeployContentToEnvironmentStore.signalToStop(false);
        PublishContentToDeploymentTarget.signalToStop(false);
    }

    private void signalWorkersToStop() {
        DeployContentToEnvironmentStore.signalToStop(true);
        PublishContentToDeploymentTarget.signalToStop(true);
        while (DeployContentToEnvironmentStore.isRunning() && PublishContentToDeploymentTarget.isRunning()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while waiting to stop workers", e);
            }
        }
    }

    @Override
    public List<CopyToEnvironment> getScheduledItems(String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("state", "READY_FOR_LIVE");
        params.put("now", new Date());
        return this.copyToEnvironmentMapper.getScheduledItems(params);
    }

    @Override
    public void cancelWorkflow(String site, String path) throws DeploymentException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.put("state", (Object)CopyToEnvironmentItem.State.READY_FOR_LIVE);
        params.put("canceledState", (Object)CopyToEnvironmentItem.State.CANCELED);
        params.put("now", new Date());
        this.copyToEnvironmentMapper.cancelWorkflow(params);
    }

    @Override
    public List<DmDeploymentTaskTO> getDeploymentHistory(String site, int daysFromToday, int numberOfItems, String sort, boolean ascending, String filterType) {
        Date toDate = new Date();
        Date fromDate = new Date(toDate.getTime() - 86400000L * (long)daysFromToday);
        List<DeploymentSyncHistory> deployReports = this.getDeploymentHistory(site, fromDate, toDate, filterType, numberOfItems);
        ArrayList<DmDeploymentTaskTO> tasks = new ArrayList<DmDeploymentTaskTO>();
        if (deployReports != null) {
            int count = 0;
            SimpleDateFormat deployedFormat = new SimpleDateFormat("MM/dd");
            deployedFormat.setTimeZone(TimeZone.getTimeZone(this.servicesConfig.getDefaultTimezone(site)));
            String timezone = this.servicesConfig.getDefaultTimezone(site);
            for (int index = 0; index < deployReports.size() && count < numberOfItems; ++index) {
                DeploymentSyncHistory entry = deployReports.get(index);
                ContentItemTO deployedItem = this.getDeployedItem(entry.getSite(), entry.getPath());
                if (deployedItem == null) continue;
                deployedItem.eventDate = entry.getSyncDate();
                deployedItem.endpoint = entry.getTarget();
                String deployedLabel = ContentFormatUtils.formatDate(deployedFormat, entry.getSyncDate(), timezone);
                if (tasks.size() > 0) {
                    DmDeploymentTaskTO lastTask = (DmDeploymentTaskTO)tasks.get(tasks.size() - 1);
                    String lastDeployedLabel = lastTask.getInternalName();
                    if (lastDeployedLabel.equals(deployedLabel)) {
                        lastTask.setNumOfChildren(lastTask.getNumOfChildren() + 1);
                        lastTask.getChildren().add(deployedItem);
                    } else {
                        tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                    }
                } else {
                    tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                }
                ++count;
            }
        }
        return tasks;
    }

    protected List<DeploymentSyncHistory> getDeploymentHistory(String site, Date fromDate, Date toDate, String filterType, int numberOfItems) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("from_date", fromDate);
        params.put("to_date", toDate);
        if (numberOfItems <= 0) {
            params.put("limit", 9999999);
        } else {
            params.put("limit", numberOfItems);
        }
        if (!filterType.equalsIgnoreCase(CONTENT_TYPE_ALL)) {
            params.put("filter", filterType);
        }
        return this.deploymentSyncHistoryMapper.getDeploymentHistory(params);
    }

    protected DmDeploymentTaskTO createDeploymentTask(String deployedLabel, ContentItemTO item) {
        DmDeploymentTaskTO task = new DmDeploymentTaskTO();
        task.setInternalName(deployedLabel);
        List<ContentItemTO> taskItems = task.getChildren();
        if (taskItems == null) {
            taskItems = new ArrayList<ContentItemTO>();
            task.setChildren(taskItems);
        }
        taskItems.add(item);
        task.setNumOfChildren(taskItems.size());
        return task;
    }

    protected ContentItemTO getDeployedItem(String site, String path) {
        ContentItemTO item = null;
        if (!this.contentService.contentExists(site, path)) {
            item = this.contentService.createDummyDmContentItemForDeletedNode(site, path);
            ActivityFeed activity = this.activityService.getDeletedActivity(site, path);
            if (activity != null) {
                JSONObject summaryObject = JSONObject.fromObject((Object)activity.getSummary());
                if (summaryObject.containsKey((Object)"content-type")) {
                    String contentType;
                    item.contentType = contentType = (String)summaryObject.get("content-type");
                }
                if (summaryObject.containsKey((Object)"internalName")) {
                    String internalName;
                    item.internalName = internalName = (String)summaryObject.get("internalName");
                }
                if (summaryObject.containsKey((Object)"browserUri")) {
                    String browserUri;
                    item.browserUri = browserUri = (String)summaryObject.get("browserUri");
                }
            }
            item.setLockOwner("");
        } else {
            item = this.contentService.getContentItem(site, path, 0);
        }
        return item;
    }

    @Override
    public List<ContentItemTO> getScheduledItems(String site, String sort, boolean ascending, String subSort, boolean subAscending, String filterType) throws ServiceException {
        if (StringUtils.isEmpty((String)sort)) {
            sort = "eventDate";
        }
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, true, true);
        DmContentItemComparator subComparator = new DmContentItemComparator(subSort, subAscending, true, true);
        List<ContentItemTO> items = null;
        items = this.getScheduledItems(site, comparator, subComparator, filterType);
        return items;
    }

    protected List<ContentItemTO> getScheduledItems(String site, DmContentItemComparator comparator, DmContentItemComparator subComparator, String filterType) {
        FastArrayList results = new FastArrayList();
        List<String> displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        List<CopyToEnvironment> deploying = this.getScheduledItems(site);
        SimpleDateFormat format = new SimpleDateFormat("MM/dd hh:mma");
        ArrayList scheduledItems = new ArrayList();
        for (CopyToEnvironment deploymentItem : deploying) {
            String fullPath = this.contentService.expandRelativeSitePath(site, deploymentItem.getPath());
            this.addScheduledItem(site, deploymentItem.getScheduledDate(), format, fullPath, (List<ContentItemTO>)results, comparator, subComparator, displayPatterns, filterType);
        }
        return results;
    }

    protected void addScheduledItem(String site, Date launchDate, SimpleDateFormat format, String fullPath, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType) {
        try {
            DmPathTO path = new DmPathTO(fullPath);
            this.addToScheduledDateList(site, launchDate, format, fullPath, scheduledItems, comparator, subComparator, displayPatterns, filterType);
            String relativePath = this.contentService.getRelativeSitePath(site, fullPath);
            if (!relativePath.endsWith("/index.xml") && !relativePath.endsWith(".xml")) {
                relativePath = relativePath + "/" + "index.xml";
            }
            this.addDependendenciesToSchdeuleList(site, launchDate, format, scheduledItems, comparator, subComparator, displayPatterns, filterType, relativePath);
        }
        catch (ServiceException e) {
            logger.error("failed to read " + fullPath + ". " + e.getMessage(), new Object[0]);
        }
    }

    protected void addToScheduledDateList(String site, Date launchDate, SimpleDateFormat format, String fullPath, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType) throws ServiceException {
        ContentItemTO itemToAdd;
        String timeZone = this.servicesConfig.getDefaultTimezone(site);
        String dateLabel = ContentFormatUtils.formatDate(format, launchDate, timeZone);
        DmPathTO path = new DmPathTO(fullPath);
        if (ContentUtils.matchesPatterns(path.getRelativePath(), displayPatterns) && this.dmFilterWrapper.accept(site, itemToAdd = this.contentService.getContentItem(site, path.getRelativePath(), 0), filterType)) {
            itemToAdd.submitted = false;
            itemToAdd.scheduledDate = launchDate;
            itemToAdd.inProgress = false;
            boolean found = false;
            for (int index = 0; index < scheduledItems.size(); ++index) {
                ContentItemTO currDateItem = scheduledItems.get(index);
                if (currDateItem.name.equals(dateLabel)) {
                    currDateItem.addChild(itemToAdd, subComparator, false);
                    found = true;
                    break;
                }
                if (itemToAdd.scheduledDate.compareTo(currDateItem.scheduledDate) >= 0) continue;
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(index, dateItem);
                found = true;
                break;
            }
            if (!found) {
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(dateItem);
            }
        }
    }

    protected void addDependendenciesToSchdeuleList(String site, Date launchDate, SimpleDateFormat format, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType, String relativePath) {
        DmDependencyTO dmDependencyTo = this.dmDependencyService.getDependencies(site, relativePath, false, true);
        if (dmDependencyTo != null) {
            List<DmDependencyTO> pages = dmDependencyTo.getPages();
            this._addDependendenciesToSchdeuleList(site, launchDate, format, scheduledItems, comparator, subComparator, displayPatterns, filterType, pages);
            List<DmDependencyTO> components = dmDependencyTo.getComponents();
            this._addDependendenciesToSchdeuleList(site, launchDate, format, scheduledItems, comparator, subComparator, displayPatterns, filterType, components);
            List<DmDependencyTO> documents = dmDependencyTo.getDocuments();
            this._addDependendenciesToSchdeuleList(site, launchDate, format, scheduledItems, comparator, subComparator, displayPatterns, filterType, documents);
        }
    }

    protected ContentItemTO createDateItem(String name, ContentItemTO itemToAdd, DmContentItemComparator comparator, String timeZone) {
        ContentItemTO dateItem = new ContentItemTO();
        dateItem.name = name;
        dateItem.internalName = name;
        dateItem.eventDate = itemToAdd.scheduledDate;
        dateItem.scheduledDate = itemToAdd.scheduledDate;
        dateItem.timezone = timeZone;
        dateItem.addChild(itemToAdd, comparator, false);
        return dateItem;
    }

    protected void _addDependendenciesToSchdeuleList(String site, Date launchDate, SimpleDateFormat format, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType, List<DmDependencyTO> dependencies) {
        if (dependencies != null) {
            for (DmDependencyTO dependencyTo : dependencies) {
                if (!this.objectStateService.isNew(site, dependencyTo.getUri())) continue;
                String uri = dependencyTo.getUri();
                String fullPath = this.contentService.expandRelativeSitePath(site, uri);
                if (!this.objectStateService.isScheduled(site, uri)) continue;
                this.addScheduledItem(site, launchDate, format, fullPath, scheduledItems, comparator, subComparator, displayPatterns, filterType);
                if (!dependencyTo.getUri().endsWith(".xml")) continue;
                this.addDependendenciesToSchdeuleList(site, launchDate, format, scheduledItems, comparator, subComparator, displayPatterns, filterType, uri);
            }
        }
    }

    public Map<String, List<PublishingChannelTO>> getAvailablePublishingChannelGroups(String site, String path) {
        List<PublishingChannelTO> channelsTO = this.getAvailablePublishingChannelGroupsForSite(site, path);
        ArrayList<PublishingChannelTO> publishChannels = new ArrayList<PublishingChannelTO>();
        ArrayList<PublishingChannelTO> updateStatusChannels = new ArrayList<PublishingChannelTO>();
        for (PublishingChannelTO channelTO : channelsTO) {
            if (channelTO.isPublish()) {
                publishChannels.add(channelTO);
            }
            if (!channelTO.isUpdateStatus()) continue;
            updateStatusChannels.add(channelTO);
        }
        HashMap<String, List<PublishingChannelTO>> result = new HashMap<String, List<PublishingChannelTO>>();
        result.put("availablePublishChannels", publishChannels);
        result.put("availableUpdateStatusChannels", updateStatusChannels);
        return result;
    }

    protected List<PublishingChannelTO> getAvailablePublishingChannelGroupsForSite(String site, String path) {
        ArrayList<PublishingChannelTO> channelTOs = new ArrayList<PublishingChannelTO>();
        List<String> channels = this.getPublishingChannels(site);
        for (String ch : channels) {
            PublishingChannelTO chTO = new PublishingChannelTO();
            chTO.setName(ch);
            chTO.setPublish(true);
            chTO.setUpdateStatus(false);
            channelTOs.add(chTO);
        }
        return channelTOs;
    }

    protected List<String> getPublishingChannels(String site) {
        ArrayList<String> channels = new ArrayList<String>();
        Map<String, PublishingChannelGroupConfigTO> channelGroupConfigTOs = this.siteService.getPublishingChannelGroupConfigs(site);
        for (PublishingChannelGroupConfigTO configTO : channelGroupConfigTOs.values()) {
            channels.add(configTO.getName());
        }
        return channels;
    }

    @Override
    public void setupItemsForPublishingSync(String site, String environment, List<CopyToEnvironment> itemsToDeploy) throws DeploymentException {
        List<PublishToTarget> items = this.createItems(site, environment, itemsToDeploy);
        for (PublishToTarget item : items) {
            this.publishToTargetMapper.insertItemForTargetSync(item);
        }
    }

    private List<PublishToTarget> createItems(String site, String environment, List<CopyToEnvironment> itemsToDeploy) {
        Calendar cal = Calendar.getInstance();
        long currentTimestamp = cal.getTimeInMillis();
        ArrayList<PublishToTarget> newItems = new ArrayList<PublishToTarget>(itemsToDeploy.size());
        for (CopyToEnvironment itemToDeploy : itemsToDeploy) {
            PublishToTarget item = new PublishToTarget();
            item.setId(++PSD_AUTOINCREMENT);
            item.setSite(site);
            item.setEnvironment(itemToDeploy.getEnvironment());
            item.setPath(itemToDeploy.getPath());
            item.setUsername(itemToDeploy.getUser());
            item.setVersion(currentTimestamp);
            if (StringUtils.equals((String)itemToDeploy.getAction(), (String)"NEW")) {
                item.setAction("NEW");
            } else if (StringUtils.equals((String)itemToDeploy.getAction(), (String)"MOVE")) {
                item.setAction("MOVE");
                item.setOldPath(itemToDeploy.getOldPath());
            } else if (StringUtils.equals((String)itemToDeploy.getAction(), (String)"DELETE")) {
                item.setAction("DELETE");
                item.setOldPath(itemToDeploy.getOldPath());
            } else {
                item.setAction("UPDATE");
            }
            item.setContentTypeClass(itemToDeploy.getContentTypeClass());
            newItems.add(item);
        }
        return newItems;
    }

    @Override
    public List<PublishToTarget> getItemsToSync(String site, long targetVersion, List<String> environments) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("version", targetVersion);
        params.put("environments", environments);
        List<PublishToTarget> queue = this.publishToTargetMapper.getItemsReadyForTargetSync(params);
        return queue;
    }

    @Override
    public void insertDeploymentHistory(DeploymentEndpointConfigTO target, List<PublishToTarget> publishedItems, Date publishingDate) {
        List<DeploymentSyncHistory> items = this.createItems(target, publishedItems, publishingDate);
        for (DeploymentSyncHistory item : items) {
            this.deploymentSyncHistoryMapper.insertDeploymentSyncHistoryItem(item);
        }
    }

    private List<DeploymentSyncHistory> createItems(DeploymentEndpointConfigTO target, List<PublishToTarget> publishedItems, Date publishingDate) {
        ArrayList<DeploymentSyncHistory> items = new ArrayList<DeploymentSyncHistory>(publishedItems.size());
        for (PublishToTarget item : publishedItems) {
            DeploymentSyncHistory historyItem = new DeploymentSyncHistory();
            historyItem.setSite(item.getSite());
            historyItem.setPath(item.getPath());
            historyItem.setEnvironment(item.getEnvironment());
            historyItem.setSyncDate(publishingDate);
            historyItem.setTarget(target.getName());
            historyItem.setUser(item.getUsername());
            historyItem.setContentTypeClass(item.getContentTypeClass());
            items.add(historyItem);
        }
        return items;
    }

    @Override
    public void syncAllContentToPreview(String site) throws ServiceException {
        RepositoryEventMessage message = new RepositoryEventMessage();
        message.setSite(site);
        RequestContext context = RequestContext.getCurrent();
        String sessionTicket = null;
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            sessionTicket = (String)httpSession.getValue("alf_ticket");
        }
        RepositoryEventContext repositoryEventContext = new RepositoryEventContext(sessionTicket);
        message.setRepositoryEventContext(repositoryEventContext);
        this.repositoryReactor.notify((Object)"repository.previewSync", Event.wrap((Object)message));
    }

    protected void syncFolder(String site, String path, Deployer deployer) {
        RepositoryItem[] children;
        for (RepositoryItem item : children = this.contentRepository.getContentChildren(path)) {
            if (item.isFolder) {
                this.syncFolder(site, item.path + "/" + item.name, deployer);
                continue;
            }
            deployer.deployFile(site, this.contentService.getRelativeSitePath(site, item.path + "/" + item.name));
        }
    }

    @Override
    public List<CopyToEnvironment> getDeploymentQueue(String site) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        ArrayList<String> states = new ArrayList<String>();
        states.add("READY_FOR_LIVE");
        states.add("PROCESSING");
        params.put("states", states);
        params.put("now", new Date());
        return this.copyToEnvironmentMapper.getItemsBySiteAndStates(params);
    }

    @Override
    public boolean cancelDeployment(String site, String path, long deploymentId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.put("id", deploymentId);
        params.put("canceledState", "CANCELLED");
        this.copyToEnvironmentMapper.cancelDeployment(params);
        return true;
    }

    @Override
    public void bulkGoLive(String site, String environment, String path) {
        this.dmPublishService.bulkGoLive(site, environment, path);
    }

    @Override
    public void bulkDelete(String site, String path) {
        this.dmPublishService.bulkDelete(site, path);
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public void setDmFilterWrapper(DmFilterWrapper dmFilterWrapper) {
        this.dmFilterWrapper = dmFilterWrapper;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public DeployerFactory getDeployerFactory() {
        return this.deployerFactory;
    }

    public void setDeployerFactory(DeployerFactory deployerFactory) {
        this.deployerFactory = deployerFactory;
    }

    public Reactor getRepositoryReactor() {
        return this.repositoryReactor;
    }

    public void setRepositoryReactor(Reactor repositoryReactor) {
        this.repositoryReactor = repositoryReactor;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }
}

