/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.PublishingChannelConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;

public class DmPublishServiceImpl
extends AbstractRegistrableService
implements DmPublishService {
    private static final Logger logger = LoggerFactory.getLogger(DmPublishServiceImpl.class);
    protected DeploymentService deploymentService;
    protected SecurityService securityService;
    protected SiteService siteService;
    protected ContentService contentService;
    protected ContentRepository contentRepository;
    protected ObjectMetadataManager objectMetadataManager;
    protected DmDependencyService dmDependencyService;
    protected ObjectStateService objectStateService;

    @Override
    public void register() {
        this._servicesManager.registerService(DmPublishService.class, this);
    }

    @Override
    public void publish(String site, List<String> paths, Date launchDate, MultiChannelPublishingContext mcpContext) {
        ArrayList<String> pathsToPublish = new ArrayList<String>();
        for (String p : paths) {
            DmPathTO dmPathTO = new DmPathTO(p);
            pathsToPublish.add(dmPathTO.getRelativePath());
        }
        if (launchDate == null) {
            launchDate = new Date();
        }
        String approver = this.securityService.getCurrentUser();
        Date ld = launchDate;
        try {
            this.deploymentService.deploy(site, mcpContext.getPublishingChannelGroup(), pathsToPublish, ld, approver, mcpContext.getSubmissionComment());
        }
        catch (DeploymentException e) {
            logger.error("Error while submitting paths to publish", new Object[0]);
        }
    }

    @Override
    public void unpublish(String site, List<String> paths, String approver) {
        this.unpublish(site, paths, approver, null);
    }

    @Override
    public void unpublish(String site, List<String> paths, String approver, Date scheduleDate) {
        if (scheduleDate == null) {
            scheduleDate = new Date();
        }
        try {
            this.deploymentService.delete(site, paths, approver, scheduleDate);
        }
        catch (DeploymentException ex) {
            logger.error("Unable to delete files due a error ", ex, new Object[0]);
        }
    }

    @Override
    public void cancelScheduledItem(String site, String path) {
        try {
            this.deploymentService.cancelWorkflow(site, path);
        }
        catch (DeploymentException e) {
            logger.error(String.format("Error while canceling workflow for content at %s, site %s", path, site), e, new Object[0]);
        }
    }

    @Override
    public boolean hasChannelsConfigure(String site, MultiChannelPublishingContext mcpContext) {
        Map<String, PublishingChannelGroupConfigTO> publishingChannelGroupConfigs;
        PublishingChannelGroupConfigTO configTO;
        boolean toReturn = false;
        if (mcpContext != null && (configTO = (publishingChannelGroupConfigs = this.siteService.getPublishingChannelGroupConfigs(site)).get(mcpContext.getPublishingChannelGroup())) != null) {
            for (PublishingChannelConfigTO channelConfigTO : configTO.getChannels()) {
                if (channelConfigTO == null || this.siteService.getDeploymentEndpoint(site, channelConfigTO.getName()) == null) continue;
                toReturn = true;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkGoLive(String site, String environment, String path) {
        logger.debug("Starting Bulk Go Live for path " + path + " site " + site, new Object[0]);
        ArrayList<String> childrenPaths = new ArrayList<String>();
        ContentItemTO item = this.contentService.getContentItem(site, path, 2);
        if (item != null) {
            childrenPaths.add(item.getUri());
            if (item.getUri().endsWith("/index.xml") && this.objectMetadataManager.isRenamed(site, item.getUri())) {
                this.getAllMandatoryChildren(site, item, childrenPaths);
            } else if (item.isFolder() || item.isContainer()) {
                this.getAllMandatoryChildren(site, item, childrenPaths);
            }
        }
        ArrayList<String> pathsToPublish = new ArrayList<String>();
        for (String childPath : childrenPaths) {
            pathsToPublish.add(childPath);
            this.getAllDependenciesRecursive(site, childPath, pathsToPublish);
        }
        Date launchDate = new Date();
        String approver = this.securityService.getCurrentUser();
        String comment = "Bulk Go Live invoked by " + approver;
        logger.debug("Deploying " + pathsToPublish.size() + " items", new Object[0]);
        try {
            this.deploymentService.deploy(site, environment, pathsToPublish, launchDate, approver, comment);
        }
        catch (DeploymentException e) {
            logger.error("Error while running bulk Go Live operation", e, new Object[0]);
        }
        finally {
            logger.debug("Finished Bulk Go Live for path " + path + " site " + site, new Object[0]);
        }
    }

    protected void getAllDependenciesRecursive(String site, String path, List<String> dependencyPaths) {
        List<String> depPaths = this.dmDependencyService.getDependencyPaths(site, path);
        for (String depPath : depPaths) {
            if (dependencyPaths.contains(depPath) || !this.contentService.contentExists(site, depPath) || !this.objectStateService.isUpdatedOrNew(site, depPath)) continue;
            dependencyPaths.add(depPath);
            this.getAllDependenciesRecursive(site, depPath, dependencyPaths);
        }
    }

    protected void getAllMandatoryChildren(String site, ContentItemTO item, List<String> pathsToPublish) {
        if (item != null) {
            for (ContentItemTO child : item.getChildren()) {
                child = this.contentService.getContentItem(site, child.getUri(), 2);
                pathsToPublish.add(child.getUri());
                if (child.getChildren() == null || child.getChildren().size() <= 0) continue;
                this.getAllMandatoryChildren(site, child, pathsToPublish);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkDelete(String site, String path) {
        logger.debug("Starting Bulk Delete for path " + path + " site " + site, new Object[0]);
        ArrayList<String> childrenPaths = new ArrayList<String>();
        childrenPaths.add(path);
        ContentItemTO item = this.contentService.getContentItem(site, path, 2);
        if (item != null) {
            if (!item.isFolder()) {
                childrenPaths.add(path);
            }
            if (path.endsWith("/index.xml") && this.objectMetadataManager.isRenamed(site, path)) {
                this.getAllMandatoryChildren(site, item, childrenPaths);
            } else if (item.isFolder() || item.isContainer()) {
                this.getAllMandatoryChildren(site, item, childrenPaths);
            }
        }
        Date launchDate = new Date();
        String approver = this.securityService.getCurrentUser();
        logger.debug("Deleting " + childrenPaths.size() + " items", new Object[0]);
        try {
            this.deploymentService.delete(site, childrenPaths, approver, launchDate);
        }
        catch (DeploymentException e) {
            logger.error("Error while running bulk Delete operation", e, new Object[0]);
        }
        finally {
            logger.debug("Finished Bulk Delete for path " + path + " site " + site, new Object[0]);
        }
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }
}

